/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LanguageToLCConverter {
    private static final Map<String, String> ERPLC2ISOLC = new HashMap<String, String>();

    public static String getLC(String erpLC) {
        if (erpLC == null) {
            return "en-US";
        }
        String lc = ERPLC2ISOLC.get(erpLC);
        if (lc == null) {
            lc = "en-US";
        }
        return lc;
    }

    public static Locale getLocale(String erpLC) {
        String lc = LanguageToLCConverter.getLC(erpLC);
        String l = lc.substring(0, 2);
        String c = lc.substring(3, 5);
        return new Locale(l, c);
    }

    private LanguageToLCConverter() {
    }

    static {
        ERPLC2ISOLC.put("2", "en-US");
        ERPLC2ISOLC.put("1", "nl-NL");
        ERPLC2ISOLC.put("3", "de-DE");
        ERPLC2ISOLC.put("4", "fr-FR");
        ERPLC2ISOLC.put("5", "es-ES");
        ERPLC2ISOLC.put("6", "it-IT");
        ERPLC2ISOLC.put("7", "da-DA");
        ERPLC2ISOLC.put("8", "no-NO");
        ERPLC2ISOLC.put("9", "sv-SV");
        ERPLC2ISOLC.put("a", "ar-AR");
        ERPLC2ISOLC.put("b", "bg-BG");
        ERPLC2ISOLC.put("f", "fi-FI");
        ERPLC2ISOLC.put("h", "he-HE");
        ERPLC2ISOLC.put("j", "ja-JA");
        ERPLC2ISOLC.put("k", "ko-KO");
        ERPLC2ISOLC.put("n", "zh-TW");
        ERPLC2ISOLC.put("o", "zh-CN");
        ERPLC2ISOLC.put("p", "pt-PT");
        ERPLC2ISOLC.put("P", "pt-BR");
        ERPLC2ISOLC.put("R", "ru-RU");
        ERPLC2ISOLC.put("u", "uk-UK");
        ERPLC2ISOLC.put("v", "vi-VI");
        ERPLC2ISOLC.put("w", "sk-SK");
        ERPLC2ISOLC.put("z", "tr-TR");
    }
}

