/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2BIRT;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.birt.BML2BIRTException;
import com.ssaglobal.bml.birt.ReportDesign;
import com.ssaglobal.bml.birt.ReportField;
import com.ssaglobal.bml.birt.ReportLayout;
import com.ssaglobal.bml.birt.ReportLine;
import com.ssaglobal.bml.birt.ReportModel;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.birt.core.framework.Platform;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2BIRTDesign
extends DefaultHandler {
    private ReportModel m_current_model;
    private ReportLayout m_current_layout;
    private ReportLine m_current_line;

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        try {
            if (name.equals("report")) {
                this.m_current_model = new ReportModel(attributes);
            } else if (name.equals("layout")) {
                this.m_current_layout = new ReportLayout(attributes);
                this.m_current_model.add(this.m_current_layout);
            } else if (name.equals("lline")) {
                String id = attributes.getValue("id");
                this.m_current_line = new ReportLine(id, this.m_current_line);
                this.m_current_layout.add(this.m_current_line);
            } else if (name.equals("special") || name.equals("field") || name.equals("text")) {
                ReportField field = new ReportField(name, attributes);
                this.m_current_line.add(field);
            }
        }
        catch (Exception e) {
            throw new SAXException(new BML2BIRTException(e));
        }
    }

    @Override
    public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
    }

    public static void convertBML(String a_version, String a_bmlFile, String a_designFile, String a_templateFile) throws BML2BIRTException {
        try {
            BML2BIRTDesign b2b = new BML2BIRTDesign();
            ReportModel model = b2b.convert("not_used", a_version, a_bmlFile);
            b2b = null;
            ReportDesign design = new ReportDesign();
            design.buildDesign(a_templateFile, a_designFile, model);
        }
        catch (Throwable e) {
            throw new BML2BIRTException(e);
        }
    }

    private ReportModel convert(String a_user, String a_version, String a_bmlFile) throws SAXException, IOException {
        XMLReader saxParser = IOUtils.createXMLReader();
        saxParser.setContentHandler(this);
        saxParser.setFeature("http://xml.org/sax/features/namespaces", false);
        saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        String bml = BML2BIRT.BML2String(a_bmlFile);
        StringReader reader = new StringReader(bml);
        InputSource source = new InputSource(reader);
        saxParser.parse(source);
        reader.close();
        return this.m_current_model;
    }

    public static void main(String[] args) {
        String version = args[0];
        String bml = args[1];
        String design = args[2];
        String template = args[3];
        System.out.println("Executing conversion with:");
        System.out.println("BML file:" + bml);
        System.out.println("Version:" + version);
        System.out.println("Output design file:" + design);
        System.out.println("Birt template file:" + template);
        System.out.println("Start");
        try {
            BML2BIRTDesign.convertBML(version, bml, design, template);
        }
        catch (Throwable t) {
            System.out.println("Error converting: " + design);
            t.printStackTrace();
        }
        Platform.shutdown();
        System.out.println("Finished");
    }
}

