/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2BIRT;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.birt.BML2BIRTException;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2BIRTData
extends DefaultHandler {
    private static final char SEPARATOR = ',';
    private static final String PAGEBREAK = "pagebreak";
    private static final String EMPTYLINE = "emptyline";
    private Writer m_writer;
    private StringBuffer m_characters = null;
    private Model m_current_model;
    private Line m_current_line;
    private Layout m_current_layout;
    private Row m_current_row;
    private Value m_current_value;
    private Vector<String> m_fieldnames;
    private Hashtable<String, String> m_fieldvalues;
    String m_idOfFirstLineOfPage = null;

    Line transfer(String id, Line line) {
        Line next_line = new Line(id);
        if (line != null) {
            for (Field f : line.v) {
                if (f.height <= 1) continue;
                Field f2 = f.transfer();
                next_line.add(f2);
            }
        }
        return next_line;
    }

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        try {
            if (name.equals("report")) {
                this.m_current_model = new Model();
                this.m_current_model.desc = attributes.getValue("desc");
            } else if (name.equals("layout")) {
                String id = attributes.getValue("id");
                this.m_current_layout = new Layout(id);
                this.m_current_model.add(this.m_current_layout);
                this.m_current_line = null;
            } else if (name.equals("lline")) {
                String id = attributes.getValue("id");
                this.m_current_line = this.transfer(id, this.m_current_line);
                this.m_current_layout.add(this.m_current_line);
            } else if (name.equals("special") || name.equals("field")) {
                Field field = new Field();
                String tmp = attributes.getValue("col");
                field.col = tmp == null ? 0 : Integer.parseInt(tmp);
                tmp = attributes.getValue("height");
                field.height = tmp == null ? 0 : Integer.parseInt(tmp);
                field.fldtype = attributes.getValue("fldtype");
                field.difo = attributes.getValue("difo");
                this.m_current_line.add(field);
            } else if (name.equals("row")) {
                String id = attributes.getValue("layout");
                this.m_current_row = new Row(id);
                if (this.m_idOfFirstLineOfPage == null && this.getLine(id) != null) {
                    this.m_idOfFirstLineOfPage = id;
                }
            } else if (name.equals("e")) {
                this.m_current_value = new Value();
                this.m_current_value.pv = attributes.getValue("pv");
                this.m_current_value.difo = attributes.getValue("difo");
                this.startCharacters();
                this.m_current_row.add(this.m_current_value);
            } else if (name.equals(PAGEBREAK)) {
                this.pagebreak();
                this.m_idOfFirstLineOfPage = null;
            } else if (name.equals(EMPTYLINE)) {
                this.emptyline();
            }
        }
        catch (Exception ex) {
            throw new SAXException(new BML2BIRTException(ex));
        }
    }

    @Override
    public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
        try {
            if (name.equals("head")) {
                this.m_current_line = null;
                this.m_current_layout = null;
                this.m_fieldnames = this.getFieldNames();
                this.writeHeaderLine();
                this.m_fieldvalues = new Hashtable();
            } else if (name.equals("e")) {
                this.m_current_value.characters = this.getCharacters();
                this.stopCharacters();
                this.m_current_value = null;
            } else if (name.equals("row")) {
                this.row();
                this.m_current_row = null;
            } else if (name.equals("body")) {
                this.finish();
            }
        }
        catch (Exception ex) {
            throw new SAXException(new BML2BIRTException(ex));
        }
    }

    private void startCharacters() {
        this.m_characters = new StringBuffer();
    }

    private void stopCharacters() {
        this.m_characters = null;
    }

    private String getCharacters() {
        String result = "";
        if (this.m_characters != null) {
            result = this.m_characters.toString();
        }
        return result;
    }

    @Override
    public void characters(char[] chars, int i0, int i1) {
        if (this.m_characters != null) {
            String s = new String(chars, i0, i1);
            this.m_characters.append(s);
        }
    }

    private Vector<String> getFieldNames() {
        Vector<String> fieldnames = new Vector<String>();
        fieldnames.add(PAGEBREAK);
        fieldnames.add(EMPTYLINE);
        for (Layout layout : this.m_current_model.v) {
            for (Line line : layout.v) {
                fieldnames.add(line.id);
                for (Field field : line.v) {
                    fieldnames.add(field.id);
                }
            }
        }
        return fieldnames;
    }

    private void writeHeaderLine() throws IOException {
        String row = "";
        for (String name : this.m_fieldnames) {
            row = row + name;
            row = row + ',';
        }
        this.m_writer.write(row);
        this.m_writer.write(System.getProperty("line.separator"));
    }

    private void pagebreak() throws IOException {
        this.flush();
        this.m_fieldvalues.put(PAGEBREAK, PAGEBREAK);
    }

    private void emptyline() throws IOException {
        int count;
        boolean pagebreak = PAGEBREAK.equals(this.m_fieldvalues.get(PAGEBREAK));
        int n = count = pagebreak ? 1 : 0;
        if (this.m_fieldvalues.size() > count) {
            this.flush();
        }
        this.m_fieldvalues.put(EMPTYLINE, EMPTYLINE);
    }

    private void finish() throws IOException {
        boolean pagebreak = PAGEBREAK.equals(this.m_fieldvalues.get(PAGEBREAK));
        boolean emptyline = EMPTYLINE.equals(this.m_fieldvalues.get(EMPTYLINE));
        int count = 0;
        if (pagebreak) {
            ++count;
        }
        if (emptyline) {
            ++count;
        }
        if (this.m_fieldvalues.size() > count) {
            this.flush();
        }
    }

    private void row() throws IOException {
        Object value;
        String rowid = this.m_current_row.id;
        Line line = this.getLine(rowid);
        if (line == null) {
            return;
        }
        int index = this.m_fieldnames.indexOf(rowid);
        int size = this.m_fieldnames.size();
        for (int i = index; i < size; ++i) {
            String name = this.m_fieldnames.get(i);
            value = this.m_fieldvalues.get(name);
            if (value == null) continue;
            this.flush();
            break;
        }
        this.m_fieldvalues.put(rowid, rowid);
        Iterator<Value> fields = this.m_current_row.v.iterator();
        int count = 0;
        while (fields.hasNext() && count < line.v.size()) {
            value = fields.next();
            Field field = line.v.get(count++);
            String result = this.getFormatted((Value)value, field);
            this.m_fieldvalues.put(field.id, result.trim());
        }
    }

    private String getFormatted(Value value, Field field) {
        if (value.pv == null) {
            return value.characters;
        }
        return value.pv;
    }

    private void flush() throws IOException {
        if (this.m_fieldvalues.isEmpty()) {
            return;
        }
        String row = "";
        for (String id : this.m_fieldnames) {
            String value = this.m_fieldvalues.get(id);
            if (value != null) {
                boolean skip;
                boolean bl = skip = id.startsWith(this.m_idOfFirstLineOfPage + ".") && value.equalsIgnoreCase(this.m_current_model.desc);
                if (!skip) {
                    row = row + this.escape(value);
                }
            }
            row = row + ',';
        }
        this.m_writer.write(row);
        this.m_writer.write(System.getProperty("line.separator"));
        this.m_fieldvalues.clear();
    }

    private Line getLine(String id) {
        for (Layout layout : this.m_current_model.v) {
            for (Line line : layout.v) {
                if (!line.id.equals(id)) continue;
                return line;
            }
        }
        return null;
    }

    private String escape(String value) {
        String result;
        int QUOTE = 34;
        int posQuote = value.indexOf(34);
        int posSeparator = value.indexOf(44);
        if (posQuote < 0 && posSeparator < 0) {
            result = value;
        } else {
            result = "\"";
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    result = result + '\"';
                }
                result = result + c;
            }
            result = result + '\"';
        }
        return result;
    }

    private void convertData(String a_bmlFile, String a_dataFile) throws SAXException, IOException {
        XMLReader saxParser = IOUtils.createXMLReader();
        saxParser.setContentHandler(this);
        saxParser.setFeature("http://xml.org/sax/features/namespaces", false);
        saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(a_dataFile), "UTF8"));
        this.parse(saxParser, a_bmlFile);
        this.m_writer.close();
    }

    private void parse(XMLReader a_saxParser, String a_bmlFile) throws SAXException, IOException {
        String bml = BML2BIRT.BML2String(a_bmlFile);
        StringReader reader = new StringReader(bml);
        InputSource source = new InputSource(reader);
        a_saxParser.parse(source);
        reader.close();
    }

    public static void convertBML(String a_userName, String a_version, String a_bmlFile, String a_dataFile) throws BML2BIRTException {
        try {
            BML2BIRTData b2d = new BML2BIRTData();
            b2d.convertData(a_bmlFile, a_dataFile);
        }
        catch (Throwable e) {
            throw new BML2BIRTException(e);
        }
    }

    public static void main(String[] args) {
        String user = args[0];
        String version = args[1];
        String dataIn = args[2];
        String dataOut = args[3];
        System.out.println("Executing Data conversion with:");
        System.out.println("User:" + user);
        System.out.println("BML file:" + dataIn);
        System.out.println("Version:" + version);
        System.out.println("Output data file:" + dataOut);
        System.out.println("Start");
        try {
            BML2BIRTData.convertBML(user, version, dataIn, dataOut);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("Finished");
    }

    private class Value {
        String difo;
        String pv;
        String characters;

        private Value() {
        }
    }

    private class Row {
        String id;
        Vector<Value> v = new Vector();

        Row(String id) {
            this.id = id;
        }

        void add(Value value) {
            this.v.add(value);
        }
    }

    private class Model {
        String desc;
        Vector<Layout> v = new Vector();

        private Model() {
        }

        void add(Layout layout) {
            this.v.add(layout);
        }
    }

    private class Layout {
        String id;
        Vector<Line> v = new Vector();

        Layout(String id) {
            this.id = id;
        }

        void add(Line line) {
            this.v.add(line);
        }
    }

    private class Line {
        String id;
        Vector<Field> v = new Vector();

        Line(String id) {
            this.id = id;
        }

        void add(Field field) {
            boolean done = false;
            for (int index = 0; index < this.v.size(); ++index) {
                Field f = this.v.get(index);
                if (field.col >= f.col) continue;
                this.v.insertElementAt(field, index);
                done = true;
                break;
            }
            if (!done) {
                this.v.add(field);
            }
            field.id = this.id + "." + this.v.size();
        }
    }

    private class Field {
        String id;
        String fldtype;
        String difo;
        int col;
        int height;

        private Field() {
        }

        Field transfer() {
            Field f = new Field();
            f.id = null;
            f.fldtype = this.fldtype;
            f.difo = this.difo;
            f.col = this.col;
            f.height = this.height - 1;
            return f;
        }
    }
}

