/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.constants;

import java.util.HashSet;
import java.util.Set;

public final class StandardFonts {
    private static final Set<String> BUILTIN_FONTS = new HashSet<String>();
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";

    private StandardFonts() {
    }

    public static boolean isStandardFont(String fontName) {
        return BUILTIN_FONTS.contains(fontName);
    }

    static {
        BUILTIN_FONTS.add(COURIER);
        BUILTIN_FONTS.add(COURIER_BOLD);
        BUILTIN_FONTS.add(COURIER_BOLDOBLIQUE);
        BUILTIN_FONTS.add(COURIER_OBLIQUE);
        BUILTIN_FONTS.add(HELVETICA);
        BUILTIN_FONTS.add(HELVETICA_BOLD);
        BUILTIN_FONTS.add(HELVETICA_BOLDOBLIQUE);
        BUILTIN_FONTS.add(HELVETICA_OBLIQUE);
        BUILTIN_FONTS.add(SYMBOL);
        BUILTIN_FONTS.add(TIMES_ROMAN);
        BUILTIN_FONTS.add(TIMES_BOLD);
        BUILTIN_FONTS.add(TIMES_BOLDITALIC);
        BUILTIN_FONTS.add(TIMES_ITALIC);
        BUILTIN_FONTS.add(ZAPFDINGBATS);
    }
}

