/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.validators;

import com.itextpdf.licensekey.LicenseFileNotLoadedException;
import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.LicenseKeyLicensee;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.licensekey.util.CertificateWorker;
import com.itextpdf.licensekey.util.CollectionUtil;
import com.itextpdf.licensekey.util.DateUtil;
import com.itextpdf.licensekey.util.DateWorker;
import com.itextpdf.licensekey.util.InfoExtraction;
import com.itextpdf.licensekey.util.LicenseKeyMessageFormatUtil;
import com.itextpdf.licensekey.validators.ILicenseKeyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicenseKeyValidator
implements ILicenseKeyValidator {
    private LicenseKeyLicensee loadedLicensee;
    private boolean loadedLicenseExpired;
    private Map<String, String> loadedLicenseConfiguration;
    private HashMap<String, LicenseKeyProduct> licensedProducts = new HashMap();
    private HashMap<String, String> licensedProductsSignatures = new HashMap();
    private CertificateWorker certificateWorker;
    protected DateWorker dateWorker = new DateWorker("yyyy-MM-dd");

    public AbstractLicenseKeyValidator(CertificateWorker certificateWorker) {
        this.certificateWorker = certificateWorker;
        this.loadedLicensee = null;
        this.loadedLicenseConfiguration = null;
    }

    @Override
    public void loadLicense(Element licenseKeyRoot) throws LicenseKeyException {
        this.beforeValidLicenseLoaded();
        NodeList nodeL = licenseKeyRoot.getElementsByTagName("licensee");
        if (nodeL == null || nodeL.getLength() != 1) {
            throw new LicenseKeyException("Licensee element was not found.");
        }
        Element licenseeElement = (Element)nodeL.item(0);
        String loadingLicenseeSignature = InfoExtraction.getLicenseElementTagValue(licenseeElement, "signature", true);
        LicenseKeyLicensee loadingLicensee = this.extractLicensee(licenseeElement);
        Map<String, String> licenseConfig = this.extractLicenseConfiguration(licenseKeyRoot);
        Map<Object, Object> map = this.loadedLicenseConfiguration = licenseConfig == null ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(licenseConfig);
        if (this.loadedLicensee != null) {
            this.compareLicenseeInfo(loadingLicensee, this.loadedLicensee);
        }
        boolean loadingLicenseIsExpired = this.isExpirationDatePassed(loadingLicensee.getExpireDate());
        String signatureBuildString = this.formLicenseeSignatureString(loadingLicensee);
        this.checkSignature(signatureBuildString, loadingLicenseeSignature);
        if (loadingLicenseIsExpired) {
            throw new LicenseKeyException("License being loaded is expired");
        }
        if (this.loadedLicensee == null) {
            this.loadedLicensee = loadingLicensee;
            this.loadedLicenseExpired = false;
        }
        NodeList productList = licenseKeyRoot.getElementsByTagName("product");
        this.updateProductsOnLoad(productList, this.loadedLicensee);
        this.afterValidLicenseLoaded(this.loadedLicensee, this.licensedProducts.values());
    }

    @Override
    public void checkLicense(LicenseKeyProduct product) throws LicenseKeyException {
        boolean standaloneCall = false;
        if (product != null && "standalone".equals(product.getType())) {
            standaloneCall = true;
        }
        if (!standaloneCall) {
            if (this.loadedLicensee == null) {
                throw new LicenseFileNotLoadedException();
            }
            this.loadedLicenseExpired = this.isExpirationDatePassed(this.loadedLicensee.getExpireDate());
            if (product == null && this.loadedLicenseExpired) {
                throw new LicenseKeyException("Loaded License has expired.");
            }
        }
        if (product != null) {
            if (this.isTrial()) {
                return;
            }
            LicenseKeyProduct loadedProduct = this.licensedProducts.get(product.getProductName());
            if (loadedProduct == null) {
                throw new LicenseKeyException(LicenseKeyMessageFormatUtil.format("No license loaded for product {0}. Please use LicenseKey.loadLicense(...) to load one.", product.getProductName()));
            }
            this.compareProductContents(loadedProduct, product);
            this.checkProductCompatibility(loadedProduct, this.loadedLicensee);
            String builtSignature = this.formProductSignature(loadedProduct, this.loadedLicensee);
            this.checkSignature(builtSignature, this.licensedProductsSignatures.get(loadedProduct.getProductName()));
            if (this.isExpirationDatePassed(loadedProduct.getExpireDate())) {
                throw new LicenseKeyException("License for product has expired. Product: " + loadedProduct.getProductName());
            }
        }
    }

    @Override
    public void unloadLicense() {
        this.loadedLicenseExpired = false;
        this.loadedLicensee = null;
        this.loadedLicenseConfiguration = null;
        this.licensedProducts.clear();
        this.licensedProductsSignatures.clear();
        this.beforeValidLicenseLoaded();
    }

    @Override
    public String[] getLicenseeInfo() throws LicenseKeyException {
        if (this.loadedLicensee != null) {
            return this.getLicenseeInfo(this.loadedLicensee, true, this.loadedLicenseExpired);
        }
        throw this.loadedLicenseExpired ? new LicenseKeyException("Loaded License has expired.") : new LicenseFileNotLoadedException();
    }

    @Override
    public Map<String, String> getLicenseConfiguration() {
        return this.loadedLicenseConfiguration;
    }

    @Override
    public String[] getProducts() throws LicenseKeyException {
        if (this.loadedLicensee != null) {
            return this.licensedProducts.keySet().toArray(new String[0]);
        }
        throw this.loadedLicenseExpired ? new LicenseKeyException("Loaded License has expired.") : new LicenseFileNotLoadedException();
    }

    @Override
    public String[] getProductInfo(String product) throws LicenseKeyException {
        if (this.loadedLicensee != null) {
            LicenseKeyProduct productInfo = this.licensedProducts.get(product);
            String productSignature = this.licensedProductsSignatures.get(product);
            if (productSignature != null && productInfo != null) {
                boolean isNotExpired;
                boolean bl = isNotExpired = this.isProductValid(productInfo, this.loadedLicensee, productSignature) && !this.loadedLicenseExpired;
                if (isNotExpired) {
                    return this.getProductInfo(productInfo);
                }
                throw new LicenseKeyException(this.loadedLicenseExpired ? "Loaded License has expired." : "License for product has expired.");
            }
            throw new LicenseKeyException(this.loadedLicenseExpired ? "Loaded License has expired." : LicenseKeyMessageFormatUtil.format("No license loaded for product {0}. Please use LicenseKey.loadLicense(...) to load one.", product));
        }
        throw this.loadedLicenseExpired ? new LicenseKeyException("Loaded License has expired.") : new LicenseFileNotLoadedException();
    }

    protected abstract String[] getLicenseeInfo(LicenseKeyLicensee var1, boolean var2, boolean var3);

    protected abstract void compareLicenseeInfo(LicenseKeyLicensee var1, LicenseKeyLicensee var2);

    protected abstract String[] getProductInfo(LicenseKeyProduct var1);

    protected abstract void beforeValidLicenseLoaded();

    protected abstract void afterValidLicenseLoaded(LicenseKeyLicensee var1, Collection<? extends LicenseKeyProduct> var2);

    protected abstract LicenseKeyLicensee extractLicensee(Element var1);

    protected abstract Map<String, String> extractLicenseConfiguration(Element var1);

    protected abstract String formLicenseeSignatureString(LicenseKeyLicensee var1);

    protected abstract String formProductSignature(LicenseKeyProduct var1, LicenseKeyLicensee var2);

    protected abstract void checkProductCompatibility(LicenseKeyProduct var1, LicenseKeyLicensee var2);

    protected void compareLicenseInfoEntry(String expectedString, String loadedString) {
        if (!expectedString.equals(loadedString)) {
            throw new LicenseKeyException("The license info of already loaded license doesn't match the new one.");
        }
    }

    private void checkSignature(String signatureString, String licenseeSignature) {
        boolean isVerified = false;
        try {
            isVerified = this.certificateWorker.verify(signatureString, licenseeSignature);
        }
        catch (Exception any) {
            throw new LicenseKeyException("Signature was corrupted.");
        }
        if (!isVerified) {
            throw new LicenseKeyException("License file was corrupted.");
        }
    }

    private void checkProductVersions(LicenseKeyProduct loadedProduct, LicenseKeyProduct productToCheck) {
        int loadedMajorVersion = loadedProduct.getMajorVersion();
        int majorVersionToCheck = productToCheck.getMajorVersion();
        if (majorVersionToCheck > loadedMajorVersion) {
            throw new LicenseKeyException("Product requires different version than contained in license file. Present major version: " + productToCheck.getMajor() + ", license major version: " + loadedProduct.getMajor());
        }
        if (majorVersionToCheck == loadedMajorVersion) {
            int loadedMinorVersion = loadedProduct.getMinorVersion();
            int minorVersionToCheck = productToCheck.getMinorVersion();
            if (minorVersionToCheck > loadedMinorVersion) {
                // empty if block
            }
        }
    }

    private void checkProductFeatures(LicenseKeyProduct loadedProduct, LicenseKeyProduct productToCheck) {
        for (LicenseKeyProductFeature feature : productToCheck.getProductFeatures()) {
            boolean isFeaturePresent = false;
            for (LicenseKeyProductFeature loadedFeature : loadedProduct.getProductFeatures()) {
                if (!feature.getName().equals(loadedFeature.getName())) continue;
                isFeaturePresent = true;
                break;
            }
            if (isFeaturePresent) continue;
            throw new LicenseKeyException("One or more features was not found.");
        }
    }

    private void compareProductContents(LicenseKeyProduct loadedProduct, LicenseKeyProduct productToCheck) throws LicenseKeyException {
        this.checkProductVersions(loadedProduct, productToCheck);
        if (!"any".equals(loadedProduct.getPlatform()) && !productToCheck.getPlatform().equals(loadedProduct.getPlatform())) {
            throw new LicenseKeyException("Product requires different platform than contained in license file.");
        }
        this.checkProductFeatures(loadedProduct, productToCheck);
    }

    private LicenseKeyProduct extractProduct(Element newProduct) {
        String name = InfoExtraction.getProductAttribute(newProduct, "name", true);
        String major = InfoExtraction.getProductAttribute(newProduct, "major", true);
        String minor = InfoExtraction.getProductAttribute(newProduct, "minor");
        String expireDate = InfoExtraction.getProductAttribute(newProduct, "expire");
        String platform = InfoExtraction.getProductAttribute(newProduct, "platform");
        String type = InfoExtraction.getProductAttribute(newProduct, "licensetype");
        String subtype = InfoExtraction.getLicenseAttribute(newProduct, "deploymenttype");
        List<LicenseKeyProductFeature> feats = this.extractProductFeatures(newProduct);
        return new LicenseKeyProduct(name, major, minor, type, subtype, expireDate, platform, feats.toArray(new LicenseKeyProductFeature[0]));
    }

    private List<LicenseKeyProductFeature> extractProductFeatures(Element productElement) {
        ArrayList<LicenseKeyProductFeature> result = new ArrayList<LicenseKeyProductFeature>();
        NodeList featuresNodeList = productElement.getElementsByTagName("feature");
        Element featureElement = null;
        if (featuresNodeList != null && featuresNodeList.getLength() > 0) {
            for (int i = 0; i < featuresNodeList.getLength(); ++i) {
                featureElement = (Element)featuresNodeList.item(i);
                result.add(new LicenseKeyProductFeature(featureElement.getAttribute("name"), featureElement.getAttribute("version")));
            }
        }
        return result;
    }

    private boolean isTrial() {
        return this.loadedLicensee != null && (this.loadedLicensee.getKey() == null || this.loadedLicensee.getKey().trim().length() == 0);
    }

    private boolean isExpirationDatePassed(String expireDateStr) {
        try {
            Date expireDate = this.dateWorker.parse(expireDateStr);
            return DateUtil.isInPast(DateWorker.addBufferDay(expireDate));
        }
        catch (Exception ex) {
            return true;
        }
    }

    private boolean isProductValid(LicenseKeyProduct product, LicenseKeyLicensee licensee, String signature) {
        try {
            this.checkProductCompatibility(product, licensee);
            String builtSignature = this.formProductSignature(product, licensee);
            this.checkSignature(builtSignature, signature);
            return !this.isExpirationDatePassed(product.getExpireDate());
        }
        catch (Exception any) {
            return false;
        }
    }

    private void updateProductsOnLoad(NodeList licenseToLoadProductList, LicenseKeyLicensee licenseKeyLicensee) {
        for (int i = 0; i < licenseToLoadProductList.getLength(); ++i) {
            int oldMinorVersion;
            int newMinorVersion;
            int oldMajorVersion;
            Element newProductElement = (Element)licenseToLoadProductList.item(i);
            LicenseKeyProduct newProduct = this.extractProduct(newProductElement);
            LicenseKeyProduct oldProduct = this.licensedProducts.get(newProduct.getProductName());
            String signatureFromXML = InfoExtraction.getProductElementTagValue(newProductElement, "signature", true);
            if (oldProduct == null) {
                this.licensedProducts.put(newProduct.getProductName(), newProduct);
                this.licensedProductsSignatures.put(newProduct.getProductName(), signatureFromXML);
                continue;
            }
            int newMajorVersion = newProduct.getMajorVersion();
            if (newMajorVersion > (oldMajorVersion = oldProduct.getMajorVersion())) {
                if (!this.isProductValid(newProduct, licenseKeyLicensee, signatureFromXML)) continue;
                this.licensedProducts.put(newProduct.getProductName(), newProduct);
                this.licensedProductsSignatures.put(newProduct.getProductName(), signatureFromXML);
                continue;
            }
            if (newMajorVersion != oldMajorVersion || (newMinorVersion = newProduct.getMinorVersion()) <= (oldMinorVersion = oldProduct.getMinorVersion()) || !this.isProductValid(newProduct, licenseKeyLicensee, signatureFromXML)) continue;
            this.licensedProducts.put(newProduct.getProductName(), newProduct);
            this.licensedProductsSignatures.put(newProduct.getProductName(), signatureFromXML);
        }
    }
}

