/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.util;

import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.util.CollectionUtil;
import com.itextpdf.licensekey.util.LicenseKeyMessageFormatUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoExtraction {
    private InfoExtraction() {
    }

    public static String getLicenseElementTagValue(Element licenseElement, String tagName) {
        return InfoExtraction.getLicenseElementTagValue(licenseElement, tagName, false);
    }

    public static String getLicenseElementTagValue(Element licenseElement, String tagName, boolean required) {
        return InfoExtraction.getTagValue(licenseElement, tagName, required, "Licensee element does not contain element with tag: {0}.");
    }

    public static String getLicenseAttribute(Element licenseElement, String attributeName) {
        return InfoExtraction.getLicenseAttribute(licenseElement, attributeName, false);
    }

    public static String getLicenseAttribute(Element licenseElement, String attributeName, boolean required) {
        return InfoExtraction.getAttribute(licenseElement, attributeName, required, "Licensee element does not contain attribute with name: {0}.");
    }

    public static String getProductElementTagValue(Element product, String tagName) {
        return InfoExtraction.getProductElementTagValue(product, tagName, false);
    }

    public static String getProductElementTagValue(Element product, String tagName, boolean required) {
        return InfoExtraction.getTagValue(product, tagName, required, "Product element doesn't contain element with tag: {0}.");
    }

    public static String getProductAttribute(Element productElement, String attributeName) {
        return InfoExtraction.getProductAttribute(productElement, attributeName, false);
    }

    public static String getProductAttribute(Element productElement, String attributeName, boolean required) {
        return InfoExtraction.getAttribute(productElement, attributeName, required, "Product element doesn't contain attribute with name: {0}.");
    }

    public static Map<String, String> getChildElementsAndAttributes(Element licenseElement, String tagName) {
        NodeList temp = licenseElement.getElementsByTagName(tagName);
        if (temp == null || temp.getLength() != 1) {
            return CollectionUtil.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Node licenseConfigNode = temp.item(0);
        InfoExtraction.parseAttributes(result, licenseConfigNode, null);
        NodeList childrenNode = licenseConfigNode.getChildNodes();
        for (int i = 0; i < childrenNode.getLength(); ++i) {
            Node childNode = childrenNode.item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            result.put(child.getTagName(), child.getTextContent());
            InfoExtraction.parseAttributes(result, childNode, child.getTagName());
        }
        return result;
    }

    private static void parseAttributes(Map<String, String> result, Node node, String nodePath) {
        NamedNodeMap attributesNode = node.getAttributes();
        for (int j = 0; j < attributesNode.getLength(); ++j) {
            Node attrNode = attributesNode.item(j);
            if (!(attrNode instanceof Attr)) continue;
            Attr attr = (Attr)attrNode;
            String attrPrefix = nodePath == null ? "@" : nodePath + "/@";
            result.put(attrPrefix + attr.getName(), attr.getValue());
        }
    }

    private static String getTagValue(Element element, String tagName, boolean required, String errorMessageBase) {
        NodeList temp = element.getElementsByTagName(tagName);
        if (temp != null && temp.getLength() == 1) {
            return temp.item(0).getTextContent();
        }
        if (!required) {
            return "";
        }
        throw new LicenseKeyException(LicenseKeyMessageFormatUtil.format(errorMessageBase, tagName));
    }

    private static String getAttribute(Element element, String attributeName, boolean required, String errorMessageBase) {
        Node attribute = element.getAttributes().getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        if (!required) {
            return "";
        }
        throw new LicenseKeyException(LicenseKeyMessageFormatUtil.format(errorMessageBase, attributeName));
    }
}

