/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.ln.server.CustomAppender;
import com.infor.ln.server.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;

public class LogServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(LogServlet.class);
    private static final String LOGGING_NOT_ACTIVE = "Logging not active";
    private static final String APPENDER_NOT_FOUND = "Custom appender not found";
    private static final String MISSING_USER = "Missing user parameter";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block31: {
            String user = request.getParameter("user");
            String tenant = request.getParameter("tenant");
            Utils.setCacheHeaders(response);
            response.setContentType("text/plain; charset=utf-8");
            if (user != null) {
                CustomAppender customAppender = this.getCustomAppender();
                if (customAppender != null) {
                    try (InputStream inputStream = customAppender.getInputStream(user, tenant);){
                        if (inputStream == null) {
                            this.sendError(LOGGING_NOT_ACTIVE, 404, response);
                            return;
                        }
                        try (ServletOutputStream outputStream = response.getOutputStream();){
                            Utils.copy(inputStream, (OutputStream)outputStream);
                            break block31;
                        }
                    }
                }
                LOG.error(APPENDER_NOT_FOUND);
                this.sendError(APPENDER_NOT_FOUND, 500, response);
            } else {
                this.sendError(MISSING_USER, 400, response);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = request.getParameter("user");
        String tenant = request.getParameter("tenant");
        String level = request.getParameter("level");
        if (user != null) {
            if (!this.changeUserLogLevel(user, tenant, level)) {
                LOG.error(APPENDER_NOT_FOUND);
                this.sendError(APPENDER_NOT_FOUND, 500, response);
            }
        } else {
            this.sendError(MISSING_USER, 400, response);
        }
    }

    private void sendError(String message, int code, HttpServletResponse response) throws IOException {
        response.setStatus(code);
        try (PrintWriter writer = response.getWriter();){
            writer.println(message);
        }
    }

    private boolean changeUserLogLevel(String user, String tenant, String level) {
        CustomAppender customAppender = this.getCustomAppender();
        if (customAppender != null) {
            customAppender.setUserLogLevel(user, tenant, level);
            return true;
        }
        return false;
    }

    private CustomAppender getCustomAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Appender appender = config.getAppender("custom");
        if (appender instanceof CustomAppender) {
            return (CustomAppender)appender;
        }
        return null;
    }
}

