/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import javax.servlet.ServletContext;

public class ConfigManager {
    private static final String CONFIG_MANAGER = "configManager";
    private static final String LOG4JFILE = "log4j2.xml";
    private final ServletContext m_context;
    private final File m_configDir;
    private final URI m_log4jFile;
    private final boolean m_isMultiTenant;

    public static ConfigManager getConfigManager(ServletContext context) {
        Object configManager = context.getAttribute(CONFIG_MANAGER);
        if (!(configManager instanceof ConfigManager)) {
            configManager = new ConfigManager(context);
            context.setAttribute(CONFIG_MANAGER, configManager);
        }
        return (ConfigManager)configManager;
    }

    public File getConfigDir() {
        return this.m_configDir;
    }

    public boolean isMultiTenant() {
        return this.m_isMultiTenant;
    }

    URI getLog4jFile() {
        return this.m_log4jFile;
    }

    private ConfigManager(ServletContext context) {
        this.m_context = context;
        this.m_configDir = this.findConfigDir();
        this.m_log4jFile = this.createFile(new File(this.m_configDir, LOG4JFILE), "/com/infor/ln/server/log4j2.xml");
        this.m_isMultiTenant = this.checkIsMultiTenant();
    }

    private File findConfigDir() {
        File configPath = null;
        String path = this.m_context.getInitParameter("ConfigPath");
        if (path != null && !path.isEmpty()) {
            configPath = new File(path);
        }
        if (configPath == null) {
            configPath = new File(this.getWebAppDir(), "config");
        }
        if (!configPath.exists()) {
            configPath.mkdirs();
        }
        return configPath;
    }

    private File getWebAppDir() {
        String webappDir = this.m_context.getRealPath("/");
        return new File(webappDir);
    }

    private URI createFile(File targetFile, String resourceName) {
        URI result = targetFile.toURI();
        if (!targetFile.exists()) {
            try (InputStream input = this.getClass().getResourceAsStream(resourceName);){
                Files.copy(input, targetFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                result = this.getResourceURI(resourceName);
            }
        }
        return result;
    }

    private URI getResourceURI(String resourceName) {
        try {
            return this.getClass().getResource(resourceName).toURI();
        }
        catch (URISyntaxException e) {
            return URI.create(resourceName);
        }
    }

    private boolean checkIsMultiTenant() {
        return Boolean.parseBoolean(this.m_context.getInitParameter("MultiTenant"));
    }
}

