/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.erpln.utils.oauth10.Authenticator;
import com.infor.erpln.utils.oauth10.AuthorizationStatus;
import com.infor.erpln.utils.oauth10.BaseUriUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthFilter
implements Filter {
    private static final String ATTR_AUTH = "Authenticator";

    public static void setAuthenticator(ServletContext context, String key, String secret) {
        Authenticator auth = Authenticator.getInstance((String)key, (String)secret);
        context.setAttribute(ATTR_AUTH, (Object)auth);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            Authenticator auth = (Authenticator)request.getServletContext().getAttribute(ATTR_AUTH);
            if (auth == null) {
                ((HttpServletResponse)response).sendError(401, "Authenticator not configured");
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            AuthorizationStatus status = auth.verify(httpRequest.getMethod(), BaseUriUtil.getBaseUri((HttpServletRequest)httpRequest), httpRequest.getQueryString(), httpRequest.getHeader("Authorization"));
            if (!status.isOk()) {
                ((HttpServletResponse)response).sendError(401, "Signature verification error");
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

