/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey;

import com.itextpdf.licensekey.LicenseFileNotLoadedException;
import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.util.CertificateWorker;
import com.itextpdf.licensekey.util.DateUtil;
import com.itextpdf.licensekey.util.XmlWorker;
import com.itextpdf.licensekey.validators.ILicenseKeyValidator;
import com.itextpdf.licensekey.validators.LicenseKey5Validator;
import com.itextpdf.licensekey.validators.LicenseKey7Validator;
import com.itextpdf.licensekey.validators.NoOpValidator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseKey {
    private static final Object staticLock = new Object();
    private static final long CHECK_INTERVAL = 43200000L;
    private static final String ITEXT7_CERTIFICATE_RESOURCE_PATH = "com/itextpdf/licensekey/itext7.cer";
    private static final String ITEXT5_CERTIFICATE_RESOURCE_PATH = "com/itextpdf/licensekey/itext5.cer";
    public static final String DEFAULT_VALIDATOR = "7";
    private static Map<String, ILicenseKeyValidator> validators;
    private static String currentDefault;
    private static Map<String, Long> initialTimes;
    private static final String DEFAULT = "DEFAULT";

    public static void loadLicenseFile(InputStream licenseIs) throws LicenseKeyException {
        LicenseKey.loadLicenseFileInternal(licenseIs);
    }

    public static void loadLicenseFile(InputStream[] licenseIs) throws LicenseKeyException {
        for (InputStream is : licenseIs) {
            LicenseKey.loadLicenseFile(is);
        }
    }

    public static void loadLicenseFile(String pathToLicFile) throws LicenseKeyException {
        try {
            LicenseKey.loadLicenseFile(new FileInputStream(pathToLicFile));
        }
        catch (FileNotFoundException fnf) {
            throw new LicenseKeyException(fnf.getMessage());
        }
    }

    public static void loadLicenseFile(String[] files) throws LicenseKeyException {
        for (String fileName : files) {
            try {
                LicenseKey.loadLicenseFile(new FileInputStream(fileName));
            }
            catch (FileNotFoundException fnf) {
                throw new LicenseKeyException(fnf.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLicenseFileInternal(InputStream licenseIs) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            block5: {
                LicenseKey.initializeiTextValidators();
                Element root = new XmlWorker(licenseIs).getDocumentElement();
                String validatorToUse = LicenseKey.selectValidatorKey(root);
                try {
                    validators.get(validatorToUse).loadLicense(root);
                    currentDefault = validatorToUse;
                }
                catch (LicenseKeyException le) {
                    if (LicenseKey.loadUsingFallbackValidators(root, validatorToUse)) break block5;
                    LicenseKey.unloadLicenses();
                    throw le;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadLicenses() {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                for (ILicenseKeyValidator validator : validators.values()) {
                    validator.unloadLicense();
                }
            }
            initialTimes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadLicenseForVersion(String version) {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                String key = LicenseKey.selectValidatorKeyFromVersionString(version);
                validators.get(key).unloadLicense();
            }
            initialTimes.clear();
        }
    }

    public static String[] getLicenseeInfo() throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                return validators.get(currentDefault).getLicenseeInfo();
            }
            throw new LicenseFileNotLoadedException();
        }
    }

    public static String[] getLicenseeInfoForVersion(String version) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                String key = LicenseKey.selectValidatorKeyFromVersionString(version);
                return validators.get(key).getLicenseeInfo();
            }
            throw new LicenseFileNotLoadedException();
        }
    }

    public static Map<String, String> getLicenseConfigurationForVersion(String version) {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                String key = LicenseKey.selectValidatorKeyFromVersionString(version);
                return validators.get(key).getLicenseConfiguration();
            }
            throw new LicenseFileNotLoadedException();
        }
    }

    public static String[] getProductsForVersion(String version) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                String key = LicenseKey.selectValidatorKeyFromVersionString(version);
                return validators.get(key).getProducts();
            }
            throw new LicenseFileNotLoadedException();
        }
    }

    public static String[] getProductInfoForVersion(String version, String product) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            if (validators != null) {
                String key = LicenseKey.selectValidatorKeyFromVersionString(version);
                return validators.get(key).getProductInfo(product);
            }
            throw new LicenseFileNotLoadedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduledCheck(LicenseKeyProduct product) {
        Object object = staticLock;
        synchronized (object) {
            String key = product == null ? DEFAULT : product.getProductName();
            long initialTime = initialTimes.containsKey(key) ? initialTimes.get(key) : DateUtil.getRelativeTime(DateUtil.getInitial());
            long currentTime = DateUtil.getRelativeTime(DateUtil.getCurrent());
            if (currentTime - initialTime > 43200000L) {
                initialTimes.put(key, currentTime);
                try {
                    LicenseKey.checkLicense(product);
                }
                catch (LicenseKeyException e) {
                    initialTimes.clear();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkLicense(LicenseKeyProduct product) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            if (validators == null) throw new LicenseFileNotLoadedException();
            try {
                validators.get(currentDefault).checkLicense(product);
            }
            catch (LicenseKeyException e) {
                if (LicenseKey.checkFallbackValidators(product, currentDefault)) return;
                throw e;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkFallbackValidators(LicenseKeyProduct product, String validatorToIgnore) {
        Object object = staticLock;
        synchronized (object) {
            boolean aValidatorHasLoadedTheLicense = false;
            for (String key : validators.keySet()) {
                if (key.equals(validatorToIgnore)) continue;
                try {
                    validators.get(key).checkLicense(product);
                    aValidatorHasLoadedTheLicense = true;
                    currentDefault = key;
                    break;
                }
                catch (LicenseKeyException licenseKeyException) {
                }
            }
            return aValidatorHasLoadedTheLicense;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadUsingFallbackValidators(Element licenseKeyRoot, String validatorToIgnore) {
        Object object = staticLock;
        synchronized (object) {
            boolean aValidationPassed = false;
            for (String key : validators.keySet()) {
                if (key.equals(validatorToIgnore)) continue;
                try {
                    validators.get(key).loadLicense(licenseKeyRoot);
                    aValidationPassed = true;
                    currentDefault = key;
                    break;
                }
                catch (LicenseKeyException licenseKeyException) {
                }
            }
            return aValidationPassed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String selectValidatorKey(Element licenseKeyRoot) throws LicenseKeyException {
        Object object = staticLock;
        synchronized (object) {
            NodeList nodeL = licenseKeyRoot.getElementsByTagName("licensee");
            Element licenseeElement = (Element)nodeL.item(0);
            if (licenseeElement == null) {
                throw new LicenseKeyException("Licensee element was not found.");
            }
            NodeList temp = licenseeElement.getElementsByTagName("version");
            if (temp == null || temp.getLength() == 0) {
                return "5";
            }
            if (temp.getLength() == 1) {
                String version = temp.item(0).getTextContent();
                return LicenseKey.selectValidatorKeyFromVersionString(version);
            }
            return DEFAULT_VALIDATOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String selectValidatorKeyFromVersionString(String version) {
        Object object = staticLock;
        synchronized (object) {
            if (LicenseKey.isItext7VersionString(version)) {
                return DEFAULT_VALIDATOR;
            }
            if (LicenseKey.isIText5VersionString(version)) {
                return "5";
            }
            return DEFAULT_VALIDATOR;
        }
    }

    private static boolean isItext7VersionString(String version) {
        return version.startsWith(DEFAULT_VALIDATOR);
    }

    private static boolean isIText5VersionString(String version) {
        return version.startsWith("5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeiTextValidators() {
        Object object = staticLock;
        synchronized (object) {
            if (validators == null) {
                validators = new HashMap<String, ILicenseKeyValidator>();
            }
            if (!validators.containsKey("NOOP")) {
                validators.put("NOOP", new NoOpValidator());
            }
            if (!validators.containsKey(DEFAULT_VALIDATOR)) {
                CertificateWorker worker7 = CertificateWorker.createCertificateWorker(ITEXT7_CERTIFICATE_RESOURCE_PATH, "iText7 certificate");
                validators.put(DEFAULT_VALIDATOR, new LicenseKey7Validator(worker7));
            }
            if (!validators.containsKey("5")) {
                CertificateWorker worker5 = CertificateWorker.createCertificateWorker(ITEXT5_CERTIFICATE_RESOURCE_PATH, "iText5 certificate");
                validators.put("5", new LicenseKey5Validator(worker5));
            }
        }
    }

    static {
        currentDefault = DEFAULT_VALIDATOR;
        initialTimes = new HashMap<String, Long>();
        LicenseKey.initializeiTextValidators();
    }
}

