/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.CellLayout;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TextCellLayout
extends CellLayout {
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 2;
    private int m_align;
    private String m_font;
    private boolean m_fixedText = false;
    private boolean m_addAnotherCellForTheMinusSign = false;
    private String m_difo;
    private boolean m_ignoreDifo = false;
    private int m_wait = 0;
    private int m_currentWait = 0;

    public TextCellLayout(int col, int width, int align, boolean a_addAnotherCellForTheMinusSign) {
        super(col, width);
        this.m_align = align;
        this.m_addAnotherCellForTheMinusSign = a_addAnotherCellForTheMinusSign;
    }

    public TextCellLayout(int col, String text, int width, int align) {
        super(col, width);
        if (text.trim().equals("")) {
            text = "&nbsp;";
        }
        this.setText(text);
        this.m_fixedText = true;
        this.m_align = align;
    }

    public TextCellLayout(int col, int width, String align, boolean a_addAnotherCellForTheMinusSign) {
        super(col, width);
        this.m_align = BML2HTML.getAlign(align);
        this.m_addAnotherCellForTheMinusSign = a_addAnotherCellForTheMinusSign;
    }

    public void setDifo(String a_difo) {
        if (a_difo != null && a_difo.startsWith("%D(%")) {
            this.m_difo = a_difo;
        }
    }

    public void setIgnoreDifo(boolean a_ignore) {
        this.m_ignoreDifo = a_ignore;
    }

    public String formatAccordingToDifo(String a_unformattedString) {
        if (!this.m_ignoreDifo && this.m_difo != null && this.m_difo.startsWith("%D")) {
            try {
                return this.convertDate(a_unformattedString, this.m_difo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_ignoreDifo = false;
        return a_unformattedString;
    }

    private String convertDate(String date, String difo) {
        if (date.length() > 6 && difo.length() > 4) {
            int day = Integer.parseInt(date.substring(0, 2));
            int month = Integer.parseInt(date.substring(3, 5));
            int year = Integer.parseInt(date.substring(6));
            Date theDate = new Date(year - 1900, month - 1, day);
            String format = difo.substring(3, difo.length() - 1);
            format = format.replaceAll("(?i)%0*4y", "yyyy");
            format = format.replaceAll("(?i)%0*2y", "yy");
            format = format.replaceAll("(?i)%0*2d", "dd");
            format = format.replaceAll("(?i)%d", "d");
            format = format.replaceAll("(?i)%0*2m", "MM");
            format = format.replaceAll("(?i)%m", "M");
            format = format.replaceAll("(?i)%h", "MMM");
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(theDate);
        }
        return date;
    }

    public int getAlign() {
        return this.m_align;
    }

    public String getFont() {
        return this.m_font;
    }

    public void setFont(String s) {
        this.m_font = s;
    }

    public boolean addAnotherCellForTheMinusSign() {
        return this.m_addAnotherCellForTheMinusSign;
    }

    @Override
    public void setText(String txt) {
        if (!this.m_fixedText) {
            super.setText(txt);
        }
    }

    public void setWait(int wait) {
        this.m_wait = wait;
        if (this.m_wait == -1) {
            this.m_fixedText = true;
        }
    }

    public void setCurrentWait(int wait) {
        this.m_currentWait = wait;
    }

    public int getWait() {
        return this.m_wait;
    }

    public int getCurrentWait() {
        return this.m_currentWait;
    }

    @Override
    public boolean canOverlap() {
        return this.m_currentWait > 0;
    }

    @Override
    public String getText() {
        if (this.m_currentWait > 0) {
            return "";
        }
        return super.getText();
    }

    public boolean isFixedText() {
        return this.m_fixedText;
    }

    @Override
    public boolean hasE() {
        return !this.isFixedText();
    }
}

