/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.java4less.raztec.AztecCode;
import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.rdatamatrix.RDataMatrix;
import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.BarcodeParameter;
import com.ssaglobal.bml.FileCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class BarcodeImageFactory {
    public static final int QRCODE = 500;
    public static final int AZTECCODE = 600;
    private static final String TRUE_VALUE = "true";
    private static final String BARCODE_1D_CLASS = "com.java4less.rbarcode.BarCode";
    private static final String BARCODE_PDF_CLASS = "com.java4less.rbarcode.BarCode2D";
    private static final String BARCODE_AZTECCODE_CLASS = "com.java4less.raztec.AztecCode";
    private static final String BARCODE_DATAMATRIX_CLASS = "com.java4less.rdatamatrix.RDataMatrix";
    private static final int PIXELS_PER_LINE = 30;
    private static final int PIXELS_PER_LINE_2D = 300;
    private static final int FONT_HEIGHT = 21;
    private static final int HORZ_MARGIN = 0;
    private static final int HORZ_MARGIN_EAN = 15;
    private static final int VERT_MARGIN = 0;
    private static final int NARROW_BAR_WIDTH = 3;
    private static final int PDF417_NARROW_BAR_WIDTH = 6;
    private static final int WIDE_BAR_NARROW_BAR_FACTOR = 2;
    private static final int MAX_WIDTH = 2400;
    private static final int MAX_HEIGHT = 1800;
    private final int barType;
    private final String value;
    private final Map<String, BarcodeParameter> parameters;
    private int heightInNumberOfLines;
    private int widthInChars;
    private double fontSizeFactor;
    private BufferedImage barcodeImage;
    private boolean rotated = false;

    public BarcodeImageFactory(int barType, String value, Map<String, BarcodeParameter> parameters, int widthInChars, int heightInNumberOfLines, double fontSizeFactor) {
        this.barType = barType;
        this.value = value;
        this.parameters = parameters;
        this.heightInNumberOfLines = heightInNumberOfLines;
        if (this.heightInNumberOfLines < 0) {
            this.heightInNumberOfLines = 3;
        }
        this.widthInChars = widthInChars;
        if (this.widthInChars < 0) {
            this.widthInChars = 10;
        }
        this.fontSizeFactor = fontSizeFactor;
    }

    public void createBarcode() {
        try {
            switch (this.barType) {
                case 30: {
                    this.createBarcode2D();
                    break;
                }
                case 500: {
                    this.createQRCode();
                    break;
                }
                case 600: {
                    this.createAztecCode();
                    break;
                }
                case 31: {
                    this.createDataMatrix();
                    break;
                }
                default: {
                    this.createBarcode1D();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getBarcodeImage() {
        return this.barcodeImage;
    }

    public boolean isRotated() {
        return this.rotated;
    }

    private void createBarcode1D() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName(BARCODE_1D_CLASS);
        BarCode barCode = (BarCode)c.newInstance();
        this.createBarcode1D(barCode, c);
    }

    private static int getImageType() {
        return 1;
    }

    private void createBarcode1D(BarCode barCode, Class<?> c) {
        BufferedImage image;
        BarcodeParameter rotateParameter;
        barCode.barType = this.barType;
        barCode.code = this.value;
        int horzMargin = 0;
        if (this.barType == 10 || this.barType == 11 || this.barType == 6 || this.barType == 12) {
            horzMargin = 15;
        }
        int rotate = (rotateParameter = this.parameters.get("rotate")) == null ? 0 : Integer.parseInt(rotateParameter.getValue());
        boolean swap = rotate > 45 && rotate < 135 || rotate > 225 && rotate < 315;
        int vertPixels = 30 * this.heightInNumberOfLines - (int)(31.5 * this.fontSizeFactor);
        barCode.resolution = 1;
        barCode.barHeightCM = vertPixels;
        barCode.leftMarginCM = horzMargin;
        barCode.topMarginCM = 0.0;
        barCode.X = 3.0;
        if (swap) {
            barCode.barHeightCM = 10.5 * (double)this.widthInChars;
            this.rotated = true;
        }
        if (this.barType == 30) {
            barCode.X = 6.0;
        }
        barCode.N = 2.0;
        barCode.textFont = new Font("SansSerif", 0, (int)(21.0 * this.fontSizeFactor));
        barCode.postnetHeightShortBar = barCode.barHeightCM / 3.0;
        barCode.postnetHeightTallBar = barCode.barHeightCM;
        if (this.barType != 13) {
            barCode.checkCharacter = false;
        }
        if (this.barType == 16) {
            barCode.checkCharacter = true;
        }
        barCode.setSize(2400, 1800);
        this.createBarcode(barCode, c);
        if (barCode.textFont == null) {
            barCode.barHeightCM = vertPixels + (int)(27.93 * this.fontSizeFactor);
        }
        if (this.barType == 10 || this.barType == 11) {
            String value;
            if (barCode.UPCEANSupplement2) {
                value = barCode.code;
                barCode.code = value.substring(0, value.length() - 2);
                barCode.supplement = value.substring(value.length() - 2);
            }
            if (barCode.UPCEANSupplement5) {
                value = barCode.code;
                barCode.code = value.substring(0, value.length() - 5);
                barCode.supplement = value.substring(value.length() - 5);
            }
        }
        if ((image = new BufferedImage(2400, 1800, BarcodeImageFactory.getImageType())).getGraphics() instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)image.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            barCode.paint((Graphics)g2d);
        } else {
            barCode.paint(image.getGraphics());
        }
        horzMargin = (int)((double)barCode.resolution * barCode.leftMarginCM);
        int vertMargin = (int)((double)barCode.resolution * barCode.topMarginCM);
        int w = Math.min(2400, barCode.getPaintedArea().width + horzMargin);
        int h = Math.min(1800, barCode.getPaintedArea().height + vertMargin + 3);
        this.barcodeImage = image.getSubimage(0, 0, w, h);
    }

    private void createBarcode2D() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName(BARCODE_PDF_CLASS);
        BarCode2D bc2d = (BarCode2D)c.newInstance();
        this.createBarcode1D((BarCode)bc2d, c);
    }

    private void createQRCode() throws InstantiationException, IllegalAccessException, ClassNotFoundException, WriterException, IOException {
        int vertPixels = 2400;
        int horzPixels = 2400;
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.MARGIN, 0);
        boolean latin = true;
        for (int i = 0; i < this.value.length(); ++i) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(this.value.charAt(i));
            if (block.toString().contains("LATIN")) continue;
            latin = false;
            break;
        }
        if (!latin) {
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        }
        BitMatrix matrix = new MultiFormatWriter().encode(this.value, BarcodeFormat.QR_CODE, horzPixels, vertPixels, hints);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        this.convertAlign();
        this.addImage(image, 2400, 2400);
        this.barcodeImage = image;
    }

    private void convertAlign() {
        if (this.parameters.get("imageHAlign") != null && this.parameters.get("imageVAlign") != null) {
            int halign = BML2HTML.getAlign(this.parameters.get("imageHAlign").getValue());
            int valign = BML2HTML.getAlign(this.parameters.get("imageVAlign").getValue());
            double widthPerc = 15.0;
            if (this.parameters.get("imageWidth") != null) {
                widthPerc = Double.parseDouble(this.parameters.get("imageWidth").getValue());
            }
            double heightPerc = widthPerc;
            if (this.parameters.get("imageHeight") != null) {
                heightPerc = Double.parseDouble(this.parameters.get("imageHeight").getValue());
            }
            double xPerc = 0.0;
            if (halign == 1) {
                xPerc = 50.0 - 0.5 * widthPerc;
            } else if (halign == 2) {
                xPerc = 100.0 - widthPerc;
            }
            double yPerc = 0.0;
            if (valign == 1) {
                yPerc = 50.0 - 0.5 * heightPerc;
            } else if (valign == 2) {
                yPerc = 100.0 - heightPerc;
            }
            this.parameters.put("imageX", new BarcodeParameter("imageX", "" + xPerc, false));
            this.parameters.put("imageY", new BarcodeParameter("imageY", "" + yPerc, false));
            this.parameters.put("imageWidth", new BarcodeParameter("imageWidth", "" + widthPerc, false));
            this.parameters.put("imageHeight", new BarcodeParameter("imageHeight", "" + widthPerc, false));
        }
    }

    private void addImage(BufferedImage barcodeImage, int w, int h) {
        BarcodeParameter imagePath = this.parameters.get("image");
        if (imagePath != null) {
            try {
                BufferedImage additionalImage = ImageIO.read(FileCache.getInstance().getLocalFile(imagePath.getValue()));
                Double x = Double.parseDouble(this.parameters.get("imageX").getValue());
                Double y = Double.parseDouble(this.parameters.get("imageY").getValue());
                Double width = Double.parseDouble(this.parameters.get("imageWidth").getValue());
                Double height = Double.parseDouble(this.parameters.get("imageHeight").getValue());
                int xx = (int)(0.01 * x * (double)w);
                int yy = (int)(0.01 * y * (double)h);
                int ww = (int)(0.01 * width * (double)w);
                int hh = (int)(0.01 * height * (double)h);
                barcodeImage.getGraphics().drawImage(additionalImage, xx, yy, ww, hh, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createAztecCode() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName(BARCODE_AZTECCODE_CLASS);
        AztecCode azCode = (AztecCode)c.newInstance();
        int vertPixels = 300 * this.heightInNumberOfLines;
        int horzPixels = 2400;
        azCode.setSize(horzPixels, vertPixels);
        azCode.setModuleSize(3);
        azCode.setMargin(0);
        azCode.setCode(this.value);
        this.createBarcode(azCode, c);
        BufferedImage image = new BufferedImage(2400, 1800, BarcodeImageFactory.getImageType());
        azCode.paint(image.getGraphics());
        int w = Math.min(2400, azCode.getCurrentX());
        int h = Math.min(1800, azCode.getCurrentY());
        this.barcodeImage = image.getSubimage(0, 0, w, h);
    }

    private void createDataMatrix() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName(BARCODE_DATAMATRIX_CLASS);
        RDataMatrix dmCode = (RDataMatrix)c.newInstance();
        int vertPixels = 300 * this.heightInNumberOfLines;
        int horzPixels = 2400;
        dmCode.setSize(horzPixels, vertPixels);
        dmCode.N = 3.0;
        dmCode.margin = 0;
        dmCode.code = this.value;
        this.createBarcode(dmCode, c);
        BufferedImage image = new BufferedImage(2400, 1800, BarcodeImageFactory.getImageType());
        dmCode.paint(image.getGraphics());
        int w = Math.min(2400, dmCode.getPaintedWidth());
        int h = Math.min(1800, dmCode.getPaintedHeight());
        this.barcodeImage = image.getSubimage(0, 0, w, h);
    }

    private void createBarcode(Object barcode, Class<?> c) {
        for (Map.Entry<String, BarcodeParameter> pairs : this.parameters.entrySet()) {
            BarcodeParameter par = pairs.getValue();
            if (!par.useReflection() || this.setMethod(c, barcode, par)) continue;
            BarcodeImageFactory.setField(c, barcode, par);
        }
    }

    private boolean setMethod(Class<?> c, Object barcode, BarcodeParameter parameter) {
        boolean methodFound = false;
        try {
            String methodName = "set" + parameter.getName();
            String parValue = parameter.getValue();
            Method mt = this.searchForMethod(c, methodName);
            if (null != mt) {
                Class<?> clType = mt.getParameterTypes()[0];
                if (clType == Integer.TYPE) {
                    mt.invoke(barcode, Integer.parseInt(parValue));
                    methodFound = true;
                } else if (clType == String.class) {
                    mt.invoke(barcode, parValue);
                    methodFound = true;
                } else if (clType == Byte.TYPE) {
                    mt.invoke(barcode, (byte)Integer.parseInt(parValue));
                    methodFound = true;
                } else if (clType == Boolean.TYPE) {
                    mt.invoke(barcode, parValue.equalsIgnoreCase(TRUE_VALUE));
                    methodFound = true;
                } else if (clType == Double.TYPE) {
                    mt.invoke(barcode, Double.parseDouble(parValue));
                    methodFound = true;
                } else if (clType == Color.class) {
                    mt.invoke(barcode, Color.decode(parValue));
                    methodFound = true;
                } else if (clType == Font.class) {
                    Font font = null;
                    if (!parValue.trim().equals("") && !parValue.equalsIgnoreCase("null")) {
                        font = Font.decode(parValue);
                    }
                    mt.invoke(barcode, font);
                    methodFound = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methodFound;
    }

    private Method searchForMethod(Class<?> c, String name) {
        Method method = null;
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] types;
            if (!methods[i].getName().equalsIgnoreCase(name) || (types = methods[i].getParameterTypes()).length != 1) continue;
            method = methods[i];
            break;
        }
        return method;
    }

    private static boolean setField(Class<?> c, Object barcode, BarcodeParameter parameter) {
        boolean fieldFound = false;
        try {
            String parValue = parameter.getValue();
            Field fld = BarcodeImageFactory.searchForField(c, parameter.getName());
            Class<?> flType = fld.getType();
            if (flType == Integer.TYPE) {
                fld.setInt(barcode, Integer.parseInt(parValue));
                fieldFound = true;
            } else if (flType == String.class) {
                fld.set(barcode, parValue);
                fieldFound = true;
            } else if (flType == Byte.TYPE) {
                fld.setByte(barcode, (byte)Integer.parseInt(parValue));
                fieldFound = true;
            } else if (flType == Boolean.TYPE) {
                fld.setBoolean(barcode, parValue.equalsIgnoreCase(TRUE_VALUE));
                fieldFound = true;
            } else if (flType == Double.TYPE) {
                fld.setDouble(barcode, Double.parseDouble(parValue));
                fieldFound = true;
            } else if (flType == Color.class) {
                fld.set(barcode, Color.decode(parValue));
                fieldFound = true;
            } else if (flType == Font.class) {
                Font font = null;
                if (!parValue.trim().equals("") && !parValue.equalsIgnoreCase("null")) {
                    font = Font.decode(parValue);
                }
                fld.set(barcode, font);
                fieldFound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldFound;
    }

    private static Field searchForField(Class<?> c, String name) {
        Field field = null;
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equalsIgnoreCase(name)) continue;
            field = fields[i];
            break;
        }
        return field;
    }
}

