/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.licensekey.LicenseKey;
import com.itextpdf.svg.converter.SvgConverter;
import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.BarcodeImage;
import com.ssaglobal.bml.CellWidths;
import com.ssaglobal.bml.ExactPosData;
import com.ssaglobal.bml.FallbackFontProvider;
import com.ssaglobal.bml.FileCache;
import com.ssaglobal.bml.Grid;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.Labels;
import com.ssaglobal.bml.LanguageToLCConverter;
import com.ssaglobal.bml.NotoMapper;
import com.ssaglobal.bml.PDFTextWrap;
import com.ssaglobal.bml.SimpleFontProvider;
import com.ssaglobal.bml.Style;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BML2PDF
extends BML2HTML {
    private static boolean s_licenseLoaded = false;
    private String m_pdfFileName;
    private long m_free;
    private long m_total;
    private long m_max;
    private Document m_document;
    private PdfWriter m_pdfWriter;
    private HashMap<String, Grid.SizedFont> m_fonts;
    private float m_currentYPos;
    private float m_charWidth;
    private float m_charHeight;
    private float m_leftMargin;
    private float m_rightMargin;
    private float m_topMargin;
    private float m_bottomMargin;
    private int m_linesPerPage;
    private int m_linesPerPageMax;
    private boolean m_doPageBreaksMySelf;
    private int m_lineNr;
    private String m_arialuniFont;
    private String m_arialFont;
    private String m_couriernewFont;
    private com.itextpdf.kernel.colors.Color m_lineColor;
    private boolean m_debug;
    private boolean m_debugShowProps;
    private boolean m_negativeSignsArePresent;
    private String m_reportId;
    public static float DEFAULT_FONT_SIZE_FACTOR = 1.84f;
    private static final float FONT_SIZE_FACTOR_MAX = 3.5f;
    private float m_fontSizeFactor;
    private float m_dynamicFactor;
    private int m_landscape;
    private boolean m_usePWidth = false;
    private boolean m_ignoreSpecificProperties = false;
    private Grid m_grid;
    private CellWidths m_cellWidths;
    private int m_layoutStrategy;
    private Properties m_properties;
    private String m_pdfPropertiesLocation;
    private float m_pageWidth;
    private float m_pageHeight;
    private PageSize m_pageSize;
    private boolean m_useExactPositioning;
    private String m_backgroundImage;
    private HashMap<String, BackgroundImage> m_backgroundImages;
    private HashMap<String, Count> m_numberOfLinesPerLayout;
    private Count m_currentCount;
    private PdfPage m_currentPage;
    private NotoMapper m_notoMapper;
    private boolean m_signaturePrinted;
    private Labels m_labels;
    private boolean m_boundBarCodes = true;
    private static final Logger logger = Logger.getLogger(BML2PDF.class.getName());
    private HashMap<String, com.itextpdf.layout.element.Image> m_imageCache = new HashMap();
    private String m_pageWidthAsReportAttribute;
    private String m_pageHeightAsReportAttribute;

    protected static void loadLicense() {
        if (s_licenseLoaded) {
            return;
        }
        s_licenseLoaded = true;
        try {
            String key = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><license date=\"2019-10-03\" issuer=\"iText Group NV\" library=\"3\"><licensee expire=\"2069-10-03\"><name>Bram Vijfhuizen</name><email>bram.vijfhuizen@infor.com</email><company>Infor</company><version>7.1</version><key>18df2-f7baf-c7be3-75a5b</key><licensetype>oem</licensetype><signature>Vj0x+cr4MdUNySgeaXWVdl4EQS2yYQ7+cJM/pdKeM0hVp+BPXdYKR4+AyFl4EvN0Ip15jDf5bTekWh+ruX2GEqga5kxaDl45wVglHqC3rqfDtYmMb8GwfiFCf1yX5OzKtklr+vaQZE++34bnrQ0xjPYYepfi0SAygE//1o30Kq+p9dkvhZoetBjxwyjAVqp3WzKi1h1qRDio550jHYTHPW3cTOtgh+yuGis/2nZcaQbk4ENs0zL9RA3IpMXAph1t0TggFhFKqVpzHyFRSwST8Hdt9xjwdDkMYvlwCuJeej2WG1cjeGVNve15aKmoqLmE8zEOYT2XDvTvobN/MOy8Hgd31g4NsWXtJUHhXb52x8grmTTFcuYIhAVsln/jMgeZWJWPWewbwJJjHmFuUCJ6aL+44ozTzSBdLhGOR4aFtvu7nAxGfewScT+unttvkGlvFep+EEFPMYVV6zVr6gvrgaEPaRl3RwjKNqUfuX377JrD+iH+TkuSsshMmB/ofDjYFcueO/WZQ/5N0ENUirTUg+IjbIg1kzoqP3FV0/6COQu/X8gRPAPKatEOts1PSBlS35HT3fddB49gTs/0+yw1iShAWhDLrUtk/m0PfVCN9PrpdecnUcidJaEFfEZVsOtU0Q93dxYsSXUaVjCrpQPWFwzu3GyE3aiuCnKZWSkC+yU=</signature></licensee></license>";
            BML2PDF.loadLicense(key);
            String key2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><license date=\"2019-10-09\" issuer=\"iText Group NV\" library=\"3\"><licensee expire=\"2069-10-09\"><name>Bram Vijfhuizen</name><email>bram.vijfhuizen@infor.com</email><company>Infor</company><version>7.1</version><key>90372-cae5c-a5786-9ce65</key><licensetype>oem</licensetype><signature>SWMd1n3lG0xYMfoDKJlmZGgG9qpZK6LNhGBRxBEb5QPYGbfwZ4aRpcZFubezpMbT85v5h0SllSoCCnthIBQ1ulJaZ7iBWLLfb4nVAPGCx4ILOdkr7vuDhrYjCFip/9MKkIDNG+yDHCWC1d3FUEAYq5W/iimGFpCdD55jJKzyuxLZUhW+epYu9kBzOBQbCGR2tk7zENkky13Vmi+Nfa7eLg8TWlJth47Nqpa8kBrrUvD7jQv8iU+agvP5JvqJQ8CDElE56S+fAEbWyH7pkOc478OYDva8asQmQ1gAcqCxRajmqSVU9Z2mWqLQuDRMjZ9H4gGzJsT4qQGq5Di4vhSYY/AmxFeTlgpH1qpwpIS4zWQ+FaRdf6Y0R8PL4RFRikyTnBXLxFxP4+5RzPqsHuzBjrYlqB3GN0PaNv6A9X50hcTqAPMbpeiC9lMtSGXh5Khj2aKOcqQAcKLaFgKQdyv1ryaJbLeqZQ15PVR4pB5pU80XnAOxq2FH5wuEdPHCn03gaZBUCuExj6ln/nK1l6liUSfFpQezN9wivSPOVSYmIMnySZTNr83rvKK56A+2hqV8huen9bHJcBWGhck6bLunPledKfQgkpZribdq+GDE0Og9Lwih2AtO6uHH7MckrrCX4dEVPlj/VUv3uR6sQokCMG1GIs5YfT0CZjtd2PG+0Ik=</signature></licensee><product deploymenttype=\"\" expire=\"2069-10-09\" licensetype=\"oem\" major=\"2\" name=\"pdfCalligraph\" platform=\"java\"><signature>GiAoHxrrE/zwlXHrH4+QrjsjRfe2vleWgCsxV9p4kOPCwTfhS4fivdy9OndG/+Qembv0LWApCE4mnWGSQ1E2/m3nidCWGQOFzIqSO0i7oJn+V7N7y/9Ntg1wt/7ugqN7N1ifhu0OecJIhmIFRLZihzWxWWROck6ra9WX/tBGBCECknGfMsO/Y8cWOEPfrQk2Jz3rtVPFmkSVHuEibkKd09rqo4kOQQ8lIbp0YKmeu5yWOBj8yc/xJLVoOnxMLs0lEyFCqAk+7xX/e4s613hRDlZ7NuG6Plfvwy1g45d0N7VnExzzNXkXAGvDAWhjxZ7sfseyIGnvUf2FsZ8ThQGIL4v92DLmsvo0YV7zMbLw+jEmYQOGO4ucLOLumwYptzfo8vkXz4CweWwUNDGiHMnEAFzDpd8Jr9om3+kY00UslAbkN5K1EdngEcz9pJCT52NhvcXdGwTdxRRBfuOT6nTNv55gVL19SnGai3xghQ5n2EyGvvWo6BBRvQ7Vn9ZXMpW2rJOrhde4fZ6tJcFfIIIqDyR3YBCca5LrnWl+/s2FOTrig6pOfxPAqof104k5DyUzn3LkkC0qUaz6orvdXbtdBRCOnkn+CnOFaePLnAxuDZ9ZjVMt2F2n9R386SIG3utti7RZYtZ5rDR0MKCHEwXymcBbqK2DPgXWExIUP+nlhwg=</signature></product></license>";
            BML2PDF.loadLicense(key2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot load the license", e);
        }
    }

    private static void loadLicense(String key) throws UnsupportedEncodingException {
        byte[] bytes = null;
        try {
            bytes = key.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            bytes = key.getBytes();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        LicenseKey.loadLicenseFile((InputStream)bis);
    }

    private String getDefaultFont(boolean a_monospaced) {
        String font = null;
        if (a_monospaced && font == null && this.m_couriernewFont != null) {
            font = this.m_couriernewFont;
        }
        if (font == null && this.m_arialuniFont != null) {
            font = this.m_arialuniFont;
        }
        if (font == null && this.m_arialFont != null) {
            font = this.m_arialFont;
        }
        return font;
    }

    private String getITextEncoding() {
        return "Identity-H";
    }

    @Override
    public String getLocale() {
        if (this.isBidi()) {
            return "ISO88596";
        }
        return super.getLocale();
    }

    @Override
    public void init() {
        super.init();
        BML2PDF.loadLicense();
        this.m_fonts = new HashMap();
        this.m_currentYPos = 0.0f;
        this.m_charWidth = 0.0f;
        this.m_charHeight = 0.0f;
        this.m_leftMargin = 0.0f;
        this.m_rightMargin = 0.0f;
        this.m_topMargin = 0.0f;
        this.m_bottomMargin = 0.0f;
        this.m_linesPerPage = 0;
        this.m_linesPerPageMax = 0;
        this.m_doPageBreaksMySelf = false;
        this.m_lineNr = -1;
        this.m_arialuniFont = null;
        this.m_arialFont = null;
        this.m_couriernewFont = null;
        this.m_lineColor = ColorConstants.LIGHT_GRAY;
        this.m_debug = false;
        this.m_debugShowProps = false;
        this.m_negativeSignsArePresent = false;
        this.m_reportId = null;
        this.m_fontSizeFactor = DEFAULT_FONT_SIZE_FACTOR;
        this.m_dynamicFactor = 1.6f;
        this.m_landscape = 150;
        this.m_usePWidth = false;
        this.m_ignoreSpecificProperties = false;
        this.m_grid = null;
        this.m_cellWidths = new CellWidths();
        this.m_layoutStrategy = 1;
        this.m_properties = null;
        this.m_pageWidth = 21.0f;
        this.m_pageHeight = 29.7f;
        this.m_pageSize = null;
        this.m_useExactPositioning = false;
        this.m_backgroundImage = "";
        this.m_backgroundImages = new HashMap();
        this.m_numberOfLinesPerLayout = new HashMap();
        this.m_currentCount = null;
        this.m_currentPage = null;
        this.m_notoMapper = null;
        this.m_signaturePrinted = false;
        this.m_boundBarCodes = true;
    }

    private void tryToFindArialFonts() {
        String couriernew;
        File couriernewFile;
        String uniFile;
        File theFile;
        if (this.m_arialuniFont != null) {
            return;
        }
        String defaultProportionalFont = this.getProperty(this.getProperties(), "default-proportional-font", null);
        String defaultMonospacedFont = this.getProperty(this.getProperties(), "default-monospaced-font", null);
        if (defaultProportionalFont != null) {
            this.m_arialuniFont = defaultProportionalFont;
            if (defaultMonospacedFont == null) {
                defaultMonospacedFont = defaultProportionalFont;
            }
            this.m_couriernewFont = defaultMonospacedFont;
            return;
        }
        File file = this.getLocalFileNoException("c:/notosans/");
        if (file.exists()) {
            this.m_arialuniFont = file.getAbsolutePath();
            this.m_couriernewFont = file.getAbsolutePath();
            return;
        }
        String os = System.getProperty("os.name").toLowerCase();
        String dir = "";
        if (os.indexOf("windows") > -1) {
            String windir = System.getenv("windir");
            dir = windir + File.separator + "fonts" + File.separator;
        } else if (os.indexOf("solaris") > -1) {
            dir = File.separator + "usr";
            dir = dir + File.separator + "openwin";
            dir = dir + File.separator + "lib";
            dir = dir + File.separator + "X11";
            dir = dir + File.separator + "fonts";
            dir = dir + File.separator + "TrueType" + File.separator;
        } else if (os.indexOf("linux") > -1) {
            dir = File.separator + "usr";
            dir = dir + File.separator + "lib";
            dir = dir + File.separator + "X11";
            dir = dir + File.separator + "fonts";
            dir = dir + File.separator + "TrueType" + File.separator;
        } else {
            dir = File.separator + "usr";
            dir = dir + File.separator + "share";
            dir = dir + File.separator + "fonts";
            dir = dir + File.separator + "default";
            dir = dir + File.separator + "TrueType" + File.separator;
        }
        String fontPath = this.getFontPath();
        if (fontPath != null && !(dir = fontPath).endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if ((theFile = this.getLocalFileNoException(uniFile = dir + "arialuni.ttf")).exists()) {
            this.m_arialuniFont = uniFile;
        } else {
            uniFile = dir + "ARIALUNI.TTF";
            theFile = this.getLocalFileNoException(uniFile);
            if (theFile.exists()) {
                this.m_arialuniFont = uniFile;
            }
        }
        if (this.m_arialuniFont == null) {
            String arial = dir + "arial.ttf";
            File arialFile = this.getLocalFileNoException(arial);
            if (arialFile.exists()) {
                this.m_arialFont = arial;
            } else {
                arial = dir + "ARIAL.TTF";
                arialFile = this.getLocalFileNoException(arial);
                if (arialFile.exists()) {
                    this.m_arialFont = arial;
                }
            }
        }
        if ((couriernewFile = this.getLocalFileNoException(couriernew = dir + "cour.ttf")).exists()) {
            this.m_couriernewFont = couriernew;
        } else {
            couriernew = dir + "COUR.TTF";
            couriernewFile = this.getLocalFileNoException(couriernew);
            if (couriernewFile.exists()) {
                this.m_couriernewFont = couriernew;
            }
        }
    }

    @Override
    public int getPWidth() {
        return super.getPWidth();
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }

    @Override
    public boolean getReencodeCharacters() {
        return false;
    }

    @Override
    public boolean getReencodeCharacterApos() {
        return false;
    }

    @Override
    protected void setNumberOfCharactersForTheCurrentLine(int a_number, String a_font, boolean a_justify) {
        super.setNumberOfCharactersForTheCurrentLine(a_number, a_font, a_justify);
        if ((double)a_number < 0.5 * (double)this.getPWidth()) {
            a_number = (int)(0.5 * (double)this.getPWidth());
        }
        if (a_number > this.getPWidth()) {
            a_number = this.getPWidth();
        }
        if (!this.useDynamicCols() || this.m_usePWidth && !this.m_useExactPositioning) {
            a_number = this.getPWidth();
        }
        if (this.m_document != null) {
            this.m_charWidth = (this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin) / (float)a_number;
        }
        if (this.getPass() == 2 || this.useDynamicCols()) {
            this.createGrid(a_number, a_justify);
        }
    }

    private void createGrid(int a_number, boolean a_justify) {
        boolean changedGrid;
        boolean bl = changedGrid = this.m_grid == null || a_number != this.m_grid.getWidth() || a_justify != this.m_grid.getJustify() && !this.m_useExactPositioning;
        if (changedGrid) {
            float fs;
            this.writeGrid();
            float[] widths = null;
            float fontSize = -1.0f;
            if (this.m_layoutStrategy == 1) {
                if (this.getPass() == 1 || this.getPass() == 2) {
                    widths = this.m_cellWidths.load("" + a_number + a_justify);
                    fontSize = this.m_cellWidths.getFontSize(a_number);
                }
            } else if (this.m_layoutStrategy != 2 && this.m_layoutStrategy == 3 && this.getPass() == 2) {
                widths = this.m_cellWidths.load("" + a_number + a_justify);
                fontSize = this.m_cellWidths.getFontSize(a_number);
            }
            if ((fs = this.getFontSize()) > 3.5f) {
                fs = 3.5f;
            }
            float originalFontSize = fs * this.m_charWidth;
            this.m_grid = this.m_useExactPositioning ? new Grid(this.m_document, this.m_pageSize.getWidth(), this.m_pageSize.getHeight(), this.m_leftMargin, this.m_rightMargin, this.m_lineColor, this.isBidi(), this.isMonospaced(), this.m_debug, fontSize, this.m_currentYPos) : new Grid(this.m_document, a_number, this.m_charWidth, this.m_charHeight, this.m_pageSize.getWidth(), this.m_leftMargin, this.m_rightMargin, this.m_lineColor, this.isBidi(), this.useDynamicCols(), this.isMonospaced(), this.m_debug, widths, originalFontSize, fontSize, this.m_fontSizeFactor, a_justify);
        }
    }

    @Override
    public boolean useDynamicCols() {
        if (this.m_useExactPositioning) {
            return false;
        }
        return this.getFontSize() >= this.m_dynamicFactor;
    }

    @Override
    protected void writeBorderCell(int col, int a_width, int a_borderType, Style a_style) throws IOException {
        if (this.getPass() == 1) {
            return;
        }
        Grid grid = this.m_grid;
        grid.getClass();
        this.m_grid.addLine(new Grid.Line(grid, col, this.m_currentYPos, a_width, a_borderType, a_style));
    }

    public float getFontSize() {
        return this.m_fontSizeFactor;
    }

    private void showTextAligned(int align, String txt, int x, float y, float rotation, BaseDirection runDirection, int width, String fontString, Style a_style) {
        if (this.getPass() == 2 || this.useDynamicCols()) {
            Grid.SizedFont font = null;
            font = this.isMonospaced() || a_style != null && a_style.getMonospace() != null && a_style.getMonospace() != false ? this.getFont(fontString, true, a_style == null ? null : a_style.getForegroundColor(), txt) : this.getFont(fontString, false, a_style == null ? null : a_style.getForegroundColor(), txt);
            if (a_style != null && a_style.getBold() != null) {
                font.setBold(a_style.getBold());
            }
            if (a_style != null && a_style.getItalic() != null) {
                font.setItalic(a_style.getItalic());
            }
            if (a_style != null && a_style.getUnderline() != null) {
                font.setUnderline(a_style.getUnderline());
            }
            if (a_style != null && a_style.getHAlign() != null) {
                align = a_style.getHAlign();
            }
            Grid grid = this.m_grid;
            grid.getClass();
            this.m_grid.addTextBlock(new Grid.TextBlock(grid, align, txt, font, x, y, rotation, runDirection, width, fontString, a_style));
        }
    }

    private Grid.SizedFont getFont(String fontString, boolean monospace, String fgColor, String txt) {
        Grid.SizedFont font = this.getFont(monospace, fontString, txt);
        if (fgColor != null) {
            font.setColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(Color.decode(fgColor)));
        }
        return font;
    }

    @Override
    protected void writeTextCell(String a_text, int a_col, int a_width, int a_align, boolean a_splitUpTheTextInSpans, String a_font, Style a_style) throws IOException {
        boolean bidiText;
        boolean monospace;
        if (a_text == null) {
            return;
        }
        if (a_text.equals("&nbsp;")) {
            a_text = " ";
        }
        float y = this.m_currentYPos;
        boolean writeNegativeSignOnNumbersOnTheRight = false;
        boolean bl = monospace = this.isMonospaced() || a_style != null && a_style.getMonospace() != null && a_style.getMonospace() != false;
        if (a_splitUpTheTextInSpans && !monospace && a_align == 2) {
            if (this.getPass() == 2 && !this.m_negativeSignsArePresent) {
                writeNegativeSignOnNumbersOnTheRight = false;
            } else {
                String txt = null;
                boolean signIsNotVisible = true;
                if (a_text.length() == 0) {
                    txt = a_text;
                } else {
                    char lastChar = a_text.charAt(a_text.length() - 1);
                    signIsNotVisible = Character.isDigit(lastChar);
                    if (signIsNotVisible) {
                        txt = a_text;
                    } else {
                        txt = a_text.substring(0, a_text.length() - 1);
                        this.m_negativeSignOnNumbersOnTheRight = "" + lastChar;
                    }
                }
                a_text = txt;
                --a_width;
                if (!signIsNotVisible) {
                    writeNegativeSignOnNumbersOnTheRight = true;
                    this.m_negativeSignsArePresent = true;
                }
            }
        }
        BaseDirection runDirection = BaseDirection.LEFT_TO_RIGHT;
        boolean bl2 = bidiText = this.isBidi() || this.isRtlText(a_text) && this.isFirstTextOfCurrentLineRtl();
        if (bidiText) {
            if (a_align == 0) {
                a_align = 2;
            } else if (a_align == 2) {
                a_align = 0;
            }
            runDirection = BaseDirection.RIGHT_TO_LEFT;
        }
        if (a_align == 0) {
            this.showTextAligned(0, a_text, a_col, y, 0.0f, runDirection, a_width, a_font, a_style);
            if (writeNegativeSignOnNumbersOnTheRight) {
                this.showTextAligned(0, this.m_negativeSignOnNumbersOnTheRight, a_col + a_width, y, 0.0f, runDirection, 1, a_font, a_style);
            }
        } else if (a_align == 1) {
            this.showTextAligned(1, a_text, a_col, y, 0.0f, runDirection, a_width, a_font, a_style);
        } else if (a_align == 2) {
            this.showTextAligned(2, a_text, a_col, y, 0.0f, runDirection, a_width, a_font, a_style);
            if (writeNegativeSignOnNumbersOnTheRight) {
                this.showTextAligned(0, this.m_negativeSignOnNumbersOnTheRight, a_col + a_width, y, 0.0f, runDirection, 1, a_font, a_style);
            }
        }
    }

    private File getFontFile(boolean a_monospace, String fontName, String a_txt) {
        File file;
        String path = this.getProperty(this.getProperties(), fontName, null);
        if (path != null && (file = this.getLocalFileNoException(path)).exists()) {
            return file;
        }
        path = this.getDefaultFont(a_monospace);
        if (path == null) {
            if (a_monospace) {
                return new File("some_non_existing_monospace_font_file");
            }
            return new File("some_non_existing_font_file");
        }
        file = this.getLocalFileNoException(path);
        return file;
    }

    private Grid.SizedFont getBaseFont(boolean a_monospace, String a_prop, String a_txt) {
        String fontName = this.getFontName(a_prop);
        File fontFile = this.getFontFile(a_monospace, fontName, a_txt);
        Grid.SizedFont baseFont = this.m_fonts.get(fontFile.getAbsolutePath());
        if (baseFont == null) {
            try {
                if (!fontFile.exists()) {
                    PdfFont font = a_monospace ? PdfFontFactory.createFont((String)"Courier") : PdfFontFactory.createFont((String)"Helvetica");
                    baseFont = new Grid.SizedFont(font, 12.0f, false, a_monospace);
                } else if (fontFile.isDirectory()) {
                    FontProvider provider = null;
                    File notoCheck = this.getLocalFileNoException(new File(fontFile, "NotoSans-Regular.ttf").getAbsolutePath());
                    if (notoCheck.exists()) {
                        if (this.m_notoMapper == null) {
                            this.m_notoMapper = new NotoMapper(fontFile, this.m_debug);
                        }
                        provider = this.m_notoMapper;
                    } else {
                        provider = new FontProvider();
                        provider.addDirectory(fontFile.getAbsolutePath());
                    }
                    baseFont = new Grid.SizedFont(provider, 12.0f, false, a_monospace);
                } else {
                    PdfFont font = this.createFont(fontFile);
                    File defaultFont = this.getLocalFileNoException(this.getDefaultFont(false));
                    if (fontFile.getAbsolutePath().equals(defaultFont.getAbsolutePath())) {
                        baseFont = new Grid.SizedFont(font, 12.0f, false, a_monospace);
                    } else {
                        Grid.SizedFont defaultSizedFont = this.getBaseFont(false, "default.please", null);
                        FontProvider provider = defaultSizedFont.getProvider();
                        if (provider == null) {
                            provider = new SimpleFontProvider(defaultSizedFont.getFont());
                        }
                        FallbackFontProvider fallbackProvider = new FallbackFontProvider(font, provider);
                        baseFont = new Grid.SizedFont(fallbackProvider, 12.0f, false, a_monospace);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create the font: " + fontFile.getAbsolutePath(), e);
            }
            this.m_fonts.put(fontFile.getAbsolutePath(), baseFont);
        }
        return baseFont;
    }

    private PdfFont createFont(File fontFile) throws IOException {
        PdfFont font = PdfFontFactory.createFont((String)fontFile.getAbsolutePath(), (String)this.getITextEncoding(), (boolean)true);
        return font;
    }

    private Grid.SizedFont getFont(boolean a_monospace, String a_font, String a_txt) {
        String fontName = this.getFontName(a_font);
        float fontSizeInPt = this.getFontSizeInPt(a_font);
        a_font = fontName.replaceAll(" ", "");
        Grid.SizedFont baseFont = this.getBaseFont(a_monospace, a_font, a_txt);
        if (fontSizeInPt < 0.0f) {
            float fontSize = this.getFontSize();
            if (fontSize > 3.5f) {
                fontSize = 3.5f;
            }
            fontSizeInPt = fontSize * this.m_charWidth;
            Grid.SizedFont font = new Grid.SizedFont(baseFont, fontSizeInPt, false, a_monospace);
            return font;
        }
        Grid.SizedFont font = new Grid.SizedFont(baseFont, fontSizeInPt, true, a_monospace);
        return font;
    }

    private String getFontName(String a_font) {
        if (this.getFontSizeInPt(a_font) < 0.0f) {
            return a_font;
        }
        int index = a_font.indexOf(40);
        return a_font.substring(0, index - 1).trim();
    }

    private float getFontSizeInPt(String a_font) {
        int index = a_font.indexOf(40);
        if (index == -1) {
            return -1.0f;
        }
        if ((index = (a_font = a_font.substring(index + 1)).indexOf(41)) == -1) {
            return -1.0f;
        }
        String[] size = (a_font = a_font.substring(0, index)).split(" ");
        if (size.length != 2) {
            return -1.0f;
        }
        if (!size[1].toLowerCase().equals("pt")) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(size[0]);
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    @Override
    protected void writeBarcode(int col, int width, BML2HTML.BarCode barCode, String a_font, Style a_style) throws IOException {
        if (this.getPass() < 2) {
            return;
        }
        this.writeBarcodeJ4L(col, barCode, a_font, a_style);
    }

    @Override
    protected void writeImage(int col, int width, int height, String filePathOrSvg, int halign, int valign, Style a_style, String signatureId, boolean svg, boolean background) {
        if (this.getPass() < 2) {
            return;
        }
        try {
            if (signatureId != null && !this.m_signaturePrinted) {
                this.m_signaturePrinted = true;
                Grid grid = this.m_grid;
                grid.getClass();
                this.m_grid.addImage(new Grid.ImageBlock(grid, col, this.m_currentYPos, width, height, null, false, false, halign, valign, a_style, signatureId), background);
            } else if (svg) {
                ByteArrayInputStream bis = new ByteArrayInputStream(filePathOrSvg.getBytes("UTF-8"));
                com.itextpdf.layout.element.Image image = SvgConverter.convertToImage((InputStream)bis, (PdfDocument)this.m_document.getPdfDocument());
                Grid grid = this.m_grid;
                grid.getClass();
                this.m_grid.addImage(new Grid.ImageBlock(grid, col, this.m_currentYPos, width, height, image, false, false, halign, valign, a_style, null), background);
            } else {
                if (filePathOrSvg.trim().isEmpty()) {
                    return;
                }
                com.itextpdf.layout.element.Image image = this.m_imageCache.get(filePathOrSvg);
                if (image == null) {
                    File file = this.getLocalFile(filePathOrSvg);
                    ImageData data = ImageDataFactory.create((String)file.getAbsolutePath());
                    image = new com.itextpdf.layout.element.Image(data);
                    String label = this.m_labels.getLabel("image.filename");
                    image.getAccessibilityProperties().setAlternateDescription(label + " " + file.getName());
                    this.m_imageCache.put(filePathOrSvg, image);
                }
                Grid grid = this.m_grid;
                grid.getClass();
                this.m_grid.addImage(new Grid.ImageBlock(grid, col, this.m_currentYPos, width, height, image, false, false, halign, valign, a_style, signatureId), background);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeBarcodeJ4L(int col, BML2HTML.BarCode barCode, String a_font, Style a_style) throws IOException {
        if (barCode == null || barCode.getValue() == null || barCode.getValue().isEmpty()) {
            return;
        }
        float y = this.m_currentYPos;
        String barCodeType = this.getBarcodeType(barCode);
        if (barCodeType != null) {
            Properties props = this.getProperties();
            BufferedImage bi = this.getBufferedImage(barCode, barCodeType);
            if (bi != null) {
                ImageData data = ImageDataFactory.create((Image)bi, null);
                com.itextpdf.layout.element.Image image = new com.itextpdf.layout.element.Image(data);
                String label = this.m_labels.getLabel("barcode.value");
                image.getAccessibilityProperties().setAlternateDescription(label + " " + barCode.getValue());
                boolean fillHeight = !barCode.isRotated();
                Grid grid = this.m_grid;
                grid.getClass();
                Grid.ImageBlock imageBlock = new Grid.ImageBlock(grid, col, y, barCode.getWidth(), barCode.getHeight(), image, fillHeight, "yes".equals(this.getProperty(props, "extend-barcodes", "no")), 0, 0, a_style, null);
                this.m_grid.addImage(imageBlock, false);
            }
        } else {
            this.writeTextCell("Unsupported bar code: " + barCode.getType(), col, 30, 0, false, "", null);
        }
    }

    private String getBarcodeType(BML2HTML.BarCode barCode) {
        String barCodeType = null;
        if (barCode.getJ4LType() != null) {
            barCodeType = barCode.getJ4LType();
        } else if (barCode.getType() == 1) {
            barCodeType = "EAN13";
        } else if (barCode.getType() == 2) {
            barCodeType = "EAN8";
        } else if (barCode.getType() == 5) {
            barCodeType = "UPCA";
        } else if (barCode.getType() == 6) {
            barCodeType = "UPCE";
        } else if (barCode.getType() == 7) {
            barCodeType = "INTERLEAVED25";
        } else if (barCode.getType() != 8) {
            if (barCode.getType() == 9) {
                barCodeType = "BAR39";
            } else if (barCode.getType() == 10) {
                barCodeType = "CODE128";
            } else if (barCode.getType() == 11) {
                barCodeType = "EAN128";
            } else if (barCode.getType() != 12 && barCode.getType() != 13) {
                if (barCode.getType() == 14) {
                    barCodeType = "BAR39";
                } else if (barCode.getType() != 15) {
                    if (barCode.getType() == 16) {
                        barCodeType = "CODE11";
                    } else if (barCode.getType() == 17) {
                        barCodeType = "CODABAR";
                    } else if (barCode.getType() != 18) {
                        if (barCode.getType() == 19) {
                            barCodeType = "BAR39EXT";
                        } else if (barCode.getType() != 20 && barCode.getType() != 21 && barCode.getType() != 22 && barCode.getType() != 23 && barCode.getType() != 24 && barCode.getType() != 25 && barCode.getType() != 26 && barCode.getType() != 27 && barCode.getType() != 28) {
                            if (barCode.getType() == 29) {
                                barCodeType = "POSTNET";
                            } else if (barCode.getType() == 30) {
                                barCodeType = "POSTNET";
                            } else if (barCode.getType() == 31) {
                                barCodeType = "POSTNET";
                            } else if (barCode.getType() != 32 && barCode.getType() != 33 && barCode.getType() != 34 && barCode.getType() != 35 && barCode.getType() != 36) {
                                if (barCode.getType() == 37) {
                                    barCodeType = "CODE93";
                                } else if (barCode.getType() == 38) {
                                    barCodeType = "CODE93EXT";
                                } else if (barCode.getType() != 39 && barCode.getType() != 40 && barCode.getType() != 41 && barCode.getType() != 42 && barCode.getType() != 43 && barCode.getType() != 44 && barCode.getType() != 45 && barCode.getType() != 46 && barCode.getType() != 47 && barCode.getType() != 48 && barCode.getType() != 49 && barCode.getType() != 50 && barCode.getType() != 51 && barCode.getType() != 52 && barCode.getType() != 53 && barCode.getType() != 54 && barCode.getType() != 55 && barCode.getType() != 56 && barCode.getType() != 57 && barCode.getType() != 58 && barCode.getType() != 59 && barCode.getType() != 60 && barCode.getType() != 61 && barCode.getType() != 62 && barCode.getType() != 63 && barCode.getType() != 64 && barCode.getType() != 65 && barCode.getType() != 66 && barCode.getType() != 67 && barCode.getType() != 68 && barCode.getType() != 69 && barCode.getType() != 70 && barCode.getType() != 71 && barCode.getType() != 72 && barCode.getType() != 73 && barCode.getType() != 74 && barCode.getType() != 1001 && barCode.getType() != 1002) {
                                    if (barCode.getType() == 1003) {
                                        barCodeType = "PDF417";
                                    } else if (barCode.getType() == 1004) {
                                        barCodeType = "AZTECCODE";
                                    } else if (barCode.getType() == 1005) {
                                        barCodeType = "DATAMATRIX";
                                    } else if (barCode.getType() != 1006 && barCode.getType() != 1007 && barCode.getType() != 1008 && barCode.getType() != 1009 && barCode.getType() == 1010) {
                                        barCodeType = "QRCODE";
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return barCodeType;
    }

    private void writeGrid() {
        if (this.getPass() == 2 || this.useDynamicCols()) {
            if (this.m_grid != null) {
                if (this.useDynamicCols()) {
                    if (this.getPass() == 1) {
                        if (this.m_layoutStrategy == 1) {
                            this.m_grid.calculateCellDimensions(null);
                            this.m_cellWidths.save("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getCellWidths());
                            this.m_cellWidths.setFontSize("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getFontSize());
                        } else if (this.m_layoutStrategy != 2 && this.m_layoutStrategy == 3) {
                            // empty if block
                        }
                    } else {
                        if (this.m_layoutStrategy != 1) {
                            if (this.m_layoutStrategy == 2) {
                                this.m_grid.calculateCellDimensions(null);
                            } else if (this.m_layoutStrategy == 3) {
                                this.m_grid.calculateCellDimensions(null);
                                this.m_cellWidths.save("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getCellWidths());
                                this.m_cellWidths.setFontSize("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getFontSize());
                            }
                        }
                        PdfCanvas canvas = new PdfCanvas(this.m_currentPage);
                        this.m_grid.write(canvas, false);
                    }
                } else {
                    PdfCanvas canvas = new PdfCanvas(this.m_currentPage);
                    this.m_grid.write(canvas, true);
                }
            }
            this.m_grid = null;
        }
    }

    protected void checkPageSize() {
        if (this.m_landscape > 0 && this.getPWidth() >= this.m_landscape && this.m_pageWidth < this.m_pageHeight) {
            float h;
            float w = this.m_pageWidth;
            this.m_pageWidth = h = this.m_pageHeight;
            this.m_pageHeight = w;
        }
    }

    protected void createPageSize() {
        PageSize pageSize;
        float w = BML2PDF.convertCmToDocPix(this.m_pageWidth);
        float h = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        Rectangle rect = new Rectangle(w, h);
        this.m_pageSize = pageSize = new PageSize(rect);
    }

    @Override
    protected void writePageHeader() throws IOException {
        this.writeGrid();
        if (this.getPass() == 1) {
            this.m_linesPerPage = 0;
            this.m_doPageBreaksMySelf = false;
            return;
        }
        this.m_lineNr = 0;
        if (this.m_currentPage != null) {
            this.m_currentPage.flush(true);
        }
        this.m_currentPage = this.m_document.getPdfDocument().addNewPage(this.m_pageSize);
        this.startYPos();
        if (this.getPass() == 2 && !this.m_backgroundImage.isEmpty()) {
            this.createGrid(this.getPWidth(), true);
            this.m_grid.setCurrentYPos(this.m_currentYPos);
            Style style = new Style();
            ExactPosData data = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, BML2PDF.convertCmToDocPix(this.m_pageHeight) - this.m_topMargin - this.m_bottomMargin, -1.0f, 1, 0);
            style.setExactPosData(data);
            style.setPreserveRatio(this.parseBoolean(this.getProperty(this.getProperties(), "backgroundImagePreserveRatio", "true"), true));
            this.writeImage(-1, -1, -1, this.m_backgroundImage, 1, 1, style, null, false, true);
        }
    }

    protected Document createDocument(PdfWriter writer) {
        float h;
        float w;
        if (this.m_useExactPositioning) {
            w = BML2PDF.convertCmToDocPix(this.m_pageWidth);
            h = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        } else {
            w = BML2PDF.convertCmToDocPix(this.m_pageWidth);
            h = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        }
        Rectangle rect = new Rectangle(w, h);
        PdfDocument pdfdoc = new PdfDocument(writer);
        this.setMoreInfo(pdfdoc);
        return new Document(pdfdoc, new PageSize(rect));
    }

    private void setMoreInfo(PdfDocument document) {
        HashMap<String, String> version = new HashMap<String, String>();
        version.put("Converter-Version", this.getConverterVersion());
        document.getDocumentInfo().setMoreInfo(version);
    }

    private String getConverterVersion() {
        HashMap<String, String> properties = new HashMap<String, String>();
        IOUtils.read(this.getClass().getResourceAsStream("/bml.version.properties"), properties);
        return (String)properties.get("version");
    }

    private float getProperty(Properties a_props, String a_prop, float a_value) {
        try {
            String v = this.getProperty(a_props, a_prop, "" + a_value);
            if (v != null && !v.equals("")) {
                return Float.parseFloat(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a_value;
    }

    private String getProperty(Properties a_props, String a_prop, String a_value) {
        try {
            String v = null;
            if (!this.m_ignoreSpecificProperties) {
                v = a_props.getProperty(this.m_reportId + "." + a_prop);
            }
            if (v == null) {
                v = a_props.getProperty(a_prop);
            }
            if (v != null) {
                v = v.trim();
            }
            if (v != null && !v.equals("")) {
                return v;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a_value;
    }

    private String getFontPath() {
        try {
            Properties props = this.getProperties();
            if (props != null) {
                String fontPath = this.getProperty(props, "ttf-font-path", "");
                if (!"".equals(fontPath)) {
                    return fontPath;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Properties getProperties() {
        try {
            if (this.m_properties == null) {
                Properties props;
                if (this.m_pdfPropertiesLocation != null && !this.m_pdfPropertiesLocation.isEmpty()) {
                    Properties props2;
                    File file = this.getLocalFile(this.m_pdfPropertiesLocation);
                    if (!file.exists()) {
                        throw new RuntimeException("Cannot load PDF.properties: " + this.m_pdfPropertiesLocation);
                    }
                    this.m_properties = props2 = BML2PDF.getPropertiesForFile(file);
                    return props2;
                }
                this.m_properties = props = this.getPDFProperties();
                return props;
            }
            return this.m_properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load PDF.properties", e);
        }
    }

    private Properties getPDFProperties() throws IOException {
        CodeSource src = BML2PDF.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            try {
                URL url = new URL(src.getLocation(), "PDF.properties");
                File file = this.getLocalFile(url.getFile());
                return BML2PDF.getPropertiesForFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Properties();
    }

    public BufferedImage getBarcodeImage(BML2HTML.BarCode barCode, String a_pdfPropertiesLocation) {
        this.m_pdfPropertiesLocation = a_pdfPropertiesLocation;
        BufferedImage bi = null;
        String barCodeType = this.getBarcodeType(barCode);
        if (barCodeType != null) {
            bi = this.getBufferedImage(barCode, barCodeType);
        }
        return bi;
    }

    private BufferedImage getBufferedImage(BML2HTML.BarCode barCode, String barCodeType) {
        BufferedImage bi = null;
        Properties props = this.getProperties();
        String parameters1 = this.getProperty(props, "BARCODE", "");
        String reportId = this.m_reportId;
        this.m_reportId = null;
        String parameters2 = this.getProperty(props, barCodeType, "");
        String parameters3 = null;
        if (reportId != null) {
            String prop = reportId + "." + barCodeType;
            if (props != null && props.containsKey(prop)) {
                parameters3 = this.getProperty(props, prop, "");
            }
        }
        this.m_reportId = reportId;
        String parameters4 = barCode.getOptions();
        BarcodeImage barcodeImage = new BarcodeImage(barCodeType, barCode.getValue(), parameters1, parameters2, parameters3, parameters4);
        int height = barCode.getHeight();
        int width = barCode.getWidth();
        if (this.useExactPosition()) {
            float charWidth = 3.0f;
            float charHeight = 8.0f;
            height = (int)(BML2PDF.convertMmToDocPix(height) / charHeight);
            width = (int)(BML2PDF.convertMmToDocPix(width) / charWidth);
        }
        BufferedImage bufferedImage = bi = barcodeImage == null ? null : barcodeImage.getBarcodeImage(width, height, 1.0);
        if (barcodeImage != null) {
            barCode.setRotated(barcodeImage.isRotated());
            if (!barCode.isRotated()) {
                double charWidth = 1.0;
                double charHeight = 2.8;
                double ratio1 = this.useExactPosition() ? (double)(barCode.getWidth() / barCode.getHeight()) : (double)barCode.getWidth() * charWidth / (charHeight * (double)barCode.getHeight());
                double ratio2 = (double)bi.getWidth() / (1.0 * (double)bi.getHeight());
                if (ratio2 > ratio1 && this.m_boundBarCodes) {
                    double factor = ratio2 / ratio1;
                    height = (int)Math.round((double)height * factor);
                    bi = barcodeImage.getBarcodeImage(width, height, factor);
                }
            }
        }
        return bi;
    }

    private static Properties getPropertiesForFile(File file) {
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                return props;
            }
            Properties props = new Properties();
            return props;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load PDF.properties", e);
        }
    }

    private boolean parseBoolean(String b, boolean def) {
        if (b == null) {
            return def;
        }
        if (b.equalsIgnoreCase("no")) {
            return false;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        if (b.equalsIgnoreCase("yes")) {
            return true;
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        return def;
    }

    @Override
    protected void writeReportHeader(String reportTitle, String reportLanguage) throws IOException {
        this.tryToFindArialFonts();
        try {
            if (this.m_document == null) {
                this.m_labels = new Labels(LanguageToLCConverter.getLocale(reportLanguage));
                if (reportTitle == null) {
                    reportTitle = this.m_labels.getLabel("report.title");
                }
                this.m_pdfWriter = new PdfWriter(this.m_pdfFileName, new WriterProperties().addUAXmpMetadata());
                this.m_document = this.createDocument(this.m_pdfWriter);
                this.m_document.getPdfDocument().setTagged();
                this.m_document.getPdfDocument().getCatalog().setLang(new PdfString(LanguageToLCConverter.getLC(reportLanguage)));
                this.m_document.getPdfDocument().getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
                this.m_document.getPdfDocument().getDocumentInfo().setTitle(reportTitle);
            }
            String pw = this.m_pageWidthAsReportAttribute;
            String ph = this.m_pageHeightAsReportAttribute;
            Properties props = this.getProperties();
            this.m_pageWidth = this.getProperty(props, "page-width", 21.0f);
            this.m_pageHeight = this.getProperty(props, "page-height", 29.7f);
            this.m_landscape = (int)this.getProperty(props, "landscape", 150.0f);
            this.m_usePWidth = "no".equalsIgnoreCase(this.getProperty(props, "stretch-text", "yes"));
            if (pw != null && !pw.isEmpty()) {
                this.m_pageWidth = Float.parseFloat(pw);
                this.m_pageHeight = Float.parseFloat(ph);
                if (props.getProperty("landscape") == null) {
                    this.m_landscape = -1;
                }
                if (this.m_useExactPositioning) {
                    this.m_pageWidth *= 0.1f;
                    this.m_pageHeight *= 0.1f;
                }
            }
            this.m_pageSize = null;
            this.checkPageSize();
            this.createPageSize();
            if (this.getPass() == 1) {
                this.m_linesPerPage = 0;
                this.m_doPageBreaksMySelf = false;
            }
            float left = 2.0f;
            float right = 2.0f;
            float top = 1.5f;
            float bottom = 1.5f;
            int r = 192;
            int g = 192;
            int b = 192;
            if (this.m_useExactPositioning) {
                left = 10.0f * left;
                right = 10.0f * right;
                top = 10.0f * top;
                bottom = 10.0f * left;
            }
            left = this.getProperty(props, "left-margin", left);
            right = this.getProperty(props, "right-margin", right);
            top = this.getProperty(props, "top-margin", top);
            bottom = this.getProperty(props, "bottom-margin", bottom);
            if (this.m_useExactPositioning) {
                left = 0.1f * left;
                right = 0.1f * right;
                top = 0.1f * top;
                bottom = 0.1f * bottom;
            }
            r = (int)this.getProperty(props, "line-color-r", r);
            g = (int)this.getProperty(props, "line-color-g", g);
            b = (int)this.getProperty(props, "line-color-b", b);
            this.m_debug = "yes".equalsIgnoreCase(this.getProperty(props, "debug", "no"));
            this.m_debugShowProps = "yes".equalsIgnoreCase(this.getProperty(props, "debug.show.properties", "no"));
            this.m_fontSizeFactor = this.getProperty(props, "font-size-factor", DEFAULT_FONT_SIZE_FACTOR);
            this.m_dynamicFactor = this.getProperty(props, "dynamic-factor", 1.6f);
            this.m_layoutStrategy = (int)this.getProperty(props, "layout-strategy", 1.0f);
            if (this.m_layoutStrategy < 1 && this.m_layoutStrategy > 3) {
                this.m_layoutStrategy = 1;
            }
            this.m_backgroundImage = this.getProperty(props, "backgroundImage", "");
            this.m_boundBarCodes = "yes".equalsIgnoreCase(this.getProperty(props, "bound.barcodes", "yes"));
            this.m_lineColor = new DeviceRgb(r, g, b);
            this.m_leftMargin = this.m_pageSize.getWidth() * left / this.m_pageWidth;
            this.m_rightMargin = this.m_pageSize.getWidth() * right / this.m_pageWidth;
            this.m_topMargin = this.m_pageSize.getHeight() * top / this.m_pageHeight;
            this.m_bottomMargin = this.m_pageSize.getHeight() * bottom / this.m_pageHeight;
            this.m_charWidth = (this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin) / (float)this.getPWidth();
            float min = (this.m_pageSize.getHeight() - this.m_topMargin - this.m_bottomMargin) / (float)this.m_linesPerPageMax;
            this.m_charHeight = 3.0f * this.m_charWidth;
            if (this.m_charHeight > min) {
                this.m_charHeight = min;
            }
            if (this.m_charHeight < 1.5f * this.m_charWidth) {
                this.m_charHeight = 2.0f * this.m_charWidth;
                this.m_linesPerPageMax = (int)((this.m_pageSize.getHeight() - this.m_topMargin - this.m_bottomMargin) / this.m_charHeight) - 2;
                this.m_doPageBreaksMySelf = true;
            }
            this.startYPos();
            if (this.m_debug && this.getPass() == 1 && this.m_debugShowProps) {
                this.writeDebugText("Contents of PDF.properties:", true);
                this.writeDebugText("");
                if (props != null) {
                    for (String name : props.stringPropertyNames()) {
                        String value = props.getProperty(name);
                        value = value.replaceAll(" ", "_");
                        String s = name + ": " + value;
                        this.writeDebugText(s);
                    }
                } else {
                    this.writeDebugText("None");
                }
                this.writeDebugText("");
                this.writeDebugText("Other properties:", true);
                this.writeDebugText("");
                this.writeDebugText("Font size factor: " + this.getFontSize());
                this.writeDebugText("Font size factor max: 3.5");
                this.writeDebugText("");
                this.writeDebugText("Converter version: " + this.getConverterVersion());
                this.writeDebugText("");
                this.writeDebugText("Location of PDF.properties:", true);
                this.writeDebugText("");
                if (this.m_pdfPropertiesLocation != null) {
                    this.writeDebugText(this.m_pdfPropertiesLocation);
                } else {
                    CodeSource src = BML2PDF.class.getProtectionDomain().getCodeSource();
                    if (src != null) {
                        URL url = new URL(src.getLocation(), "PDF.properties");
                        this.writeDebugText(url.getFile());
                    }
                }
                this.writeDebugText("");
                this.writeDebugText("Font paths:", true);
                this.writeDebugText("");
                this.writeDebugText("Default proportional font: " + this.m_arialuniFont);
                this.writeDebugText("Default fixed font: " + this.m_couriernewFont);
                this.writeDebugText("");
                this.writeDebugText("Chinese sample text:", true);
                this.writeDebugText("");
                this.writeDebugText("These are the protagonists in 'Hero', a movie by Zhang Yimou:");
                this.writeDebugText("      \u7121\u540d (Nameless), \u6b98\u528d (Broken Sword), ");
                this.writeDebugText("      \u98db\u96ea (Flying Snow), \u5982\u6708 (Moon), ");
                this.writeDebugText("      \u79e6\u738b (the King) and \u9577\u7a7a (Sky).");
                this.writeDebugText("");
                this.writeDebugText("Some Java properties:", true);
                this.writeDebugText("");
                this.writeDebugText("free memory (inital): " + this.m_free / 0x100000L + "m");
                this.writeDebugText("total memory (initial): " + this.m_total / 0x100000L + "m");
                this.writeDebugText("max memory (initial): " + this.m_max / 0x100000L + "m");
                this.writeDebugText("free memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
                this.writeDebugText("total memory: " + Runtime.getRuntime().totalMemory() / 0x100000L + "m");
                this.writeDebugText("max memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "m");
                if (this.m_notoMapper != null) {
                    for (int i = 0; i < this.m_notoMapper.getDebugLines().size(); ++i) {
                        this.writeDebugText(this.m_notoMapper.getDebugLines().get(i));
                    }
                }
                List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
                for (int i = 0; i < args.size(); ++i) {
                    this.writeDebugText("vm arg " + i + ": " + args.get(i));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDebugText(String txt) throws IOException {
        this.writeDebugText(txt, false);
    }

    private void writeDebugText(String txt, boolean header) throws IOException {
        int index = txt.indexOf(": ");
        String name = index == -1 ? "" : txt.substring(0, index);
        String value = index == -1 ? txt : txt.substring(index + 1, txt.length());
        File file = new File(value.trim());
        if (file.exists()) {
            value = " <some path>/" + file.getName();
        }
        txt = index == -1 ? value : name + ":" + value;
        int margin = 0;
        if (txt == null || txt.contentEquals("")) {
            margin = 15;
        }
        Grid.SizedFont font = this.getFont(false, "debug (10 pt)", txt);
        if (header) {
            font.setBold(true);
            font.setUnderline(true);
        }
        PDFTextWrap.TabStopParagraph p = new PDFTextWrap.TabStopParagraph(txt, font);
        p.setMarginTop(margin);
        p.setMarginBottom(0.0f);
        this.m_document.add((IBlockElement)p);
    }

    @Override
    protected void writeStartOfNewLine() throws IOException {
        if (this.getPass() == 1) {
            ++this.m_linesPerPage;
            return;
        }
        ++this.m_lineNr;
        if (!this.m_useExactPositioning && this.m_doPageBreaksMySelf && this.m_lineNr >= this.m_linesPerPageMax) {
            this.writePageHeader();
        }
        if (this.getRowFixedOffset() >= 0.0f) {
            this.m_currentYPos = this.m_pageSize.getHeight() - BML2PDF.convertMmToDocPix(this.getRowFixedOffset());
            if (this.m_grid != null) {
                this.m_grid.setCurrentYPos(this.m_currentYPos);
            }
        }
    }

    @Override
    protected void writeEmptyLine() throws IOException {
        if (this.getPass() == 1) {
            ++this.m_linesPerPage;
            return;
        }
        ++this.m_lineNr;
        if (this.m_useExactPositioning || !this.m_doPageBreaksMySelf || this.m_lineNr >= this.m_linesPerPageMax) {
            // empty if block
        }
        this.calcYPos();
    }

    @Override
    protected void writePageBreakIfNeeded() throws IOException {
        if (this.getPass() == 1 && this.m_linesPerPage > this.m_linesPerPageMax) {
            this.m_linesPerPageMax = this.m_linesPerPage;
        }
    }

    @Override
    protected void writeReportEnd() throws IOException {
        if (this.getPass() == 1 && this.m_linesPerPage > this.m_linesPerPageMax) {
            this.m_linesPerPageMax = this.m_linesPerPage;
        }
        this.writeGrid();
    }

    @Override
    protected void writeEndOfLine() throws IOException {
        if (this.getPass() == 1) {
            return;
        }
        this.calcYPos();
    }

    private void calcYPos() {
        if (this.m_useExactPositioning) {
            float rowHeight = this.getRowHeight();
            float rowHeightInDocPix = BML2PDF.convertMmToDocPix(rowHeight);
            this.m_currentYPos -= rowHeightInDocPix;
        } else {
            this.m_currentYPos -= this.m_charHeight;
        }
        if (this.m_grid != null) {
            this.m_grid.setCurrentYPos(this.m_currentYPos);
        }
    }

    private void startYPos() {
        this.m_currentYPos = this.m_pageSize.getHeight() - this.m_topMargin;
        if (this.m_grid != null) {
            this.m_grid.setCurrentYPos(this.m_currentYPos);
        }
    }

    public static float convertMmToDocPix(float mm) {
        return 72.0f * mm / 25.4f;
    }

    public static float convertDocPixToMm(float px) {
        return 25.4f * px / 72.0f;
    }

    public static float convertCmToDocPix(float cm) {
        return 72.0f * cm / 2.54f;
    }

    public static float convertPtToDocPix(float pt) {
        float cm = 0.035277f * pt;
        return BML2PDF.convertCmToDocPix(cm);
    }

    @Override
    public void convert(String a_bmlFile, String a_file) throws SAXException, IOException {
        this.m_pdfFileName = a_file;
        this.m_free = Runtime.getRuntime().freeMemory();
        this.m_total = Runtime.getRuntime().totalMemory();
        this.m_max = Runtime.getRuntime().maxMemory();
        super.convert(a_bmlFile, a_file);
        FileCache.getInstance().ready();
        if (this.m_document != null) {
            this.m_document.close();
        }
    }

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        String layout;
        BackgroundImage image;
        String id;
        if (name.equals("report")) {
            id = attributes.getValue("id");
            if (id == null) {
                id = "<unknown>";
            }
            if (id.length() > 15) {
                try {
                    String reportId;
                    this.m_reportId = reportId = id.substring(1, 3) + id.substring(13, id.length());
                }
                catch (Exception e) {
                    this.m_reportId = id;
                }
            }
            String pw = attributes.getValue("pagewidth");
            String ph = attributes.getValue("pageheight");
            this.m_pageWidthAsReportAttribute = pw;
            this.m_pageHeightAsReportAttribute = ph;
            this.m_ignoreSpecificProperties = "yes".equalsIgnoreCase(attributes.getValue("ignoreSpecificPDFproperties"));
            this.m_useExactPositioning = attributes.getValue("pwidth") == null;
        }
        super.startElement(not_used_1, not_used_2, name, attributes);
        if (name.equals("property")) {
            String nme = attributes.getValue("name");
            String val = attributes.getValue("value");
            nme = nme.replaceAll(" ", "");
            this.getProperties().setProperty(nme, val);
        } else if (name.equals("special") || name.equals("field") || name.equals("bgitem") || name.equals("image") || name.equals("barcode") || name.equals("text") || name.equals("signature") || name.equals("svg")) {
            if (this.m_useExactPositioning) {
                float xpos = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("xpos"), -1.0));
                float ypos = -BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("ypos"), -1.0));
                float width = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("width"), -1.0));
                float height = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("height"), -1.0));
                float leading = (float)this.parseDouble(attributes.getValue("lineheight"), 1.0);
                int maxlines = this.parseInt(attributes.getValue("multiline"), 1);
                int valign = BML2HTML.getAlign(attributes.getValue("valign"));
                ExactPosData data = new ExactPosData(xpos, ypos, width, height, leading, maxlines, valign);
                this.getLastAddedCell().getStyle().setExactPosData(data);
            }
        } else if (name.equals("layout")) {
            if (this.getPass() == 1) {
                this.m_currentCount = new Count();
                if (this.m_useExactPositioning) {
                    this.m_currentCount.m_count = 1;
                    this.m_numberOfLinesPerLayout.put(attributes.getValue("id"), this.m_currentCount);
                } else {
                    this.m_currentCount.m_count = 0;
                    this.m_numberOfLinesPerLayout.put(attributes.getValue("id"), this.m_currentCount);
                }
            } else if (this.getPass() == 2) {
                id = attributes.getValue("id");
                String bgi = attributes.getValue("backgroundImage");
                String bgipr = attributes.getValue("backgroundImagePreserveRatio");
                if (!this.m_useExactPositioning) {
                    id = id + ".1";
                }
                if (bgi != null) {
                    BackgroundImage image2 = new BackgroundImage();
                    image2.m_backgroundImage = bgi;
                    image2.m_preserveRatio = this.parseBoolean(bgipr, true);
                    this.m_backgroundImages.put(id, image2);
                }
            }
        } else if (name.equals("lline")) {
            if (this.getPass() == 1) {
                ++this.m_currentCount.m_count;
            }
        } else if ((name.equals("row") || name.equals("emptyline")) && this.getPass() == 2 && (image = this.m_backgroundImages.get(layout = attributes.getValue("layout"))) != null) {
            if (this.m_useExactPositioning) {
                float rowHeight = this.getRowHeight();
                ExactPosData data = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, BML2PDF.convertMmToDocPix(rowHeight), -1.0f, 1, 0);
                Style style = new Style();
                style.setExactPosData(data);
                style.setPreserveRatio(image.m_preserveRatio);
                this.writeImage(-1, -1, -1, image.m_backgroundImage, 1, 1, style, null, false, true);
            } else {
                int nLines = 1;
                try {
                    nLines = this.m_numberOfLinesPerLayout.get((Object)layout.substring((int)0, (int)(layout.length() - 2))).m_count;
                }
                catch (Exception data) {
                    // empty catch block
                }
                float height = (float)nLines * this.m_charHeight;
                ExactPosData data = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, height, -1.0f, 1, 0);
                Style style = new Style();
                style.setExactPosData(data);
                style.setPreserveRatio(image.m_preserveRatio);
                this.writeImage(-1, -1, -1, image.m_backgroundImage, 1, 1, style, null, false, true);
            }
        }
    }

    @Override
    protected double getFontSizeInPt(int n) {
        double w = this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin;
        return (double)this.m_fontSizeFactor * w / (double)n;
    }

    public static void convertBML(String a_bmlFile, String a_file) {
        try {
            BML2PDF b2pdf = new BML2PDF();
            b2pdf.convert(a_bmlFile, a_file);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create the PDF file", e);
        }
    }

    protected void handleNameValue(String nameValue) {
        if (nameValue == null) {
            return;
        }
        if (nameValue != null && nameValue.startsWith("pdfprops=")) {
            int pos = nameValue.indexOf("=");
            this.m_pdfPropertiesLocation = nameValue.substring(pos + 1);
        } else if (nameValue != null && nameValue.startsWith("fileservice=")) {
            int pos = nameValue.indexOf("=");
            String fileService = nameValue.substring(pos + 1);
            FileCache fileCache = FileCache.getInstance(fileService);
            this.setFileCache(fileCache);
        }
    }

    public static void convertBML(String a_bmlFile, String a_file, String a_nameValue1, String a_nameValue2) {
        BML2PDF b2pdf = new BML2PDF();
        b2pdf.convert(a_bmlFile, a_file, a_nameValue1, a_nameValue2);
    }

    public static void convertBML(String a_bmlFile, String a_file, String a_nameValue) {
        BML2PDF.convertBML(a_bmlFile, a_file, a_nameValue, null);
    }

    protected void convert(String a_bmlFile, String a_file, String a_nameValue1, String a_nameValue2) {
        try {
            this.handleNameValue(a_nameValue1);
            this.handleNameValue(a_nameValue2);
            this.convert(a_bmlFile, a_file);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create the PDF file", e);
        }
    }

    protected void convert(String a_bmlFile, String a_file, String a_nameValue) {
        this.convert(a_bmlFile, a_file, a_nameValue, null);
    }

    public static void convertBML2PDF(String a_bmlFile, String a_file, boolean a_showCompanyLogo, boolean a_showNavigation, String a_font, String a_monospacedFont, boolean a_bidi) {
        try {
            BML2PDF b2pdf = new BML2PDF();
            b2pdf.setBidi(a_bidi);
            b2pdf.convert(a_bmlFile, a_file);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create the PDF file", e);
        }
    }

    public static String getVersion() {
        BML2PDF instance = new BML2PDF();
        return instance.getConverterVersion();
    }

    public static String convertToPDF(String a_bmlFile, String a_file, boolean a_showCompanyLogo, boolean a_showNavigation, String a_font, String a_monospacedFont, boolean a_bidi) {
        BML2PDF.convertBML2PDF(a_bmlFile, a_file, a_showCompanyLogo, a_showNavigation, a_font, a_monospacedFont, a_bidi);
        return "PDF";
    }

    @Override
    public boolean useExactPosition() {
        return this.m_useExactPositioning;
    }

    @Override
    public int getSpacesPerTab() {
        try {
            String spaces = this.getProperties().getProperty("spaces-per-tab");
            return Integer.parseInt(spaces);
        }
        catch (Exception exception) {
            return super.getSpacesPerTab();
        }
    }

    public static int getNumberOfLines(String filePathIn, String fontPath, double fontSize, double width) {
        return BML2PDF.saveLines(filePathIn, null, fontPath, fontSize, width);
    }

    public static int saveLines(String filePathIn, String filePathOut, String fontPath, double fontSize, double width) {
        return BML2PDF.saveLines(null, filePathIn, filePathOut, fontPath, fontSize, width);
    }

    public static int saveLinesOrThrows(String fileService, String filePathIn, String filePathOut, String fontPath, double fontSize, double width) throws Exception {
        BML2PDF.loadLicense();
        FileCache fileCache = null;
        if (fileService != null) {
            fileCache = FileCache.getInstance(fileService);
            filePathIn = fileCache.getLocalFileName(filePathIn);
            if (fontPath != null && !fontPath.isEmpty()) {
                fontPath = fileCache.getLocalFileName(fontPath);
            }
        }
        if (fontPath == null || fontPath.isEmpty()) {
            BML2PDF b2p = new BML2PDF();
            b2p.setFileCache(fileCache);
            b2p.tryToFindArialFonts();
            fontPath = b2p.m_arialuniFont;
        }
        File tmpFile = File.createTempFile("pdf", ".pdf");
        PdfDocument pdfdoc = new PdfDocument(new PdfWriter(tmpFile));
        Document document = new Document(pdfdoc, PageSize.A4);
        StringBuffer s = new StringBuffer();
        FileInputStream fis = new FileInputStream(filePathIn);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        char[] chars = new char[16];
        boolean go = true;
        while (go) {
            int n = isr.read(chars);
            if (n == -1) {
                go = false;
                continue;
            }
            s.append(chars, 0, n);
        }
        isr.close();
        fis.close();
        String text = s.toString();
        width = BML2PDF.convertMmToDocPix((float)width);
        PdfFont font = PdfFontFactory.createFont((String)fontPath, (String)"Identity-H", (boolean)true);
        Grid.SizedFont f = new Grid.SizedFont(font, (float)fontSize, false, false);
        PDFTextWrap.TabStopParagraph tsp = new PDFTextWrap.TabStopParagraph(text, f);
        Div div = new Div();
        div.setBorder((Border)new SolidBorder(1.0f));
        div.setFixedPosition(1, 0.0f, 600.0f, (float)width);
        div.add((IBlockElement)tsp);
        document.add((IBlockElement)div);
        String lines = tsp.toString();
        document.close();
        tmpFile.delete();
        if (fileCache != null) {
            fileCache.ready();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        if (filePathOut != null) {
            fos = new FileOutputStream(new File(filePathOut));
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(lines);
            osw.flush();
            fos.flush();
            osw.close();
            fis.close();
        }
        String[] allLines = lines.split("\n");
        return allLines.length;
    }

    public static int saveLines(String fileService, String filePathIn, String filePathOut, String fontPath, double fontSize, double width) {
        try {
            return BML2PDF.saveLinesOrThrows(fileService, filePathIn, filePathOut, fontPath, fontSize, width);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot save the lines", e);
            return -1;
        }
    }

    private class Count {
        public int m_count = 0;

        private Count() {
        }
    }

    private class BackgroundImage {
        public String m_backgroundImage;
        public boolean m_preserveRatio = true;

        private BackgroundImage() {
        }
    }
}

