/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.property;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphWidowsControl {
    private int minWidows;
    private int maxLinesToMove;
    private boolean overflowOnWidowsViolation;

    public ParagraphWidowsControl(int minWidows, int maxLinesToMove, boolean overflowParagraphOnViolation) {
        this.minWidows = minWidows;
        this.maxLinesToMove = maxLinesToMove;
        this.overflowOnWidowsViolation = overflowParagraphOnViolation;
    }

    public ParagraphWidowsControl setMinAllowedWidows(int minWidows, int maxLinesToMove, boolean overflowParagraphOnViolation) {
        this.minWidows = minWidows;
        this.maxLinesToMove = maxLinesToMove;
        this.overflowOnWidowsViolation = overflowParagraphOnViolation;
        return this;
    }

    public int getMinWidows() {
        return this.minWidows;
    }

    public int getMaxLinesToMove() {
        return this.maxLinesToMove;
    }

    public boolean isOverflowOnWidowsViolation() {
        return this.overflowOnWidowsViolation;
    }

    public void handleViolatedWidows(ParagraphRenderer widowsRenderer, String message) {
        Logger logger = LoggerFactory.getLogger(ParagraphWidowsControl.class);
        if (widowsRenderer.getOccupiedArea() != null && widowsRenderer.getLines() != null) {
            int pageNumber = widowsRenderer.getOccupiedArea().getPageNumber();
            String warnText = MessageFormatUtil.format((String)"Widows constraint violated for paragraph split at page {0}. Min number of widows: {1}; actual: {2}.\nComment: {3}", (Object[])new Object[]{pageNumber, this.minWidows, widowsRenderer.getLines().size(), message});
            logger.warn(warnText);
        } else {
            logger.warn("Premature call of handleViolation method.");
        }
    }
}

