/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.util;

import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class TypographyShippedFontsUtil {
    private static final String FONTS_DIR = "com/itextpdf/typography/font/";
    private static final String[] CALLIGRAPHIC_FONT_NAMES = new String[]{"NotoSansArabic", "NotoSansGurmukhi", "NotoSansOriya", "NotoSerifBengali", "NotoSerifDevanagari", "NotoSerifGujarati", "NotoSerifHebrew", "NotoSerifKannada", "NotoSerifKhmer", "NotoSerifMalayalam", "NotoSerifTamil", "NotoSerifTelugu", "NotoSerifThai"};

    public static ArrayList<byte[]> loadShippedFonts() throws IOException {
        ArrayList<byte[]> fontStreams = new ArrayList<byte[]>(CALLIGRAPHIC_FONT_NAMES.length * 2);
        for (String fontName : CALLIGRAPHIC_FONT_NAMES) {
            fontStreams.add(TypographyShippedFontsUtil.process(FONTS_DIR + fontName + "-Regular.ttf"));
            fontStreams.add(TypographyShippedFontsUtil.process(FONTS_DIR + fontName + "-Bold.ttf"));
        }
        return fontStreams;
    }

    private static byte[] process(String fullFontName) throws IOException {
        try (InputStream resourceStream = ResourceUtil.getResourceStream((String)fullFontName);){
            byte[] byArray = StreamUtil.inputStreamToArray((InputStream)resourceStream);
            return byArray;
        }
    }
}

