/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import com.itextpdf.io.font.otf.Glyph;

public class IndicUtil {
    private static final int[] raChars = new int[]{2352, 2480, 2544, 2608, 2736, 2864, 2992, 3120, 3248, 3376, 3515, 6042};
    public static final long MEDIAL_FLAGS = IndicUtil.flag(17) | IndicUtil.flag(31);
    public static final long CONSONANT_FLAGS = IndicUtil.flag(1) | IndicUtil.flag(16) | MEDIAL_FLAGS | IndicUtil.flag(2) | IndicUtil.flag(11) | IndicUtil.flag(12);
    public static final long JOINER_FLAGS = IndicUtil.flag(6) | IndicUtil.flag(5);
    public static final long HALANT_OR_COENG_FLAGS = IndicUtil.flag(4) | IndicUtil.flag(14);

    public static boolean inRange(int u, int lo, int hi) {
        return u >= lo && u <= hi;
    }

    public static boolean inRanges(int u, int lo1, int hi1, int lo2, int hi2) {
        return IndicUtil.inRange(u, lo1, hi1) || IndicUtil.inRange(u, lo2, hi2);
    }

    public static boolean inRanges(int u, int lo1, int hi1, int lo2, int hi2, int lo3, int hi3) {
        return IndicUtil.inRange(u, lo1, hi1) || IndicUtil.inRange(u, lo2, hi2) || IndicUtil.inRange(u, lo3, hi3);
    }

    public static long flag(int category) {
        return 1L << category;
    }

    public static long flagRange(int category1, int category2) {
        return IndicUtil.flag(category2 + 1) - IndicUtil.flag(category1);
    }

    public static boolean isRa(int u) {
        for (int raChar : raChars) {
            if (u != raChar) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(int category, long flags) {
        return (1L << category & flags) != 0L;
    }

    public static boolean isJoiner(Glyph glyph, int category) {
        return IndicUtil.isOneOf(category, JOINER_FLAGS);
    }

    public static boolean isConsonant(Glyph glyph, int category) {
        return IndicUtil.isOneOf(category, CONSONANT_FLAGS);
    }

    public static boolean isHalantOrCoeng(int category) {
        return IndicUtil.isOneOf(category, HALANT_OR_COENG_FLAGS);
    }

    public static int convertCharacterTypeToTypographyType(int type) {
        switch (type) {
            case 8: {
                return 10;
            }
            case 23: {
                return 16;
            }
            case 15: {
                return 0;
            }
            case 26: {
                return 23;
            }
            case 20: {
                return 17;
            }
            case 9: {
                return 13;
            }
            case 7: {
                return 11;
            }
            case 22: {
                return 18;
            }
            case 30: {
                return 19;
            }
            case 16: {
                return 1;
            }
            case 29: {
                return 20;
            }
            case 10: {
                return 14;
            }
            case 13: {
                return 27;
            }
            case 2: {
                return 5;
            }
            case 25: {
                return 25;
            }
            case 4: {
                return 6;
            }
            case 27: {
                return 24;
            }
            case 6: {
                return 12;
            }
            case 5: {
                return 7;
            }
            case 11: {
                return 15;
            }
            case 24: {
                return 21;
            }
            case 28: {
                return 26;
            }
            case 14: {
                return 28;
            }
            case 18: {
                return 3;
            }
            case 12: {
                return 29;
            }
            case 21: {
                return 22;
            }
            case 19: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 9;
            }
        }
        return 0;
    }
}

