/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GlyphPositioningTableReader;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.typography.ordering.indic.IndicCategory;
import com.itextpdf.typography.ordering.indic.IndicCluster;
import com.itextpdf.typography.ordering.indic.IndicConfig;
import com.itextpdf.typography.ordering.indic.IndicFeatures;
import com.itextpdf.typography.ordering.indic.IndicPosition;
import com.itextpdf.typography.ordering.indic.IndicTable;
import com.itextpdf.typography.ordering.indic.IndicUtil;
import com.itextpdf.typography.util.PortUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class IndicShaper {
    public static List<IndicCluster> splitIndicGlyphLineIntoClusters(GlyphLine originalGlyphLine) {
        ArrayList<IndicCluster.IndicGlyph> indicGlyphs = new ArrayList<IndicCluster.IndicGlyph>();
        StringBuilder sb = new StringBuilder();
        for (int i = originalGlyphLine.start; i < originalGlyphLine.end; ++i) {
            Glyph oldGlyph = originalGlyphLine.get(i);
            IndicCluster.IndicGlyph indicGlyph = new IndicCluster.IndicGlyph(oldGlyph);
            indicGlyphs.add(indicGlyph);
            sb.append(!indicGlyph.hasValidUnicode() ? (char)'X' : IndicCategory.getCategoryRegexChar(indicGlyph.category));
        }
        String classes = sb.toString();
        Pattern pattern = Pattern.compile(IndicCategory.getSyllableRegex());
        Matcher matcher = pattern.matcher(classes);
        ArrayList<IndicCluster> clusters = new ArrayList<IndicCluster>();
        matcher = PortUtil.initMatch(matcher);
        while (PortUtil.isSucceed(matcher)) {
            if (matcher.start() != matcher.end()) {
                StringBuilder actualText = new StringBuilder();
                for (int pos = originalGlyphLine.start + matcher.start(); pos < originalGlyphLine.start + matcher.end() && actualText != null; ++pos) {
                    Glyph glyph = originalGlyphLine.get(pos);
                    if (glyph.hasValidUnicode()) {
                        actualText.append(TextUtil.convertFromUtf32((int)glyph.getUnicode()));
                        continue;
                    }
                    actualText = null;
                }
                IndicCluster newCluster = new IndicCluster(indicGlyphs.subList(matcher.start(), matcher.end()), originalGlyphLine.start + matcher.start(), originalGlyphLine.start + matcher.end(), actualText != null ? actualText.toString() : null);
                if (0 != matcher.start()) {
                    newCluster.setPreviousGlyphUnicode(((Glyph)indicGlyphs.get(matcher.start() - 1)).getUnicode());
                }
                clusters.add(newCluster);
            }
            matcher = PortUtil.nextMatch(matcher);
        }
        return clusters;
    }

    public static GlyphLine indicDecompose(FontProgram font, GlyphLine glyphLine) {
        ArrayList decomposedGlyphs = new ArrayList();
        int initialIdx = glyphLine.idx;
        block7: for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            if (!glyphLine.get(i).hasValidUnicode()) continue;
            int curGlyphUnicode = glyphLine.get(i).getUnicode();
            switch (curGlyphUnicode) {
                case 6078: {
                    IndicShaper.substituteIfPossible(glyphLine, i, font, new int[]{6081, 6078});
                    ++i;
                    continue block7;
                }
                case 6079: {
                    IndicShaper.substituteIfPossible(glyphLine, i, font, new int[]{6081, 6079});
                    ++i;
                    continue block7;
                }
                case 6080: {
                    IndicShaper.substituteIfPossible(glyphLine, i, font, new int[]{6081, 6080});
                    ++i;
                    continue block7;
                }
                case 6084: {
                    IndicShaper.substituteIfPossible(glyphLine, i, font, new int[]{6081, 6084});
                    ++i;
                    continue block7;
                }
                case 6085: {
                    IndicShaper.substituteIfPossible(glyphLine, i, font, new int[]{6081, 6085});
                    ++i;
                }
            }
        }
        glyphLine.idx = initialIdx;
        return new GlyphLine(decomposedGlyphs);
    }

    public static void setIndicProperties(IndicCluster cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            IndicShaper.setIndicProperties((IndicCluster.IndicGlyph)cluster.get(i));
        }
    }

    public static void setIndicProperties(IndicCluster.IndicGlyph glyph) {
        if (!glyph.hasValidUnicode()) {
            return;
        }
        int u = glyph.getUnicode();
        int type = IndicTable.getCategories(u);
        int cat = type & 0x7F;
        int pos = type >> 8;
        if (IndicUtil.inRanges(u, 2385, 2386, 7376, 7378, 7380, 7393) || u == 7412) {
            cat = 10;
        } else if (IndicUtil.inRange(u, 2387, 2388)) {
            cat = 8;
        } else if (IndicUtil.inRanges(u, 2674, 2675, 7413, 7414)) {
            cat = 1;
        } else if (IndicUtil.inRange(u, 7394, 7400)) {
            cat = 10;
        } else if (u == 7405) {
            cat = 10;
        } else if (IndicUtil.inRanges(u, 43250, 43255, 7401, 7404, 7406, 7409)) {
            cat = 18;
        } else if (IndicUtil.inRange(u, 6093, 6097) || u == 6091 || u == 6099 || u == 6109) {
            cat = 7;
            pos = 6;
        } else if (u == 6086) {
            cat = 3;
        } else if (u == 6098) {
            cat = 14;
        } else if (IndicUtil.inRange(u, 8208, 8209)) {
            cat = 11;
        } else if (u == 9676) {
            cat = 12;
        } else if (u == 43394) {
            cat = 8;
        } else if (u == 43454) {
            cat = 31;
        } else if (u == 43453) {
            cat = 7;
            pos = 11;
        }
        if ((IndicUtil.flag(cat) & IndicUtil.CONSONANT_FLAGS) != 0L) {
            pos = 4;
            if (IndicUtil.isRa(u)) {
                cat = 16;
            }
        } else if (cat == 7) {
            pos = IndicPosition.matraPosition(u, pos);
        } else if ((IndicUtil.flag(cat) & (IndicUtil.flag(8) | IndicUtil.flag(9) | IndicUtil.flag(10) | IndicUtil.flag(18))) != 0L) {
            pos = 14;
        }
        if (u == 2817) {
            pos = 7;
        }
        glyph.category = cat;
        glyph.indicPos = pos;
    }

    public static void updateConsonantPositions(TrueTypeFont fontProgram, IndicCluster cluster, IndicConfig indicConfig, List<OpenTableLookup> blwf, List<OpenTableLookup> pstf, List<OpenTableLookup> pref) {
        if (indicConfig.getBasePosition() != 2) {
            return;
        }
        Glyph virama = IndicShaper.getViramaGlyph(fontProgram, indicConfig);
        if (virama != null) {
            for (int i = 0; i < cluster.size(); ++i) {
                if (((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos != 4) continue;
                Glyph consonant = cluster.get(i);
                ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos = IndicShaper.consonantPositionFromFace(consonant, virama, indicConfig, blwf, pstf, pref);
            }
        }
    }

    public static void initialReordering(IndicCluster cluster, IndicConfig config, List<OpenTableLookup> rphf, List<OpenTableLookup> pref, boolean isOldSpec, Character.UnicodeScript script) {
        int j;
        int pref_len;
        int j2;
        int i;
        int end;
        int start = 0;
        int base = end = cluster.size();
        boolean hasReph = false;
        int limit = start;
        if (config.getRephPosition() != 1 && cluster.size() >= 3 && (config.getRephMode() == 0 && !IndicUtil.isJoiner(cluster.get(start + 2), ((IndicCluster.IndicGlyph)cluster.get((int)(start + 2))).category) || config.getRephMode() == 1 && ((IndicCluster.IndicGlyph)cluster.get((int)(start + 2))).category == 6)) {
            List<Glyph> glyphs = Arrays.asList(cluster.get(0), cluster.get(1), config.getRephMode() == 1 ? cluster.get(2) : null);
            if (IndicShaper.wouldSubstitute(rphf, glyphs, 2) || config.getRephMode() == 1 && IndicShaper.wouldSubstitute(rphf, glyphs, 3)) {
                limit += 2;
                while (limit < end && IndicUtil.isJoiner(cluster.get(limit), ((IndicCluster.IndicGlyph)cluster.get((int)limit)).category)) {
                    ++limit;
                }
                base = start;
                hasReph = true;
            }
        } else if (config.getRephMode() == 3 && ((IndicCluster.IndicGlyph)cluster.get((int)start)).category == 15) {
            ++limit;
            while (limit < end && IndicUtil.isJoiner(cluster.get(limit), ((IndicCluster.IndicGlyph)cluster.get((int)limit)).category)) {
                ++limit;
            }
            base = start;
            hasReph = true;
        }
        block0 : switch (config.getBasePosition()) {
            case 2: {
                int i2 = end;
                boolean seenBelow = false;
                do {
                    if (IndicUtil.isConsonant(cluster.get(--i2), ((IndicCluster.IndicGlyph)cluster.get((int)i2)).category)) {
                        if (((IndicCluster.IndicGlyph)cluster.get((int)i2)).indicPos != 8 && (((IndicCluster.IndicGlyph)cluster.get((int)i2)).indicPos != 11 || seenBelow)) {
                            base = i2;
                            break block0;
                        }
                        if (((IndicCluster.IndicGlyph)cluster.get((int)i2)).indicPos == 8) {
                            seenBelow = true;
                        }
                        base = i2;
                        continue;
                    }
                    if (start < i2 && ((IndicCluster.IndicGlyph)cluster.get((int)i2)).category == 6 && ((IndicCluster.IndicGlyph)cluster.get((int)(i2 - 1))).category == 4) break block0;
                } while (i2 > limit);
                break;
            }
            case 1: {
                int i2;
                if (!hasReph) {
                    base = limit;
                }
                for (i2 = limit; i2 < end; ++i2) {
                    if (!IndicUtil.isConsonant(cluster.get(i2), ((IndicCluster.IndicGlyph)cluster.get((int)i2)).category)) continue;
                    if (limit < i2 && ((IndicCluster.IndicGlyph)cluster.get((int)(i2 - 1))).category == 6) break;
                    base = i2;
                }
                for (i2 = base + 1; i2 < end; ++i2) {
                    if (!IndicUtil.isConsonant(cluster.get(i2), ((IndicCluster.IndicGlyph)cluster.get((int)i2)).category)) continue;
                    ((IndicCluster.IndicGlyph)cluster.get((int)i2)).indicPos = 8;
                }
                break;
            }
            case 0: {
                int i2;
                assert (config.getRephMode() == 2);
                assert (!hasReph);
                base = start;
                for (i2 = base + 1; i2 < end; ++i2) {
                    if (!IndicUtil.isConsonant(cluster.get(i2), ((IndicCluster.IndicGlyph)cluster.get((int)i2)).category)) continue;
                    ((IndicCluster.IndicGlyph)cluster.get((int)i2)).indicPos = 8;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (hasReph && base == start && limit - base <= 2) {
            hasReph = false;
        }
        for (i = start; i < base; ++i) {
            ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos = Math.min(3, ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos);
        }
        if (base < end) {
            ((IndicCluster.IndicGlyph)cluster.get((int)base)).indicPos = 4;
        }
        block12: for (i = base + 1; i < end; ++i) {
            if (((IndicCluster.IndicGlyph)cluster.get((int)i)).category != 7) continue;
            for (int j3 = i + 1; j3 < end; ++j3) {
                if (!IndicUtil.isConsonant(cluster.get(j3), ((IndicCluster.IndicGlyph)cluster.get((int)j3)).category)) continue;
                ((IndicCluster.IndicGlyph)cluster.get((int)j3)).indicPos = 13;
                break block12;
            }
            break;
        }
        if (hasReph) {
            ((IndicCluster.IndicGlyph)cluster.get((int)start)).indicPos = 1;
        }
        if (isOldSpec) {
            boolean disallowDoubleHalants = script != Character.UnicodeScript.MALAYALAM;
            for (i = base + 1; i < end; ++i) {
                if (((IndicCluster.IndicGlyph)cluster.get((int)i)).category != 4) continue;
                for (j2 = end - 1; !(j2 <= i || IndicUtil.isConsonant(cluster.get(j2), ((IndicCluster.IndicGlyph)cluster.get((int)j2)).category) || disallowDoubleHalants && ((IndicCluster.IndicGlyph)cluster.get((int)j2)).category == 4); --j2) {
                }
                if (((IndicCluster.IndicGlyph)cluster.get((int)j2)).category == 4 || j2 <= i) break;
                Glyph t = cluster.get(i);
                cluster.memMove(i, i + 1, j2 - i);
                cluster.set(j2, t);
                break;
            }
        }
        int last_pos = 0;
        block16: for (i = start; i < end; ++i) {
            if ((IndicUtil.flag(((IndicCluster.IndicGlyph)cluster.get((int)i)).category) & (IndicUtil.JOINER_FLAGS | IndicUtil.flag(3) | IndicUtil.flag(13) | IndicUtil.MEDIAL_FLAGS | IndicUtil.HALANT_OR_COENG_FLAGS)) != 0L) {
                ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos = last_pos;
                if (((IndicCluster.IndicGlyph)cluster.get((int)i)).category != 4 || ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos != 2) continue;
                for (j2 = i; j2 > start; --j2) {
                    if (((IndicCluster.IndicGlyph)cluster.get((int)(j2 - 1))).indicPos == 2) continue;
                    ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos = ((IndicCluster.IndicGlyph)cluster.get((int)(j2 - 1))).indicPos;
                    continue block16;
                }
                continue;
            }
            if (((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos == 14) continue;
            last_pos = ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos;
        }
        int last = base;
        for (i = base + 1; i < end; ++i) {
            if (IndicUtil.isConsonant(cluster.get(i), ((IndicCluster.IndicGlyph)cluster.get((int)i)).category)) {
                for (j2 = last + 1; j2 < i; ++j2) {
                    if (((IndicCluster.IndicGlyph)cluster.get((int)j2)).indicPos >= 14) continue;
                    ((IndicCluster.IndicGlyph)cluster.get((int)j2)).indicPos = ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos;
                }
                last = i;
                continue;
            }
            if (((IndicCluster.IndicGlyph)cluster.get((int)i)).category != 7) continue;
            last = i;
        }
        cluster.sortIndicOrder();
        base = end;
        for (i = start; i < end; ++i) {
            if (((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos != 4) continue;
            base = i;
            break;
        }
        int[] maskArray = new int[21];
        for (i = 0; i < 21; ++i) {
            maskArray[i] = IndicFeatures.getMask(i);
        }
        for (i = start; i < end && ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos == 1; ++i) {
            ((IndicCluster.IndicGlyph)cluster.get((int)i)).mask |= maskArray[2];
        }
        int mask = maskArray[7];
        if (!isOldSpec && config.getBlwfMode() == 0) {
            mask |= maskArray[5];
        }
        for (i = start; i < base; ++i) {
            ((IndicCluster.IndicGlyph)cluster.get((int)i)).mask |= mask;
        }
        mask = 0;
        if (base < end) {
            ((IndicCluster.IndicGlyph)cluster.get((int)base)).mask |= mask;
        }
        mask = maskArray[5] | maskArray[6] | maskArray[8];
        for (i = base + 1; i < end; ++i) {
            ((IndicCluster.IndicGlyph)cluster.get((int)i)).mask |= mask;
        }
        if (isOldSpec && script == Character.UnicodeScript.DEVANAGARI) {
            i = start;
            while (i + 1 < base) {
                if (((IndicCluster.IndicGlyph)cluster.get((int)i)).category == 16 && ((IndicCluster.IndicGlyph)cluster.get((int)(i + 1))).category == 4 && (i + 2 == base || ((IndicCluster.IndicGlyph)cluster.get((int)(i + 2))).category != 6)) {
                    ((IndicCluster.IndicGlyph)cluster.get((int)i)).mask |= maskArray[5];
                    ((IndicCluster.IndicGlyph)cluster.get((int)(i + 1))).mask |= maskArray[5];
                }
                ++i;
            }
        }
        if (base + (pref_len = config.getPrefLen()) < end) {
            assert (1 <= pref_len && pref_len <= 2);
            i = base + 1;
            while (i + pref_len - 1 < end) {
                ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
                for (j = 0; j < pref_len; ++j) {
                    glyphs.add(cluster.get(i + j));
                }
                if (IndicShaper.wouldSubstitute(pref, glyphs, pref_len)) {
                    for (j = 0; j < pref_len; ++j) {
                        ((IndicCluster.IndicGlyph)cluster.get((int)i++)).mask |= maskArray[4];
                    }
                    break;
                }
                ++i;
            }
        }
        for (i = start + 1; i < end; ++i) {
            if (!IndicUtil.isJoiner(cluster.get(i), ((IndicCluster.IndicGlyph)cluster.get((int)i)).category)) continue;
            boolean nonJoiner = ((IndicCluster.IndicGlyph)cluster.get((int)i)).category == 5;
            j = i;
            do {
                --j;
                if (!nonJoiner) continue;
            } while (j > start && !IndicUtil.isConsonant(cluster.get(j), ((IndicCluster.IndicGlyph)cluster.get((int)j)).category));
        }
    }

    public static void finalReordering(IndicCluster cluster, IndicConfig config, Character.UnicodeScript script) {
        int i;
        int base;
        int start = 0;
        int end = cluster.size();
        boolean try_pref = true;
        for (base = start; base < end; ++base) {
            if (((IndicCluster.IndicGlyph)cluster.get((int)base)).indicPos < 4) continue;
            if (!try_pref || base + 1 >= end || config.getPrefLen() == 2) {
                // empty if block
            }
            if (start >= base || ((IndicCluster.IndicGlyph)cluster.get((int)base)).indicPos <= 4) break;
            --base;
            break;
        }
        if (base == end && start < base && IndicUtil.isOneOf(((IndicCluster.IndicGlyph)cluster.get((int)(base - 1))).category, IndicUtil.flag(6))) {
            --base;
        }
        if (base < end) {
            while (start < base && IndicUtil.isOneOf(((IndicCluster.IndicGlyph)cluster.get((int)base)).category, IndicUtil.flag(3) | IndicUtil.HALANT_OR_COENG_FLAGS)) {
                --base;
            }
        }
        if (start + 1 < end && start < base) {
            int new_pos;
            int n = new_pos = base == end ? base - 2 : base - 1;
            if (script != Character.UnicodeScript.MALAYALAM && script != Character.UnicodeScript.TAMIL) {
                while (new_pos > start && !IndicUtil.isOneOf(((IndicCluster.IndicGlyph)cluster.get((int)new_pos)).category, IndicUtil.flag(7) | IndicUtil.HALANT_OR_COENG_FLAGS)) {
                    --new_pos;
                }
                if (IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)new_pos)).category) && ((IndicCluster.IndicGlyph)cluster.get((int)new_pos)).indicPos != 2) {
                    if (new_pos + 1 < end && IndicUtil.isJoiner(cluster.get(new_pos + 1), ((IndicCluster.IndicGlyph)cluster.get((int)(new_pos + 1))).category)) {
                        ++new_pos;
                    }
                } else {
                    new_pos = start;
                }
            }
            if (start < new_pos && ((IndicCluster.IndicGlyph)cluster.get((int)new_pos)).indicPos != 2) {
                for (i = new_pos; i > start; --i) {
                    if (((IndicCluster.IndicGlyph)cluster.get((int)(i - 1))).indicPos != 2) continue;
                    int old_pos = i - 1;
                    if (old_pos < base && base <= new_pos) {
                        --base;
                    }
                    Glyph tmp = cluster.get(old_pos);
                    cluster.memMove(old_pos, old_pos + 1, new_pos - old_pos);
                    cluster.set(new_pos, tmp);
                    --new_pos;
                }
            } else {
                for (i = start; i < base && ((IndicCluster.IndicGlyph)cluster.get((int)i)).indicPos != 2; ++i) {
                }
            }
        }
        if (start + 1 < end && ((IndicCluster.IndicGlyph)cluster.get((int)start)).indicPos == 1 && ((IndicCluster.IndicGlyph)cluster.get((int)start)).category == 15 ^ true) {
            int new_reph_pos = start + 1;
            int reph_pos = config.getRephPosition();
            assert (reph_pos != 1);
            boolean gotoRephStep5 = false;
            if (reph_pos == 12) {
                gotoRephStep5 = true;
            }
            boolean gotoRephMove = false;
            if (!gotoRephStep5) {
                for (new_reph_pos = start + 1; new_reph_pos < base && !IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)new_reph_pos)).category); ++new_reph_pos) {
                }
                if (new_reph_pos < base && IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)new_reph_pos)).category)) {
                    if (new_reph_pos + 1 < base && IndicUtil.isJoiner(cluster.get(new_reph_pos + 1), ((IndicCluster.IndicGlyph)cluster.get((int)(new_reph_pos + 1))).category)) {
                        ++new_reph_pos;
                    }
                    gotoRephMove = true;
                }
                if (!gotoRephMove && reph_pos == 5) {
                    new_reph_pos = base;
                    while (new_reph_pos + 1 < end && ((IndicCluster.IndicGlyph)cluster.get((int)(new_reph_pos + 1))).indicPos <= 5) {
                        ++new_reph_pos;
                    }
                    if (new_reph_pos < end) {
                        gotoRephMove = true;
                    }
                }
                if (!gotoRephMove && reph_pos == 9) {
                    new_reph_pos = base;
                    while (new_reph_pos + 1 < end && (IndicUtil.flag(((IndicCluster.IndicGlyph)cluster.get((int)(new_reph_pos + 1))).indicPos) & (IndicUtil.flag(11) | IndicUtil.flag(12) | IndicUtil.flag(14))) == 0L) {
                        ++new_reph_pos;
                    }
                    if (new_reph_pos < end) {
                        gotoRephMove = true;
                    }
                }
            }
            if (!gotoRephMove) {
                for (new_reph_pos = start + 1; new_reph_pos < base && !IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)new_reph_pos)).category); ++new_reph_pos) {
                }
                if (new_reph_pos < base && IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)new_reph_pos)).category)) {
                    if (new_reph_pos + 1 < base && IndicUtil.isJoiner(cluster.get(new_reph_pos + 1), ((IndicCluster.IndicGlyph)cluster.get((int)(new_reph_pos + 1))).category)) {
                        ++new_reph_pos;
                    }
                    gotoRephMove = true;
                }
            }
            if (!gotoRephMove) {
                for (new_reph_pos = end - 1; new_reph_pos > start && ((IndicCluster.IndicGlyph)cluster.get((int)new_reph_pos)).indicPos == 14; --new_reph_pos) {
                }
                gotoRephMove = true;
            }
            IndicCluster.IndicGlyph reph = (IndicCluster.IndicGlyph)cluster.get(start);
            cluster.memMove(start, start + 1, new_reph_pos - start);
            cluster.set(new_reph_pos, reph);
            if (start < base && base <= new_reph_pos) {
                --base;
            }
        }
        int[] maskArray = new int[21];
        for (i = 0; i < 21; ++i) {
            maskArray[i] = IndicFeatures.getMask(i);
        }
        if (try_pref && base + 1 < end) {
            int pref_len = config.getPrefLen();
            for (int i2 = base + 1; i2 < end; ++i2) {
                int new_pos;
                if ((((IndicCluster.IndicGlyph)cluster.get((int)i2)).mask & maskArray[4]) == 0) continue;
                if (!((IndicCluster.IndicGlyph)cluster.get(i2)).substituted() || !(pref_len == 1 ^ ((IndicCluster.IndicGlyph)cluster.get(i2)).ligatedAndDidntMultiply())) break;
                if (script != Character.UnicodeScript.MALAYALAM && script != Character.UnicodeScript.TAMIL) {
                    for (new_pos = base; new_pos > start && !IndicUtil.isOneOf(((IndicCluster.IndicGlyph)cluster.get((int)(new_pos - 1))).category, IndicUtil.flag(7) | IndicUtil.HALANT_OR_COENG_FLAGS); --new_pos) {
                    }
                    if (new_pos > start && ((IndicCluster.IndicGlyph)cluster.get((int)(new_pos - 1))).category == 7) {
                        int old_pos = i2;
                        for (int j = base + 1; j < old_pos; ++j) {
                            if (((IndicCluster.IndicGlyph)cluster.get((int)j)).category != 7) continue;
                            --new_pos;
                            break;
                        }
                    }
                }
                if (new_pos > start && IndicUtil.isHalantOrCoeng(((IndicCluster.IndicGlyph)cluster.get((int)(new_pos - 1))).category) && new_pos < end && IndicUtil.isJoiner(cluster.get(new_pos), ((IndicCluster.IndicGlyph)cluster.get((int)new_pos)).category)) {
                    ++new_pos;
                }
                int old_pos = i2;
                Glyph tmp = cluster.get(old_pos);
                cluster.memMove(new_pos + 1, new_pos, old_pos - new_pos);
                cluster.set(new_pos, tmp);
                if (new_pos > base || base >= old_pos) break;
                ++base;
                break;
            }
        }
        if (((IndicCluster.IndicGlyph)cluster.get((int)start)).indicPos == 2 && (-1 == cluster.getPreviousGlyphUnicode() || (IndicUtil.flag(IndicUtil.convertCharacterTypeToTypographyType(Character.getType((char)cluster.getPreviousGlyphUnicode()))) & IndicUtil.flagRange(IndicUtil.convertCharacterTypeToTypographyType(16), IndicUtil.convertCharacterTypeToTypographyType(6))) == 0L)) {
            ((IndicCluster.IndicGlyph)cluster.get((int)start)).mask |= maskArray[12];
        }
    }

    private static boolean wouldSubstitute(List<OpenTableLookup> feature, List<Glyph> glyphs, int glyphCount) {
        boolean substitute = false;
        if (feature != null) {
            GlyphLine simulate = new GlyphLine(new ArrayList<Glyph>(glyphs.subList(0, glyphCount)), 0, glyphCount);
            for (OpenTableLookup lookup : feature) {
                if (!lookup.transformLine(simulate)) continue;
                substitute = true;
            }
        }
        return substitute;
    }

    private static boolean isLigated(Glyph glyph, char category) {
        return glyph.getChars() != null && glyph.getChars().length > 1;
    }

    private static Glyph getViramaGlyph(TrueTypeFont fontProgram, IndicConfig indicConfig) {
        return fontProgram.getGlyph(indicConfig.getVirama());
    }

    private static int consonantPositionFromFace(Glyph consonant, Glyph virama, IndicConfig config, List<OpenTableLookup> blwf, List<OpenTableLookup> pstf, List<OpenTableLookup> pref) {
        List<Glyph> glyphs = Arrays.asList(virama, consonant, virama);
        if (IndicShaper.wouldSubstitute(blwf, glyphs, 2) || IndicShaper.wouldSubstitute(blwf, glyphs.subList(1, glyphs.size()), 2)) {
            return 8;
        }
        if (IndicShaper.wouldSubstitute(pstf, glyphs, 2) || IndicShaper.wouldSubstitute(pstf, glyphs.subList(1, glyphs.size()), 2)) {
            return 11;
        }
        int pref_len = config.getPrefLen();
        if (pref_len == 2 && (IndicShaper.wouldSubstitute(pref, glyphs, 2) || IndicShaper.wouldSubstitute(pref, glyphs.subList(1, glyphs.size()), 2)) || pref_len == 1 && IndicShaper.wouldSubstitute(pref, glyphs.subList(1, glyphs.size()), 1)) {
            return 11;
        }
        return 4;
    }

    private static void substituteIfPossible(GlyphLine glyphLine, int idx, FontProgram font, int[] substGlyphUnicodes) {
        GlyphPositioningTableReader reader;
        GlyphPositioningTableReader glyphPositioningTableReader = reader = font instanceof TrueTypeFont ? ((TrueTypeFont)font).getGposTable() : null;
        if (reader == null) {
            return;
        }
        int[] substGlyphIds = new int[substGlyphUnicodes.length];
        for (int i = 0; i < substGlyphUnicodes.length; ++i) {
            Glyph substGlyph = font.getGlyph(substGlyphUnicodes[i]);
            if (substGlyph == null || substGlyph.getCode() <= 0) {
                return;
            }
            substGlyphIds[i] = substGlyph.getCode();
        }
        glyphLine.idx = idx;
        glyphLine.substituteOneToMany((OpenTypeFontTableReader)reader, substGlyphIds);
    }
}

