/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.typography.ordering.indic.IndicShaper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndicCluster
extends GlyphLine {
    public int originalGlyphLineStart;
    public int originalGlyphLineEnd;
    private String clusterActualText;
    private int previousGlyphUnicode = -1;

    IndicCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        super(IndicCluster.constructIndicGlyphList(glyphs));
        this.originalGlyphLineStart = originalGlyphLineStart;
        this.originalGlyphLineEnd = originalGlyphLineEnd;
        this.clusterActualText = actualText;
    }

    IndicCluster(GlyphLine glyphLine, int start, int end, String actualText) {
        super(glyphLine, start, end);
        ArrayList<Glyph> indicGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.glyphs) {
            indicGlyphs.add((Glyph)(glyph instanceof IndicGlyph ? glyph : new IndicGlyph(glyph)));
        }
        this.setGlyphs(indicGlyphs);
        this.originalGlyphLineStart = start;
        this.originalGlyphLineEnd = end;
        this.clusterActualText = actualText;
    }

    public static List<Glyph> constructIndicGlyphList(List<Glyph> glyphs) {
        ArrayList<Glyph> newGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : glyphs) {
            newGlyphs.add(new IndicGlyph(glyph));
        }
        return newGlyphs;
    }

    void sortIndicOrder() {
        Collections.sort(this.glyphs, new Comparator<Glyph>(){

            @Override
            public int compare(Glyph o1, Glyph o2) {
                if (!(o1 instanceof IndicGlyph) || !(o2 instanceof IndicGlyph)) {
                    throw new IllegalStateException();
                }
                IndicGlyph a = (IndicGlyph)o1;
                IndicGlyph b = (IndicGlyph)o2;
                if (a.indicPos == b.indicPos) {
                    return 0;
                }
                if (a.indicPos < b.indicPos) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public void set(int i, int j) {
        this.glyphs.set(i, this.glyphs.get(j));
    }

    public Glyph get(int pos) {
        if (!(this.glyphs.get(pos) instanceof IndicGlyph)) {
            this.glyphs.set(pos, new IndicGlyph((Glyph)this.glyphs.get(pos)));
        }
        return (Glyph)this.glyphs.get(pos);
    }

    public String getClusterActualText() {
        return this.clusterActualText;
    }

    public void substituteManyToOne(OpenTypeFontTableReader tableReader, int lookupFlag, int rightPartLen, int substitutionGlyphIndex) {
        IndicGlyph oldGlyph = (IndicGlyph)this.get(this.idx);
        super.substituteManyToOne(tableReader, lookupFlag, rightPartLen, substitutionGlyphIndex);
        this.glyphs.set(this.idx, new IndicGlyph((Glyph)this.glyphs.get(this.idx), oldGlyph.category, oldGlyph.indicPos, oldGlyph.mask).setLigated().setSubstituted());
    }

    public void substituteOneToOne(OpenTypeFontTableReader tableReader, int substitutionGlyphIndex) {
        IndicGlyph oldGlyph = (IndicGlyph)this.get(this.idx);
        super.substituteOneToOne(tableReader, substitutionGlyphIndex);
        this.glyphs.set(this.idx, new IndicGlyph((Glyph)this.glyphs.get(this.idx), oldGlyph.category, oldGlyph.indicPos, oldGlyph.mask).setSubstituted());
    }

    public void substituteOneToMany(OpenTypeFontTableReader tableReader, int[] substGlyphIds) {
        IndicGlyph oldGlyph = (IndicGlyph)this.get(this.idx);
        super.substituteOneToMany(tableReader, substGlyphIds);
        for (int i = 0; i < substGlyphIds.length; ++i) {
            this.glyphs.set(this.idx - i, new IndicGlyph((Glyph)this.glyphs.get(this.idx - i), oldGlyph.category, oldGlyph.indicPos, oldGlyph.mask).setSubstituted());
        }
    }

    public GlyphLine copy(int left, int right) {
        GlyphLine gl = super.copy(left, right);
        IndicCluster copy = new IndicCluster(gl, gl.start, gl.end, this.getClusterActualText());
        copy.originalGlyphLineStart = this.originalGlyphLineStart;
        copy.originalGlyphLineEnd = this.originalGlyphLineEnd;
        return copy;
    }

    void memMove(int dest, int source, int count) {
        int i;
        ArrayList temp = new ArrayList(count);
        for (i = 0; i < count; ++i) {
            temp.add(this.glyphs.get(source + i));
        }
        for (i = 0; i < count; ++i) {
            this.glyphs.set(dest + i, temp.get(i));
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        IndicCluster other = (IndicCluster)((Object)obj);
        return this.originalGlyphLineEnd == other.originalGlyphLineEnd && this.originalGlyphLineStart == other.originalGlyphLineStart && this.clusterActualText.equals(other.clusterActualText);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.originalGlyphLineStart;
        result = 31 * result + this.originalGlyphLineEnd;
        result = 31 * result + this.clusterActualText.hashCode();
        return result;
    }

    int getPreviousGlyphUnicode() {
        return this.previousGlyphUnicode;
    }

    IndicCluster setPreviousGlyphUnicode(int previousGlyphUnicode) {
        this.previousGlyphUnicode = previousGlyphUnicode;
        return this;
    }

    public static class IndicGlyph
    extends Glyph {
        public int category = -1;
        public int indicPos = -1;
        public int mask = 0;
        private boolean substituted;
        private boolean ligated;

        public IndicGlyph(Glyph glyph) {
            super(glyph);
            IndicShaper.setIndicProperties(this);
        }

        public IndicGlyph(Glyph glyph, int category, int indicPos, int mask) {
            super(glyph);
            this.category = category;
            this.indicPos = indicPos;
            this.mask = mask;
        }

        IndicGlyph setSubstituted() {
            this.substituted = true;
            return this;
        }

        IndicGlyph setLigated() {
            this.ligated = true;
            return this;
        }

        boolean substituted() {
            return this.substituted;
        }

        boolean ligatedAndDidntMultiply() {
            return this.ligated;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            IndicGlyph other = (IndicGlyph)((Object)obj);
            return this.category == other.category && this.indicPos == other.indicPos && this.mask == other.mask && this.substituted == other.substituted && this.ligated == other.ligated;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.category;
            result = 31 * result + this.indicPos;
            result = 31 * result + this.mask;
            result = 31 * result + (this.substituted ? 1 : 0);
            result = 31 * result + (this.ligated ? 1 : 0);
            return result;
        }
    }
}

