/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IOUtils {
    private static final SAXParserFactory SAX_PARSER_FACTORY;

    public static XMLReader createXMLReader() throws SAXException {
        try {
            return SAX_PARSER_FACTORY.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(InputStream stream, Map<String, String> result) {
        if (stream != null) {
            try {
                Properties items = new Properties();
                items.load(stream);
                for (String key : items.stringPropertyNames()) {
                    result.put(key, items.getProperty(key));
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    private IOUtils() {
    }

    static {
        try {
            SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
            SAX_PARSER_FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
            SAX_PARSER_FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAX_PARSER_FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Exception creating SAX parser factory", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Exception creating SAX parser factory", e);
        }
    }
}

