/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.KmsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class FileCache {
    private ThreadLocal<String> m_fileService = new ThreadLocal();
    private ThreadLocal<String> m_sharedStorageDir = new ThreadLocal();
    private ThreadLocal<String> m_userDir = new ThreadLocal();
    private ThreadLocal<String> m_configPath = new ThreadLocal();
    private HashMap<String, Thread> m_busyFiles = new HashMap();
    private static FileCache s_fileCache;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static HashMap<String, Long> s_expiries;
    private Timer m_deleteTimer = new Timer(true);
    private HashSet<String> m_touched = new HashSet();
    private PrintStream m_out;
    private Object m_consumer;
    private static final String DIRECTORY_FILE = "html.directory";

    public static synchronized FileCache getInstance(String fileService) {
        if (fileService == null) {
            fileService = "";
        }
        String[] values = fileService.split("\\|");
        String userDir = "";
        String sharedDir = "c:/storage/infor/";
        String configPath = null;
        if (values.length >= 4) {
            fileService = values[0];
            userDir = values[1];
            sharedDir = values[2];
            configPath = values[3];
        }
        if (s_fileCache == null) {
            s_fileCache = new FileCache();
        }
        FileCache.s_fileCache.m_sharedStorageDir.set(FileCache.getFileName(sharedDir, true));
        FileCache.s_fileCache.m_userDir.set(FileCache.getFileName(userDir, true));
        FileCache.s_fileCache.m_fileService.set(fileService);
        FileCache.s_fileCache.m_configPath.set(configPath);
        return s_fileCache;
    }

    public static synchronized FileCache getInstance() {
        if (s_fileCache == null) {
            s_fileCache = new FileCache();
        }
        return s_fileCache;
    }

    public void ready() {
        if (s_fileCache != null) {
            FileCache.s_fileCache.m_sharedStorageDir.remove();
            FileCache.s_fileCache.m_userDir.remove();
            FileCache.s_fileCache.m_fileService.remove();
            FileCache.s_fileCache.m_configPath.remove();
        }
    }

    private FileCache() {
        this.clearExpiredCache();
    }

    private synchronized boolean isBusy(String key) {
        return this.m_busyFiles.containsKey(key);
    }

    private synchronized void setBusy(String key, boolean busy) {
        if (!busy) {
            this.m_busyFiles.remove(key);
        } else {
            this.m_busyFiles.put(key, Thread.currentThread());
        }
    }

    private synchronized void touched(String key) {
        this.m_touched.add(key);
    }

    private synchronized boolean isTouched(String key) {
        if (this.m_touched.contains(key)) {
            this.m_touched.remove(key);
            return true;
        }
        return false;
    }

    private synchronized boolean getLock(String key) {
        if (this.isBusy(key)) {
            return false;
        }
        this.setBusy(key, true);
        return true;
    }

    private void waitAndLock(String key) {
        while (!this.getLock(key)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(File file) {
        String key = file.getName();
        File parent = file.getParentFile();
        this.isTouched(key);
        this.waitAndLock(key);
        try {
            this.log("Delete " + file.getName());
            boolean del = file.delete();
            if (!del) {
                this.log("Could not delete " + file.getName());
            }
        }
        finally {
            this.setBusy(key, false);
        }
        if (parent != null && !parent.equals(this.getCacheDir()) && parent.list() != null && parent.list().length == 0) {
            this.delete(file.getParentFile());
        }
    }

    private String getKey(String fileName) {
        fileName = fileName.replaceFirst(this.m_sharedStorageDir.get(), "");
        String key = fileName.toLowerCase();
        key = key.replace("\\\\", "/");
        return key;
    }

    public File getCacheDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "fileCache");
        this.mkdirs(dir);
        return dir;
    }

    private synchronized void mkdirs(File dir) {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + dir.getAbsolutePath());
        }
    }

    public void clearCache() {
        File dir = this.getCacheDir();
        this.clearCache(dir);
    }

    private void clearCache(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.clearCache(files[i]);
                this.delete(files[i]);
                continue;
            }
            this.delete(files[i]);
        }
    }

    public void clearExpiredCache() {
        File dir = this.getCacheDir();
        this.clearExpiredCache(dir);
    }

    public void clearExpiredCache(File dir) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            if (files[i].isDirectory()) {
                this.clearExpiredCache(files[i]);
                if (!this.isExpired(files[i])) continue;
                this.delete(files[i]);
                continue;
            }
            if (!this.isExpired(files[i])) continue;
            this.delete(files[i]);
        }
    }

    public boolean isDownloading(String fileName) {
        fileName = FileCache.getFileName(fileName, false);
        String key = this.getKey(fileName);
        return this.isBusy(key);
    }

    public File getLocalFile(String fileName) throws IOException {
        return new File(this.getLocalFileName(fileName));
    }

    public String getLocalFileName(String fileName) throws IOException {
        if (this.m_fileService.get() == null || this.m_fileService.get().isEmpty()) {
            return fileName;
        }
        if (!(fileName = FileCache.getFileName(fileName, false)).startsWith("/") && fileName.charAt(1) != ':') {
            fileName = this.m_sharedStorageDir.get() + this.m_userDir.get() + fileName;
        }
        if (!this.isSharedStorage(fileName)) {
            return fileName;
        }
        String key = this.getKey(fileName);
        File cachefile = new File(this.getCacheDir(), key);
        this.storeFile(key, fileName, cachefile.getAbsolutePath());
        return cachefile.getAbsolutePath();
    }

    private static String getFileName(String fileName, boolean dir) {
        String f = fileName.replaceAll("\\\\", "/").replace("//", "/");
        if (dir && !f.endsWith("/")) {
            f = f + "/";
        }
        if (!dir && f.endsWith("/")) {
            f = f.substring(0, f.length() - 1);
        }
        return f;
    }

    private boolean isSharedStorage(String fileName) {
        return fileName.startsWith(this.m_sharedStorageDir.get());
    }

    private boolean isUpToDate(String key, String realFileName, File cacheFile, String sharedStorageDir, String fileService) {
        try {
            if (cacheFile.isDirectory()) {
                return false;
            }
            if (!cacheFile.exists()) {
                return false;
            }
            String part = realFileName.replace(sharedStorageDir, "");
            String urlString = fileService + part;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            long lastModified = cacheFile.lastModified();
            con.setIfModifiedSince(lastModified);
            con.setDoOutput(true);
            con.setUseCaches(false);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection urlCon = (HttpURLConnection)con;
                urlCon.setRequestMethod("GET");
                this.sign(urlCon);
                int code = urlCon.getResponseCode();
                if (code == 304) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void storeFile(String key, String realFileName, String cacheFileName) throws IOException {
        String theKey = key;
        this.waitAndLock(theKey);
        OutputStream fos = null;
        InputStream is = null;
        String urlString = null;
        try {
            File cacheFile = new File(cacheFileName);
            if (cacheFile.exists()) {
                this.touched(key);
                return;
            }
            this.mkdirs(cacheFile.getParentFile());
            boolean readResponse = true;
            boolean directory = false;
            String part = realFileName.replace(this.m_sharedStorageDir.get(), "");
            urlString = this.m_fileService.get() + part;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            con.setUseCaches(false);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection urlCon = (HttpURLConnection)con;
                urlCon.setRequestMethod("GET");
                this.sign(urlCon);
                int code = urlCon.getResponseCode();
                if (urlCon.getURL().toString().endsWith("/")) {
                    this.mkdirs(cacheFile);
                    directory = true;
                    key = key + "/" + DIRECTORY_FILE;
                    realFileName = realFileName + "/" + DIRECTORY_FILE;
                    cacheFileName = cacheFileName + "/" + DIRECTORY_FILE;
                    cacheFile = new File(cacheFileName);
                } else if (code != 200) {
                    readResponse = false;
                    throw new IOException("Cannot get the file from the file service, http error " + code);
                }
            }
            if (readResponse) {
                int n;
                is = con.getInputStream();
                fos = new FileOutputStream(new File(cacheFileName));
                byte[] bytes = new byte[1024];
                while ((n = is.read(bytes)) > 0) {
                    ((FileOutputStream)fos).write(bytes, 0, n);
                }
                is.close();
                fos.flush();
                ((FileOutputStream)fos).close();
                this.log("File put in cache " + cacheFile.getName());
                this.scheduleDelete(key, realFileName, cacheFile, this.m_sharedStorageDir.get(), this.m_fileService.get());
                if (directory) {
                    this.fillCache(key, realFileName, cacheFileName);
                }
            }
        }
        catch (Exception e) {
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            File delete = new File(cacheFileName);
            delete.delete();
            throw new IOException("Cannot store the file " + realFileName + " in the file cache with url " + urlString, e);
        }
        finally {
            this.setBusy(theKey, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCache(String htmlKey, String htmlRealFileName, String htmlCacheFileName) throws IOException {
        String dirKey = htmlKey.substring(0, htmlKey.length() - DIRECTORY_FILE.length());
        String dirRealFileName = htmlRealFileName.substring(0, htmlRealFileName.length() - DIRECTORY_FILE.length());
        String dirCacheFileName = htmlCacheFileName.substring(0, htmlCacheFileName.length() - DIRECTORY_FILE.length());
        try (FileInputStream fis = new FileInputStream(htmlCacheFileName);){
            int index;
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((n = fis.read(bytes)) > 0) {
                bos.write(bytes, 0, n);
            }
            String html = bos.toString();
            while ((index = html.indexOf("href=\"")) != -1) {
                String href = (html = html.substring(index + 6)).substring(0, index = html.indexOf(34));
                if (href.endsWith("/")) continue;
                index = href.lastIndexOf(47);
                String name = href.substring(index + 1);
                this.storeFile(dirKey + name, dirRealFileName + name, dirCacheFileName + name);
            }
        }
    }

    private void scheduleDelete(final String key, final String realFileName, final File cacheFile, final String sharedStorageDir, final String fileService) {
        this.log("Schedule delete " + cacheFile.getName());
        long lastModified = new Date().getTime();
        cacheFile.setLastModified(lastModified);
        long delay = this.getExpiry(cacheFile);
        this.m_deleteTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!FileCache.this.isTouched(key)) {
                    FileCache.this.log("File is expired and not touched " + cacheFile.getName());
                    FileCache.this.delete(cacheFile);
                } else if (FileCache.this.isUpToDate(key, realFileName, cacheFile, sharedStorageDir, fileService)) {
                    FileCache.this.log("File is touched and still up-to-date " + cacheFile.getName());
                    FileCache.this.scheduleDelete(key, realFileName, cacheFile, sharedStorageDir, fileService);
                } else {
                    FileCache.this.log("File is touched and modified " + cacheFile.getName());
                    FileCache.this.delete(cacheFile);
                }
            }
        }, delay);
    }

    private boolean isExpired(File cacheFile) {
        if (cacheFile.exists()) {
            long expiry = this.getExpiry(cacheFile);
            long now = new Date().getTime();
            if (now - cacheFile.lastModified() < expiry) {
                return false;
            }
        }
        return true;
    }

    private long getExpiry(File cacheFile) {
        Long expiry;
        String extension = "";
        String name = cacheFile.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            extension = name.substring(index + 1);
        }
        if (cacheFile.isDirectory()) {
            extension = "directory";
        }
        if ((expiry = s_expiries.get(extension)) == null || expiry == 0L) {
            expiry = s_expiries.get("default");
        }
        return expiry;
    }

    private void log(String line) {
        if (this.m_out != null) {
            this.m_out.println(line);
        }
    }

    private void sign(HttpURLConnection con) throws Exception {
        Class<?> clazz = Class.forName("oauth.signpost.basic.DefaultOAuthConsumer");
        if (this.m_consumer == null) {
            Constructor<?> contructor = clazz.getConstructor(String.class, String.class);
            try {
                Properties props = this.getFileCacheProperties();
                String key = props.getProperty("key");
                String secret = props.getProperty("secret");
                if (secret != null && secret.startsWith("$1AWSKMS$")) {
                    secret = KmsUtil.getInstance().kmsDecrypt(secret);
                }
                this.m_consumer = contructor.newInstance(key, secret);
            }
            catch (Exception e) {
                this.m_consumer = contructor.newInstance("infor", "ChangeThisSecretASAP!");
            }
        }
        Method signMethod = clazz.getMethod("sign", Object.class);
        signMethod.invoke(this.m_consumer, con);
    }

    private Properties getFileCacheProperties() throws Exception {
        if (this.m_configPath.get() != null && !this.m_configPath.get().trim().isEmpty()) {
            File file = new File(this.m_configPath.get(), "fileCache.properties");
            return FileCache.getPropertiesForFile(file);
        }
        throw new IOException("No ConfigPath given");
    }

    private static Properties getPropertiesForFile(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        Properties props = new Properties();
        props.load(fis);
        fis.close();
        return props;
    }

    public static void setExpiry(String extension, long expiry) {
        s_expiries.put(extension, expiry);
    }

    public static void resetExpiries() {
        s_expiries.clear();
        s_expiries.put("otf", WEEK);
        s_expiries.put("ttf", WEEK);
        s_expiries.put("png", DAY);
        s_expiries.put("jpg", DAY);
        s_expiries.put("bml", HOUR);
        s_expiries.put("xml", HOUR);
        s_expiries.put("properties", MINUTE);
        s_expiries.put("directory", WEEK);
        s_expiries.put("default", DAY);
    }

    public void setPrintStream(PrintStream ps) {
        this.m_out = ps;
    }

    static {
        MINUTE = 60000L;
        HOUR = 60L * MINUTE;
        DAY = 24L * HOUR;
        WEEK = 7L * DAY;
        s_expiries = new HashMap();
        FileCache.resetExpiries();
    }
}

