/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;

public class ConfigManager {
    private static final String CONFIG_MANAGER = "configManager";
    private static final String LOG4JFILE = "log4j2.xml";
    private final ServletContext m_context;
    private final File m_configDir;
    private final File m_log4jFile;
    private final boolean m_isMultiTenant;

    public static ConfigManager getConfigManager(ServletContext context) {
        Object configManager = context.getAttribute(CONFIG_MANAGER);
        if (configManager == null || !(configManager instanceof ConfigManager)) {
            configManager = new ConfigManager(context);
            context.setAttribute(CONFIG_MANAGER, configManager);
        }
        return (ConfigManager)configManager;
    }

    public File getConfigDir() {
        return this.m_configDir;
    }

    public boolean isMultiTenant() {
        return this.m_isMultiTenant;
    }

    File getLog4jFile() {
        return this.m_log4jFile;
    }

    private ConfigManager(ServletContext context) {
        this.m_context = context;
        this.m_configDir = this.findConfigDir();
        this.m_log4jFile = this.createFile(this.m_configDir, LOG4JFILE);
        this.m_isMultiTenant = this.checkIsMultiTenant();
    }

    private File findConfigDir() {
        File configPath = null;
        String path = this.m_context.getInitParameter("ConfigPath");
        if (path != null && !path.isEmpty()) {
            configPath = new File(path);
        }
        if (configPath == null) {
            configPath = new File(this.getWebAppDir(), "config");
        }
        if (!configPath.exists()) {
            configPath.mkdirs();
        }
        return configPath;
    }

    private File getWebAppDir() {
        String webappDir = this.m_context.getRealPath("/");
        return new File(webappDir);
    }

    private File createFile(File destinationDirectory, String resourceName) {
        File file = new File(destinationDirectory, resourceName);
        try (InputStream input = this.getClass().getResourceAsStream(resourceName);
             FileOutputStream output = new FileOutputStream(file);){
            this.copy(input, output);
        }
        catch (IOException e) {
            System.err.println("Cannot create file " + resourceName);
        }
        return file;
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }

    private boolean checkIsMultiTenant() {
        return Boolean.parseBoolean(this.m_context.getInitParameter("MultiTenant"));
    }
}

