/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.itextpdf.io.codec.Base64;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class KmsUtil {
    private static final String s_keyArn = "arn:aws:kms:us-east-1:192491131326:key/053c3060-d8aa-4092-b5ba-97c862cfef85";
    private static AWSKMSClient s_client;

    public static String encode(String string) {
        if (s_client == null) {
            s_client = new AWSKMSClient();
        }
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = KmsUtil.str_to_bb(string, charset);
        EncryptRequest encryptRequest = new EncryptRequest().withKeyId(s_keyArn).withPlaintext(byteBuffer);
        ByteBuffer byteBuffer2 = s_client.encrypt(encryptRequest).getCiphertextBlob();
        byte[] byArray = Base64.encodeBytes(byteBuffer2.array()).getBytes();
        String string2 = new String(byArray, charset);
        return string2;
    }

    public static String decode(String string) {
        if (s_client == null) {
            s_client = new AWSKMSClient();
        }
        Charset charset = Charset.forName("UTF-8");
        byte[] byArray = Base64.decode(string);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        DecryptRequest decryptRequest = new DecryptRequest().withCiphertextBlob(byteBuffer);
        ByteBuffer byteBuffer2 = s_client.decrypt(decryptRequest).getPlaintext();
        String string2 = KmsUtil.bb_to_str(byteBuffer2, charset);
        return string2;
    }

    private static ByteBuffer str_to_bb(String string, Charset charset) {
        byte[] byArray = string.getBytes(charset);
        return ByteBuffer.wrap(byArray);
    }

    private static String bb_to_str(ByteBuffer byteBuffer, Charset charset) {
        byte[] byArray;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        return new String(byArray, charset);
    }
}

