/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.ln.server.UserEventLog;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Custom", category="Core", elementType="appender", printObject=true)
public class CustomAppender
extends AbstractAppender {
    private Map<String, UserEventLog> m_eventLogs = new HashMap<String, UserEventLog>();
    private Timer m_cleanupTimer;
    private static final int CLEANUP_DELAY = 14400000;

    private CustomAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        String tenant;
        String user = ThreadContext.get((String)"user");
        UserEventLog eventLog = this.getUserEventLog(user, tenant = ThreadContext.get((String)"tenant"));
        if (eventLog != null) {
            eventLog.append(event);
        }
    }

    public InputStream getInputStream(String user, String tenant) {
        UserEventLog eventLog = this.getUserEventLog(user, tenant);
        if (eventLog != null) {
            return eventLog.getInputStream();
        }
        return null;
    }

    public void setUserLogLevel(String user, String tenant, String level) {
        String key = this.getKey(user, tenant);
        Level logLevel = Level.toLevel((String)level, (Level)Level.OFF);
        if (logLevel.equals((Object)Level.OFF)) {
            this.cleanupEventLog(key);
        } else {
            UserEventLog eventLog = this.getAndSet(key);
            eventLog.setLevel(level);
        }
    }

    private synchronized UserEventLog getUserEventLog(String user, String tenant) {
        String key = this.getKey(user, tenant);
        return this.m_eventLogs.get(key);
    }

    private void cleanupEventLog(String key) {
        UserEventLog eventLog = this.getAndRemove(key);
        if (eventLog != null) {
            eventLog.cleanup();
            TimerCleanupTask task = eventLog.getCleanupTask();
            task.cancel();
        }
    }

    private synchronized UserEventLog getAndSet(String key) {
        UserEventLog eventLog = this.m_eventLogs.get(key);
        if (eventLog == null) {
            eventLog = new UserEventLog((Layout<? extends Serializable>)this.getLayout());
            this.m_eventLogs.put(key, eventLog);
        } else {
            eventLog.getCleanupTask().cancel();
        }
        TimerCleanupTask task = new TimerCleanupTask(key);
        eventLog.setCleanupTask(task);
        this.getcleanupTimer().schedule((TimerTask)task, 14400000L);
        return eventLog;
    }

    private synchronized UserEventLog getAndRemove(String key) {
        UserEventLog eventLog = this.m_eventLogs.get(key);
        if (eventLog != null) {
            this.m_eventLogs.remove(key);
        }
        return eventLog;
    }

    private String getKey(String user, String tenant) {
        String key = "";
        if (user != null) {
            key = user;
            if (tenant != null) {
                key = key + ":" + tenant;
            }
        }
        return key;
    }

    public synchronized Timer getcleanupTimer() {
        if (this.m_cleanupTimer == null) {
            this.m_cleanupTimer = new Timer("cleanupTimer", true);
        }
        return this.m_cleanupTimer;
    }

    @PluginFactory
    public static CustomAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for CustomAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        Property[] properties = new Property[]{};
        return new CustomAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, properties);
    }

    public class TimerCleanupTask
    extends TimerTask {
        private final String m_key;

        public TimerCleanupTask(String key) {
            this.m_key = key;
        }

        @Override
        public void run() {
            CustomAppender.this.cleanupEventLog(this.m_key);
        }
    }
}

