/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import java.util.LinkedHashMap;
import java.util.Map;

final class IndicCategory {
    private static final Map<Integer, Character> categoryRegexChars = new LinkedHashMap<Integer, Character>();
    public static final char OT_X = '\u0000';
    public static final char OT_C = '\u0001';
    public static final char OT_V = '\u0002';
    public static final char OT_N = '\u0003';
    public static final char OT_H = '\u0004';
    public static final char OT_ZWNJ = '\u0005';
    public static final char OT_ZWJ = '\u0006';
    public static final char OT_M = '\u0007';
    public static final char OT_SM = '\b';
    public static final char OT_VD = '\t';
    public static final char OT_A = '\n';
    public static final char OT_PLACEHOLDER = '\u000b';
    public static final char OT_DOTTEDCIRCLE = '\f';
    public static final char OT_RS = '\r';
    public static final char OT_Coeng = '\u000e';
    public static final char OT_Repha = '\u000f';
    public static final char OT_Ra = '\u0010';
    public static final char OT_CM = '\u0011';
    public static final char OT_Symbol = '\u0012';
    public static final char OT_CM2 = '\u001f';

    private IndicCategory() {
    }

    public static char getCategoryRegexChar(int category) {
        return categoryRegexChars.get(category).charValue();
    }

    public static String getSyllableRegex() {
        String C = String.valueOf(IndicCategory.getCategoryRegexChar(1));
        String V = String.valueOf(IndicCategory.getCategoryRegexChar(2));
        String N = String.valueOf(IndicCategory.getCategoryRegexChar(3));
        String H = String.valueOf(IndicCategory.getCategoryRegexChar(4));
        String ZWNJ = String.valueOf(IndicCategory.getCategoryRegexChar(5));
        String ZWJ = String.valueOf(IndicCategory.getCategoryRegexChar(6));
        String M = String.valueOf(IndicCategory.getCategoryRegexChar(7));
        String SM = String.valueOf(IndicCategory.getCategoryRegexChar(8));
        String VD = String.valueOf(IndicCategory.getCategoryRegexChar(9));
        String A = String.valueOf(IndicCategory.getCategoryRegexChar(10));
        String PLACEHOLDER = String.valueOf(IndicCategory.getCategoryRegexChar(11));
        String DOTTEDCIRCLE = String.valueOf(IndicCategory.getCategoryRegexChar(12));
        String RS = String.valueOf(IndicCategory.getCategoryRegexChar(13));
        String Coeng = String.valueOf(IndicCategory.getCategoryRegexChar(14));
        String Repha = String.valueOf(IndicCategory.getCategoryRegexChar(15));
        String Ra = String.valueOf(IndicCategory.getCategoryRegexChar(16));
        String CM = String.valueOf(IndicCategory.getCategoryRegexChar(17));
        String Symbol = String.valueOf(IndicCategory.getCategoryRegexChar(18));
        String CM2 = String.valueOf(IndicCategory.getCategoryRegexChar(31));
        String c = "((" + C + "|" + Ra + "))";
        String n = "(((" + ZWNJ + "?" + RS + ")?(" + N + N + "?)?))";
        String z = "(" + ZWJ + "|" + ZWNJ + ")";
        String h = "(" + H + "|" + Coeng + ")";
        String reph = "((" + Ra + H + "|" + Repha + "))";
        String cn = "(" + c + ZWJ + "?" + n + "?)";
        String forced_rakar = "(" + ZWJ + H + ZWJ + Ra + ")";
        String symbol = "(" + Symbol + N + "?)";
        String matra_group = "(" + z + "{0,3}" + M + N + "?(" + H + "|" + forced_rakar + ")?)";
        String syllable_tail = "((" + z + "?" + SM + SM + "?" + ZWNJ + "?)?" + A + "{0,3}?" + VD + "{0,2})";
        String place_holder = "(" + PLACEHOLDER + "|" + DOTTEDCIRCLE + ")";
        String halant_group = "((" + z + "?" + h + "(" + ZWJ + N + "?)?))";
        String final_halant_group = "(" + halant_group + "|" + h + ZWNJ + ")";
        String medial_group = "(" + CM + "?" + CM2 + "?)";
        String halant_or_matra_group = "((" + final_halant_group + "|(" + h + ZWJ + ")?" + matra_group + "{0,4})(" + Coeng + "(" + cn + "|" + V + "))?)";
        String consonant_syllable = "(" + Repha + "?(" + cn + halant_group + "){0,4}" + cn + medial_group + halant_or_matra_group + syllable_tail + ")";
        String vowel_syllable = "(" + reph + "?" + V + n + "?(" + ZWJ + "|(" + halant_group + cn + "){0,4}" + medial_group + halant_or_matra_group + syllable_tail + "))";
        String standalone_cluster = "((" + Repha + "?" + PLACEHOLDER + "|" + reph + "?" + DOTTEDCIRCLE + ")" + n + "?(" + halant_group + cn + "){0,4}" + medial_group + halant_or_matra_group + syllable_tail + ")";
        String symbol_cluster = "(" + symbol + syllable_tail + ")";
        String broken_cluster = "(" + reph + "?" + n + "?(" + halant_group + cn + "){0,4}" + medial_group + halant_or_matra_group + syllable_tail + ")";
        String regexp = "(" + consonant_syllable + "|" + vowel_syllable + "|" + standalone_cluster + "|" + symbol_cluster + "|" + broken_cluster + ")";
        return regexp;
    }

    public static boolean isDeva(int u) {
        return IndicCategory.inHalfBlock(u, 2304);
    }

    public static boolean isBeng(int u) {
        return IndicCategory.inHalfBlock(u, 2432);
    }

    public static boolean isGuru(int u) {
        return IndicCategory.inHalfBlock(u, 2560);
    }

    public static boolean isGujr(int u) {
        return IndicCategory.inHalfBlock(u, 2688);
    }

    public static boolean isOrya(int u) {
        return IndicCategory.inHalfBlock(u, 2816);
    }

    public static boolean isTaml(int u) {
        return IndicCategory.inHalfBlock(u, 2944);
    }

    public static boolean isTelu(int u) {
        return IndicCategory.inHalfBlock(u, 3072);
    }

    public static boolean isKnda(int u) {
        return IndicCategory.inHalfBlock(u, 3200);
    }

    public static boolean isMlym(int u) {
        return IndicCategory.inHalfBlock(u, 3328);
    }

    public static boolean isSinh(int u) {
        return IndicCategory.inHalfBlock(u, 3456);
    }

    public static boolean isKhmr(int u) {
        return IndicCategory.inHalfBlock(u, 6016);
    }

    private static boolean inHalfBlock(int u, int base) {
        return (u & 0xFFFFFF80) == base;
    }

    static {
        categoryRegexChars.put(0, Character.valueOf('X'));
        categoryRegexChars.put(1, Character.valueOf('C'));
        categoryRegexChars.put(2, Character.valueOf('V'));
        categoryRegexChars.put(3, Character.valueOf('N'));
        categoryRegexChars.put(4, Character.valueOf('H'));
        categoryRegexChars.put(5, Character.valueOf('z'));
        categoryRegexChars.put(6, Character.valueOf('Z'));
        categoryRegexChars.put(7, Character.valueOf('M'));
        categoryRegexChars.put(8, Character.valueOf('S'));
        categoryRegexChars.put(9, Character.valueOf('D'));
        categoryRegexChars.put(10, Character.valueOf('A'));
        categoryRegexChars.put(11, Character.valueOf('P'));
        categoryRegexChars.put(12, Character.valueOf('o'));
        categoryRegexChars.put(13, Character.valueOf('r'));
        categoryRegexChars.put(14, Character.valueOf('v'));
        categoryRegexChars.put(15, Character.valueOf('a'));
        categoryRegexChars.put(16, Character.valueOf('R'));
        categoryRegexChars.put(17, Character.valueOf('c'));
        categoryRegexChars.put(18, Character.valueOf('h'));
        categoryRegexChars.put(31, Character.valueOf('s'));
    }
}

