/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.config;

import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.typography.config.IFeaturesConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypographyConfigurator {
    private Map<Character.UnicodeScript, IFeaturesConfig> featureConfigs = new HashMap<Character.UnicodeScript, IFeaturesConfig>();

    public TypographyConfigurator addFeatureConfig(IFeaturesConfig featureConfig) {
        for (Character.UnicodeScript script : featureConfig.getScripts()) {
            this.featureConfigs.put(script, featureConfig);
        }
        return this;
    }

    public IFeaturesConfig getFeatureConfig(Character.UnicodeScript script) {
        return this.featureConfigs.get(EnumUtil.throwIfNull((Enum)script));
    }

    public Set<Character.UnicodeScript> getConfiguredScripts() {
        return Collections.unmodifiableSet(new HashSet<Character.UnicodeScript>(this.featureConfigs.keySet()));
    }
}

