/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.bidi;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.licensekey.LicenseKey;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidiCharacterMap {
    private static final int MAP_SIZE = 19;
    private static final byte[] directionalityMap = new byte[19];

    public static byte getCharacterType(int c) {
        try {
            return directionalityMap[Character.getDirectionality(c)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger logger = LoggerFactory.getLogger(BidiCharacterMap.class);
            logger.warn(MessageFormatUtil.format((String)"The direction for this character has not been detected: code point {0}. The Other Neutrals algorithm will be used.", (Object[])new Object[]{c}));
            return 18;
        }
    }

    public static byte[] getCharacterTypes(int[] text, int startPos, int endPos) {
        LicenseKey.scheduledCheck((LicenseKeyProduct)new LicenseKeyProduct("pdfCalligraph", 2, 0, new LicenseKeyProductFeature[0]));
        int len = endPos - startPos;
        byte[] ret = new byte[len];
        for (int i = startPos; i < endPos; ++i) {
            ret[i - startPos] = BidiCharacterMap.getCharacterType(text[i]);
        }
        return ret;
    }

    static {
        BidiCharacterMap.directionalityMap[0] = 0;
        BidiCharacterMap.directionalityMap[1] = 3;
        BidiCharacterMap.directionalityMap[2] = 4;
        BidiCharacterMap.directionalityMap[3] = 8;
        BidiCharacterMap.directionalityMap[4] = 9;
        BidiCharacterMap.directionalityMap[5] = 10;
        BidiCharacterMap.directionalityMap[6] = 11;
        BidiCharacterMap.directionalityMap[7] = 12;
        BidiCharacterMap.directionalityMap[8] = 13;
        BidiCharacterMap.directionalityMap[9] = 14;
        BidiCharacterMap.directionalityMap[10] = 15;
        BidiCharacterMap.directionalityMap[11] = 16;
        BidiCharacterMap.directionalityMap[12] = 17;
        BidiCharacterMap.directionalityMap[13] = 18;
        BidiCharacterMap.directionalityMap[14] = 1;
        BidiCharacterMap.directionalityMap[15] = 2;
        BidiCharacterMap.directionalityMap[16] = 5;
        BidiCharacterMap.directionalityMap[17] = 6;
        BidiCharacterMap.directionalityMap[18] = 7;
    }
}

