/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode;

import com.java4less.rbarcode.BarCode2D;
import com.java4less.rbarcode.common.IBarcodeGenerator;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class BarCode2DFacade
implements IBarcodeGenerator {
    BarCode2D bc;

    public BarCode2D getBarcode() {
        return this.bc;
    }

    public Image createBarcodeImage(String code, byte[] codeBinary, int rows, int maxRows, int cols, int ecLevel, String compaction, int X, int H, int margin, Properties properties) {
        this.createBarcode(code, codeBinary, rows, maxRows, cols, ecLevel, compaction, X, H, margin, properties);
        return this.createImage();
    }

    public void createBarcode(String code, byte[] codeBinary, int rows, int maxRows, int cols, int ecLevel, String compaction, int X, int H, int margin, Properties properties) {
        this.bc = new BarCode2D();
        if (codeBinary != null && codeBinary.length > 0) {
            this.bc.codeBinary = codeBinary;
        }
        if (rows > 0) {
            this.bc.PDFRows = rows;
        }
        if (maxRows > 0) {
            this.bc.PDFMaxRows = maxRows;
        }
        if (cols > 0) {
            this.bc.PDFColumns = cols;
        }
        this.bc.PDFECLevel = ecLevel;
        this.bc.X = X >= 1 ? (double)X : 1.0;
        this.bc.resolution = 1;
        if (H >= 2) {
            this.bc.barHeightCM = H;
        } else {
            H = 2;
        }
        this.bc.leftMarginCM = margin;
        this.bc.topMarginCM = margin;
        this.bc.barType = 30;
        this.bc.code = code;
        String v = compaction;
        if (v.equalsIgnoreCase("BINARY")) {
            this.bc.PDFMode = 0;
        }
        if (v.equalsIgnoreCase("NUMERIC")) {
            this.bc.PDFMode = 2;
        }
        if (v.equalsIgnoreCase("TEXT")) {
            this.bc.PDFMode = 1;
        }
        if (properties != null) {
            String fileId = properties.getProperty("PDFMacroFileId", null);
            boolean PDFMacroAuto = properties.getProperty("PDFMacroAuto", "true").equalsIgnoreCase("true");
            if (fileId != null) {
                this.bc.PDFMacroAddresse = properties.getProperty("PDFMacroAddresse", "");
                byte[] b = null;
                try {
                    b = fileId.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                int[] bi = new int[b.length];
                for (int i = 0; i < b.length; ++i) {
                    bi[i] = b[i];
                    if (bi[i] >= 0) continue;
                    bi[i] = 256 + bi[i];
                }
                this.bc.PDFMacroFileId = bi;
                this.bc.PDFMacroFileName = properties.getProperty("PDFMacroFileName", "");
                this.bc.PDFMacroFileSize = Integer.parseInt(properties.getProperty("PDFMacroFileSize", "0"));
                this.bc.PDFMacroSegment = Integer.parseInt(properties.getProperty("PDFMacroSegment", "0"));
                this.bc.PDFMacroSegmentCount = Integer.parseInt(properties.getProperty("PDFMacroSegmentCount", "0"));
                this.bc.PDFMacroTimeStamp = properties.getProperty("PDFMacroTimeStamp", "");
                this.bc.PDFMacroSender = properties.getProperty("PDFMacroSender", "");
                boolean bl = this.bc.PDFMacroLastSegment = this.bc.PDFMacroSegmentCount - 1 == this.bc.PDFMacroSegment;
                if (properties.getProperty("PDFMacroLastSegment", "").length() > 0) {
                    this.bc.PDFMacroLastSegment = properties.getProperty("PDFMacroLastSegment", "false").equalsIgnoreCase("true");
                }
                if (PDFMacroAuto) {
                    this.bc.resetMacroPDF();
                    this.bc.prepareMacroPDF();
                    this.bc.PDFMacroSegment = Integer.parseInt(properties.getProperty("PDFMacroSegment", "0"));
                }
            }
        }
    }

    public Image createImage() {
        BufferedImage barImage = new BufferedImage(500, 500, 1);
        Graphics2D barGraphics = barImage.createGraphics();
        this.bc.setSize(500, 500);
        this.bc.paint(barGraphics);
        int w = (int)(this.bc.getPaintedArea().getWidth() + this.bc.leftMarginCM);
        int h = (int)this.bc.getPaintedArea().getHeight() + (int)this.bc.topMarginCM;
        barImage = new BufferedImage(w, h, 1);
        this.bc.setSize(w, h);
        barGraphics = barImage.createGraphics();
        this.bc.paint(barGraphics);
        return barImage;
    }

    public void createBarcode(Properties properties) {
        this.createBarcodeFromProperties(properties);
    }

    protected void createBarcodeFromProperties(Properties properties) {
        String margin;
        String H;
        String X;
        String compaction;
        String ecLevel;
        String cols;
        String maxRows;
        String code = properties.getProperty("code".toUpperCase());
        if (code == null) {
            code = "";
        }
        byte[] codeBinary = (byte[])properties.get("codeBinary".toUpperCase());
        String rows = properties.getProperty("rows".toUpperCase());
        if (rows == null) {
            rows = "3";
        }
        if ((maxRows = properties.getProperty("maxRows".toUpperCase())) == null) {
            maxRows = "30";
        }
        if ((cols = properties.getProperty("cols".toUpperCase())) == null) {
            cols = "10";
        }
        if ((ecLevel = properties.getProperty("ecLevel".toUpperCase())) == null) {
            ecLevel = "0";
        }
        if ((compaction = properties.getProperty("compaction".toUpperCase())) == null) {
            compaction = "BINARY";
        }
        if ((X = properties.getProperty("X".toUpperCase())) == null) {
            X = "1";
        }
        if ((H = properties.getProperty("H".toUpperCase())) == null) {
            H = "4";
        }
        if ((margin = properties.getProperty("margin".toUpperCase())) == null) {
            margin = "0";
        }
        Properties additionalProperties = (Properties)properties.get("additionalProperties");
        this.createBarcode(code, codeBinary, Integer.parseInt(rows), Integer.parseInt(maxRows), Integer.parseInt(cols), Integer.parseInt(ecLevel), compaction, Integer.parseInt(X), Integer.parseInt(H), Integer.parseInt(margin), additionalProperties);
    }

    public void paintBarcode(Graphics g) {
        this.bc.paint(g);
    }
}

