/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import com.ssaglobal.bml.FileCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NotoMapper
extends FontProvider {
    private File m_directory;
    private boolean m_debug = false;
    private ArrayList m_debugLines = new ArrayList();
    private PdfFont m_latinFont;
    private PdfFont m_monospaceLatinFont;
    public static final Glyph DUMMY = new Glyph(-1, -1, new char[]{'a'});
    private HashMap<String, PdfFont> m_fonts = new HashMap();
    private PdfFont m_arialUni;

    public NotoMapper(File file, boolean bl) {
        this.m_directory = file;
        this.m_debug = bl;
        File file2 = new File(this.m_directory, this.getNotoFileName("LATIN"));
        try {
            this.m_latinFont = this.createFont(file2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private PdfFont createFont(File file) throws IOException {
        if (this.m_debug) {
            this.m_debugLines.add("About to load font: " + file.getName());
            this.m_debugLines.add("free memory before load: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
        }
        file = FileCache.getInstance().getLocalFile(file.getAbsolutePath());
        PdfFont pdfFont = PdfFontFactory.createFont(file.getAbsolutePath(), "Identity-H", false);
        if (this.m_debug) {
            this.m_debugLines.add("free memory after load: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
        }
        return pdfFont;
    }

    public List<String> getDebugLines() {
        return this.m_debugLines;
    }

    public void next(CurrentFont currentFont) {
        if (currentFont.m_remainderTxt == null || currentFont.m_remainderTxt.isEmpty()) {
            currentFont.m_txt = "";
            currentFont.m_font = this.m_latinFont;
            return;
        }
        int n = 0;
        char c = currentFont.m_remainderTxt.charAt(n);
        String string = this.getUnicodeBlock(c);
        String string2 = null;
        while (n < currentFont.m_remainderTxt.length() - 1 && string.equals(string2 = this.getUnicodeBlock(c = currentFont.m_remainderTxt.charAt(++n)))) {
        }
        if (n == currentFont.m_remainderTxt.length() - 1) {
            if (string.equals(string2)) {
                ++n;
            } else if (string2 == null) {
                ++n;
            }
        }
        currentFont.m_txt = currentFont.m_remainderTxt.substring(0, n);
        currentFont.m_remainderTxt = currentFont.m_remainderTxt.substring(n);
        if (string.equals("LATIN")) {
            this.setLatinFont(currentFont);
        } else {
            File file = new File(this.m_directory, this.getNotoFileName(string));
            if (!file.exists()) {
                this.setLatinFont(currentFont);
                return;
            }
            try {
                currentFont.m_font = this.m_fonts.get(file.getAbsolutePath());
                if (currentFont.m_font == null) {
                    currentFont.m_font = this.createFont(file);
                    this.m_fonts.put(file.getAbsolutePath(), currentFont.m_font);
                }
            }
            catch (Exception exception) {
                this.setLatinFont(currentFont);
                this.m_fonts.put(file.getAbsolutePath(), currentFont.m_font);
            }
        }
    }

    private void setLatinFont(CurrentFont currentFont) {
        if (currentFont.m_monospace && this.m_monospaceLatinFont == null) {
            try {
                this.m_monospaceLatinFont = this.createFont(new File(this.m_directory, this.getNotoFileName("Mono", "ttf")));
            }
            catch (Exception exception) {
                this.m_monospaceLatinFont = this.m_latinFont;
            }
        }
        currentFont.m_font = currentFont.m_monospace ? this.m_monospaceLatinFont : this.m_latinFont;
    }

    private String getNotoFileName(String string) {
        if (string.equals("LATIN")) {
            return this.getNotoFileName("", "ttf");
        }
        if (string.equals("KOREAN")) {
            return this.getNotoFileName("CJKkr", "otf");
        }
        if (string.equals("JAPANESE")) {
            return this.getNotoFileName("CJKjp", "otf");
        }
        if (string.equals("CHINESE")) {
            return this.getNotoFileName("CJKsc", "otf");
        }
        String string2 = string.toString().substring(0, 1) + string.toString().toLowerCase().substring(1);
        return this.getNotoFileName(string2, "ttf");
    }

    private String getUnicodeBlock(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        if (unicodeBlock.toString().contains("LATIN")) {
            return "LATIN";
        }
        if (unicodeBlock.toString().contains("HANGUL")) {
            return "KOREAN";
        }
        if (unicodeBlock.toString().contains("ARABIC")) {
            return "ARABIC";
        }
        if (unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA) {
            return "JAPANESE";
        }
        if (unicodeBlock.toString().contains("CJK") || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || unicodeBlock == Character.UnicodeBlock.NUMBER_FORMS) {
            return "CHINESE";
        }
        if (unicodeBlock == Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS || unicodeBlock == Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS) {
            return "SYMBOLS";
        }
        String string = unicodeBlock.toString();
        int n = string.indexOf(95);
        if (n != -1) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private String getNotoFileName(String string, String string2) {
        return "NotoSans" + string + "-Regular." + string2;
    }

    public FontSelectorStrategy getStrategy(String string, List<String> list) {
        return new NotoFontSelectorStrategy(string, this, null, list.size() > 0);
    }

    public class ArialUniFontSelectorStrategy
    extends FontSelectorStrategy {
        private String m_txt;

        protected ArialUniFontSelectorStrategy(String string, FontProvider fontProvider, FontSet fontSet) {
            super(string, fontProvider, fontSet);
            this.m_txt = string;
            if (NotoMapper.this.m_arialUni == null) {
                try {
                    NotoMapper.this.m_arialUni = NotoMapper.this.createFont(new File("c:/windows/fonts/arialuni.ttf"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public PdfFont getCurrentFont() {
            return NotoMapper.this.m_arialUni;
        }

        public List<Glyph> nextGlyphs() {
            ArrayList<Glyph> arrayList = new ArrayList<Glyph>();
            for (int i = 0; i < this.m_txt.length(); ++i) {
                arrayList.add(DUMMY);
            }
            this.m_txt = "";
            return arrayList;
        }
    }

    public class NotoFontSelectorStrategy
    extends FontSelectorStrategy {
        private CurrentFont m_current;

        protected NotoFontSelectorStrategy(String string, FontProvider fontProvider, FontSet fontSet, boolean bl) {
            super(string, fontProvider, fontSet);
            this.m_current = new CurrentFont();
            this.m_current.m_remainderTxt = string;
            this.m_current.m_monospace = bl;
        }

        public PdfFont getCurrentFont() {
            return this.m_current.m_font;
        }

        public List<Glyph> nextGlyphs() {
            NotoMapper.this.next(this.m_current);
            ArrayList<Glyph> arrayList = new ArrayList<Glyph>();
            for (int i = 0; i < this.m_current.m_txt.length(); ++i) {
                arrayList.add(DUMMY);
            }
            return arrayList;
        }
    }

    public static class CurrentFont {
        public PdfFont m_font;
        public String m_txt;
        public String m_remainderTxt;
        public boolean m_monospace;
    }
}

