/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.KmsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class FileCache {
    private ThreadLocal<String> m_fileService = new ThreadLocal();
    private ThreadLocal<String> m_sharedStorageDir = new ThreadLocal();
    private ThreadLocal<String> m_userDir = new ThreadLocal();
    private ThreadLocal<String> m_configPath = new ThreadLocal();
    private HashMap<String, Thread> m_busyFiles = new HashMap();
    private static FileCache s_fileCache;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static HashMap<String, Long> s_expiries;
    private Timer m_deleteTimer = new Timer(true);
    private HashSet<String> m_touched = new HashSet();
    private PrintStream m_out;
    private Object m_consumer;
    private static final String DIRECTORY_FILE = "html.directory";

    public static synchronized FileCache getInstance(String string) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split("\\|");
        String string2 = "";
        String string3 = "c:/storage/infor/";
        String string4 = null;
        if (stringArray.length >= 4) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
            string4 = stringArray[3];
        }
        if (s_fileCache == null) {
            s_fileCache = new FileCache();
        }
        FileCache.s_fileCache.m_sharedStorageDir.set(FileCache.getFileName(string3, true));
        FileCache.s_fileCache.m_userDir.set(FileCache.getFileName(string2, true));
        FileCache.s_fileCache.m_fileService.set(string);
        FileCache.s_fileCache.m_configPath.set(string4);
        return s_fileCache;
    }

    public static synchronized FileCache getInstance() {
        if (s_fileCache == null) {
            s_fileCache = new FileCache();
        }
        return s_fileCache;
    }

    public void ready() {
        if (s_fileCache != null) {
            FileCache.s_fileCache.m_sharedStorageDir.remove();
            FileCache.s_fileCache.m_userDir.remove();
            FileCache.s_fileCache.m_fileService.remove();
            FileCache.s_fileCache.m_configPath.remove();
        }
    }

    private FileCache() {
        this.clearExpiredCache();
    }

    private synchronized boolean isBusy(String string) {
        return this.m_busyFiles.containsKey(string);
    }

    private synchronized void setBusy(String string, boolean bl) {
        if (!bl) {
            this.m_busyFiles.remove(string);
        } else {
            this.m_busyFiles.put(string, Thread.currentThread());
        }
    }

    private synchronized void touched(String string) {
        this.m_touched.add(string);
    }

    private synchronized boolean isTouched(String string) {
        if (this.m_touched.contains(string)) {
            this.m_touched.remove(string);
            return true;
        }
        return false;
    }

    private synchronized boolean getLock(String string) {
        if (this.isBusy(string)) {
            return false;
        }
        this.setBusy(string, true);
        return true;
    }

    private void waitAndLock(String string) {
        while (!this.getLock(string)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(File file) {
        String string = file.getName();
        File file2 = file.getParentFile();
        this.isTouched(string);
        this.waitAndLock(string);
        try {
            this.log("Delete " + file.getName());
            boolean bl = file.delete();
            if (!bl) {
                this.log("Could not delete " + file.getName());
            }
        }
        finally {
            this.setBusy(string, false);
        }
        if (file2 != null && !file2.equals(this.getCacheDir()) && file2.list() != null && file2.list().length == 0) {
            this.delete(file.getParentFile());
        }
    }

    private String getKey(String string) {
        string = string.replaceFirst(this.m_sharedStorageDir.get(), "");
        String string2 = string.toLowerCase();
        string2 = string2.replace("\\\\", "/");
        return string2;
    }

    public File getCacheDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        File file2 = new File(file, "fileCache");
        this.mkdirs(file2);
        return file2;
    }

    private synchronized void mkdirs(File file) {
        if (file.exists()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
        }
    }

    public void clearCache() {
        File file = this.getCacheDir();
        this.clearCache(file);
    }

    private void clearCache(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.clearCache(fileArray[i]);
                this.delete(fileArray[i]);
                continue;
            }
            this.delete(fileArray[i]);
        }
    }

    public void clearExpiredCache() {
        File file = this.getCacheDir();
        this.clearExpiredCache(file);
    }

    public void clearExpiredCache(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null) continue;
            if (fileArray[i].isDirectory()) {
                this.clearExpiredCache(fileArray[i]);
                if (!this.isExpired(fileArray[i])) continue;
                this.delete(fileArray[i]);
                continue;
            }
            if (!this.isExpired(fileArray[i])) continue;
            this.delete(fileArray[i]);
        }
    }

    public boolean isDownloading(String string) {
        string = FileCache.getFileName(string, false);
        String string2 = this.getKey(string);
        return this.isBusy(string2);
    }

    public File getLocalFile(String string) throws IOException {
        return new File(this.getLocalFileName(string));
    }

    public String getLocalFileName(String string) throws IOException {
        if (this.m_fileService.get() == null || this.m_fileService.get().isEmpty()) {
            return string;
        }
        if (!(string = FileCache.getFileName(string, false)).startsWith("/") && string.charAt(1) != ':') {
            string = this.m_sharedStorageDir.get() + this.m_userDir.get() + string;
        }
        if (!this.isSharedStorage(string)) {
            return string;
        }
        String string2 = this.getKey(string);
        File file = new File(this.getCacheDir(), string2);
        this.storeFile(string2, string, file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    private static String getFileName(String string, boolean bl) {
        String string2 = string.replaceAll("\\\\", "/").replace("//", "/");
        if (bl && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (!bl && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private boolean isSharedStorage(String string) {
        return string.startsWith(this.m_sharedStorageDir.get());
    }

    private boolean isUpToDate(String string, String string2, File file, String string3, String string4) {
        try {
            if (file.isDirectory()) {
                return false;
            }
            if (!file.exists()) {
                return false;
            }
            String string5 = string2.replace(string3, "");
            String string6 = string4 + string5;
            URL uRL = new URL(string6);
            URLConnection uRLConnection = uRL.openConnection();
            long l = file.lastModified();
            uRLConnection.setIfModifiedSince(l);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("GET");
                this.sign(httpURLConnection);
                int n = httpURLConnection.getResponseCode();
                if (n == 304) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void storeFile(String string, String string2, String string3) throws IOException {
        String string4 = string;
        this.waitAndLock(string4);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        String string5 = null;
        try {
            int n;
            Object object;
            File file = new File(string3);
            if (file.exists()) {
                this.touched(string);
                return;
            }
            this.mkdirs(file.getParentFile());
            boolean bl = true;
            boolean bl2 = false;
            String string6 = string2.replace(this.m_sharedStorageDir.get(), "");
            string5 = this.m_fileService.get() + string6;
            URL uRL = new URL(string5);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                ((HttpURLConnection)object).setRequestMethod("GET");
                this.sign((HttpURLConnection)object);
                n = ((HttpURLConnection)object).getResponseCode();
                if (((URLConnection)object).getURL().toString().endsWith("/")) {
                    this.mkdirs(file);
                    bl2 = true;
                    string = string + "/" + DIRECTORY_FILE;
                    string2 = string2 + "/" + DIRECTORY_FILE;
                    string3 = string3 + "/" + DIRECTORY_FILE;
                    file = new File(string3);
                } else if (n != 200) {
                    bl = false;
                    throw new IOException("Cannot get the file from the file service, http error " + n);
                }
            }
            if (bl) {
                inputStream = uRLConnection.getInputStream();
                outputStream = new FileOutputStream(new File(string3));
                object = new byte[1024];
                while ((n = inputStream.read((byte[])object)) > 0) {
                    ((FileOutputStream)outputStream).write((byte[])object, 0, n);
                }
                inputStream.close();
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
                this.log("File put in cache " + file.getName());
                this.scheduleDelete(string, string2, file, this.m_sharedStorageDir.get(), this.m_fileService.get());
                if (bl2) {
                    this.fillCache(string, string2, string3);
                }
            }
        }
        catch (Exception exception) {
            if (outputStream != null) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
            File file = new File(string3);
            file.delete();
            throw new IOException("Cannot store the file " + string2 + " in the file cache with url " + string5, exception);
        }
        finally {
            this.setBusy(string4, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCache(String string, String string2, String string3) throws IOException {
        String string4 = string.substring(0, string.length() - DIRECTORY_FILE.length());
        String string5 = string2.substring(0, string2.length() - DIRECTORY_FILE.length());
        String string6 = string3.substring(0, string3.length() - DIRECTORY_FILE.length());
        try (FileInputStream fileInputStream = new FileInputStream(string3);){
            int n;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            String string7 = byteArrayOutputStream.toString();
            while ((n = string7.indexOf("href=\"")) != -1) {
                String string8 = (string7 = string7.substring(n + 6)).substring(0, n = string7.indexOf(34));
                if (string8.endsWith("/")) continue;
                n = string8.lastIndexOf(47);
                String string9 = string8.substring(n + 1);
                this.storeFile(string4 + string9, string5 + string9, string6 + string9);
            }
        }
    }

    private void scheduleDelete(final String string, final String string2, final File file, final String string3, final String string4) {
        this.log("Schedule delete " + file.getName());
        long l = new Date().getTime();
        file.setLastModified(l);
        long l2 = this.getExpiry(file);
        this.m_deleteTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!FileCache.this.isTouched(string)) {
                    FileCache.this.log("File is expired and not touched " + file.getName());
                    FileCache.this.delete(file);
                } else if (FileCache.this.isUpToDate(string, string2, file, string3, string4)) {
                    FileCache.this.log("File is touched and still up-to-date " + file.getName());
                    FileCache.this.scheduleDelete(string, string2, file, string3, string4);
                } else {
                    FileCache.this.log("File is touched and modified " + file.getName());
                    FileCache.this.delete(file);
                }
            }
        }, l2);
    }

    private boolean isExpired(File file) {
        if (file.exists()) {
            long l = this.getExpiry(file);
            long l2 = new Date().getTime();
            if (l2 - file.lastModified() < l) {
                return false;
            }
        }
        return true;
    }

    private long getExpiry(File file) {
        Long l;
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string = string2.substring(n + 1);
        }
        if (file.isDirectory()) {
            string = "directory";
        }
        if ((l = s_expiries.get(string)) == null || l == 0L) {
            l = s_expiries.get("default");
        }
        return l;
    }

    private void log(String string) {
        if (this.m_out != null) {
            this.m_out.println(string);
        }
    }

    private void sign(HttpURLConnection httpURLConnection) throws Exception {
        Executable executable;
        Class<?> clazz = Class.forName("oauth.signpost.basic.DefaultOAuthConsumer");
        if (this.m_consumer == null) {
            executable = clazz.getConstructor(String.class, String.class);
            try {
                Properties properties = this.getFileCacheProperties();
                String string = properties.getProperty("key");
                String string2 = properties.getProperty("secret");
                if (string2 != null && string2.startsWith("$1AWSKMS$")) {
                    string2 = KmsUtil.decode(string2.substring(9));
                }
                this.m_consumer = ((Constructor)executable).newInstance(string, string2);
            }
            catch (Exception exception) {
                this.m_consumer = ((Constructor)executable).newInstance("infor", "ChangeThisSecretASAP!");
            }
        }
        executable = clazz.getMethod("sign", Object.class);
        ((Method)executable).invoke(this.m_consumer, httpURLConnection);
    }

    private Properties getFileCacheProperties() throws Exception {
        if (this.m_configPath.get() != null && !this.m_configPath.get().trim().isEmpty()) {
            File file = new File(this.m_configPath.get(), "fileCache.properties");
            return FileCache.getPropertiesForFile(file);
        }
        throw new IOException("No ConfigPath given");
    }

    private static Properties getPropertiesForFile(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        return properties;
    }

    public static void setExpiry(String string, long l) {
        s_expiries.put(string, l);
    }

    public static void resetExpiries() {
        s_expiries.clear();
        s_expiries.put("otf", WEEK);
        s_expiries.put("ttf", WEEK);
        s_expiries.put("png", DAY);
        s_expiries.put("jpg", DAY);
        s_expiries.put("bml", HOUR);
        s_expiries.put("xml", HOUR);
        s_expiries.put("properties", MINUTE);
        s_expiries.put("directory", WEEK);
        s_expiries.put("default", DAY);
    }

    public void setPrintStream(PrintStream printStream) {
        this.m_out = printStream;
    }

    static {
        MINUTE = 60000L;
        HOUR = 60L * MINUTE;
        DAY = 24L * HOUR;
        WEEK = 7L * DAY;
        s_expiries = new HashMap();
        FileCache.resetExpiries();
    }
}

