/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BarcodeImageFactory;
import com.ssaglobal.bml.BarcodeParameter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class BarcodeImage {
    private static final String BARTYPE = "barType";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String FILETYPE = "fileType";
    private static final Map<String, Integer> TYPES = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -5018979056472423799L;
        {
            this.put("BAR39", 0);
            this.put("BAR39EXT", 1);
            this.put("CODE93", 9);
            this.put("CODE11", 3);
            this.put("CODABAR", 4);
            this.put("CODE93EXT", 14);
            this.put("CODE128", 13);
            this.put("EAN13", 10);
            this.put("EAN8", 11);
            this.put("EAN128", 16);
            this.put("INTERLEAVED25", 2);
            this.put("POSTNET", 15);
            this.put("UPCA", 6);
            this.put("UPCE", 12);
            this.put("IND25", 7);
            this.put("MAT25", 8);
            this.put("MSI", 5);
            this.put("PDF417", 30);
            this.put("QRCODE", 500);
            this.put("DATAMATRIX", 31);
            this.put("AZTECCODE", 600);
        }
    };
    private final String value;
    private final String type;
    private final Map<String, BarcodeParameter> keyValuePairs = new HashMap<String, BarcodeParameter>();
    private boolean rotated = false;

    public BarcodeImage(String string, String string2, String ... stringArray) {
        this.value = string2;
        this.type = string;
        this.setParameterMap(stringArray);
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public BufferedImage getBarcodeImage(int n, int n2) {
        try {
            BarcodeImageFactory barcodeImageFactory = new BarcodeImageFactory(TYPES.get(this.type), this.value, this.keyValuePairs, n, n2);
            barcodeImageFactory.createBarcode();
            this.rotated = barcodeImageFactory.isRotated();
            return barcodeImageFactory.getBarcodeImage();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot generate barcode for type " + this.type + " and value " + this.value, exception);
        }
    }

    private void setParameterMap(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            String[] stringArray2 = stringArray[i].split("[;]");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = stringArray2[j];
                String[] stringArray3 = string.split("[=]");
                String string2 = stringArray3[0].trim().toUpperCase();
                if (stringArray3.length <= 1) continue;
                BarcodeParameter barcodeParameter = new BarcodeParameter(stringArray3[0].trim(), stringArray3[1].trim(), this.useReflection(string2));
                this.keyValuePairs.put(stringArray3[0].trim(), barcodeParameter);
            }
        }
    }

    private boolean useReflection(String string) {
        return !string.equalsIgnoreCase(WIDTH) && !string.equalsIgnoreCase(HEIGHT) && !string.equalsIgnoreCase(BARTYPE) && !string.equalsIgnoreCase(FILETYPE) && !string.startsWith("image");
    }
}

