/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode.jr;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;

public class J4LBarcodeRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 1L;
    transient Image image;
    byte[] imageBytes;
    int iWidth = 0;
    int iHeight = 0;

    public J4LBarcodeRenderer() {
        this.image = null;
        this.imageBytes = null;
    }

    public J4LBarcodeRenderer(Image im) {
        this.image = im;
        this.imageBytes = null;
        this.iWidth = this.image.getWidth(null);
        this.iHeight = this.image.getHeight(null);
    }

    public J4LBarcodeRenderer(Image im, boolean serialize) {
        this.iWidth = im.getWidth(null);
        this.iHeight = im.getHeight(null);
        if (serialize) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
            try {
                encoder.encode((BufferedImage)im);
                this.imageBytes = os.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.image = im;
        } else {
            this.imageBytes = null;
        }
    }

    public Dimension2D getDimension() {
        return new Dimension(this.iWidth, this.iHeight);
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        if (this.imageBytes != null) {
            this.image = Toolkit.getDefaultToolkit().createImage(this.imageBytes);
            grx.drawImage(this.image, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
        } else {
            grx.drawImage(this.image, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
        }
    }
}

