/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.ShorthandResolverFactory;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.AbstractBorderShorthandResolver;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderShorthandResolver
extends AbstractBorderShorthandResolver {
    @Override
    protected String getPrefix() {
        return "border";
    }

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        List<CssDeclaration> preResolvedProps = super.resolveShorthand(shorthandExpression);
        ArrayList<CssDeclaration> resolvedProps = new ArrayList<CssDeclaration>();
        for (CssDeclaration prop : preResolvedProps) {
            IShorthandResolver shorthandResolver = ShorthandResolverFactory.getShorthandResolver(prop.getProperty());
            if (shorthandResolver != null) {
                resolvedProps.addAll(shorthandResolver.resolveShorthand(prop.getExpression()));
                continue;
            }
            Logger logger = LoggerFactory.getLogger(BorderShorthandResolver.class);
            logger.error(MessageFormatUtil.format((String)"Cannot find a shorthand resolver for the \"{0}\" property. Expected border-width, border-style or border-color properties.", (Object[])new Object[]{prop.getProperty()}));
        }
        return resolvedProps;
    }
}

