/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import java.io.InputStream;

public class PdfOutputIntent
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -3814334679568337730L;

    public PdfOutputIntent(String outputConditionIdentifier, String outputCondition, String registryName, String info, InputStream iccStream) {
        super(new PdfDictionary());
        this.setOutputIntentSubtype(PdfName.GTS_PDFA1);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.OutputIntent);
        if (outputCondition != null) {
            this.setOutputCondition(outputCondition);
        }
        if (outputConditionIdentifier != null) {
            this.setOutputConditionIdentifier(outputConditionIdentifier);
        }
        if (registryName != null) {
            this.setRegistryName(registryName);
        }
        if (info != null) {
            this.setInfo(info);
        }
        if (iccStream != null) {
            this.setDestOutputProfile(iccStream);
        }
    }

    public PdfOutputIntent(PdfDictionary outputIntentDict) {
        super(outputIntentDict);
    }

    public PdfStream getDestOutputProfile() {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.DestOutputProfile);
    }

    public void setDestOutputProfile(InputStream iccStream) {
        PdfStream stream = PdfCieBasedCs.IccBased.getIccProfileStream(iccStream);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.DestOutputProfile, stream);
    }

    public PdfString getInfo() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Info);
    }

    public void setInfo(String info) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Info, new PdfString(info));
    }

    public PdfString getRegistryName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.RegistryName);
    }

    public void setRegistryName(String registryName) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.RegistryName, new PdfString(registryName));
    }

    public PdfString getOutputConditionIdentifier() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.OutputConditionIdentifier);
    }

    public void setOutputConditionIdentifier(String outputConditionIdentifier) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OutputConditionIdentifier, new PdfString(outputConditionIdentifier));
    }

    public PdfString getOutputCondition() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.OutputCondition);
    }

    public void setOutputCondition(String outputCondition) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OutputCondition, new PdfString(outputCondition));
    }

    public PdfName getOutputIntentSubtype() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
    }

    public void setOutputIntentSubtype(PdfName subtype) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, subtype);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

