/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.SvgTagSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.SvgTextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    private static final float DEFAULT_MARKER_WIDTH = 2.25f;
    private static final float DEFAULT_MARKER_HEIGHT = 2.25f;
    private static final float DEFAULT_REF_X = 0.0f;
    private static final float DEFAULT_REF_Y = 0.0f;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        MarkerSvgNodeRenderer copy = new MarkerSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    @Override
    void preDraw(SvgDrawContext context) {
        super.preDraw(context);
        float[] markerWidthHeight = this.getMarkerWidthHeightValues();
        float markerWidth = markerWidthHeight[0];
        float markerHeight = markerWidthHeight[1];
        Rectangle markerViewport = new Rectangle(CssUtils.parseAbsoluteLength((String)this.getAttribute("x")), CssUtils.parseAbsoluteLength((String)this.getAttribute("y")), markerWidth, markerHeight);
        context.addViewPort(markerViewport);
    }

    void applyMarkerAttributes(SvgDrawContext context) {
        this.applyRotation(context);
        this.applyUserSpaceScaling(context);
        this.applyCoordinatesTranslation(context);
    }

    static void drawMarker(SvgDrawContext context, String moveX, String moveY, MarkerVertexType markerToUse, AbstractSvgNodeRenderer parent) {
        ISvgNodeRenderer namedObject;
        String elementToReUse = parent.attributesAndStyles.get(markerToUse.toString());
        String normalizedName = SvgTextUtil.filterReferenceValue(elementToReUse);
        ISvgNodeRenderer template = context.getNamedObject(normalizedName);
        ISvgNodeRenderer iSvgNodeRenderer = namedObject = template == null ? null : template.createDeepCopy();
        if (namedObject instanceof MarkerSvgNodeRenderer && MarkerSvgNodeRenderer.markerWidthHeightAreCorrect((MarkerSvgNodeRenderer)namedObject)) {
            namedObject.setParent(parent);
            namedObject.setAttribute("marker", markerToUse.toString());
            namedObject.setAttribute("x", moveX);
            namedObject.setAttribute("y", moveY);
            namedObject.draw(context);
            namedObject.setParent(null);
        }
    }

    @Override
    protected void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            float[] markerWidthHeight = this.getMarkerWidthHeightValues();
            float markerWidth = markerWidthHeight[0];
            float markerHeight = markerWidthHeight[1];
            float[] values = this.getViewBoxValues(markerWidth, markerHeight);
            Rectangle currentViewPort = context.getCurrentViewPort();
            super.calculateAndApplyViewBox(context, values, currentViewPort);
        }
    }

    private float[] getMarkerWidthHeightValues() {
        float markerWidth = 2.25f;
        if (this.attributesAndStyles.containsKey("markerwidth")) {
            String markerWidthRawValue = (String)this.attributesAndStyles.get("markerwidth");
            markerWidth = CssUtils.parseAbsoluteLength((String)markerWidthRawValue);
        }
        float markerHeight = 2.25f;
        if (this.attributesAndStyles.containsKey("markerheight")) {
            String markerHeightRawValue = (String)this.attributesAndStyles.get("markerheight");
            markerHeight = CssUtils.parseAbsoluteLength((String)markerHeightRawValue);
        }
        return new float[]{markerWidth, markerHeight};
    }

    private static boolean markerWidthHeightAreCorrect(MarkerSvgNodeRenderer namedObject) {
        Logger log = LoggerFactory.getLogger(MarkerSvgNodeRenderer.class);
        String markerWidth = namedObject.getAttribute("markerwidth");
        String markerHeight = namedObject.getAttribute("markerheight");
        boolean isCorrect = true;
        if (markerWidth != null) {
            float absoluteMarkerWidthValue = CssUtils.parseAbsoluteLength((String)markerWidth);
            if (absoluteMarkerWidthValue == 0.0f) {
                log.warn("markerWidth has zero value. Marker will not be rendered.");
                isCorrect = false;
            } else if (absoluteMarkerWidthValue < 0.0f) {
                log.warn("markerWidth has negative value. Marker will not be rendered.");
                isCorrect = false;
            }
        }
        if (markerHeight != null) {
            float absoluteMarkerHeightValue = CssUtils.parseAbsoluteLength((String)markerHeight);
            if (absoluteMarkerHeightValue == 0.0f) {
                log.warn("markerHeight has zero value. Marker will not be rendered.");
                isCorrect = false;
            } else if (absoluteMarkerHeightValue < 0.0f) {
                log.warn("markerHeight has negative value. Marker will not be rendered.");
                isCorrect = false;
            }
        }
        return isCorrect;
    }

    private ISvgNodeRenderer getSvgRootElement(ISvgNodeRenderer element) {
        if (element instanceof SvgTagSvgNodeRenderer && element.getParent() instanceof PdfRootSvgNodeRenderer) {
            return element;
        }
        if (element.getParent() != null) {
            return this.getSvgRootElement(element.getParent());
        }
        return null;
    }

    private float parseFontRelativeOrAbsoluteLengthOnMarker(String length) {
        float value = 0.0f;
        if (CssUtils.isMetricValue((String)length) || CssUtils.isNumericValue((String)length)) {
            value = CssUtils.parseAbsoluteLength((String)length);
        } else if (CssUtils.isFontRelativeValue((String)length)) {
            value = CssUtils.parseRelativeValue((String)length, (float)CssUtils.parseAbsoluteFontSize((String)"medium"));
            if (CssUtils.isRemValue((String)length)) {
                ISvgNodeRenderer rootElement = this.getSvgRootElement(this.getParent());
                if (rootElement != null && rootElement.getAttribute("font-size") != null) {
                    value = CssUtils.parseRelativeValue((String)length, (float)CssUtils.parseAbsoluteFontSize((String)rootElement.getAttribute("font-size")));
                }
            } else if (CssUtils.isEmValue((String)length)) {
                ISvgNodeRenderer parentElement = this.getParent();
                if (parentElement != null && parentElement.getAttribute("font-size") != null) {
                    value = CssUtils.parseRelativeValue((String)length, (float)CssUtils.parseAbsoluteFontSize((String)parentElement.getAttribute("font-size")));
                }
            } else if (CssUtils.isExValue((String)length) && this.getAttribute("font-size") != null) {
                value = CssUtils.parseRelativeValue((String)length, (float)CssUtils.parseAbsoluteFontSize((String)this.getAttribute("font-size")));
            }
        }
        return value;
    }

    private void applyRotation(SvgDrawContext context) {
        if (this.attributesAndStyles.containsKey("orient")) {
            String orient = (String)this.attributesAndStyles.get("orient");
            double rotAngle = Double.NaN;
            if ("auto".equals(orient) || "auto-start-reverse".equals(orient) && !"marker-start".equals(this.attributesAndStyles.get("marker"))) {
                rotAngle = ((IMarkerCapable)((Object)this.getParent())).getAutoOrientAngle(this, false);
            } else if ("auto-start-reverse".equals(orient) && "marker-start".equals(this.attributesAndStyles.get("marker"))) {
                rotAngle = ((IMarkerCapable)((Object)this.getParent())).getAutoOrientAngle(this, true);
            } else if (CssUtils.isAngleValue((String)orient) || CssUtils.isNumericValue((String)orient)) {
                rotAngle = CssUtils.parseAngle((String)((String)this.attributesAndStyles.get("orient")));
            }
            if (!Double.isNaN(rotAngle)) {
                context.getCurrentCanvas().concatMatrix(AffineTransform.getRotateInstance((double)rotAngle));
            }
        }
    }

    private void applyUserSpaceScaling(SvgDrawContext context) {
        String parentValue;
        if ((!this.attributesAndStyles.containsKey("markerunits") || "strokeWidth".equals(this.attributesAndStyles.get("markerunits"))) && (parentValue = this.getParent().getAttribute("stroke-width")) != null) {
            float strokeWidthScale;
            if (CssUtils.isPercentageValue((String)parentValue)) {
                double rootViewPortHeight = context.getRootViewPort().getHeight();
                double rootViewPortWidth = context.getRootViewPort().getWidth();
                double viewBoxDiagonalLength = Math.sqrt(rootViewPortHeight * rootViewPortHeight + rootViewPortWidth * rootViewPortWidth);
                strokeWidthScale = CssUtils.parseRelativeValue((String)parentValue, (float)((float)viewBoxDiagonalLength));
            } else {
                strokeWidthScale = SvgCssUtils.convertPtsToPx(this.parseFontRelativeOrAbsoluteLengthOnMarker(parentValue));
            }
            context.getCurrentCanvas().concatMatrix(AffineTransform.getScaleInstance((double)strokeWidthScale, (double)strokeWidthScale));
        }
    }

    private void applyCoordinatesTranslation(SvgDrawContext context) {
        AffineTransform translation;
        float xScale = 1.0f;
        float yScale = 1.0f;
        if (this.attributesAndStyles.containsKey("viewbox")) {
            String viewBoxValues = (String)this.attributesAndStyles.get("viewbox");
            List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
            float[] viewBox = this.getViewBoxValues();
            xScale = context.getCurrentViewPort().getWidth() / viewBox[2];
            yScale = context.getCurrentViewPort().getHeight() / viewBox[3];
        }
        float moveX = 0.0f;
        if (this.attributesAndStyles.containsKey("refx")) {
            String refX = (String)this.attributesAndStyles.get("refx");
            moveX = CssUtils.isPercentageValue((String)refX) ? CssUtils.parseRelativeValue((String)refX, (float)context.getRootViewPort().getWidth()) : this.parseFontRelativeOrAbsoluteLengthOnMarker(refX);
            moveX *= -1.0f * xScale;
        }
        float moveY = 0.0f;
        if (this.attributesAndStyles.containsKey("refy")) {
            String refY = (String)this.attributesAndStyles.get("refy");
            moveY = CssUtils.isPercentageValue((String)refY) ? CssUtils.parseRelativeValue((String)refY, (float)context.getRootViewPort().getHeight()) : this.parseFontRelativeOrAbsoluteLengthOnMarker(refY);
            moveY *= -1.0f * yScale;
        }
        if (!(translation = AffineTransform.getTranslateInstance((double)moveX, (double)moveY)).isIdentity()) {
            context.getCurrentCanvas().concatMatrix(translation);
        }
    }

    private float[] getViewBoxValues(float defaultWidth, float defaultHeight) {
        float[] values = this.attributesAndStyles.containsKey("viewbox") ? super.getViewBoxValues() : new float[]{0.0f, 0.0f, defaultWidth, defaultHeight};
        return values;
    }
}

