/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.config;

import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.typography.config.IFeaturesConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardScriptConfig
implements IFeaturesConfig {
    private Set<Character.UnicodeScript> scripts;
    private boolean ccmp;
    private boolean liga;
    private boolean dist;
    private boolean kern;
    private boolean mark = true;
    private boolean mkmk = true;
    private Set<String> preCustomFeatures = new LinkedHashSet<String>();
    private Set<String> postCustomFeatures = new LinkedHashSet<String>();
    public static final Set<Character.UnicodeScript> STANDARD_SCRIPTS = Collections.unmodifiableSet(new LinkedHashSet<Character.UnicodeScript>(Arrays.asList(Character.UnicodeScript.ARMENIAN, Character.UnicodeScript.CYRILLIC, Character.UnicodeScript.GEORGIAN, Character.UnicodeScript.GREEK, Character.UnicodeScript.LATIN, Character.UnicodeScript.RUNIC, Character.UnicodeScript.OGHAM)));

    public StandardScriptConfig(Set<Character.UnicodeScript> scripts) {
        this.scripts = Collections.unmodifiableSet(new HashSet<Character.UnicodeScript>(scripts));
        for (Character.UnicodeScript s : scripts) {
            if (STANDARD_SCRIPTS.contains(EnumUtil.throwIfNull((Enum)s))) continue;
            Logger logger = LoggerFactory.getLogger(StandardScriptConfig.class);
            logger.error("StandardScriptConfig class is designed for only standard scripts, otherwise it might be incompatible.");
        }
    }

    @Override
    public Set<Character.UnicodeScript> getScripts() {
        return this.scripts;
    }

    public StandardScriptConfig setLigaturesApplying(boolean enabled) {
        this.liga = enabled;
        return this;
    }

    public StandardScriptConfig setCharacterCompositionDecompositionSubstitution(boolean enabled) {
        this.ccmp = enabled;
        return this;
    }

    public StandardScriptConfig setKerningFeature(boolean enabled) {
        this.kern = enabled;
        return this;
    }

    public StandardScriptConfig setDistancesAdjustment(boolean enabled) {
        this.dist = enabled;
        return this;
    }

    public StandardScriptConfig setMarkToBasePositioning(boolean enabled) {
        this.mark = enabled;
        return this;
    }

    public StandardScriptConfig setMarkToMarkPositioning(boolean enabled) {
        this.mkmk = enabled;
        return this;
    }

    public StandardScriptConfig appendCustomFeature(String feature) {
        this.postCustomFeatures.add(feature);
        return this;
    }

    public StandardScriptConfig prependCustomFeature(String feature) {
        this.preCustomFeatures.add(feature);
        return this;
    }

    public StandardScriptConfig removeCustomFeature(String feature) {
        this.preCustomFeatures.remove(feature);
        this.postCustomFeatures.remove(feature);
        return this;
    }

    @Override
    public List<String> listFeatures() {
        int stdFeaturesNum = 7;
        ArrayList<String> features = new ArrayList<String>(this.preCustomFeatures.size() + stdFeaturesNum + this.postCustomFeatures.size());
        features.addAll(this.preCustomFeatures);
        if (this.ccmp) {
            features.add("ccmp");
        }
        if (this.liga) {
            features.add("liga");
        }
        if (this.dist) {
            features.add("dist");
        }
        if (this.kern) {
            features.add("kern");
        }
        if (this.mark) {
            features.add("mark");
        }
        if (this.mkmk) {
            features.add("mkmk");
        }
        features.addAll(this.postCustomFeatures);
        return Collections.unmodifiableList(features);
    }
}

