/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.bidi;

import com.itextpdf.licensekey.LicenseKey;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.typography.bidi.BidiPBAAlgorithm;
import java.util.Arrays;

public final class BidiAlgorithm {
    private final byte[] initialTypes;
    public static final byte implicitEmbeddingLevel = 2;
    private byte paragraphEmbeddingLevel = (byte)2;
    private int textLength;
    private byte[] resultTypes;
    private byte[] resultLevels;
    private int[] matchingPDI;
    private int[] matchingIsolateInitiator;
    private final byte[] pairTypes;
    private final int[] pairValues;
    public BidiPBAAlgorithm pba;
    public static final byte L = 0;
    public static final byte LRE = 1;
    public static final byte LRO = 2;
    public static final byte R = 3;
    public static final byte AL = 4;
    public static final byte RLE = 5;
    public static final byte RLO = 6;
    public static final byte PDF = 7;
    public static final byte EN = 8;
    public static final byte ES = 9;
    public static final byte ET = 10;
    public static final byte AN = 11;
    public static final byte CS = 12;
    public static final byte NSM = 13;
    public static final byte BN = 14;
    public static final byte B = 15;
    public static final byte S = 16;
    public static final byte WS = 17;
    public static final byte ON = 18;
    public static final byte LRI = 19;
    public static final byte RLI = 20;
    public static final byte FSI = 21;
    public static final byte PDI = 22;
    public static final byte TYPE_MIN = 0;
    public static final byte TYPE_MAX = 22;
    public static final String[] typenames = new String[]{"L", "LRE", "LRO", "R", "AL", "RLE", "RLO", "PDF", "EN", "ES", "ET", "AN", "CS", "NSM", "BN", "B", "S", "WS", "ON", "LRI", "RLI", "FSI", "PDI"};
    public static final int MAX_DEPTH = 125;

    public byte[] getResultTypes() {
        return (byte[])this.resultTypes.clone();
    }

    public BidiAlgorithm(byte[] types, byte[] pairTypes, int[] pairValues) {
        BidiAlgorithm.validateTypes(types);
        BidiAlgorithm.validatePbTypes(pairTypes);
        BidiAlgorithm.validatePbValues(pairValues, pairTypes);
        this.initialTypes = (byte[])types.clone();
        this.pairTypes = pairTypes;
        this.pairValues = pairValues;
        this.runAlgorithm();
    }

    public BidiAlgorithm(byte[] types, byte[] pairTypes, int[] pairValues, byte paragraphEmbeddingLevel) {
        LicenseKey.scheduledCheck((LicenseKeyProduct)new LicenseKeyProduct("pdfCalligraph", 2, 0, new LicenseKeyProductFeature[0]));
        BidiAlgorithm.validateTypes(types);
        BidiAlgorithm.validatePbTypes(pairTypes);
        BidiAlgorithm.validatePbValues(pairValues, pairTypes);
        BidiAlgorithm.validateParagraphEmbeddingLevel(paragraphEmbeddingLevel);
        this.initialTypes = (byte[])types.clone();
        this.paragraphEmbeddingLevel = paragraphEmbeddingLevel;
        this.pairTypes = pairTypes;
        this.pairValues = pairValues;
        this.runAlgorithm();
    }

    private void runAlgorithm() {
        this.textLength = this.initialTypes.length;
        this.resultTypes = (byte[])this.initialTypes.clone();
        this.determineMatchingIsolates();
        if (this.paragraphEmbeddingLevel == 2) {
            this.paragraphEmbeddingLevel = this.determineParagraphEmbeddingLevel(0, this.textLength);
        }
        this.resultLevels = new byte[this.textLength];
        this.setLevels(this.resultLevels, 0, this.textLength, this.paragraphEmbeddingLevel);
        this.determineExplicitEmbeddingLevels();
        IsolatingRunSequence[] sequences = this.determineIsolatingRunSequences();
        for (int i = 0; i < sequences.length; ++i) {
            IsolatingRunSequence sequence = sequences[i];
            sequence.resolveWeakTypes();
            sequence.resolvePairedBrackets();
            sequence.resolveNeutralTypes();
            sequence.resolveImplicitLevels();
            sequence.applyLevelsAndTypes();
        }
        this.assignLevelsToCharactersRemovedByX9();
    }

    private void determineMatchingIsolates() {
        int i;
        this.matchingPDI = new int[this.textLength];
        this.matchingIsolateInitiator = new int[this.textLength];
        for (i = 0; i < this.textLength; ++i) {
            this.matchingIsolateInitiator[i] = -1;
        }
        for (i = 0; i < this.textLength; ++i) {
            this.matchingPDI[i] = -1;
            byte t = this.resultTypes[i];
            if (t != 19 && t != 20 && t != 21) continue;
            int depthCounter = 1;
            for (int j = i + 1; j < this.textLength; ++j) {
                byte u = this.resultTypes[j];
                if (u == 19 || u == 20 || u == 21) {
                    ++depthCounter;
                    continue;
                }
                if (u != 22 || --depthCounter != 0) continue;
                this.matchingPDI[i] = j;
                this.matchingIsolateInitiator[j] = i;
                break;
            }
            if (this.matchingPDI[i] != -1) continue;
            this.matchingPDI[i] = this.textLength;
        }
    }

    private byte determineParagraphEmbeddingLevel(int startIndex, int endIndex) {
        int strongType = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            int t = this.resultTypes[i];
            if (t == 0 || t == 4 || t == 3) {
                strongType = t;
                break;
            }
            if (t != 21 && t != 19 && t != 20) continue;
            i = this.matchingPDI[i];
            assert (i <= endIndex);
        }
        if (strongType == -1) {
            return 0;
        }
        if (strongType == 0) {
            return 0;
        }
        return 1;
    }

    private void determineExplicitEmbeddingLevels() {
        directionalStatusStack stack = new directionalStatusStack();
        stack.empty();
        stack.push(this.paragraphEmbeddingLevel, (byte)18, false);
        int overflowIsolateCount = 0;
        int overflowEmbeddingCount = 0;
        int validIsolateCount = 0;
        block6: for (int i = 0; i < this.textLength; ++i) {
            byte t = this.resultTypes[i];
            switch (t) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 19: 
                case 20: 
                case 21: {
                    byte newLevel;
                    boolean isRTL;
                    boolean isIsolate = t == 20 || t == 19 || t == 21;
                    boolean bl = isRTL = t == 5 || t == 6 || t == 20;
                    if (t == 21) {
                        boolean bl2 = isRTL = this.determineParagraphEmbeddingLevel(i + 1, this.matchingPDI[i]) == 1;
                    }
                    if (isIsolate) {
                        this.resultLevels[i] = stack.lastEmbeddingLevel();
                    }
                    if ((newLevel = isRTL ? (byte)(stack.lastEmbeddingLevel() + 1 | 1) : (byte)(stack.lastEmbeddingLevel() + 2 & 0xFFFFFFFE)) <= 125 && overflowIsolateCount == 0 && overflowEmbeddingCount == 0) {
                        if (isIsolate) {
                            ++validIsolateCount;
                        }
                        stack.push(newLevel, (byte)(t == 2 ? 0 : (t == 6 ? 3 : 18)), isIsolate);
                        if (isIsolate) continue block6;
                        this.resultLevels[i] = newLevel;
                        continue block6;
                    }
                    if (isIsolate) {
                        ++overflowIsolateCount;
                        continue block6;
                    }
                    if (overflowIsolateCount != 0) continue block6;
                    ++overflowEmbeddingCount;
                    continue block6;
                }
                case 22: {
                    if (overflowIsolateCount > 0) {
                        --overflowIsolateCount;
                    } else if (validIsolateCount != 0) {
                        overflowEmbeddingCount = 0;
                        while (!stack.lastDirectionalIsolateStatus()) {
                            stack.pop();
                        }
                        stack.pop();
                        --validIsolateCount;
                    }
                    this.resultLevels[i] = stack.lastEmbeddingLevel();
                    continue block6;
                }
                case 7: {
                    this.resultLevels[i] = stack.lastEmbeddingLevel();
                    if (overflowIsolateCount > 0) continue block6;
                    if (overflowEmbeddingCount > 0) {
                        --overflowEmbeddingCount;
                        continue block6;
                    }
                    if (stack.lastDirectionalIsolateStatus() || stack.depth() < 2) continue block6;
                    stack.pop();
                    continue block6;
                }
                case 15: {
                    stack.empty();
                    overflowIsolateCount = 0;
                    overflowEmbeddingCount = 0;
                    validIsolateCount = 0;
                    this.resultLevels[i] = this.paragraphEmbeddingLevel;
                    continue block6;
                }
                default: {
                    this.resultLevels[i] = stack.lastEmbeddingLevel();
                    if (stack.lastDirectionalOverrideStatus() == 18) continue block6;
                    this.resultTypes[i] = stack.lastDirectionalOverrideStatus();
                }
            }
        }
    }

    private int[][] determineLevelRuns() {
        int[] temporaryRun = new int[this.textLength];
        int[][] allRuns = new int[this.textLength][];
        int numRuns = 0;
        byte currentLevel = -1;
        int runLength = 0;
        for (int i = 0; i < this.textLength; ++i) {
            if (BidiAlgorithm.isRemovedByX9(this.initialTypes[i])) continue;
            if (this.resultLevels[i] != currentLevel) {
                if (currentLevel != -1) {
                    int[] run = Arrays.copyOf(temporaryRun, runLength);
                    allRuns[numRuns] = run;
                    ++numRuns;
                }
                currentLevel = this.resultLevels[i];
                runLength = 0;
            }
            temporaryRun[runLength] = i;
            ++runLength;
        }
        if (runLength != 0) {
            int[] run = Arrays.copyOf(temporaryRun, runLength);
            allRuns[numRuns] = run;
            ++numRuns;
        }
        return (int[][])Arrays.copyOf(allRuns, numRuns);
    }

    private IsolatingRunSequence[] determineIsolatingRunSequences() {
        int[][] levelRuns = this.determineLevelRuns();
        int numRuns = levelRuns.length;
        int[] runForCharacter = new int[this.textLength];
        for (int runNumber = 0; runNumber < numRuns; ++runNumber) {
            for (int i = 0; i < levelRuns[runNumber].length; ++i) {
                int characterIndex = levelRuns[runNumber][i];
                runForCharacter[characterIndex] = runNumber;
            }
        }
        IsolatingRunSequence[] sequences = new IsolatingRunSequence[numRuns];
        int numSequences = 0;
        int[] currentRunSequence = new int[this.textLength];
        for (int i = 0; i < levelRuns.length; ++i) {
            int firstCharacter = levelRuns[i][0];
            if (this.initialTypes[firstCharacter] == 22 && this.matchingIsolateInitiator[firstCharacter] != -1) continue;
            int currentRunSequenceLength = 0;
            int run = i;
            while (true) {
                System.arraycopy(levelRuns[run], 0, currentRunSequence, currentRunSequenceLength, levelRuns[run].length);
                int lastCharacter = currentRunSequence[(currentRunSequenceLength += levelRuns[run].length) - 1];
                byte lastType = this.initialTypes[lastCharacter];
                if (lastType != 19 && lastType != 20 && lastType != 21 || this.matchingPDI[lastCharacter] == this.textLength) break;
                run = runForCharacter[this.matchingPDI[lastCharacter]];
            }
            sequences[numSequences] = new IsolatingRunSequence(Arrays.copyOf(currentRunSequence, currentRunSequenceLength));
            ++numSequences;
        }
        return Arrays.copyOf(sequences, numSequences);
    }

    private int assignLevelsToCharactersRemovedByX9() {
        int i;
        for (i = 0; i < this.initialTypes.length; ++i) {
            byte t = this.initialTypes[i];
            if (t != 1 && t != 5 && t != 2 && t != 6 && t != 7 && t != 14) continue;
            this.resultTypes[i] = t;
            this.resultLevels[i] = -1;
        }
        if (this.resultLevels[0] == -1) {
            this.resultLevels[0] = this.paragraphEmbeddingLevel;
        }
        for (i = 1; i < this.initialTypes.length; ++i) {
            if (this.resultLevels[i] != -1) continue;
            this.resultLevels[i] = this.resultLevels[i - 1];
        }
        return this.initialTypes.length;
    }

    public byte[] getLevels(int[] linebreaks) {
        BidiAlgorithm.validateLineBreaks(linebreaks, this.textLength);
        byte[] result = (byte[])this.resultLevels.clone();
        for (int i = 0; i < result.length; ++i) {
            byte t = this.initialTypes[i];
            if (t != 15 && t != 16) continue;
            result[i] = this.paragraphEmbeddingLevel;
            for (int j = i - 1; j >= 0 && BidiAlgorithm.isWhitespace(this.initialTypes[j]); --j) {
                result[j] = this.paragraphEmbeddingLevel;
            }
        }
        int start = 0;
        for (int i = 0; i < linebreaks.length; ++i) {
            int limit = linebreaks[i];
            for (int j = limit - 1; j >= start && BidiAlgorithm.isWhitespace(this.initialTypes[j]); --j) {
                result[j] = this.paragraphEmbeddingLevel;
            }
            start = limit;
        }
        return result;
    }

    public int[] getReordering(int[] linebreaks) {
        BidiAlgorithm.validateLineBreaks(linebreaks, this.textLength);
        byte[] levels = this.getLevels(linebreaks);
        return BidiAlgorithm.computeMultilineReordering(levels, linebreaks);
    }

    private static int[] computeMultilineReordering(byte[] levels, int[] linebreaks) {
        int[] result = new int[levels.length];
        int start = 0;
        for (int i = 0; i < linebreaks.length; ++i) {
            int limit = linebreaks[i];
            byte[] templevels = new byte[limit - start];
            System.arraycopy(levels, start, templevels, 0, templevels.length);
            int[] temporder = BidiAlgorithm.computeReordering(templevels);
            for (int j = 0; j < temporder.length; ++j) {
                result[start + j] = temporder[j] + start;
            }
            start = limit;
        }
        return result;
    }

    public static int[] computeReordering(byte[] levels) {
        int lineLength = levels.length;
        int[] result = new int[lineLength];
        for (int i = 0; i < lineLength; ++i) {
            result[i] = i;
        }
        int highestLevel = 0;
        int lowestOddLevel = 127;
        for (int i = 0; i < lineLength; ++i) {
            int level = levels[i];
            if (level > highestLevel) {
                highestLevel = level;
            }
            if ((level & 1) == 0 || level >= lowestOddLevel) continue;
            lowestOddLevel = level;
        }
        for (int level = highestLevel; level >= lowestOddLevel; --level) {
            for (int i = 0; i < lineLength; ++i) {
                int limit;
                if (levels[i] < level) continue;
                int start = i;
                for (limit = i + 1; limit < lineLength && levels[limit] >= level; ++limit) {
                }
                int j = start;
                for (int k = limit - 1; j < k; ++j, --k) {
                    int temp = result[j];
                    result[j] = result[k];
                    result[k] = temp;
                }
                i = limit;
            }
        }
        return result;
    }

    public static int[] inverseReordering(int[] reordering) {
        int[] result = new int[reordering.length];
        for (int j = 0; j < reordering.length; ++j) {
            result[reordering[j]] = j;
        }
        return result;
    }

    public byte getBaseLevel() {
        return this.paragraphEmbeddingLevel;
    }

    private static boolean isWhitespace(byte biditype) {
        switch (biditype) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRemovedByX9(byte biditype) {
        switch (biditype) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private static byte typeForLevel(int level) {
        return (level & 1) == 0 ? (byte)0 : 3;
    }

    private void setLevels(byte[] levels, int start, int limit, byte newLevel) {
        for (int i = start; i < limit; ++i) {
            levels[i] = newLevel;
        }
    }

    private static void validateTypes(byte[] types) {
        int i;
        if (types == null) {
            throw new IllegalArgumentException("types is null");
        }
        for (i = 0; i < types.length; ++i) {
            if (types[i] >= 0 && types[i] <= 22) continue;
            throw new IllegalArgumentException("illegal type value at " + i + ": " + types[i]);
        }
        for (i = 0; i < types.length - 1; ++i) {
            if (types[i] != 15) continue;
            throw new IllegalArgumentException("B type before end of paragraph at index: " + i);
        }
    }

    private static void validateParagraphEmbeddingLevel(byte paragraphEmbeddingLevel) {
        if (paragraphEmbeddingLevel != 2 && paragraphEmbeddingLevel != 0 && paragraphEmbeddingLevel != 1) {
            throw new IllegalArgumentException("illegal paragraph embedding level: " + paragraphEmbeddingLevel);
        }
    }

    private static void validateLineBreaks(int[] linebreaks, int textLength) {
        int prev = 0;
        for (int i = 0; i < linebreaks.length; ++i) {
            int next = linebreaks[i];
            if (next <= prev) {
                throw new IllegalArgumentException("bad linebreak: " + next + " at index: " + i);
            }
            prev = next;
        }
        if (prev != textLength) {
            throw new IllegalArgumentException("last linebreak must be at " + textLength);
        }
    }

    private static void validatePbTypes(byte[] pairTypes) {
        if (pairTypes == null) {
            throw new IllegalArgumentException("pairTypes is null");
        }
        for (int i = 0; i < pairTypes.length; ++i) {
            if (pairTypes[i] >= 0 && pairTypes[i] <= 2) continue;
            throw new IllegalArgumentException("illegal pairType value at " + i + ": " + pairTypes[i]);
        }
    }

    private static void validatePbValues(int[] pairValues, byte[] pairTypes) {
        if (pairValues == null) {
            throw new IllegalArgumentException("pairValues is null");
        }
        if (pairTypes.length != pairValues.length) {
            throw new IllegalArgumentException("pairTypes is different length from pairValues");
        }
    }

    public static final BidiAlgorithm analyzeInput(byte[] types, byte[] pairTypes, int[] pairValues, byte paragraphEmbeddingLevel) {
        BidiAlgorithm bidi = new BidiAlgorithm(types, pairTypes, pairValues, paragraphEmbeddingLevel);
        return bidi;
    }

    private class IsolatingRunSequence {
        private final int[] indexes;
        private final byte[] types;
        private byte[] resolvedLevels;
        private final int length;
        private final byte level;
        private final byte sos;
        private final byte eos;

        public IsolatingRunSequence(int[] inputIndexes) {
            byte succLevel;
            int prevChar;
            this.indexes = inputIndexes;
            this.length = this.indexes.length;
            this.types = new byte[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.types[i] = BidiAlgorithm.this.resultTypes[this.indexes[i]];
            }
            this.level = BidiAlgorithm.this.resultLevels[this.indexes[0]];
            for (prevChar = this.indexes[0] - 1; prevChar >= 0 && BidiAlgorithm.isRemovedByX9(BidiAlgorithm.this.initialTypes[prevChar]); --prevChar) {
            }
            byte prevLevel = prevChar >= 0 ? BidiAlgorithm.this.resultLevels[prevChar] : BidiAlgorithm.this.paragraphEmbeddingLevel;
            this.sos = BidiAlgorithm.typeForLevel(Math.max(prevLevel, this.level));
            byte lastType = this.types[this.length - 1];
            if (lastType == 19 || lastType == 20 || lastType == 21) {
                succLevel = BidiAlgorithm.this.paragraphEmbeddingLevel;
            } else {
                int limit;
                for (limit = this.indexes[this.length - 1] + 1; limit < BidiAlgorithm.this.textLength && BidiAlgorithm.isRemovedByX9(BidiAlgorithm.this.initialTypes[limit]); ++limit) {
                }
                succLevel = limit < BidiAlgorithm.this.textLength ? BidiAlgorithm.this.resultLevels[limit] : BidiAlgorithm.this.paragraphEmbeddingLevel;
            }
            this.eos = BidiAlgorithm.typeForLevel(Math.max(succLevel, this.level));
        }

        public void resolvePairedBrackets() {
            BidiAlgorithm.this.pba = new BidiPBAAlgorithm();
            BidiAlgorithm.this.pba.resolvePairedBrackets(this.indexes, this.types, BidiAlgorithm.this.pairTypes, BidiAlgorithm.this.pairValues, this.sos, this.level);
        }

        public void resolveWeakTypes() {
            byte t;
            int t2;
            int i;
            this.assertOnly(new byte[]{0, 3, 4, 8, 9, 10, 11, 12, 15, 16, 17, 18, 13, 19, 20, 21, 22});
            int preceedingCharacterType = this.sos;
            for (i = 0; i < this.length; ++i) {
                t2 = this.types[i];
                if (t2 == 13) {
                    this.types[i] = preceedingCharacterType;
                    continue;
                }
                if (t2 == 19 || t2 == 20 || t2 == 21 || t2 == 22) {
                    preceedingCharacterType = 18;
                }
                preceedingCharacterType = t2;
            }
            block1: for (i = 0; i < this.length; ++i) {
                if (this.types[i] != 8) continue;
                for (int j = i - 1; j >= 0; --j) {
                    byte t3 = this.types[j];
                    if (t3 != 0 && t3 != 3 && t3 != 4) continue;
                    if (t3 != 4) continue block1;
                    this.types[i] = 11;
                    continue block1;
                }
            }
            for (i = 0; i < this.length; ++i) {
                if (this.types[i] != 4) continue;
                this.types[i] = 3;
            }
            for (i = 1; i < this.length - 1; ++i) {
                if (this.types[i] != 9 && this.types[i] != 12) continue;
                byte prevSepType = this.types[i - 1];
                byte succSepType = this.types[i + 1];
                if (prevSepType == 8 && succSepType == 8) {
                    this.types[i] = 8;
                    continue;
                }
                if (this.types[i] != 12 || prevSepType != 11 || succSepType != 11) continue;
                this.types[i] = 11;
            }
            for (i = 0; i < this.length; ++i) {
                if (this.types[i] != 10) continue;
                int runstart = i;
                int runlimit = this.findRunLimit(runstart, this.length, new byte[]{10});
                byte by = t = runstart == 0 ? this.sos : this.types[runstart - 1];
                if (t != 8) {
                    byte by2 = t = runlimit == this.length ? this.eos : this.types[runlimit];
                }
                if (t == 8) {
                    this.setTypes(runstart, runlimit, (byte)8);
                }
                i = runlimit;
            }
            for (i = 0; i < this.length; ++i) {
                t2 = this.types[i];
                if (t2 != 9 && t2 != 10 && t2 != 12) continue;
                this.types[i] = 18;
            }
            for (i = 0; i < this.length; ++i) {
                if (this.types[i] != 8) continue;
                byte prevStrongType = this.sos;
                for (int j = i - 1; j >= 0; --j) {
                    t = this.types[j];
                    if (t != 0 && t != 3) continue;
                    prevStrongType = t;
                    break;
                }
                if (prevStrongType != 0) continue;
                this.types[i] = 0;
            }
        }

        public void resolveNeutralTypes() {
            this.assertOnly(new byte[]{0, 3, 8, 11, 15, 16, 17, 18, 20, 19, 21, 22});
            for (int i = 0; i < this.length; ++i) {
                byte trailingType;
                byte leadingType;
                byte t = this.types[i];
                if (t != 17 && t != 18 && t != 15 && t != 16 && t != 20 && t != 19 && t != 21 && t != 22) continue;
                int runstart = i;
                int runlimit = this.findRunLimit(runstart, this.length, new byte[]{15, 16, 17, 18, 20, 19, 21, 22});
                if (runstart == 0) {
                    leadingType = this.sos;
                } else {
                    leadingType = this.types[runstart - 1];
                    if (leadingType == 11 || leadingType == 8) {
                        leadingType = 3;
                    }
                }
                if (runlimit == this.length) {
                    trailingType = this.eos;
                } else {
                    trailingType = this.types[runlimit];
                    if (trailingType == 11 || trailingType == 8) {
                        trailingType = 3;
                    }
                }
                byte resolvedType = leadingType == trailingType ? leadingType : (byte)BidiAlgorithm.typeForLevel(this.level);
                this.setTypes(runstart, runlimit, resolvedType);
                i = runlimit;
            }
        }

        public void resolveImplicitLevels() {
            this.assertOnly(new byte[]{0, 3, 8, 11});
            this.resolvedLevels = new byte[this.length];
            BidiAlgorithm.this.setLevels(this.resolvedLevels, 0, this.length, this.level);
            if ((this.level & 1) == 0) {
                for (int i = 0; i < this.length; ++i) {
                    byte t = this.types[i];
                    if (t == 0) continue;
                    if (t == 3) {
                        int n = i;
                        this.resolvedLevels[n] = (byte)(this.resolvedLevels[n] + 1);
                        continue;
                    }
                    int n = i;
                    this.resolvedLevels[n] = (byte)(this.resolvedLevels[n] + 2);
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    byte t = this.types[i];
                    if (t == 3) continue;
                    int n = i;
                    this.resolvedLevels[n] = (byte)(this.resolvedLevels[n] + 1);
                }
            }
        }

        public void applyLevelsAndTypes() {
            for (int i = 0; i < this.length; ++i) {
                int originalIndex = this.indexes[i];
                ((BidiAlgorithm)BidiAlgorithm.this).resultTypes[originalIndex] = this.types[i];
                ((BidiAlgorithm)BidiAlgorithm.this).resultLevels[originalIndex] = this.resolvedLevels[i];
            }
        }

        private int findRunLimit(int index, int limit, byte[] validSet) {
            block0: while (index < limit) {
                byte t = this.types[index];
                for (int i = 0; i < validSet.length; ++i) {
                    if (t != validSet[i]) continue;
                    ++index;
                    continue block0;
                }
                return index;
            }
            return limit;
        }

        private void setTypes(int start, int limit, byte newType) {
            for (int i = start; i < limit; ++i) {
                this.types[i] = newType;
            }
        }

        private void assertOnly(byte[] codes) {
            block0: for (int i = 0; i < this.length; ++i) {
                byte t = this.types[i];
                for (int j = 0; j < codes.length; ++j) {
                    if (t == codes[j]) continue block0;
                }
                throw new Error("invalid bidi code " + typenames[t] + " present in assertOnly at position " + this.indexes[i]);
            }
        }
    }

    private class directionalStatusStack {
        private int stackCounter = 0;
        private final byte[] embeddingLevelStack = new byte[126];
        private final byte[] overrideStatusStack = new byte[126];
        private final boolean[] isolateStatusStack = new boolean[126];

        private directionalStatusStack() {
        }

        public void empty() {
            this.stackCounter = 0;
        }

        public void push(byte level, byte overrideStatus, boolean isolateStatus) {
            this.embeddingLevelStack[this.stackCounter] = level;
            this.overrideStatusStack[this.stackCounter] = overrideStatus;
            this.isolateStatusStack[this.stackCounter] = isolateStatus;
            ++this.stackCounter;
        }

        public void pop() {
            --this.stackCounter;
        }

        public int depth() {
            return this.stackCounter;
        }

        public byte lastEmbeddingLevel() {
            return this.embeddingLevelStack[this.stackCounter - 1];
        }

        public byte lastDirectionalOverrideStatus() {
            return this.overrideStatusStack[this.stackCounter - 1];
        }

        public boolean lastDirectionalIsolateStatus() {
            return this.isolateStatusStack[this.stackCounter - 1];
        }
    }
}

