/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml.birt;

import com.ibm.icu.util.ULocale;
import com.ssaglobal.bml.birt.BMLString;
import com.ssaglobal.bml.birt.ReportField;
import com.ssaglobal.bml.birt.ReportLayout;
import com.ssaglobal.bml.birt.ReportLine;
import com.ssaglobal.bml.birt.ReportModel;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.xml.sax.SAXException;

public class ReportDesign {
    static IDesignEngine cEngine = null;
    ReportDesignHandle mReportDesignHandle = null;
    ElementFactory mElementFactory = null;
    SortedSet<Integer> mAllFieldPositions = null;
    ReportModel mReportModel = null;
    double mCharWidth;
    String mStandardUnits;

    public ReportDesign() throws BirtException {
        this.init();
    }

    private synchronized void init() throws BirtException {
        if (cEngine == null) {
            DesignConfig designConfig = new DesignConfig();
            String string = System.getenv("BIRT_HOME");
            if (string != null) {
                string = string.replace("\\", "/");
                designConfig.setBIRTHome(string);
            }
            Platform.startup((PlatformConfig)designConfig);
            IDesignEngineFactory iDesignEngineFactory = (IDesignEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory");
            cEngine = iDesignEngineFactory.createDesignEngine(designConfig);
        }
    }

    private double getcpi(String string) {
        int n = string == null ? 0 : string.length();
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' || c == '0' || c >= '1' && c <= '9') {
                string2 = string2 + c;
                continue;
            }
            if (c != ',') continue;
            string2 = string2 + '.';
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 17.1;
        }
    }

    public void buildDesign(String string, String string2, ReportModel reportModel) throws BirtException, ParserConfigurationException, SAXException, IOException {
        this.mReportModel = reportModel;
        ULocale uLocale = ULocale.getDefault();
        SessionHandle sessionHandle = cEngine.newSessionHandle(uLocale);
        this.mReportDesignHandle = sessionHandle.openDesign(string);
        String string3 = System.getProperty("user.name");
        this.mReportDesignHandle.setCreatedBy(string3);
        String string4 = this.mReportModel.getName();
        this.mReportDesignHandle.setDescription(string4);
        this.mReportDesignHandle.setDisplayName(string4);
        this.mReportDesignHandle.setProperty("title", (Object)string4);
        this.mElementFactory = this.mReportDesignHandle.getElementFactory();
        OdaDataSourceHandle odaDataSourceHandle = this.mElementFactory.newOdaDataSource("Data_Source", "org.eclipse.datatools.connectivity.oda.flatfile");
        odaDataSourceHandle.setProperty("HOME", (Object)".");
        odaDataSourceHandle.setProperty("DELIMTYPE", (Object)"COMMA");
        odaDataSourceHandle.setProperty("CHARSET", (Object)"UTF-8");
        odaDataSourceHandle.setProperty("INCLCOLUMNNAME", (Object)"YES");
        odaDataSourceHandle.setProperty("INCLTYPELINE", (Object)"NO");
        String string5 = "var ds = params[\"DS\"];var f = new java.io.File(ds);var fn = \"\" + f.getParent();this.setExtensionProperty(\"HOME\", fn);";
        odaDataSourceHandle.setBeforeOpen(string5);
        String string6 = System.getenv("DELETE_DATA_FILE");
        if (!"NO".equals(string6)) {
            string5 = "var cf = new Packages.com.infor.studio.reporting.StoreXMLInFile();var ds = params[\"DS\"];cf.DeleteFile(ds);";
            odaDataSourceHandle.setAfterClose(string5);
        }
        this.mReportDesignHandle.getDataSources().add((DesignElementHandle)odaDataSourceHandle);
        SimpleMasterPageHandle simpleMasterPageHandle = (SimpleMasterPageHandle)this.mReportDesignHandle.getMasterPages().get(0);
        simpleMasterPageHandle.setComments("Original font: " + this.mReportModel.getFont());
        this.mStandardUnits = simpleMasterPageHandle.getPageWidth().getUnits();
        int n = this.getPageWidth();
        double d = this.getcpi(this.mReportModel.getFont());
        double d2 = 1.0 / d;
        double d3 = (double)n * d2;
        double d4 = this.convertToStandardUnits(d3, "in");
        this.mCharWidth = d4 / (double)n;
        this.mCharWidth *= 0.95;
        double d5 = this.convertToStandardUnits(simpleMasterPageHandle.getLeftMargin().getAbsoluteValue()) + this.convertToStandardUnits(simpleMasterPageHandle.getRightMargin().getAbsoluteValue());
        double d6 = this.convertToStandardUnits(simpleMasterPageHandle.getPageWidth()) - d5;
        if (d4 > d6) {
            simpleMasterPageHandle.setOrientation("landscape");
        } else {
            simpleMasterPageHandle.setOrientation("portrait");
        }
        d6 = this.convertToStandardUnits(simpleMasterPageHandle.getPageWidth()) - d5;
        if (d6 < d4) {
            double d7 = this.convertToStandardUnits(simpleMasterPageHandle.getPageWidth());
            double d8 = this.convertToStandardUnits(simpleMasterPageHandle.getPageHeight());
            double d9 = d4 + d5;
            double d10 = d9 / d7;
            double d11 = d8 * d10;
            simpleMasterPageHandle.setPageType("custom");
            simpleMasterPageHandle.setProperty("width", (Object)(NumberFormat.getInstance().format(d9) + this.mStandardUnits));
            simpleMasterPageHandle.setProperty("height", (Object)(NumberFormat.getInstance().format(d11) + this.mStandardUnits));
        }
        this.createBanner();
        TableHandle tableHandle = this.createTable();
        this.setColumnWidth(tableHandle);
        SharedStyleHandle sharedStyleHandle = (SharedStyleHandle)this.mReportDesignHandle.getStyles().get(0);
        DimensionValue dimensionValue = sharedStyleHandle.getFontSize().getAbsoluteValue();
        dimensionValue = DimensionUtil.convertTo((double)dimensionValue.getMeasure(), (String)dimensionValue.getUnits(), (String)"pt");
        double d12 = dimensionValue.getMeasure();
        double d13 = d12 * 17.1 / d;
        int n2 = (int)((d13 *= 0.9) * 10.0);
        d13 = (double)n2 / 10.0;
        sharedStyleHandle.setProperty("fontSize", (Object)(NumberFormat.getInstance().format(d13) + "pt"));
        tableHandle.setStyle(sharedStyleHandle);
        OdaDataSetHandle odaDataSetHandle = this.createDataSet();
        string5 = "var ds = params[\"DS\"];var f = new java.io.File(ds);var fn = f.getName();this.queryText=\"select * from \" + fn;";
        odaDataSetHandle.setBeforeOpen(string5);
        tableHandle.setDataSet((DataSetHandle)odaDataSetHandle);
        this.createComputedColumns(tableHandle);
        this.createCells(tableHandle);
        this.mReportDesignHandle.saveAs(string2);
        this.mReportDesignHandle.close();
    }

    private void createBanner() throws BirtException {
        int n;
        TextItemHandle textItemHandle = (TextItemHandle)this.mReportDesignHandle.findElement("Title");
        String string = this.mReportModel.getName();
        textItemHandle.setContent(string);
        CellHandle cellHandle = (CellHandle)textItemHandle.getContainer();
        RowHandle rowHandle = (RowHandle)cellHandle.getContainer();
        int n2 = cellHandle.getIndex();
        int n3 = this.getPageWidth();
        int n4 = string.length();
        if (n4 > n3 / 5 && (n = rowHandle.getCells().getCount()) > 1 + n2) {
            CellHandle cellHandle2 = (CellHandle)rowHandle.getCells().get(1 + n2);
            cellHandle2.dropAndClear();
            cellHandle.setColumnSpan(2);
        }
    }

    private double convertToStandardUnits(double d, String string) {
        return DimensionUtil.convertTo((double)d, (String)string, (String)this.mStandardUnits).getMeasure();
    }

    private double convertToStandardUnits(DimensionValue dimensionValue) {
        return this.convertToStandardUnits(dimensionValue.getMeasure(), dimensionValue.getUnits());
    }

    private int getPageWidth() {
        SortedSet<Integer> sortedSet = this.getAllFieldPositions();
        return sortedSet.last() - 1;
    }

    private void setColumnWidth(TableHandle tableHandle) throws SemanticException {
        SortedSet<Integer> sortedSet = this.getAllFieldPositions();
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (iterator.hasNext()) {
            n = (Integer)iterator.next();
        }
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            int n4 = n2 - n;
            double d = this.mCharWidth * (double)n4;
            String string = NumberFormat.getInstance().format(d) + this.mStandardUnits;
            tableHandle.getColumns().get(n3++).setProperty("width", (Object)string);
            n = n2;
        }
    }

    private void createComputedColumns(TableHandle tableHandle) throws SemanticException {
        this.createComputedColumnForField(tableHandle, "pagebreak");
        this.createComputedColumnForField(tableHandle, "emptyline");
        for (ReportLayout reportLayout : this.mReportModel.layouts) {
            for (ReportLine reportLine : reportLayout.lines) {
                this.createComputedColumnForField(tableHandle, reportLine.id);
                for (ReportField reportField : reportLine.fields) {
                    if (!reportField.hasDataItem()) continue;
                    this.createComputedColumnForField(tableHandle, reportField.getName());
                }
            }
        }
    }

    private void createComputedColumnForField(TableHandle tableHandle, String string) throws SemanticException {
        ComputedColumn computedColumn = StructureFactory.createComputedColumn();
        String string2 = "dataSetRow[\"" + string + "\"]";
        computedColumn.setName(string);
        computedColumn.setExpression(string2);
        computedColumn.setDataType("string");
        tableHandle.getColumnBindings().addItem((IStructure)computedColumn);
    }

    private void createCells(TableHandle tableHandle) throws SemanticException {
        this.createCellsForPageBreak(tableHandle);
        this.createCellsForEmptyLine(tableHandle);
        for (ReportLayout reportLayout : this.mReportModel.layouts) {
            for (ReportLine reportLine : reportLayout.lines) {
                this.createRow(reportLine, tableHandle);
            }
        }
    }

    private void setPadding(ReportElementHandle reportElementHandle) throws SemanticException {
        reportElementHandle.setProperty("paddingTop", (Object)"0pt");
        reportElementHandle.setProperty("paddingBottom", (Object)"0pt");
        reportElementHandle.setProperty("paddingLeft", (Object)"0pt");
        reportElementHandle.setProperty("paddingRight", (Object)"0pt");
    }

    private void createCellsForPageBreak(TableHandle tableHandle) throws SemanticException {
        RowHandle rowHandle = this.mElementFactory.newTableRow(1);
        this.setPadding((ReportElementHandle)rowHandle);
        rowHandle.setProperty("pageBreakBefore", (Object)"avoid");
        rowHandle.setProperty("pageBreakAfter", (Object)"always");
        this.setVisibility((ReportElementHandle)rowHandle, "pagebreak");
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        cellHandle.setColumnSpan(tableHandle.getColumnCount());
        tableHandle.getDetail().add((DesignElementHandle)rowHandle);
    }

    private void createCellsForEmptyLine(TableHandle tableHandle) throws SemanticException {
        RowHandle rowHandle = this.mElementFactory.newTableRow(1);
        this.setPadding((ReportElementHandle)rowHandle);
        this.setVisibility((ReportElementHandle)rowHandle, "emptyline");
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        this.setPadding((ReportElementHandle)cellHandle);
        this.emptyCellForEmptyLine(cellHandle);
        cellHandle.setColumnSpan(tableHandle.getColumnCount());
        tableHandle.getDetail().add((DesignElementHandle)rowHandle);
    }

    private OdaDataSetHandle createDataSet() throws SemanticException {
        OdaDataSetHandle odaDataSetHandle = null;
        odaDataSetHandle = this.mElementFactory.newOdaDataSet("Data_Set", "org.eclipse.datatools.connectivity.oda.flatfile.dataSet");
        odaDataSetHandle.setDataSource("Data_Source");
        this.mReportDesignHandle.getDataSets().add((DesignElementHandle)odaDataSetHandle);
        return odaDataSetHandle;
    }

    public SortedSet<Integer> getAllFieldPositions() {
        if (this.mAllFieldPositions == null) {
            this.mAllFieldPositions = new TreeSet<Integer>();
            int n = 0;
            for (ReportField reportField : this.mReportModel.getAllFields()) {
                String string;
                int n2;
                int n3 = reportField.getStartPosition();
                int n4 = n3 + (n2 = reportField.getWidth());
                if (n4 > n) {
                    n = n4;
                }
                this.mAllFieldPositions.add(n3);
                if (!reportField.hasDataItem() || "left".equals(string = reportField.getAlignment())) continue;
                this.mAllFieldPositions.add(n4);
            }
            this.mAllFieldPositions.add(n);
        }
        return this.mAllFieldPositions;
    }

    private void setVisibility(ReportElementHandle reportElementHandle, String string) throws SemanticException {
        char c = '\"';
        String string2 = "row[" + c + string + c + "]!=" + c + string + c;
        HideRule hideRule = StructureFactory.createHideRule();
        hideRule.setFormat("all");
        hideRule.setExpression(string2);
        PropertyHandle propertyHandle = reportElementHandle.getPropertyHandle("visibility");
        propertyHandle.addItem((IStructure)hideRule);
    }

    private void createRow(ReportLine reportLine, TableHandle tableHandle) throws SemanticException {
        int n;
        int n2;
        RowHandle rowHandle = this.mElementFactory.newTableRow(tableHandle.getColumnCount());
        this.setPadding((ReportElementHandle)rowHandle);
        this.setVisibility((ReportElementHandle)rowHandle, reportLine.id);
        TreeMap<Integer, ReportField> treeMap = new TreeMap<Integer, ReportField>();
        for (ReportField object2 : reportLine.fields) {
            n2 = object2.getStartPosition();
            treeMap.put(n2, object2);
        }
        SortedSet<Integer> sortedSet = this.getAllFieldPositions();
        n2 = sortedSet.last();
        Iterator iterator = sortedSet.iterator();
        int n3 = 0;
        ReportField reportField = null;
        int n4 = n2;
        while (iterator.hasNext() && (n = ((Integer)iterator.next()).intValue()) != n2) {
            int n5;
            CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(n3);
            this.setPadding((ReportElementHandle)cellHandle);
            if (treeMap.containsKey(n)) {
                ReportField reportField2;
                reportField = (ReportField)treeMap.get(n);
                int n6 = this.defineCell(cellHandle, reportField, reportField2 = (ReportField)treeMap.get(n5 = n + reportField.getWidth()));
                n4 = n6 < 0 ? n2 : n + n6;
                ++n3;
                continue;
            }
            if (n < n4 && n3 > 0) {
                cellHandle.dropAndClear();
                cellHandle = (CellHandle)rowHandle.getCells().get(n3 - 1);
                n5 = cellHandle.getColumnSpan();
                cellHandle.setColumnSpan(++n5);
                continue;
            }
            if (reportLine.fields.isEmpty()) {
                this.emptyCell(cellHandle, n);
            }
            n4 = n2;
            ++n3;
        }
        tableHandle.getDetail().add((DesignElementHandle)rowHandle);
    }

    private void emptyCell(CellHandle cellHandle, int n) throws SemanticException {
        cellHandle.setProperty("fontSize", (Object)"25%");
        TextItemHandle textItemHandle = this.mElementFactory.newTextItem(this.name(n));
        textItemHandle.setContent(" ");
        this.setPadding((ReportElementHandle)textItemHandle);
        cellHandle.addElement((DesignElementHandle)textItemHandle, 0);
    }

    private void emptyCellForEmptyLine(CellHandle cellHandle) throws SemanticException {
        int n = 1;
        TextItemHandle textItemHandle = this.mElementFactory.newTextItem(this.name(n));
        textItemHandle.setContent(" ");
        this.setPadding((ReportElementHandle)textItemHandle);
        cellHandle.addElement((DesignElementHandle)textItemHandle, 0);
    }

    private int defineCell(CellHandle cellHandle, ReportField reportField, ReportField reportField2) throws SemanticException {
        int n = reportField.getStartPosition();
        int n2 = reportField.getWidth();
        if (reportField.hasDataItem()) {
            String string = reportField.getName();
            DataItemHandle dataItemHandle = this.mElementFactory.newDataItem(this.name(n));
            dataItemHandle.setResultSetColumn(string);
            this.setPadding((ReportElementHandle)dataItemHandle);
            cellHandle.addElement((DesignElementHandle)dataItemHandle, 0);
            if (reportField.isBold()) {
                cellHandle.setProperty("fontWeight", (Object)"bold");
            }
            if (reportField.isUnderlined()) {
                cellHandle.setProperty("textUnderline", (Object)"underline");
            }
            String string2 = reportField.getAlignment();
            cellHandle.setProperty("textAlign", (Object)string2);
            if ("left".equals(string2)) {
                n2 = -1;
            }
        } else if (reportField.hasText()) {
            BMLString.FORMAT fORMAT;
            String string = reportField.getText();
            BMLString bMLString = new BMLString(string);
            String string3 = null;
            if (bMLString.hasPlainText()) {
                string3 = bMLString.getPlainText();
                fORMAT = this.mElementFactory.newTextItem(this.name(n));
                fORMAT.setContent(string3);
                this.setPadding((ReportElementHandle)fORMAT);
                cellHandle.addElement((DesignElementHandle)fORMAT, 0);
            }
            if ((fORMAT = bMLString.getFormat()) == BMLString.FORMAT.HORIZONTAL) {
                BMLString bMLString2;
                BMLString.FORMAT fORMAT2;
                boolean bl = false;
                if (reportField2 != null && reportField2.hasText() && (fORMAT2 = (bMLString2 = new BMLString(reportField2.getText())).getFormat()) == BMLString.FORMAT.HORIZONTAL) {
                    bl = true;
                }
                if (!bl) {
                    --n2;
                }
                this.setTopBorder(cellHandle);
                if (string3 == null) {
                    this.emptyCell(cellHandle, n);
                }
            } else if (fORMAT == BMLString.FORMAT.VERTICAL_LEFT_AND_VERTICAL_RIGHT) {
                --n2;
                this.setLeftBorder(cellHandle);
                this.setRightBorder(cellHandle);
            } else if (fORMAT == BMLString.FORMAT.VERTICAL_LEFT) {
                this.setLeftBorder(cellHandle);
                n2 = -1;
            } else if (fORMAT == BMLString.FORMAT.VERTICAL_RIGHT) {
                --n2;
                this.setRightBorder(cellHandle);
            } else if (fORMAT == BMLString.FORMAT.CORNER_LEFT_TOP) {
                this.setLeftBorder(cellHandle);
                this.setTopBorder(cellHandle);
                if (string3 == null) {
                    this.emptyCell(cellHandle, n);
                }
            } else if (fORMAT == BMLString.FORMAT.CORNER_LEFT_BOTTOM) {
                this.setTopBorder(cellHandle);
                if (string3 == null) {
                    this.emptyCell(cellHandle, n);
                }
            } else if (fORMAT == BMLString.FORMAT.CORNER_RIGHT_TOP) {
                if (n2 > 1) {
                    --n2;
                    this.setRightBorder(cellHandle);
                    this.setTopBorder(cellHandle);
                    if (string3 == null) {
                        this.emptyCell(cellHandle, n);
                    }
                } else {
                    n2 = -1;
                    this.setLeftBorder(cellHandle);
                }
            } else if (fORMAT == BMLString.FORMAT.CORNER_RIGHT_BOTTOM) {
                if (n2 > 1) {
                    --n2;
                    this.setTopBorder(cellHandle);
                    if (string3 == null) {
                        this.emptyCell(cellHandle, n);
                    }
                } else {
                    n2 = -1;
                }
            } else if (fORMAT == BMLString.FORMAT.CORNER_LEFT_AND_RIGHT_TOP) {
                --n2;
                this.setLeftBorder(cellHandle);
                this.setRightBorder(cellHandle);
                this.setTopBorder(cellHandle);
                if (string3 == null) {
                    this.emptyCell(cellHandle, n);
                }
            } else if (fORMAT == BMLString.FORMAT.CORNER_LEFT_AND_RIGHT_BOTTOM) {
                --n2;
                this.setTopBorder(cellHandle);
                if (string3 == null) {
                    this.emptyCell(cellHandle, n);
                }
            } else if (fORMAT == BMLString.FORMAT.NONE) {
                n2 = -1;
            }
        }
        return n2;
    }

    private String name(int n) {
        return "COL_" + n + "_";
    }

    private void setTopBorder(CellHandle cellHandle) throws SemanticException {
        cellHandle.setProperty("borderTopColor", (Object)"#000000");
        cellHandle.setProperty("borderTopStyle", (Object)"solid");
        cellHandle.setProperty("borderTopWidth", (Object)"thin");
    }

    private void setBottomBorder(CellHandle cellHandle) throws SemanticException {
        cellHandle.setProperty("borderBottomColor", (Object)"#000000");
        cellHandle.setProperty("borderBottomStyle", (Object)"solid");
        cellHandle.setProperty("borderBottomWidth", (Object)"thin");
    }

    private void setLeftBorder(CellHandle cellHandle) throws SemanticException {
        cellHandle.setProperty("borderLeftColor", (Object)"#000000");
        cellHandle.setProperty("borderLeftStyle", (Object)"solid");
        cellHandle.setProperty("borderLeftWidth", (Object)"thin");
    }

    private void setRightBorder(CellHandle cellHandle) throws SemanticException {
        cellHandle.setProperty("borderRightColor", (Object)"#000000");
        cellHandle.setProperty("borderRightStyle", (Object)"solid");
        cellHandle.setProperty("borderRightWidth", (Object)"thin");
    }

    private TableHandle createTable() throws SemanticException {
        SortedSet<Integer> sortedSet = this.getAllFieldPositions();
        int n = sortedSet.size();
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TableHandle tableHandle = this.mElementFactory.newTableItem("tabledata", n2, n3, n4, n5);
        this.setPadding((ReportElementHandle)tableHandle);
        this.mReportDesignHandle.getBody().add((DesignElementHandle)tableHandle);
        return tableHandle;
    }
}

