/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml.birt;

public class BMLString {
    private static final int HORIZONTAL = 9472;
    private static final int VERTICAL = 9474;
    private static final int LEFT_TOP = 9484;
    private static final int RIGHT_TOP = 9488;
    private static final int LEFT_BOTTOM = 9492;
    private static final int RIGHT_BOTTOM = 9496;
    private String m_bmlString;
    private int m_first;
    private int m_last;

    protected BMLString() {
    }

    public BMLString(String string) {
        this.m_bmlString = string == null || string.length() == 0 ? " " : string;
        this.m_first = this.m_bmlString.charAt(0);
        this.m_last = this.m_bmlString.charAt(this.m_bmlString.length() - 1);
    }

    public boolean hasPlainText() {
        for (int i = 0; i < this.m_bmlString.length(); ++i) {
            if (this.isControl(this.m_bmlString.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public String getPlainText() {
        String string = this.m_bmlString;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!this.isControl(c)) continue;
            string = string.replace(c, ' ');
        }
        return string;
    }

    private boolean contains(int n) {
        for (int i = 0; i < this.m_bmlString.length(); ++i) {
            if (n != this.m_bmlString.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public FORMAT getFormat() {
        if (this.m_first == 9474) {
            if (this.m_last == 9474 && this.m_bmlString.length() > 1) {
                return FORMAT.VERTICAL_LEFT_AND_VERTICAL_RIGHT;
            }
            return FORMAT.VERTICAL_LEFT;
        }
        if (this.m_last == 9474) {
            return FORMAT.VERTICAL_RIGHT;
        }
        if (this.m_first == 9484) {
            if (this.m_last == 9488) {
                return FORMAT.CORNER_LEFT_AND_RIGHT_TOP;
            }
            return FORMAT.CORNER_LEFT_TOP;
        }
        if (this.m_first == 9492) {
            if (this.m_last == 9496) {
                return FORMAT.CORNER_LEFT_AND_RIGHT_BOTTOM;
            }
            return FORMAT.CORNER_LEFT_BOTTOM;
        }
        if (this.m_last == 9488) {
            return FORMAT.CORNER_RIGHT_TOP;
        }
        if (this.m_last == 9496) {
            return FORMAT.CORNER_RIGHT_BOTTOM;
        }
        if (this.contains(9472)) {
            return FORMAT.HORIZONTAL;
        }
        return FORMAT.NONE;
    }

    private boolean isControl(int n) {
        return n >= 9472 && n <= 9580;
    }

    public static enum FORMAT {
        NONE,
        HORIZONTAL,
        VERTICAL_LEFT,
        VERTICAL_RIGHT,
        CORNER_LEFT_TOP,
        CORNER_LEFT_BOTTOM,
        CORNER_RIGHT_TOP,
        CORNER_RIGHT_BOTTOM,
        CORNER_LEFT_AND_RIGHT_TOP,
        CORNER_LEFT_AND_RIGHT_BOTTOM,
        VERTICAL_LEFT_AND_VERTICAL_RIGHT;

    }
}

