/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.CellLayout;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TextCellLayout
extends CellLayout {
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 2;
    private int m_align;
    private String m_font;
    private boolean m_fixedText = false;
    private boolean m_addAnotherCellForTheMinusSign = false;
    private String m_difo;
    private int m_wait = 0;
    private int m_currentWait = 0;

    public TextCellLayout(int n, int n2, int n3, boolean bl) {
        super(n, n2);
        this.m_align = n3;
        this.m_addAnotherCellForTheMinusSign = bl;
    }

    public TextCellLayout(int n, String string, int n2, int n3) {
        super(n, n2);
        if (string.trim().equals("")) {
            string = "&nbsp;";
        }
        this.setText(string);
        this.m_fixedText = true;
        this.m_align = n3;
    }

    public TextCellLayout(int n, int n2, String string, boolean bl) {
        super(n, n2);
        this.m_align = BML2HTML.getAlign(string);
        this.m_addAnotherCellForTheMinusSign = bl;
    }

    public void setDifo(String string) {
        if (string != null && string.startsWith("%D(%")) {
            this.m_difo = string;
        }
    }

    public String formatAccordingToDifo(String string) {
        if (this.m_difo != null && this.m_difo.startsWith("%D")) {
            try {
                return this.convertDate(string, this.m_difo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String convertDate(String string, String string2) {
        if (string.length() > 6 && string2.length() > 4) {
            int n = Integer.parseInt(string.substring(0, 2));
            int n2 = Integer.parseInt(string.substring(3, 5));
            int n3 = Integer.parseInt(string.substring(6));
            Date date = new Date(n3 - 1900, n2 - 1, n);
            String string3 = string2.substring(3, string2.length() - 1);
            string3 = string3.replaceAll("(?i)%0*4y", "yyyy");
            string3 = string3.replaceAll("(?i)%0*2y", "yy");
            string3 = string3.replaceAll("(?i)%0*2d", "dd");
            string3 = string3.replaceAll("(?i)%d", "d");
            string3 = string3.replaceAll("(?i)%0*2m", "MM");
            string3 = string3.replaceAll("(?i)%m", "M");
            string3 = string3.replaceAll("(?i)%h", "MMM");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
            return simpleDateFormat.format(date);
        }
        return string;
    }

    public int getAlign() {
        return this.m_align;
    }

    public String getFont() {
        return this.m_font;
    }

    public void setFont(String string) {
        this.m_font = string;
    }

    public boolean addAnotherCellForTheMinusSign() {
        return this.m_addAnotherCellForTheMinusSign;
    }

    @Override
    public void setText(String string) {
        if (!this.m_fixedText) {
            super.setText(string);
        }
    }

    public void setWait(int n) {
        this.m_wait = n;
        if (this.m_wait == -1) {
            this.m_fixedText = true;
        }
    }

    public void setCurrentWait(int n) {
        this.m_currentWait = n;
    }

    public int getWait() {
        return this.m_wait;
    }

    public int getCurrentWait() {
        return this.m_currentWait;
    }

    @Override
    public boolean canOverlap() {
        return this.m_currentWait > 0;
    }

    @Override
    public String getText() {
        if (this.m_currentWait > 0) {
            return "";
        }
        return super.getText();
    }

    public boolean isFixedText() {
        return this.m_fixedText;
    }

    @Override
    public boolean hasE() {
        return !this.isFixedText();
    }
}

