/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import com.ssaglobal.bml.PDFTextWrap;
import com.ssaglobal.bml.Style;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Grid {
    private ArrayList<TextBlock> m_textBlocks = new ArrayList();
    private ArrayList<Line> m_lines = new ArrayList();
    private ArrayList<ImageBlock> m_images = new ArrayList();
    private float[] m_cellStartPosX = new float[1000];
    private float[] m_cellWidths = new float[1000];
    private int m_width;
    private int m_originalWidth;
    private float m_charWidth;
    private float m_charHeight;
    private float m_pageWidth;
    private float m_pageHeight;
    private float m_leftMargin;
    private float m_rightMargin;
    private Color m_lineColor;
    private boolean m_debug;
    private boolean m_bidi;
    private boolean m_monospaced;
    private boolean m_dynamicCols;
    private float m_startYPix = 0.0f;
    private float m_endYPix = 100000.0f;
    private boolean m_cellWidthsSet = false;
    private float m_originalFontSize = -1.0f;
    private float m_fontSize = -1.0f;
    private float m_fontSizeFactor;
    private float m_factor;
    private boolean m_justify;
    private float m_currentYPos = -1.0f;
    private Document m_document;
    public static final float MIN_LINE_THICKNESS = 0.3f;

    public Grid(Document document, float f, float f2, float f3, float f4, Color color, boolean bl, boolean bl2, boolean bl3, float f5, float f6) {
        this.m_document = document;
        this.m_width = -1;
        this.m_originalWidth = -1;
        this.m_charWidth = -1.0f;
        this.m_charHeight = -1.0f;
        this.m_pageWidth = f;
        this.m_pageHeight = f2;
        this.m_leftMargin = f3;
        this.m_rightMargin = f4;
        this.m_lineColor = color;
        this.m_bidi = bl;
        this.m_debug = bl3;
        this.m_dynamicCols = false;
        this.m_monospaced = bl2;
        this.m_fontSize = f5;
        this.m_originalFontSize = f5;
        this.m_fontSizeFactor = -1.0f;
        this.m_justify = false;
        this.m_currentYPos = f6;
    }

    public Grid(Document document, int n, float f, float f2, float f3, float f4, float f5, Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4, float[] fArray, float f6, float f7, float f8, boolean bl5) {
        this.m_document = document;
        this.m_width = n;
        this.m_originalWidth = n;
        this.m_charWidth = f;
        this.m_charHeight = f2;
        this.m_pageWidth = f3;
        this.m_leftMargin = f4;
        this.m_rightMargin = f5;
        this.m_lineColor = color;
        this.m_bidi = bl;
        this.m_debug = bl4;
        this.m_dynamicCols = bl2;
        this.m_monospaced = bl3;
        if (fArray != null) {
            this.m_cellWidths = (float[])fArray.clone();
            this.m_cellWidthsSet = true;
        }
        this.m_fontSize = f7 > 0.0f ? f7 : f6;
        this.m_originalFontSize = f6;
        this.m_fontSizeFactor = f8;
        this.m_justify = bl5;
    }

    public void addTextBlock(TextBlock textBlock) {
        this.m_textBlocks.add(textBlock);
    }

    public void addLine(Line line) {
        this.m_lines.add(line);
    }

    public void addImage(ImageBlock imageBlock) {
        this.m_images.add(imageBlock);
    }

    private void setCellWidth(int n, float f) {
        if (this.m_cellWidths[n] < f) {
            this.m_cellWidths[n] = f;
        }
    }

    private void calcCellDimension(Block block) {
        float f = 0.0f;
        for (int i = 0; i < block.getWidth(); ++i) {
            f += this.m_cellWidths[block.getX() + i];
        }
        float f2 = block.getPreferredWidth();
        if (f2 > f) {
            float f3 = 1.0f * f2 / (1.0f * (float)block.getWidth());
            float f4 = 0.0f;
            int n = 0;
            for (int i = 0; i < block.getWidth(); ++i) {
                if (this.m_cellWidths[block.getX() + i] >= f3) {
                    f4 += this.m_cellWidths[block.getX() + i];
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                float f5 = 1.0f * (f2 - f4) / (1.0f * (float)n);
                for (int i = 0; i < block.getWidth(); ++i) {
                    if (!(this.m_cellWidths[block.getX() + i] < f3)) continue;
                    this.setCellWidth(block.getX() + i, f5);
                }
            }
        }
    }

    private void calcCellDimensions(PdfCanvas pdfCanvas) {
        if (this.m_dynamicCols && this.m_textBlocks.size() > 0) {
            int n;
            Collections.sort(this.m_textBlocks);
            if (!this.m_cellWidthsSet) {
                for (n = 0; n <= this.m_width; ++n) {
                    this.m_cellWidths[n] = 0.0f;
                }
            }
            for (n = 0; n < this.m_textBlocks.size(); ++n) {
                this.calcCellDimension(this.m_textBlocks.get(n));
            }
        } else {
            for (int i = 0; i < this.m_width; ++i) {
                this.m_cellWidths[i] = this.m_charWidth;
            }
            this.m_cellWidths[this.m_width] = 0.0f;
        }
    }

    private void fillStartPosX(PdfCanvas pdfCanvas) {
        if (this.m_width == -1) {
            return;
        }
        float f = 0.0f;
        for (int i = 0; i < this.m_width; ++i) {
            f += this.m_cellWidths[i];
        }
        float f2 = this.m_pageWidth - this.m_leftMargin - this.m_rightMargin;
        this.m_factor = f2 / f;
        if (this.m_justify && !(Math.abs(this.m_factor - 1.0f) < 0.001f)) {
            if (this.m_factor < 1.0f) {
                int n;
                if (this.m_originalFontSize * this.m_factor < this.m_fontSize) {
                    this.m_fontSize = this.m_originalFontSize * this.m_factor;
                }
                for (n = 0; n < this.m_width; ++n) {
                    this.m_cellWidths[n] = this.m_cellWidths[n] * this.m_factor;
                }
                for (n = 0; n < this.m_textBlocks.size(); ++n) {
                    TextBlock textBlock = this.m_textBlocks.get(n);
                    textBlock.adjustFontSize(textBlock.pdfFont, this.m_fontSize);
                }
            } else {
                float f3 = this.getFraction();
                float f4 = f3 * this.m_charWidth;
                for (int i = 0; i < this.m_width; ++i) {
                    if (!(this.m_cellWidths[i] < f4)) continue;
                    this.m_cellWidths[i] = f4;
                }
            }
        }
        float f5 = this.m_leftMargin;
        for (int i = 0; i <= this.m_width; ++i) {
            this.m_cellStartPosX[i] = f5;
            f5 += this.m_cellWidths[i];
        }
    }

    private float getWidth(float f) {
        float f2 = 0.0f;
        float f3 = f * this.m_charWidth;
        for (int i = 0; i < this.m_width; ++i) {
            if (this.m_cellWidths[i] < f3) {
                f2 += f3;
                continue;
            }
            f2 += this.m_cellWidths[i];
        }
        return f2;
    }

    private float getFraction() {
        float f = 1.0f;
        float f2 = this.f(f);
        int n = 1;
        while (Math.abs(f2) > 1.0f && n < 20) {
            float f3;
            float f4;
            if (n != 1) {
                f2 = this.f(f);
            }
            if ((double)Math.abs(f4 = ((f3 = this.f(f + 0.01f)) - f2) / 0.01f) < 0.01) {
                n = 20;
                continue;
            }
            f -= f2 / f4;
            ++n;
        }
        if (n == 20) {
            f = 1.0f;
        }
        return f;
    }

    private float f(float f) {
        return this.getWidth(f) - this.m_pageWidth + this.m_leftMargin + this.m_rightMargin;
    }

    public void calculateCellDimensions(PdfCanvas pdfCanvas) {
        this.calcCellDimensions(pdfCanvas);
    }

    public void write(PdfCanvas pdfCanvas, boolean bl) {
        Block block;
        int n;
        int n2;
        if (bl && this.m_width > 0) {
            this.calcCellDimensions(pdfCanvas);
        }
        this.fillStartPosX(pdfCanvas);
        if (this.m_debug && this.m_width > 0) {
            pdfCanvas.setLineWidth(0.0f);
            pdfCanvas.setStrokeColor((Color)new DeviceRgb(230, 230, 230));
            for (n2 = 0; n2 <= this.m_width; ++n2) {
                float f = this.m_cellStartPosX[n2];
                pdfCanvas.moveTo((double)f, (double)(this.m_startYPix - 5.0f));
                pdfCanvas.lineTo((double)f, (double)this.m_endYPix);
                pdfCanvas.stroke();
            }
        }
        n2 = this.m_textBlocks.size();
        for (n = 0; n < this.m_images.size(); ++n) {
            block = this.m_images.get(n);
            this.write(pdfCanvas, block, false, false);
        }
        for (n = 0; n < this.m_lines.size(); ++n) {
            block = this.m_lines.get(n);
            this.write(pdfCanvas, block, false, true);
        }
        for (n = 0; n < n2; ++n) {
            block = this.m_textBlocks.get(n);
            this.write(pdfCanvas, block, false, true);
        }
        for (n = 0; n < n2; ++n) {
            block = this.m_textBlocks.get(n);
            this.write(pdfCanvas, block, false, false);
        }
        for (n = 0; n < this.m_lines.size(); ++n) {
            block = this.m_lines.get(n);
            this.write(pdfCanvas, block, false, false);
        }
        if (this.m_debug) {
            for (n = 0; n < n2; ++n) {
                block = this.m_textBlocks.get(n);
                this.write(pdfCanvas, block, true, false);
            }
        }
    }

    private void write(PdfCanvas pdfCanvas, Block block, boolean bl, boolean bl2) {
        try {
            boolean bl3;
            boolean bl4 = bl3 = block.style != null && block.style.getExactPosData() != null;
            if (!bl3) {
                float f;
                block.xPix = f = this.m_cellStartPosX[block.getX()];
                if (block.getWidth() >= 0) {
                    float f2;
                    block.widthPix = f2 = this.m_cellStartPosX[block.getX() + block.getWidth()] - f;
                }
            }
            if (this.m_bidi) {
                block.xPix = this.m_pageWidth - block.xPix - block.widthPix;
            }
            if (bl2) {
                block.writeBackground(pdfCanvas, bl, block.heightPix, ColorConstants.CYAN);
            } else {
                block.write(pdfCanvas, bl, block.heightPix, ColorConstants.CYAN);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public float[] getCellWidths() {
        return this.m_cellWidths;
    }

    public int getWidth() {
        return this.m_originalWidth;
    }

    public float getFontSize() {
        return this.m_fontSize;
    }

    public boolean getJustify() {
        return this.m_justify;
    }

    public void setCurrentYPos(float f) {
        this.m_currentYPos = f;
    }

    public class ImageBlock
    extends Block {
        private Image m_image;
        private int m_heightInLines;
        private boolean m_scaleInHeight;
        private boolean m_useExtraSpace;
        private int m_halign;
        private int m_valign;
        private String m_signatureId;

        public ImageBlock(int n, float f, int n2, int n3, Image image, boolean bl, boolean bl2, int n4, int n5, Style style, String string) {
            super(n, f, n2, style);
            if (style != null && style.getExactPosData() != null) {
                this.m_heightInLines = -1;
                this.m_useExtraSpace = false;
            } else {
                this.prefWidthPix = (float)n2 * Grid.this.m_charWidth;
                this.m_heightInLines = n3;
                this.m_useExtraSpace = bl2;
            }
            this.m_image = image;
            this.m_scaleInHeight = bl;
            this.m_halign = n4;
            this.m_valign = n5;
            this.m_signatureId = string;
        }

        @Override
        protected void write(PdfCanvas pdfCanvas, boolean bl, float f, Color color) throws IOException {
            float f2;
            float f3;
            float f4;
            float f5;
            if (this.m_signatureId != null) {
                f5 = (float)this.m_heightInLines * Grid.this.m_charHeight;
                if (this.m_heightInLines == -1) {
                    f5 = this.heightPix;
                }
                f4 = this.widthPix;
                f3 = this.xPix;
                f2 = this.yPix;
                PdfSignatureFormField pdfSignatureFormField = PdfFormField.createSignature((PdfDocument)Grid.this.m_document.getPdfDocument(), (Rectangle)new Rectangle(f3, f2 - f5, f4, f5));
                pdfSignatureFormField.setFieldName(this.m_signatureId);
                pdfSignatureFormField.setFieldFlags(4);
                pdfSignatureFormField.setBorderColor(ColorConstants.BLACK);
                pdfSignatureFormField.setPage(Grid.this.m_document.getPdfDocument().getPageNumber(Grid.this.m_document.getPdfDocument().getLastPage()));
                PdfAcroForm pdfAcroForm = PdfAcroForm.getAcroForm((PdfDocument)Grid.this.m_document.getPdfDocument(), (boolean)true);
                pdfAcroForm.addField((PdfFormField)pdfSignatureFormField, Grid.this.m_document.getPdfDocument().getLastPage());
                super.write(pdfCanvas, bl, f5, ColorConstants.BLUE);
            }
            if (this.m_image != null) {
                f5 = 1.0f;
                if (this.m_useExtraSpace) {
                    f5 = -5.0f;
                }
                if (this.m_heightInLines == -1) {
                    f5 = 0.0f;
                }
                f4 = (float)this.m_heightInLines * Grid.this.m_charHeight - 2.0f * f5;
                if (this.m_heightInLines == -1) {
                    f4 = this.heightPix;
                }
                f3 = f4 / this.m_image.getImageHeight();
                if (!this.m_scaleInHeight) {
                    f2 = this.widthPix / this.m_image.getImageWidth();
                    f3 = Math.min(f3, f2);
                }
                f2 = this.m_image.getImageHeight() * f3;
                float f6 = this.m_image.getImageWidth() * f3;
                float f7 = this.xPix;
                float f8 = this.yPix - f2 - f5;
                f7 = this.m_halign == 0 ? this.xPix : (this.m_halign == 1 ? this.xPix + 0.5f * (this.widthPix - f6) : this.xPix + this.widthPix - f6);
                f8 = this.m_valign == 0 ? this.yPix - f2 - f5 : (this.m_valign == 1 ? this.yPix - f2 - f5 - 0.5f * (f4 - f2) : this.yPix - f5 - f4);
                if (this.style != null && !this.style.isPreserveRatio()) {
                    this.m_image.scaleAbsolute(this.widthPix, f4);
                    f7 = this.xPix;
                    f8 = this.yPix - f4;
                } else {
                    this.m_image.scale(f3, f3);
                }
                this.m_image.setFixedPosition(f7, f8);
                Canvas canvas = new Canvas(pdfCanvas, Grid.this.m_document.getPdfDocument(), (Rectangle)new PageSize(Grid.this.m_pageWidth, Grid.this.m_pageHeight));
                canvas.add(this.m_image);
                canvas.close();
                super.write(pdfCanvas, bl, f4, ColorConstants.BLUE);
            }
        }
    }

    public class Line
    extends Block {
        private int type;

        public Line(int n, float f, int n2, int n3, Style style) {
            super(n, f, n2, style);
            this.type = n3;
            this.prefWidthPix = 0.0f;
        }

        @Override
        public Color getBackgroundColor() {
            if (this.isRealLine() && this.style != null && this.style.getLineBgColor() != null) {
                return this.style.getLineBgColor();
            }
            if (this.isRealLine() && this.style != null && this.style.hasBgColorFromStyle()) {
                return null;
            }
            return super.getBackgroundColor();
        }

        @Override
        public Color getForegroundColor() {
            if (this.isRealLine() && this.style != null && this.style.getLineFgColor() != null) {
                return this.style.getLineFgColor();
            }
            if (this.isRealLine() && this.style != null && this.style.hasFgColorFromStyle()) {
                return null;
            }
            return super.getForegroundColor();
        }

        private boolean isRealLine() {
            return this.type > 0 && this.type < 13;
        }

        @Override
        protected void write(PdfCanvas pdfCanvas, boolean bl, float f, Color color) throws IOException {
            super.write(pdfCanvas, bl, f, color);
            pdfCanvas.saveState();
            if (this.getForegroundColor() != null) {
                pdfCanvas.setStrokeColor(this.getForegroundColor());
            } else {
                pdfCanvas.setStrokeColor(Grid.this.m_lineColor);
            }
            this.setLineStyle(pdfCanvas, this.getLineStyle(), (float)this.getThickness());
            pdfCanvas.setLineWidth((float)this.getThickness());
            float f2 = (float)(0.5 * this.getThickness());
            float f3 = this.xPix;
            float f4 = this.yPix;
            if (this.type == 1 || this.type == 9 || this.type == 10 || this.type == 11) {
                pdfCanvas.moveTo((double)f3, (double)(f4 - 0.5f * this.heightPix));
                pdfCanvas.lineTo((double)(f3 + this.widthPix), (double)(f4 - 0.5f * this.heightPix));
            }
            if (this.type == 4 || this.type == 6 || this.type == 8) {
                pdfCanvas.moveTo((double)f3, (double)(f4 - 0.5f * this.heightPix));
                pdfCanvas.lineTo((double)(f3 + 0.5f * this.widthPix + f2), (double)(f4 - 0.5f * this.heightPix));
            }
            if (this.type == 3 || this.type == 5 || this.type == 7) {
                pdfCanvas.moveTo((double)(f3 + 0.5f * this.widthPix - f2), (double)(f4 - 0.5f * this.heightPix));
                pdfCanvas.lineTo((double)(f3 + this.widthPix), (double)(f4 - 0.5f * this.heightPix));
            }
            if (this.type == 2 || this.type == 7 || this.type == 8 || this.type == 11) {
                pdfCanvas.moveTo((double)(f3 + 0.5f * this.widthPix), (double)f4);
                pdfCanvas.lineTo((double)(f3 + 0.5f * this.widthPix), (double)(f4 - this.heightPix));
            }
            if (this.type == 5 || this.type == 6 || this.type == 10) {
                pdfCanvas.moveTo((double)(f3 + 0.5f * this.widthPix), (double)f4);
                pdfCanvas.lineTo((double)(f3 + 0.5f * this.widthPix), (double)(f4 - 0.5f * this.heightPix - f2));
            }
            if (this.type == 3 || this.type == 4 || this.type == 9) {
                pdfCanvas.moveTo((double)(f3 + 0.5f * this.widthPix), (double)(f4 - 0.5f * this.heightPix - f2));
                pdfCanvas.lineTo((double)(f3 + 0.5f * this.widthPix), (double)(f4 - this.heightPix));
            }
            if (this.type == 12) {
                pdfCanvas.moveTo((double)f3, (double)(f4 - 0.45f * this.heightPix));
                pdfCanvas.lineTo((double)(f3 + this.widthPix), (double)(f4 - 0.45f * this.heightPix));
                pdfCanvas.moveTo((double)f3, (double)(f4 - 0.55f * this.heightPix));
                pdfCanvas.lineTo((double)(f3 + this.widthPix), (double)(f4 - 0.55f * this.heightPix));
            }
            pdfCanvas.stroke();
            pdfCanvas.restoreState();
        }
    }

    public class TextBlock
    extends Block {
        int align;
        float rotation;
        BaseDirection runDirection;
        int arabicOptions;
        String font;
        String txt;
        SizedFont pdfFont;

        public TextBlock(int n, String string, SizedFont sizedFont, int n2, float f, float f2, BaseDirection baseDirection, int n3, String string2, Style style) {
            float f3;
            super(n2, f, n3, style);
            this.align = n;
            this.rotation = f2;
            this.runDirection = baseDirection;
            this.font = string2;
            this.pdfFont = sizedFont;
            if (string.trim().isEmpty()) {
                string = "";
            }
            if (!Grid.this.m_monospaced) {
                string = this.trim(string, n);
            }
            this.txt = this.replaceLeadingSpaces(string);
            if (Grid.this.m_fontSize > 0.0f && !sizedFont.m_fixed) {
                this.pdfFont.m_size = Grid.this.m_fontSize;
            }
            this.prefWidthPix = style != null && style.getExactPosData() != null ? this.widthPix : (f3 = sizedFont.getWidth(this.txt));
        }

        private String replaceLeadingSpaces(String string) {
            char[] cArray = string.toCharArray();
            int n = 0;
            while (n < cArray.length && cArray[n] == ' ') {
                cArray[n] = 160;
            }
            return new String(cArray);
        }

        private String trim(String string, int n) {
            int n2;
            if (Grid.this.m_bidi) {
                if (n == 0) {
                    n = 2;
                } else if (n == 2) {
                    n = 0;
                }
            }
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            char[] cArray2 = cArray;
            if (n == 1 || n == 2) {
                for (n2 = 0; n2 < n3 && cArray2[n2] == ' '; ++n2) {
                }
            }
            if (n == 1 || n == 0) {
                while (n2 < n3 && cArray2[n3 - 1] == ' ') {
                    --n3;
                }
            }
            return n2 > 0 || n3 < cArray.length ? string.substring(n2, n3) : string;
        }

        @Override
        protected void write(PdfCanvas pdfCanvas, boolean bl, float f, Color color) throws IOException {
            super.write(pdfCanvas, bl, f, color);
            pdfCanvas.setStrokeColor(ColorConstants.BLACK);
            pdfCanvas.setLineWidth(0.0f);
            if (this.style != null && this.style.getExactPosData() != null) {
                int n = this.style.getExactPosData().getMaxLines();
                if (n < 1) {
                    n = 1;
                }
                VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
                if (this.style != null && this.style.getExactPosData() != null) {
                    if (this.style.getExactPosData().getVAlign() == 0) {
                        verticalAlignment = VerticalAlignment.TOP;
                    } else if (this.style.getExactPosData().getVAlign() == 1) {
                        verticalAlignment = VerticalAlignment.MIDDLE;
                    } else if (this.style.getExactPosData().getVAlign() == 2) {
                        verticalAlignment = VerticalAlignment.BOTTOM;
                    }
                    if (this.style.getVAlign() != null) {
                        if (this.style.getVAlign() == 0) {
                            verticalAlignment = VerticalAlignment.TOP;
                        } else if (this.style.getVAlign() == 1) {
                            verticalAlignment = VerticalAlignment.MIDDLE;
                        } else if (this.style.getVAlign() == 2) {
                            verticalAlignment = VerticalAlignment.BOTTOM;
                        }
                    }
                }
                this.showText(pdfCanvas, n, verticalAlignment, true);
            } else {
                this.showText(pdfCanvas, 1, VerticalAlignment.BOTTOM, false);
            }
        }

        private void showText(PdfCanvas pdfCanvas, int n, VerticalAlignment verticalAlignment, boolean bl) {
            IRenderer iRenderer;
            LayoutResult layoutResult;
            if (this.txt.length() == 0) {
                return;
            }
            PDFTextWrap.TabStopParagraph tabStopParagraph = new PDFTextWrap.TabStopParagraph(this.txt, this.pdfFont);
            float f = this.pdfFont.getWidth("" + this.txt.charAt(0)) + 1.0f;
            this.widthPix = Math.max(this.widthPix, f);
            float f2 = this.xPix;
            float f3 = this.yPix;
            float f4 = this.widthPix;
            float f5 = 1000.0f;
            if (bl && ((layoutResult = (iRenderer = tabStopParagraph.createRendererSubTree()).setParent((IRenderer)Grid.this.m_document.getRenderer()).layout(new LayoutContext(new LayoutArea(1, new Rectangle(this.widthPix, 1000.0f))))) == null || layoutResult.getOccupiedArea() == null || layoutResult.getOccupiedArea().getBBox() == null)) {
                bl = false;
            }
            if (bl) {
                tabStopParagraph.setMarginTop(0.1f * this.pdfFont.getSize());
                tabStopParagraph.setMarginBottom(0.0f);
            } else {
                tabStopParagraph.setMarginTop(0.0f);
                tabStopParagraph.setMarginBottom(0.0f);
                tabStopParagraph.setPaddingBottom(0.0f);
                tabStopParagraph.setPaddingTop(0.0f);
                tabStopParagraph.setFixedLeading(0.0f);
                f5 = 5.0f * this.heightPix;
                f3 = (float)((double)f3 + (4.1 * (double)this.heightPix + (double)(this.pdfFont.m_size / 2.0f)));
            }
            if (this.style != null && this.style.getExactPosData() != null) {
                tabStopParagraph.setMultipliedLeading(this.style.getExactPosData().getLeading() * 0.75f);
            }
            if (this.align == 0) {
                tabStopParagraph.setTextAlignment(TextAlignment.LEFT);
                if (!bl) {
                    f4 += 1000.0f;
                }
            } else if (this.align == 1) {
                tabStopParagraph.setTextAlignment(TextAlignment.CENTER);
                if (!bl) {
                    f2 -= 500.0f;
                    f4 += 1000.0f;
                }
            } else if (this.align == 2) {
                tabStopParagraph.setTextAlignment(TextAlignment.RIGHT);
                if (!bl) {
                    f2 -= 1000.0f;
                    f4 += 1000.0f;
                }
            }
            tabStopParagraph.setWidth(f4);
            if (bl) {
                iRenderer = tabStopParagraph.createRendererSubTree();
                layoutResult = iRenderer.setParent((IRenderer)Grid.this.m_document.getRenderer()).layout(new LayoutContext(new LayoutArea(1, new Rectangle(this.widthPix, 1000.0f))));
                float f6 = layoutResult.getOccupiedArea().getBBox().getHeight();
                String[] stringArray = tabStopParagraph.toString().split("\n");
                int n2 = stringArray.length;
                float f7 = f6 / (float)n2;
                float f8 = (float)n * f7;
                if (n2 > n) {
                    String string = "";
                    for (int i = 0; i < n; ++i) {
                        string = string + stringArray[i] + "\n";
                    }
                    tabStopParagraph = new PDFTextWrap.TabStopParagraph(string, this.pdfFont);
                    tabStopParagraph.setMarginTop(0.1f * this.pdfFont.getSize());
                    tabStopParagraph.setMarginBottom(0.0f);
                    if (this.style != null && this.style.getExactPosData() != null) {
                        tabStopParagraph.setMultipliedLeading(this.style.getExactPosData().getLeading() * 0.75f);
                    }
                    if (this.align == 0) {
                        tabStopParagraph.setTextAlignment(TextAlignment.LEFT);
                    } else if (this.align == 1) {
                        tabStopParagraph.setTextAlignment(TextAlignment.CENTER);
                    } else if (this.align == 2) {
                        tabStopParagraph.setTextAlignment(TextAlignment.RIGHT);
                    }
                    tabStopParagraph.setWidth(this.widthPix);
                }
                if (verticalAlignment == VerticalAlignment.MIDDLE) {
                    f3 = (float)((double)f3 + 0.5 * (double)(f8 - this.heightPix));
                } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                    f3 += f8 - this.heightPix;
                }
            }
            iRenderer = new Rectangle(f2, f3 - f5, f4, f5);
            layoutResult = new Canvas(pdfCanvas, Grid.this.m_document.getPdfDocument(), (Rectangle)iRenderer);
            if (bl) {
                layoutResult.add((IBlockElement)tabStopParagraph);
            } else {
                Div div = new Div();
                div.setHeight(f5);
                div.setVerticalAlignment(VerticalAlignment.BOTTOM);
                div.add((IBlockElement)tabStopParagraph);
                layoutResult.add((IBlockElement)div);
            }
            layoutResult.close();
        }

        public void adjustFontSize(SizedFont sizedFont, float f) {
            if (!sizedFont.m_fixed) {
                sizedFont.m_size = f;
            }
        }
    }

    public class Block
    implements Comparable<Block> {
        int x;
        int width;
        float yPix;
        float prefWidthPix;
        float xPix;
        float widthPix;
        float heightPix;
        Style style;

        public Block(int n, float f, int n2, Style style) {
            this.style = style;
            if (style != null && style.getExactPosData() != null) {
                this.x = -1;
                this.width = -1;
                this.xPix = style.getExactPosData().getXpos() + Grid.this.m_leftMargin;
                this.yPix = style.getExactPosData().getYpos() + Grid.this.m_currentYPos;
                this.widthPix = style.getExactPosData().getWidth();
                this.heightPix = style.getExactPosData().getHeight();
                this.prefWidthPix = this.widthPix;
            } else {
                this.x = n - 1;
                this.yPix = f;
                this.width = n2;
                this.heightPix = Grid.this.m_charHeight;
                if (style != null && style.getHeight() > 1) {
                    this.heightPix = (float)style.getHeight() * Grid.this.m_charHeight;
                }
                if (f > Grid.this.m_startYPix) {
                    Grid.this.m_startYPix = f;
                }
                if (f - this.heightPix < Grid.this.m_endYPix) {
                    Grid.this.m_endYPix = f - this.heightPix;
                }
                if (this.x + this.width > Grid.this.m_width) {
                    Grid.this.m_width = this.x + this.width;
                }
            }
        }

        protected void setLineStyle(PdfCanvas pdfCanvas, Style.BorderType borderType, float f) {
            if (borderType == Style.BorderType.dashed) {
                pdfCanvas.setLineDash(3.0f * f, 1.0f * f, 0.0f);
            } else if (borderType == Style.BorderType.dotted) {
                pdfCanvas.setLineDash(f, f, 0.0f);
            }
        }

        @Override
        public int compareTo(Block block) {
            float f = block.width;
            float f2 = this.width;
            return (int)(f2 - f);
        }

        public int getX() {
            return this.x;
        }

        public int getWidth() {
            return this.width;
        }

        public float getPreferredWidth() {
            return this.prefWidthPix;
        }

        public Color getForegroundColor() {
            return this.style == null ? null : this.style.getFgColor();
        }

        public double getThickness() {
            double d = this.style == null ? 0.0 : this.style.getThickness();
            d = Math.max((double)0.3f, d);
            return d;
        }

        public Style.BorderType getLineStyle() {
            return this.style == null ? Style.BorderType.solid : this.style.getLineStyle();
        }

        public Color getBackgroundColor() {
            return this.style == null ? null : this.style.getBgColor();
        }

        public Color getBackgroundColor1() {
            return this.style == null ? null : this.style.getBgColor1();
        }

        public Color getBackgroundColor2() {
            return this.style == null ? null : this.style.getBgColor2();
        }

        public Color getBackgroundColor3() {
            return this.style == null ? null : this.style.getBgColor3();
        }

        public Color getBackgroundColor4() {
            return this.style == null ? null : this.style.getBgColor4();
        }

        protected void writeBackground(PdfCanvas pdfCanvas, boolean bl, float f, Color color) throws IOException {
            float f2;
            float f3;
            if (this.getBackgroundColor() != null) {
                pdfCanvas.setFillColor(this.getBackgroundColor());
                pdfCanvas.rectangle((double)this.xPix, (double)(this.yPix - f), (double)this.widthPix, (double)f);
                pdfCanvas.fill();
                pdfCanvas.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor1() != null) {
                f3 = 0.5f * f;
                f2 = 0.5f * this.widthPix;
                pdfCanvas.setFillColor(this.getBackgroundColor1());
                pdfCanvas.rectangle((double)this.xPix, (double)(this.yPix - f3), (double)f2, (double)f3);
                pdfCanvas.fill();
                pdfCanvas.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor2() != null) {
                f3 = 0.5f * f;
                f2 = 0.5f * this.widthPix;
                pdfCanvas.setFillColor(this.getBackgroundColor2());
                pdfCanvas.rectangle((double)(this.xPix + f2), (double)(this.yPix - f3), (double)f2, (double)f3);
                pdfCanvas.fill();
                pdfCanvas.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor3() != null) {
                f3 = 0.5f * f;
                f2 = 0.5f * this.widthPix;
                pdfCanvas.setFillColor(this.getBackgroundColor3());
                pdfCanvas.rectangle((double)(this.xPix + f2), (double)(this.yPix - f), (double)f2, (double)f3);
                pdfCanvas.fill();
                pdfCanvas.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor4() != null) {
                f3 = 0.5f * f;
                f2 = 0.5f * this.widthPix;
                pdfCanvas.setFillColor(this.getBackgroundColor4());
                pdfCanvas.rectangle((double)this.xPix, (double)(this.yPix - f), (double)f2, (double)f3);
                pdfCanvas.fill();
                pdfCanvas.setFillColor(ColorConstants.BLACK);
            }
        }

        private void writeBorder(PdfCanvas pdfCanvas, Style.Border border, float f, float f2, float f3, float f4) {
            float f5 = Math.max(0.3f, (float)border.getThickness());
            this.setLineStyle(pdfCanvas, border.getType(), f5);
            pdfCanvas.setStrokeColor(border.getColor());
            pdfCanvas.setLineWidth(f5);
            pdfCanvas.moveTo((double)f, (double)f2);
            pdfCanvas.lineTo((double)f3, (double)f4);
            pdfCanvas.stroke();
        }

        protected void write(PdfCanvas pdfCanvas, boolean bl, float f, Color color) throws IOException {
            float f2;
            float f3;
            float f4;
            if (this.style != null) {
                float f5;
                pdfCanvas.saveState();
                if (this.style.getBorderLeft() != null) {
                    f4 = (float)this.style.getBorderLeft().getThickness();
                    f3 = 0.5f * f4;
                    f2 = this.yPix - f;
                    f5 = this.yPix;
                    if (this.style.getBorderTop() != null) {
                        f5 = this.yPix + f4;
                    }
                    if (this.style.getBorderBottom() != null) {
                        f2 = this.yPix - f - f4;
                    }
                    this.writeBorder(pdfCanvas, this.style.getBorderLeft(), this.xPix - f3, f2, this.xPix - f3, f5);
                }
                if (this.style.getBorderTop() != null) {
                    f4 = (float)this.style.getBorderTop().getThickness();
                    f3 = 0.5f * f4;
                    this.writeBorder(pdfCanvas, this.style.getBorderTop(), this.xPix, this.yPix + f3, this.xPix + this.widthPix, this.yPix + f3);
                }
                if (this.style.getBorderRight() != null) {
                    f4 = (float)this.style.getBorderRight().getThickness();
                    f3 = 0.5f * f4;
                    f2 = this.yPix - f;
                    f5 = this.yPix;
                    if (this.style.getBorderTop() != null) {
                        f5 = this.yPix + f4;
                    }
                    if (this.style.getBorderBottom() != null) {
                        f2 = this.yPix - f - f4;
                    }
                    this.writeBorder(pdfCanvas, this.style.getBorderRight(), this.xPix + this.widthPix + f3, f2, this.xPix + this.widthPix + f3, f5);
                }
                if (this.style.getBorderBottom() != null) {
                    f4 = (float)this.style.getBorderBottom().getThickness();
                    f3 = 0.5f * f4;
                    this.writeBorder(pdfCanvas, this.style.getBorderBottom(), this.xPix, this.yPix - f - f3, this.xPix + this.widthPix, this.yPix - f - f3);
                }
                pdfCanvas.restoreState();
            }
            if (Grid.this.m_debug) {
                f4 = this.widthPix;
                pdfCanvas.setStrokeColor(color);
                pdfCanvas.setLineWidth(0.0f);
                f3 = 0.2f;
                f2 = 0.2f;
                if (this instanceof ImageBlock) {
                    f3 = -0.5f;
                    f2 = -0.5f;
                }
                if (bl) {
                    if (this.prefWidthPix > this.widthPix + 1.0f) {
                        f2 = 0.5f;
                        f3 = 0.3f;
                        Color color2 = ColorConstants.RED;
                        pdfCanvas.setStrokeColor(color2);
                        f4 = this.prefWidthPix;
                    } else {
                        return;
                    }
                }
                pdfCanvas.moveTo((double)(this.xPix + f3), (double)(this.yPix - f2));
                pdfCanvas.lineTo((double)(this.xPix - f3 + f4), (double)(this.yPix - f2));
                pdfCanvas.lineTo((double)(this.xPix - f3 + f4), (double)(this.yPix + f2 - f));
                pdfCanvas.lineTo((double)(this.xPix + f3), (double)(this.yPix + f2 - f));
                pdfCanvas.lineTo((double)(this.xPix + f3), (double)(this.yPix - f2));
                pdfCanvas.stroke();
            }
        }
    }

    public static class SizedFont {
        private PdfFont m_font;
        private FontProvider m_provider;
        private float m_size;
        private boolean m_fixed;
        private boolean m_monospace;
        private boolean m_bold = false;
        private boolean m_underline = false;
        private boolean m_italic = false;
        private Color m_color;

        public SizedFont(SizedFont sizedFont, float f, boolean bl, boolean bl2) {
            this.m_font = sizedFont.m_font;
            this.m_provider = sizedFont.m_provider;
            this.m_size = f;
            this.m_fixed = bl;
            this.m_monospace = bl2;
        }

        public SizedFont(PdfFont pdfFont, float f, boolean bl, boolean bl2) {
            this.m_font = pdfFont;
            this.m_size = f;
            this.m_fixed = bl;
            this.m_monospace = bl2;
        }

        public SizedFont(FontProvider fontProvider, float f, boolean bl, boolean bl2) {
            this.m_provider = fontProvider;
            this.m_size = f;
            this.m_fixed = bl;
            this.m_monospace = bl2;
        }

        public void setBold(boolean bl) {
            this.m_bold = bl;
        }

        public void setUnderline(boolean bl) {
            this.m_underline = bl;
        }

        public void setItalic(boolean bl) {
            this.m_italic = bl;
        }

        public void setColor(Color color) {
            this.m_color = color;
        }

        public Color getColor() {
            return this.m_color;
        }

        public float getWidth(String string) {
            List list;
            int n;
            if (this.getProvider() == null) {
                return this.m_font.getWidth(string, this.m_size);
            }
            int n2 = 0;
            String string2 = string;
            FontSelectorStrategy fontSelectorStrategy = this.getProvider().getStrategy(string2, this.getFamilies());
            while ((n = (list = fontSelectorStrategy.nextGlyphs()).size()) > 0) {
                PdfFont pdfFont = fontSelectorStrategy.getCurrentFont();
                String string3 = string2.substring(0, n);
                n2 = (int)((float)n2 + pdfFont.getWidth(string3, this.m_size));
                string2 = string2.substring(n);
            }
            return n2;
        }

        public boolean isUnderline() {
            return this.m_underline;
        }

        public boolean isBold() {
            return this.m_bold;
        }

        public boolean isItalic() {
            return this.m_italic;
        }

        public boolean isMonospace() {
            return this.m_monospace;
        }

        public PdfFont getFont() {
            return this.m_font;
        }

        public FontProvider getProvider() {
            return this.m_provider;
        }

        public float getSize() {
            return this.m_size;
        }

        public ArrayList<String> getFamilies() {
            return this.m_monospace ? PDFTextWrap.MONO : PDFTextWrap.EMPTY;
        }
    }
}

