/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class FileCache {
    private String m_fileService;
    private HashMap<String, Thread> m_busyFiles = new HashMap();
    private static FileCache s_fileCache;
    private Timer m_timer = new Timer(true);
    private long m_deleteTime = 86400000L;
    private String m_sharedStorageDir = "c:\\storage\\infor\\";
    private static final long DAY = 86400000L;

    public static synchronized FileCache getInstance(String string) {
        if (string == null) {
            string = "";
        }
        if (s_fileCache == null) {
            s_fileCache = new FileCache(string);
        }
        if (!FileCache.s_fileCache.m_fileService.equals(string)) {
            s_fileCache = new FileCache(string);
        }
        return s_fileCache;
    }

    public static synchronized FileCache getInstance() {
        if (s_fileCache == null) {
            s_fileCache = new FileCache(null);
        }
        return s_fileCache;
    }

    private FileCache(String string) {
        if (string == null) {
            string = "";
        }
        this.m_fileService = string;
    }

    private synchronized boolean isBusy(String string) {
        return this.m_busyFiles.containsKey(string);
    }

    private synchronized void setBusy(String string, boolean bl) {
        if (!bl) {
            this.m_busyFiles.remove(string);
        } else {
            this.m_busyFiles.put(string, Thread.currentThread());
        }
    }

    private synchronized boolean getLock(String string) {
        if (this.isBusy(string)) {
            return false;
        }
        this.setBusy(string, true);
        return true;
    }

    private void waitAndLock(String string) {
        while (!this.getLock(string)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(String string, File file) {
        this.waitAndLock(string);
        try {
            boolean bl = file.delete();
            if (!bl) {
                System.out.println("Could not delete: " + file.getAbsolutePath());
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.setBusy(string, false);
        }
    }

    private String getKey(String string) {
        String string2 = string.toLowerCase();
        string2 = string2.replaceAll("/", "#");
        string2 = string2.replaceAll("\\\\", "#");
        if ((string2 = string2.replaceAll(":", "#")).length() > 255) {
            string2 = string2.substring(string2.length() - 255);
        }
        if (string2.endsWith("#")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private File getCacheDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        File file2 = new File(file, "fileCache");
        file2.mkdirs();
        return file2;
    }

    public void clearCache() {
        File file = this.getCacheDir();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            this.delete(string, fileArray[i]);
        }
    }

    public boolean isDownloading(String string) {
        String string2 = this.getKey(string);
        return this.isBusy(string2);
    }

    public File getLocalFile(String string) throws IOException {
        return new File(this.getLocalFileName(string));
    }

    public String getLocalFileName(String string) throws IOException {
        Object object;
        if (this.m_fileService == null || this.m_fileService.isEmpty()) {
            return string;
        }
        if (!this.isSharedStorage(string)) {
            return string;
        }
        if (this.m_fileService.startsWith("file://") && ((File)(object = new File(string))).isDirectory()) {
            return string;
        }
        object = this.getKey(string);
        File file = new File(this.getCacheDir(), (String)object);
        this.storeFile((String)object, string, file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    private boolean isSharedStorage(String string) {
        File file = new File(string);
        return file.getPath().toLowerCase().startsWith(this.m_sharedStorageDir);
    }

    public void setSharedStorageDir(String string) {
        File file = new File(string);
        this.m_sharedStorageDir = file.getPath().toLowerCase();
    }

    public void setDeleteTime(long l) {
        this.m_deleteTime = l;
    }

    private void storeFile(final String string, String string2, final String string3) throws IOException {
        this.waitAndLock(string);
        File file = new File(string3);
        if (file.exists()) {
            try {
                file.setLastModified(new Date().getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBusy(string, false);
            return;
        }
        OutputStream outputStream = null;
        try {
            Object object;
            InputStream inputStream = null;
            boolean bl = true;
            if (this.m_fileService.startsWith("file://")) {
                object = new File(string2);
                if (((File)object).isDirectory()) {
                    bl = false;
                }
                if (bl) {
                    inputStream = new FileInputStream((File)object);
                }
            } else if (bl) {
                int n;
                object = this.m_fileService + "?file=" + URLEncoder.encode(string2, "UTF-8");
                URL uRL = new URL((String)object);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).setRequestMethod("GET");
                }
                inputStream = uRLConnection.getInputStream();
                if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) != 200) {
                    bl = false;
                    throw new IOException("Cannot get the file from the file service, http error " + n);
                }
            }
            if (bl) {
                int n;
                outputStream = new FileOutputStream(new File(string3));
                object = new byte[1024];
                while ((n = inputStream.read((byte[])object)) > 0) {
                    ((FileOutputStream)outputStream).write((byte[])object, 0, n);
                }
                inputStream.close();
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            } else if (inputStream != null) {
                inputStream.close();
            }
            this.m_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    long l = new Date().getTime();
                    File file = new File(string3);
                    if (file.lastModified() <= l - FileCache.this.m_deleteTime && !FileCache.this.delete(string, file)) {
                        FileCache.this.m_timer.schedule((TimerTask)this, FileCache.this.m_deleteTime);
                    }
                }
            }, this.m_deleteTime);
        }
        catch (Exception exception) {
            if (outputStream != null) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
            File file2 = new File(string3);
            file2.delete();
            throw new IOException("Cannot store the file locally", exception);
        }
        finally {
            this.setBusy(string, false);
        }
    }
}

