/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BMLConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BML2TXT
extends BMLConverter {
    private Hashtable m_rowLayouts;
    private RowLayout m_currentRow;
    private Vector m_fieldsWithHeightHigherThanOne = null;

    @Override
    public boolean getReencodeCharacters() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.m_rowLayouts = new Hashtable();
        this.m_currentRow = null;
        this.m_fieldsWithHeightHigherThanOne = new Vector();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (!string3.equals("report")) {
                if (string3.equals("row")) {
                    String string4 = attributes.getValue("layout");
                    this.m_currentRow = (RowLayout)this.m_rowLayouts.get(string4);
                    if (this.m_currentRow == null) {
                        System.err.println("There is no lline with this ID: " + string4 + ". Row will not be printed.");
                    }
                } else if (string3.equals("e")) {
                    this.startCharacters();
                } else if (string3.equals("pagebreak")) {
                    this.write("\r\n");
                } else if (string3.equals("emptyline")) {
                    this.write("\r\n");
                } else if (string3.equals("lline")) {
                    String string5 = attributes.getValue("id");
                    this.m_currentRow = new RowLayout();
                    this.m_rowLayouts.put(string5, this.m_currentRow);
                    for (int i = 0; i < this.m_fieldsWithHeightHigherThanOne.size(); ++i) {
                        Object[] objectArray = (Object[])this.m_fieldsWithHeightHigherThanOne.elementAt(i);
                        CellLayout cellLayout = (CellLayout)objectArray[0];
                        int[] nArray = (int[])objectArray[1];
                        this.m_currentRow.addCell(cellLayout);
                        nArray[0] = nArray[0] - 1;
                        if (nArray[0] > 0) continue;
                        this.m_fieldsWithHeightHigherThanOne.remove(i);
                        --i;
                    }
                } else if (string3.equals("special") || string3.equals("field")) {
                    int n;
                    CellLayout cellLayout = new CellLayout(attributes.getValue("col"), attributes.getValue("width"), attributes.getValue("align"), attributes.getValue("bold"));
                    this.m_currentRow.addCell(cellLayout);
                    int n2 = n = attributes.getValue("height") == null ? 0 : Integer.parseInt(attributes.getValue("height"));
                    if (n > 1) {
                        this.m_fieldsWithHeightHigherThanOne.addElement(new Object[]{cellLayout.copy(), new int[]{n - 1}});
                    }
                } else if (string3.equals("text")) {
                    this.addCells(Integer.parseInt(attributes.getValue("col")), attributes.getValue("content"));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addCells(int n, String string) {
        int n2 = -1;
        int n3 = n;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n4 = string2.length();
            if (c == '\u2500') {
                string2 = string2 + c;
                n2 = 1;
                continue;
            }
            if (c == '\u2502') {
                if (n4 > 0) {
                    this.addCell(n3, string2, n2);
                    n3 += n4;
                    string2 = "";
                }
                string2 = string2 + c;
                n2 = 2;
                continue;
            }
            if (c >= '\u2500' && c <= '\u256c') {
                if (n4 > 0) {
                    this.addCell(n3, string2, 1);
                }
                n2 = c == '\u2502' || c == '\u2503' || c == '\u2506' || c == '\u2507' || c == '\u250a' || c == '\u250b' ? 2 : (c <= '\u250b' ? 1 : (c <= '\u250f' ? 3 : (c <= '\u2513' ? 4 : (c <= '\u2517' ? 5 : (c <= '\u251b' ? 6 : (c <= '\u2523' ? 7 : (c <= '\u252b' ? 8 : (c <= '\u2533' ? 9 : (c <= '\u253b' ? 10 : 11)))))))));
                this.addCell(n3 + n4, "" + c, n2);
                n3 = n3 + n4 + 1;
                string2 = "";
                continue;
            }
            string2 = string2 + c;
        }
        if (string2.length() > 0) {
            this.addCell(n3, string2, n2);
        }
    }

    private CellLayout addCell(int n, String string, int n2) {
        CellLayout cellLayout = new CellLayout(n, string);
        this.m_currentRow.addCell(cellLayout);
        cellLayout.m_borderType = n2;
        return cellLayout;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (!string3.equals("report")) {
                if (string3.equals("e")) {
                    if (this.m_currentRow != null && this.isCharactersStarted()) {
                        this.m_currentRow.addE(this.getCharacters());
                        this.stopCharacters();
                    }
                } else if (string3.equals("row")) {
                    if (this.m_currentRow != null) {
                        this.m_currentRow.writeAscii();
                        this.m_currentRow.clearEs();
                        this.write("\r\n");
                    }
                } else if (string3.equals("lline") && this.m_currentRow != null) {
                    this.m_currentRow.sort();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void convertBML(String string, String string2) {
        try {
            BML2TXT bML2TXT = new BML2TXT();
            bML2TXT.convert(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CellLayout
    implements Comparable,
    Cloneable {
        public static final int LEFT = 0;
        public static final int CENTERED = 1;
        public static final int RIGHT = 2;
        public int m_col;
        public int m_width;
        public int m_align;
        public boolean m_bold;
        public String m_text;
        public int m_borderType = -1;

        public CellLayout(int n, int n2, int n3, boolean bl) {
            this.m_col = n;
            this.m_width = n2;
            this.m_align = n3;
            this.m_bold = bl;
        }

        public CellLayout(int n, String string) {
            this.m_col = n;
            this.m_width = string.length();
            this.m_text = string;
            this.m_bold = false;
            this.m_align = 0;
            if (string.trim().equals("")) {
                this.m_text = "";
            }
        }

        public CellLayout(String string, String string2, String string3, String string4) {
            this.m_col = Integer.parseInt(string);
            this.m_width = Integer.parseInt(string2);
            this.m_align = "Right".equals(string3) ? 2 : ("Centered".equals(string3) ? 1 : 0);
            this.m_bold = "Yes".equals(string4);
        }

        public CellLayout(String string, String string2) {
            this(Integer.parseInt(string), string2);
        }

        public int compareTo(Object object) {
            return this.m_col - ((CellLayout)object).m_col;
        }

        public CellLayout copy() throws CloneNotSupportedException {
            return (CellLayout)this.clone();
        }
    }

    class RowLayout {
        private Vector m_cellLayouts = new Vector();
        private Vector m_es = new Vector();

        public void addCell(CellLayout cellLayout) {
            this.m_cellLayouts.addElement(cellLayout);
        }

        public void sort() {
            Collections.sort(this.m_cellLayouts);
            for (int i = 1; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cellLayout = (CellLayout)this.m_cellLayouts.elementAt(i - 1);
                int n = cellLayout.m_col;
                CellLayout cellLayout2 = (CellLayout)this.m_cellLayouts.elementAt(i);
                if (cellLayout.m_width == 1 && cellLayout.m_borderType != -1) continue;
                cellLayout.m_width = cellLayout2.m_col - n;
            }
        }

        public void addE(String string) {
            this.m_es.addElement(string);
        }

        public void clearEs() {
            this.m_es.clear();
        }

        private void writeSpaces(int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                BML2TXT.this.write(" ");
            }
        }

        public void writeAscii() throws IOException {
            int n = 1;
            int n2 = 0;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                String string = null;
                CellLayout cellLayout = (CellLayout)this.m_cellLayouts.elementAt(i);
                if (cellLayout.m_text == null) {
                    string = (String)this.m_es.elementAt(n2);
                    ++n2;
                } else {
                    string = cellLayout.m_text;
                }
                if (string == null) {
                    string = "";
                }
                while (n < cellLayout.m_col) {
                    BML2TXT.this.write(" ");
                    ++n;
                }
                if (cellLayout.m_align == 0) {
                    BML2TXT.this.write(string);
                    this.writeSpaces(cellLayout.m_width - string.length());
                } else if (cellLayout.m_align == 2) {
                    this.writeSpaces(cellLayout.m_width - string.length());
                    BML2TXT.this.write(string);
                } else if (cellLayout.m_align == 1) {
                    int n3 = 0 * (cellLayout.m_width - string.length());
                    this.writeSpaces(n3);
                    BML2TXT.this.write(string);
                    this.writeSpaces(cellLayout.m_width - string.length() - n3);
                } else {
                    BML2TXT.this.write(string);
                    this.writeSpaces(cellLayout.m_width - string.length());
                }
                n += cellLayout.m_width;
            }
        }
    }
}

