/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.codec.Base64;
import com.ssaglobal.bml.BML2PDF;
import com.ssaglobal.bml.BMLConverter;
import com.ssaglobal.bml.BarcodeCellLayout;
import com.ssaglobal.bml.CellLayout;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.ImageCellLayout;
import com.ssaglobal.bml.LinesCellLayout;
import com.ssaglobal.bml.NPagesTextCellLayout;
import com.ssaglobal.bml.PageNo;
import com.ssaglobal.bml.PageNoTextCellLayout;
import com.ssaglobal.bml.Style;
import com.ssaglobal.bml.TextCellLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2HTML
extends BMLConverter {
    private Hashtable<String, RowLayout> m_rowLayouts;
    private RowLayout m_currentRow;
    private Vector<Object[]> m_fieldsWithHeightHigherThanOne;
    private ArrayList<TextCellLayout> m_waitingFields;
    private int m_countPages;
    private int m_pwidth;
    private boolean m_monospace;
    private int m_pageNoPageBreak;
    private ArrayList<PageNoTextCellLayout> m_pageNoTextCellLayouts;
    private int m_pageNoTextCellLayoutIndex;
    private PageNo m_pageNo;
    private boolean m_testMode;
    private boolean m_showNavigation;
    private boolean m_showCompanyLogo;
    protected String m_negativeSignOnNumbersOnTheRight;
    private boolean m_largeReport;
    private static final int LARGE_REPORT = 500;
    private String m_font;
    private String m_monospacedFont;
    private boolean m_pendingPagebreak;
    private String m_locale;
    private boolean m_bidi;
    private int m_numberOfCharactersForTheCurrentLine;
    private String m_layoutFont;
    private String m_reportFont;
    private Hashtable<String, Integer> m_numberOfCharactersOnLinePerFont;
    private String m_currentCharactersBeforeBarcode;
    private int m_numberOfSpacesForTab;
    private boolean m_inBody;
    private BarcodeCellLayout m_currentBarcodeCellLayout;
    private String m_currentOptionName;
    private Boolean m_justify;
    private Boolean m_layoutJustify;
    private float m_rowFixedOffset;
    private String m_reportTitle;
    private ArrayList<Style> m_styles = new ArrayList();
    private String m_currentClass = null;
    private ArrayList<Style> m_currentStyles = new ArrayList();

    @Override
    protected void init() {
        super.init();
        this.m_rowLayouts = new Hashtable();
        this.m_currentRow = null;
        this.m_fieldsWithHeightHigherThanOne = new Vector();
        this.m_waitingFields = new ArrayList();
        this.m_countPages = 0;
        this.m_pwidth = 0;
        this.m_monospace = false;
        this.m_pageNoPageBreak = 1;
        this.m_pageNoTextCellLayouts = new ArrayList();
        this.m_pageNoTextCellLayoutIndex = 0;
        this.m_pageNo = null;
        this.m_testMode = false;
        this.m_showNavigation = true;
        this.m_showCompanyLogo = true;
        this.m_negativeSignOnNumbersOnTheRight = "-";
        this.m_largeReport = false;
        this.m_font = "font-family:verdana;font-size:x-small";
        this.m_monospacedFont = "font-family:courier new;font-size:x-small";
        this.m_pendingPagebreak = false;
        this.m_locale = "ISO88591";
        this.m_bidi = false;
        this.m_numberOfCharactersForTheCurrentLine = 0;
        this.m_layoutFont = null;
        this.m_reportFont = null;
        this.m_numberOfCharactersOnLinePerFont = new Hashtable();
        this.m_currentCharactersBeforeBarcode = null;
        this.m_numberOfSpacesForTab = 0;
        this.m_inBody = false;
        this.m_currentBarcodeCellLayout = null;
        this.m_currentOptionName = null;
        this.m_justify = null;
        this.m_layoutJustify = null;
        this.m_rowFixedOffset = -1.0f;
        this.m_reportTitle = null;
        this.m_numberOfSpacesForTab = this.getSpacesPerTab();
    }

    protected int getSpacesPerTab() {
        return 8;
    }

    public boolean isBidi() {
        return this.m_bidi;
    }

    public void setBidi(boolean bl) {
        this.m_bidi = bl;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public int getPWidth() {
        return this.m_pwidth;
    }

    @Override
    public boolean getReencodeCharacters() {
        return true;
    }

    @Override
    public boolean getReencodeCharacterApos() {
        return false;
    }

    protected void setNumberOfCharactersForTheCurrentLine(int n, String string, boolean bl) {
        this.m_numberOfCharactersForTheCurrentLine = n;
    }

    protected int getNumberOfCharactersForTheCurrentLine() {
        return this.m_numberOfCharactersForTheCurrentLine;
    }

    protected void writeBorderCell(int n, int n2, int n3, Style style) throws IOException {
        if (n2 != 1) {
            this.write("<td colspan=\"" + n2 + "\"' ");
        } else {
            this.write("<td ");
        }
        this.write("class=\"b" + n3 + "\">&nbsp&nbsp</td>");
    }

    protected void writeTextCell(String string, int n, int n2, int n3, boolean bl, String string2, Style style) throws IOException {
        boolean bl2 = this.isMonospaced() || style != null && style.getMonospace() != null && style.getMonospace() != false;
        this.write("<td ");
        if (n2 != 1) {
            this.write("colspan=\"" + n2 + "\" ");
        }
        this.write("class=\"");
        if (n3 == 0) {
            this.write("al ");
        } else if (n3 == 1) {
            this.write("ac ");
        } else if (n3 == 2) {
            this.write("ar ");
        }
        if (bl2) {
            this.write("bold ");
        }
        if (bl2) {
            this.write("mono ");
        }
        if (string.trim().equals("")) {
            string = "&nbsp;";
        }
        this.write("\" ");
        if (this.m_testMode) {
            if (n3 == 0) {
                this.write("align=left ");
            } else if (n3 == 1) {
                this.write("align=center ");
            } else if (n3 == 2) {
                this.write("align=right ");
            }
            if (style != null && style.getBold().booleanValue()) {
                this.write("style='font-weight:bold' ");
            }
        }
        this.write(" >");
        if (style != null && style.getUnderline() != null && style.getUnderline().booleanValue()) {
            this.write("<u>");
        }
        if (bl && !bl2) {
            char c = string.charAt(string.length() - 1);
            String string3 = null;
            boolean bl3 = Character.isDigit(c);
            if (bl3) {
                string3 = string;
            } else {
                string3 = string.substring(0, string.length() - 1);
                this.m_negativeSignOnNumbersOnTheRight = "" + c;
            }
            this.write("<span>" + string3 + "</span><span");
            if (bl3) {
                this.write(" style='visibility:hidden'");
            }
            this.write(" >" + this.m_negativeSignOnNumbersOnTheRight + "</span>");
        } else {
            if (bl2) {
                string = string.replaceAll(" ", "&nbsp;");
            }
            this.write(string + "</td>");
        }
        if (style != null && style.getUnderline() != null && style.getUnderline().booleanValue()) {
            this.write("</u>");
        }
    }

    protected void writeBarcode(int n, int n2, BarCode barCode, String string, Style style) throws IOException {
    }

    protected void writeImage(int n, int n2, int n3, String string, int n4, int n5, Style style, String string2) {
    }

    private void writeRulerIfNeeded() throws IOException {
        if (this.m_testMode) {
            // empty if block
        }
    }

    protected void writePageHeader() throws IOException {
        int n = this.m_countPages - 1;
        int n2 = this.m_countPages + 1;
        if (this.m_countPages == 1 || this.m_largeReport) {
            if (this.m_testMode) {
                this.write("\n<table border='1' cellspacing='0' cellpadding='0' class='main'>");
                this.writeRulerIfNeeded();
            } else {
                this.write("\n<table border='0' cellspacing='0' cellpadding='0' class='main'>");
            }
        }
        this.write("<tr><td colspan=" + (this.m_pwidth + 2) + ">");
        if (this.m_countPages == 1) {
            this.write("<div id=\"" + this.m_countPages + "\" class=\"default-bg\"><span>");
        } else {
            this.write("<div id=\"" + this.m_countPages + "\" class=\"newpage default-bg\"><span>");
        }
        if (this.m_showNavigation) {
            if (this.m_showCompanyLogo) {
                if (this.m_testMode) {
                    this.write("<img name='clogo' class='clogo' src='companylogo.gif'/>");
                } else {
                    this.write("<img name='clogo' class='clogo' src='../images/ssa/header/companylogo.gif'/>");
                }
            }
            this.write("<a class=\"nav firstPage\" onclick=\"gotoPage(1)\"><img src='../images/ssa/grid/icon_first15x15_enabled.png'/></a>");
            this.write("<a class=\"nav prevPage\"  onclick=\"gotoPage(" + n + ")\"><img src='../images/ssa/grid/icon_previous15x15_enabled.png'/></a>");
            this.write("<a class=\"nav nextPage\"  onclick=\"gotoPage(" + n2 + ")\"><img src='../images/ssa/grid/icon_next15x15_enabled.png'/></a>");
            this.write("<a class=\"nav lastPage\"  onclick=\"lastPage()\"><img src='../images/ssa/grid/icon_last15x15_enabled.png'/></a>");
        }
        this.write("</span></div>");
        this.write("</td></tr>\n");
        if (!this.m_largeReport && this.m_countPages == 1) {
            this.write("<tr style='visibility:hidden'>");
            for (int i = 1; i <= this.m_pwidth + 2; ++i) {
                this.write("<td>&nbsp;</td>");
            }
            this.write("</tr>\n");
        } else if (this.m_largeReport) {
            this.write("<tr style='visibility:hidden'>");
            for (int i = 1; i <= this.m_pwidth + 2; ++i) {
                this.write("<td>_</td>");
            }
            this.write("</tr>\n");
        }
    }

    private void writePageHeaderIfNeeded() throws IOException {
        if (this.m_pendingPagebreak) {
            if (this.getPass() == 1) {
                ++this.m_countPages;
            }
            this.writePageHeader();
        }
        this.m_pendingPagebreak = false;
    }

    protected void writeReportHeader(String string) throws IOException {
        this.write("<html>");
        this.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n");
        this.write("<title>" + string + "</title>\n");
        if (this.m_testMode) {
            this.write("<link href=\"report.css\" type=\"text/css\" rel=\"stylesheet\">");
        } else {
            this.write("<link href=\"../stylesheets/ssa/report.css\" type=\"text/css\" rel=\"stylesheet\">");
        }
        this.write("<style type=\"text/css\">\n");
        if (this.m_monospace) {
            this.write("body{" + this.m_monospacedFont + "}\n");
            this.write("table{" + this.m_monospacedFont + "}\n");
        } else {
            this.write("body{" + this.m_font + "}\n");
            this.write("table{" + this.m_font + "}\n");
            this.write(".mono{" + this.m_monospacedFont + "}\n");
        }
        this.write("</style>\n");
        if (this.m_bidi) {
            this.write("<body dir=\"RTL\">\n");
        } else {
            this.write("<body>\n");
        }
    }

    protected void writeStartOfNewLine() throws IOException {
        this.writeStartTag("tr");
        this.write("<td class='lc'>&nbsp;</td>");
    }

    protected void writeEmptyLine() throws IOException {
        this.write("\n<tr>\n\t<td>&nbsp;</td>\n</tr>");
    }

    protected void writePageBreakIfNeeded() throws IOException {
        if (this.m_largeReport) {
            this.write("\n</td></tr></table>");
        }
    }

    public int parseInt(String string, int n) {
        if (string == null || string.isEmpty()) {
            return n;
        }
        int n2 = n;
        try {
            n2 = (int)Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    protected double parseDouble(String string, double d) {
        if (string == null || string.isEmpty()) {
            return d;
        }
        double d2 = d;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    private String getFont(Attributes attributes, boolean bl) {
        Integer n;
        String string = attributes.getValue("fontsize");
        String string2 = attributes.getValue("font");
        if (string != null && !string.isEmpty()) {
            int n2;
            if (string2 == null || string2.isEmpty()) {
                string2 = this.m_currentRow.getRowFont();
            }
            if ((n2 = string2.indexOf(" (")) != -1) {
                string2 = string2.substring(0, n2);
            }
            return string2 + " (" + string + " pt)";
        }
        if (bl && this.m_currentRow.getRowFont().indexOf("pt)") != -1) {
            if (string2 == null || string2.isEmpty()) {
                return this.m_currentRow.getRowFont();
            }
            int n3 = string2.indexOf(" (");
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            n3 = this.m_currentRow.getRowFont().indexOf(" (");
            return string2 + this.m_currentRow.getRowFont().substring(n3);
        }
        if (bl && string2 != null && !string2.isEmpty() && (n = this.m_numberOfCharactersOnLinePerFont.get(string2)) != null) {
            double d = this.getFontSizeInPt(n);
            int n4 = string2.indexOf(" (");
            if (n4 != -1) {
                string2 = string2.substring(0, n4);
            }
            return string2 + " (" + d + " pt)";
        }
        if (bl && string2 != null && string2.indexOf("cpi") != -1) {
            double d = this.getFontSizePt(string2);
            int n5 = string2.indexOf(" (");
            if (n5 != -1) {
                string2 = string2.substring(0, n5);
            }
            return string2 + " (" + d + " pt)";
        }
        return string2;
    }

    protected double getFontSizeInPt(int n) {
        return (double)BML2PDF.DEFAULT_FONT_SIZE_FACTOR * 510.0 / (double)n;
    }

    private double getFontSizeCpi(String string) {
        int n = string.indexOf(" cpi") - 1;
        if (n > 0) {
            String string2 = "";
            char c = string.charAt(n);
            while (n > 0 && (Character.isDigit(c) || c == '.')) {
                string2 = c + string2;
                c = string.charAt(--n);
            }
            double d = 12.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return d;
        }
        return -1.0;
    }

    private double getFontSizePt(String string) {
        double d = this.getFontSizeCpi(string);
        if (d > 0.0) {
            double d2 = 120.0 / d;
            return d2;
        }
        return -1.0;
    }

    public static int getAlign(String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.toLowerCase()).contains("right")) {
            return 2;
        }
        if (string.contains("center")) {
            return 1;
        }
        if (string.contains("left")) {
            return 0;
        }
        if (string.contains("top")) {
            return 0;
        }
        if (string.contains("bottom")) {
            return 2;
        }
        return 0;
    }

    public static String getHAlign(Attributes attributes) {
        String string = attributes.getValue("align");
        if (string == null) {
            string = attributes.getValue("halign");
        }
        return string;
    }

    private Style createStyle(Style style, String string) {
        Style style2 = style.copy();
        if (this.m_currentStyles.size() > 0) {
            Style style3 = this.m_currentStyles.get(this.m_currentStyles.size() - 1);
            style2.merge(style3, false);
        }
        this.handleClasses(string, style2);
        return style2;
    }

    private void handleClasses(String string, Style style) {
        if (string != null) {
            String[] stringArray = string.split(" ");
            for (int i = 0; i < this.m_styles.size(); ++i) {
                String string2 = this.m_styles.get(i).getName();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3 = stringArray[j];
                    if (!string3.equals(string2)) continue;
                    Style style2 = this.getStyle(string3);
                    style.merge(style2, true);
                }
            }
        }
    }

    private void endStyle(String string) {
        this.m_currentStyles.remove(this.m_currentStyles.size() - 1);
    }

    private Style createStyle(String string, Attributes attributes) {
        Style style;
        Object object;
        if (this.m_currentStyles.size() > 0) {
            object = this.m_currentStyles.get(this.m_currentStyles.size() - 1);
            style = new Style();
            style.merge((Style)object, false);
        } else {
            style = new Style();
        }
        if (!string.equals("style")) {
            this.m_currentStyles.add(style);
        }
        object = attributes.getValue("class");
        this.handleClasses((String)object, style);
        String string2 = attributes.getValue("fgcolor");
        String string3 = attributes.getValue("bgcolor");
        String string4 = attributes.getValue("linefgcolor");
        String string5 = attributes.getValue("linebgcolor");
        String string6 = attributes.getValue("bgcolortopleft");
        String string7 = attributes.getValue("bgcolortopright");
        String string8 = attributes.getValue("bgcolorbottomleft");
        String string9 = attributes.getValue("bgcolorbottomright");
        String string10 = attributes.getValue("thickness");
        String string11 = attributes.getValue("linestyle");
        String string12 = attributes.getValue("height");
        String string13 = attributes.getValue("border");
        String string14 = attributes.getValue("borderleft");
        String string15 = attributes.getValue("borderright");
        String string16 = attributes.getValue("bordertop");
        String string17 = attributes.getValue("borderbottom");
        String string18 = attributes.getValue("bold");
        String string19 = attributes.getValue("italic");
        String string20 = attributes.getValue("underline");
        String string21 = attributes.getValue("monospace");
        String string22 = attributes.getValue("halign");
        String string23 = attributes.getValue("valign");
        if (string2 != null) {
            style.setForegroundColor(string2);
        }
        if (string3 != null) {
            style.setBackgroundColor(string3);
        }
        if (string4 != null) {
            style.setLineForegroundColor(string4);
        }
        if (string5 != null) {
            style.setLineBackgroundColor(string5);
        }
        if (string6 != null) {
            style.setBackgroundColor1(string6);
        }
        if (string7 != null) {
            style.setBackgroundColor2(string7);
        }
        if (string9 != null) {
            style.setBackgroundColor3(string9);
        }
        if (string8 != null) {
            style.setBackgroundColor4(string8);
        }
        if (string10 != null) {
            style.setThickness(this.parseDouble(string10, 0.0));
        }
        if (string11 != null) {
            style.setLineStyle(Style.BorderType.valueOf(string11));
        }
        if (string12 != null) {
            style.setHeight(this.parseInt(string12, 1));
        }
        if (string13 != null) {
            style.setBorder(Style.createBorder(string13));
        }
        if (string14 != null) {
            style.setBorderLeft(Style.createBorder(string14));
        }
        if (string15 != null) {
            style.setBorderRight(Style.createBorder(string15));
        }
        if (string16 != null) {
            style.setBorderTop(Style.createBorder(string16));
        }
        if (string17 != null) {
            style.setBorderBottom(Style.createBorder(string17));
        }
        if (string18 != null) {
            style.setBold("Yes".equals(string18));
        }
        if (string19 != null) {
            style.setItalic("Yes".equals(string19));
        }
        if (string20 != null) {
            style.setUnderline("Yes".equals(string20));
        }
        if (string21 != null) {
            style.setMonospace("Yes".equals(string21));
        }
        if (string22 != null) {
            style.setHAlign(BML2HTML.getAlign(string22));
        }
        if (string23 != null) {
            style.setVAlign(BML2HTML.getAlign(string23));
        }
        return style;
    }

    private void setStyle(String string, Attributes attributes, CellLayout cellLayout) {
        Style style = this.createStyle(string, attributes);
        cellLayout.setStyle(style);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block76: {
            try {
                if (string3.equals("report")) {
                    this.createStyle("report", attributes);
                    this.m_reportTitle = attributes.getValue("desc");
                    this.m_pwidth = this.parseInt(attributes.getValue("pwidth"), -1);
                    this.m_monospace = "Yes".equals(attributes.getValue("monospace"));
                    this.m_reportFont = this.getFont(attributes, false);
                    String string4 = attributes.getValue("justify");
                    if (string4 != null && !string4.isEmpty()) {
                        this.m_justify = "Yes".equals(string4);
                    }
                    if (this.getPass() == 1) {
                        this.m_countPages = 1;
                    }
                    if (this.m_pageNo != null) {
                        this.m_pageNo.reset(this.getPass());
                    }
                    this.m_pageNoTextCellLayoutIndex = 0;
                    this.m_pageNoPageBreak = 1;
                    break block76;
                }
                if (string3.equals("input_fields")) {
                    this.writeReportHeader(this.m_reportTitle);
                    this.writePageHeader();
                    break block76;
                }
                if (string3.equals("row")) {
                    this.writePageHeaderIfNeeded();
                    this.writeRulerIfNeeded();
                    this.createStyle(string3, attributes);
                    String string5 = attributes.getValue("layout");
                    this.m_currentRow = this.m_rowLayouts.get(string5);
                    this.m_currentRow.createTempStyles();
                    this.checkFixedOffset(attributes);
                    if (this.m_currentRow == null) {
                        if (this.m_testMode) {
                            System.err.println("There is no lline with this ID: " + string5 + ". Row will not be printed.");
                        }
                    } else {
                        this.writeStartOfNewLine();
                    }
                    break block76;
                }
                if (string3.equals("e")) {
                    this.m_currentClass = attributes.getValue("class");
                    this.startCharacters();
                    break block76;
                }
                if (string3.equals("body")) {
                    this.m_inBody = true;
                    break block76;
                }
                if (string3.equals("head")) {
                    this.m_inBody = false;
                    break block76;
                }
                if (string3.equals("barcode")) {
                    if (this.m_inBody) {
                        this.m_currentCharactersBeforeBarcode = this.getCharacters();
                        int n = this.parseInt(attributes.getValue("type"), -1);
                        int n2 = this.parseInt(attributes.getValue("height"), 3);
                        String string6 = attributes.getValue("options");
                        boolean bl = !"false".equals(attributes.getValue("base64"));
                        String string7 = attributes.getValue("caption");
                        if (string7 != null && !string7.isEmpty()) {
                            bl = false;
                        }
                        int n3 = -1;
                        CellLayout cellLayout = this.m_currentRow.get(false);
                        if (cellLayout != null) {
                            n3 = cellLayout.getWidth();
                        }
                        BarCode barCode = new BarCode(n, n3, n2, string6, this.m_currentCharactersBeforeBarcode.length(), bl);
                        if (string7 != null && !string7.isEmpty()) {
                            barCode.setValue(string7);
                        }
                        this.m_currentRow.addBarCode(barCode);
                        this.startCharacters();
                    } else {
                        int n = this.parseInt(attributes.getValue("col"), -1);
                        int n4 = this.parseInt(attributes.getValue("width"), -1);
                        int n5 = this.parseInt(attributes.getValue("height"), -1);
                        String string8 = attributes.getValue("barcodeType");
                        BarcodeCellLayout barcodeCellLayout = new BarcodeCellLayout(n, n4, n5, string8);
                        this.setStyle(string3, attributes, barcodeCellLayout);
                        this.m_currentRow.addCell(barcodeCellLayout);
                        this.m_currentBarcodeCellLayout = barcodeCellLayout;
                    }
                    break block76;
                }
                if (string3.equals("option")) {
                    this.m_currentOptionName = attributes.getValue("name");
                    this.startCharacters();
                    break block76;
                }
                if (string3.equals("pagebreak")) {
                    ++this.m_pageNoPageBreak;
                    if (this.m_pageNo != null) {
                        this.m_pageNo.nextPage(this.getPass());
                    }
                    this.writePageBreakIfNeeded();
                    this.m_pendingPagebreak = true;
                    break block76;
                }
                if (string3.equals("emptyline")) {
                    if (this.useExactPosition()) {
                        this.writePageHeaderIfNeeded();
                        this.checkFixedOffset(attributes);
                        String string9 = attributes.getValue("layout");
                        this.m_currentRow = this.m_rowLayouts.get(string9);
                        this.writeStartOfNewLine();
                    } else {
                        this.writePageHeaderIfNeeded();
                        if (this.m_waitingFields != null && this.m_waitingFields.size() > 0) {
                            RowLayout rowLayout = null;
                            String string10 = attributes.getValue("layout");
                            if (string10 != null) {
                                rowLayout = this.m_rowLayouts.get(string10);
                            }
                            if (rowLayout == null) {
                                rowLayout = new RowLayout();
                            }
                            this.m_currentRow = rowLayout;
                            this.writeStartOfNewLine();
                            this.writeRow();
                        } else {
                            String string11 = attributes.getValue("layout");
                            if (string11 != null && !string11.isEmpty()) {
                                this.m_currentRow = this.m_rowLayouts.get(string11);
                                this.writeStartOfNewLine();
                                this.writeRow();
                            } else {
                                this.writeEmptyLine();
                            }
                        }
                    }
                    break block76;
                }
                if (string3.equals("lline")) {
                    String string12;
                    this.createStyle(string3, attributes);
                    String string13 = attributes.getValue("id");
                    this.m_currentRow = new RowLayout();
                    this.m_currentRow.setFont(this.m_layoutFont);
                    if (this.m_layoutJustify != null) {
                        this.m_currentRow.setJustify(this.m_layoutJustify);
                    }
                    if ((string12 = attributes.getValue("justify")) != null && !string12.isEmpty()) {
                        this.m_currentRow.setJustify("Yes".equals(string12));
                    }
                    this.m_rowLayouts.put(string13, this.m_currentRow);
                    for (int i = 0; i < this.m_fieldsWithHeightHigherThanOne.size(); ++i) {
                        Object[] objectArray = this.m_fieldsWithHeightHigherThanOne.elementAt(i);
                        CellLayout cellLayout = (CellLayout)objectArray[0];
                        int[] nArray = (int[])objectArray[1];
                        this.m_currentRow.addCell(cellLayout);
                        nArray[0] = nArray[0] - 1;
                        if (nArray[0] > 0) continue;
                        this.m_fieldsWithHeightHigherThanOne.remove(i);
                        --i;
                    }
                    break block76;
                }
                if (string3.equals("image") || string3.equals("signature")) {
                    int n = this.parseInt(attributes.getValue("col"), -1);
                    int n6 = this.parseInt(attributes.getValue("width"), -1);
                    int n7 = this.parseInt(attributes.getValue("height"), -1);
                    String string14 = attributes.getValue("halign");
                    int n8 = BML2HTML.getAlign(string14);
                    String string15 = attributes.getValue("valign");
                    int n9 = BML2HTML.getAlign(string15);
                    ImageCellLayout imageCellLayout = new ImageCellLayout(n, n6, n7, n8, n9, string3.equals("signature") ? attributes.getValue("id") : null);
                    this.setStyle(string3, attributes, imageCellLayout);
                    this.m_currentRow.addCell(imageCellLayout);
                    break block76;
                }
                if (string3.equals("special") || string3.equals("field")) {
                    boolean bl;
                    String string16;
                    boolean bl2;
                    String string17 = BML2HTML.getHAlign(attributes);
                    String string18 = attributes.getValue("fldtype");
                    boolean bl3 = bl2 = string18 != null && (string18.equalsIgnoreCase("double") || string18.equalsIgnoreCase("float") || string18.equalsIgnoreCase("integer"));
                    if (!bl2 && (string16 = attributes.getValue("difo")) != null && string16.startsWith("%A")) {
                        bl2 = true;
                    }
                    if ((string17 == null || string17.equals("") || string17.toLowerCase().startsWith("not")) && bl2) {
                        string17 = "Right";
                    }
                    boolean bl4 = false;
                    if (bl2) {
                        bl4 = true;
                    }
                    int n = this.parseInt(attributes.getValue("col"), -1);
                    int n10 = this.parseInt(attributes.getValue("width"), -1);
                    TextCellLayout textCellLayout = new TextCellLayout(n, n10, string17, bl4);
                    if ("Page No.".equals(attributes.getValue("type")) || "lattr.pageno".equals(attributes.getValue("fldname"))) {
                        if (this.getPass() == 1) {
                            if (this.m_pageNo == null) {
                                this.m_pageNo = new PageNo();
                            }
                            PageNoTextCellLayout pageNoTextCellLayout = new PageNoTextCellLayout(n, n10, string17, bl4, this.m_pageNo);
                            this.m_pageNoTextCellLayouts.add(pageNoTextCellLayout);
                            textCellLayout = pageNoTextCellLayout;
                        } else {
                            textCellLayout = this.m_pageNoTextCellLayouts.get(this.m_pageNoTextCellLayoutIndex);
                            ++this.m_pageNoTextCellLayoutIndex;
                        }
                    } else if ("Total Pages".equals(attributes.getValue("type"))) {
                        textCellLayout = new NPagesTextCellLayout(n, n10, string17, bl4);
                    }
                    this.setStyle(string3, attributes, textCellLayout);
                    if (!"Yes".equals(attributes.getValue("eformatted"))) {
                        textCellLayout.setDifo(attributes.getValue("difo"));
                    }
                    if (bl = "Yes".equals(attributes.getValue("showAsImage"))) {
                        int n11 = attributes.getValue("height") == null ? 1 : this.parseInt(attributes.getValue("height"), -1);
                        int n12 = BML2HTML.getAlign(attributes.getValue("halign"));
                        int n13 = BML2HTML.getAlign(attributes.getValue("valign"));
                        ImageCellLayout imageCellLayout = new ImageCellLayout(n, n10, n11, n12, n13, null);
                        this.m_currentRow.addCell(imageCellLayout);
                    } else {
                        String string19;
                        int n14;
                        int n15;
                        this.m_currentRow.addCell(textCellLayout);
                        int n16 = n15 = attributes.getValue("height") == null ? 0 : this.parseInt(attributes.getValue("height"), -1);
                        if (n15 > 1) {
                            this.m_fieldsWithHeightHigherThanOne.addElement(new Object[]{textCellLayout.copy(), new int[]{n15 - 1}});
                        }
                        int n17 = n14 = attributes.getValue("skip") == null ? 0 : this.parseInt(attributes.getValue("skip"), -1);
                        if (n14 > 0) {
                            textCellLayout.setWait(n14);
                            textCellLayout.setCurrentWait(n14);
                        }
                        if ((string19 = this.getFont(attributes, true)) != null && !string19.equals("")) {
                            textCellLayout.setFont(string19);
                        }
                    }
                    break block76;
                }
                if (string3.equals("text")) {
                    int n;
                    String string20 = BML2HTML.getHAlign(attributes);
                    int n18 = BML2HTML.getAlign(string20);
                    String string21 = this.getFont(attributes, true);
                    Style style = this.createStyle(string3, attributes);
                    String string22 = attributes.getValue("width");
                    String string23 = attributes.getValue("content");
                    int n19 = -1;
                    if (string22 != null && !string22.isEmpty()) {
                        try {
                            n19 = Integer.parseInt(string22);
                            if (n19 == string23.length()) {
                                n19 = -1;
                            }
                        }
                        catch (Exception exception) {
                            n19 = -1;
                        }
                    }
                    int n20 = n = attributes.getValue("skip") == null ? 0 : this.parseInt(attributes.getValue("skip"), -1);
                    if (n19 == -1) {
                        this.addCells(this.parseInt(attributes.getValue("col"), -1), string23, string21, n18, n, style);
                    } else {
                        this.addCell(this.parseInt(attributes.getValue("col"), -1), string23, n19, -1, string21, n18, n, style);
                    }
                    break block76;
                }
                if (string3.equals("bgitem")) {
                    int n = this.parseInt(attributes.getValue("col"), -1);
                    int n21 = this.parseInt(attributes.getValue("width"), -1);
                    LinesCellLayout linesCellLayout = new LinesCellLayout(n, n21, -1);
                    this.setStyle(string3, attributes, linesCellLayout);
                    this.m_currentRow.addCell(linesCellLayout);
                } else if (string3.equals("layout")) {
                    this.createStyle(string3, attributes);
                    String string24 = this.getFont(attributes, false);
                    if (string24 != null && !string24.equals("")) {
                        this.m_layoutFont = string24;
                        if (this.m_reportFont.indexOf("pt)") != -1 && this.m_layoutFont.indexOf("pt)") == -1) {
                            int n = this.m_layoutFont.indexOf(" (");
                            if (n != -1) {
                                this.m_layoutFont = this.m_layoutFont.substring(0, n);
                            }
                            n = this.m_reportFont.indexOf(" (");
                            this.m_layoutFont = this.m_layoutFont + this.m_reportFont.substring(n);
                        }
                    }
                    this.m_layoutJustify = null;
                    String string25 = attributes.getValue("justify");
                    if (string25 != null && !string25.isEmpty()) {
                        this.m_layoutJustify = "Yes".equals(string25);
                    }
                    if (this.useExactPosition()) {
                        String string26 = attributes.getValue("id");
                        this.m_currentRow = new RowLayout();
                        this.m_currentRow.setFont(this.m_layoutFont);
                        this.m_rowLayouts.put(string26, this.m_currentRow);
                        this.m_currentRow.setHeight((float)this.parseDouble(attributes.getValue("height"), -1.0));
                        this.m_currentRow.setFixedOffset((float)this.parseDouble(attributes.getValue("fixedoffset"), -1.0));
                    }
                } else if (string3.equals("locale")) {
                    this.m_locale = attributes.getValue("value");
                } else if (string3.equals("bidi")) {
                    if (!this.m_bidi) {
                        this.m_bidi = "1".equals(attributes.getValue("value"));
                    }
                } else if (string3.equals("style") && this.getPass() == 1) {
                    String string27 = attributes.getValue("name");
                    Style style = this.createStyle(string3, attributes);
                    style.setName(string27);
                    this.m_styles.add(style);
                }
            }
            catch (BMLConverter.StopParsingException stopParsingException) {
                throw stopParsingException;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    public Style getStyle(String string) {
        for (Style style : this.m_styles) {
            if (!string.equals(style.getName())) continue;
            return style;
        }
        return Style.EMPTY_STYLE;
    }

    private void checkFixedOffset(Attributes attributes) {
        this.m_rowFixedOffset = -1.0f;
        String string = attributes.getValue("fixedoffset");
        if (string != null && !string.isEmpty()) {
            this.m_rowFixedOffset = (float)this.parseDouble(attributes.getValue("fixedoffset"), -1.0);
        }
    }

    private void addCells(int n, String string, String string2, int n2, int n3, Style style) {
        int n4 = -1;
        int n5 = n;
        String string3 = "";
        boolean bl = string.indexOf("---") != -1 || string.indexOf("===") != -1;
        Style style2 = style.copy();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n6 = string3.length();
            boolean bl3 = bl2 = c >= '\u2501' && c <= '\u256c';
            if (bl2 && n6 > 0) {
                this.addCell(n5, string3, -1, n4, string2, n2, n3, style);
                style = style2;
                n5 += n6;
                string3 = "";
            }
            string3 = string3 + c;
            if (c == '\u2500' || bl && (c == '-' || c == '=')) {
                if (n6 > 0 && n4 != 1 && n4 != 12) {
                    string3 = string3.substring(0, string3.length() - 1);
                    this.addCell(n5, string3, -1, n4, string2, n2, n3, style);
                    style = style2;
                    n5 += string3.length();
                    string3 = "" + c;
                }
                if (c == '=') {
                    if (style.getForegroundColor() == null) {
                        style = style.copy();
                        style.setForegroundColor("0x000000");
                    }
                    n4 = 12;
                } else if (c == '-') {
                    if (style.getForegroundColor() == null) {
                        style = style.copy();
                        style.setForegroundColor("0x000000");
                    }
                    n4 = 1;
                } else {
                    n4 = 1;
                }
            } else if (c == '\u2502') {
                n4 = 2;
            } else if (bl2) {
                n4 = c == '\u2502' || c == '\u2503' || c == '\u2506' || c == '\u2507' || c == '\u250a' || c == '\u250b' ? 2 : (c <= '\u250b' ? 1 : (c <= '\u250f' ? 3 : (c <= '\u2513' ? 4 : (c <= '\u2517' ? 5 : (c <= '\u251b' ? 6 : (c <= '\u2523' ? 7 : (c <= '\u252b' ? 8 : (c <= '\u2533' ? 9 : (c <= '\u253b' ? 10 : 11)))))))));
            } else if ((n4 == 1 || n4 == 12) && string3.length() > 1) {
                string3 = string3.substring(0, string3.length() - 1);
                this.addCell(n5, string3, -1, n4, string2, n2, n3, style);
                style = style2;
                n5 += string3.length();
                string3 = "" + c;
                n4 = -1;
            }
            if (!bl2) continue;
            this.addCell(n5, string3, -1, n4, string2, n2, n3, style);
            style = style2;
            ++n5;
            string3 = "";
            n4 = -1;
        }
        if (string3.length() > 0) {
            this.addCell(n5, string3, -1, n4, string2, n2, n3, style);
        }
        style = style2;
    }

    private CellLayout addCell(int n, String string, int n2, int n3, String string2, int n4, int n5, Style style) {
        CellLayout cellLayout = null;
        if (n3 < 0) {
            int n6 = string.length();
            if (n2 < 0) {
                if (string.indexOf("%npages;") != -1) {
                    n6 -= 6;
                } else if (string.indexOf("%pageno;") != -1) {
                    n6 -= 6;
                }
            } else {
                n6 = n2;
            }
            cellLayout = new TextCellLayout(n, string, n6, n4);
            if (string2 != null && !string2.isEmpty()) {
                ((TextCellLayout)cellLayout).setFont(string2);
            }
            cellLayout.setStyle(style);
            if (n5 > 0) {
                ((TextCellLayout)cellLayout).setWait(n5);
                ((TextCellLayout)cellLayout).setCurrentWait(n5);
            }
        } else {
            cellLayout = new LinesCellLayout(n, string.length(), n3);
            cellLayout.setStyle(style);
        }
        this.m_currentRow.addCell(cellLayout);
        return cellLayout;
    }

    protected void writeReportEnd() throws IOException {
        this.write("\n</table>");
        if (this.m_showNavigation) {
            this.write("\n<script type=\"text/javascript\">");
            this.write("\n\t function lastPage() {");
            this.write("\n\t\t gotoPage(" + this.m_countPages + ");");
            this.write("\n}");
            this.write("\n\t function gotoPage(page) {");
            this.write("\n\t\t var elem = document.getElementById(page);");
            this.write("\n\t\t var top = elem.offsetTop - 8;");
            this.write("\n\t\t var cur = elem.offsetParent;");
            this.write("\n\t\t while (cur && (cur.nodeType == 1)) {");
            this.write("\n\t\t   top += cur.offsetTop;");
            this.write("\n\t\t   cur = cur.offsetParent;");
            this.write("\n\t\t }");
            this.write("\n\t\t window.scrollTo(0, top);");
            this.write("\n}");
            this.write("\n</script>");
        }
        this.write("\n</body>");
        this.write("\n</html>");
    }

    protected void writeEndOfLine() throws IOException {
        this.write("<td class='rc'>&nbsp;</td>");
        this.writeEndTag();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.endStyle(string3);
                this.m_pendingPagebreak = false;
                this.writeReportEnd();
            } else if (string3.equals("e")) {
                if (this.m_currentRow != null && this.isCharactersStarted()) {
                    this.m_currentRow.addE(this.getCharacters(), this.m_currentClass);
                    this.stopCharacters();
                }
            } else if (string3.equals("barcode")) {
                if (this.m_inBody) {
                    if (this.m_currentRow != null && this.isCharactersStarted()) {
                        String string4 = this.getCharacters();
                        if (this.m_currentRow.getCurrentBarCode().getValue() == null) {
                            this.m_currentRow.getCurrentBarCode().setValue(string4);
                        }
                        this.startCharacters();
                        this.addCharacters(this.m_currentCharactersBeforeBarcode);
                    }
                } else {
                    this.endStyle(string3);
                    this.m_currentBarcodeCellLayout = null;
                }
            } else if (string3.equals("option")) {
                if (this.m_currentOptionName != null && this.m_currentBarcodeCellLayout != null) {
                    this.m_currentBarcodeCellLayout.addOption(this.m_currentOptionName, this.getCharacters());
                    this.stopCharacters();
                }
            } else if (string3.equals("row")) {
                this.writeRow();
                this.endStyle(string3);
            } else if (string3.equals("emptyline")) {
                if (this.useExactPosition()) {
                    this.writeRow();
                }
            } else if (string3.equals("lline")) {
                if (this.m_currentRow != null) {
                    this.m_currentRow.sort();
                }
                this.endStyle(string3);
            } else if (string3.equals("layout")) {
                this.endStyle(string3);
                this.m_layoutFont = null;
            } else if (string3.equals("special") || string3.equals("field") || string3.equals("text") || string3.equals("bgitem")) {
                this.endStyle(string3);
            } else if (string3.equals("image") || string3.equals("signature")) {
                this.endStyle(string3);
            }
        }
        catch (BMLConverter.StopParsingException stopParsingException) {
            throw stopParsingException;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void writeRow() throws IOException {
        if (this.m_currentRow != null) {
            ArrayList<TextCellLayout> arrayList = new ArrayList<TextCellLayout>();
            for (TextCellLayout textCellLayout : this.m_waitingFields) {
                arrayList.add(textCellLayout);
            }
            for (TextCellLayout textCellLayout : arrayList) {
                this.m_currentRow.addCell(textCellLayout);
            }
            this.m_currentRow.writeHTML();
            for (TextCellLayout textCellLayout : arrayList) {
                this.m_currentRow.removeCell(textCellLayout);
            }
            this.m_currentRow.clearEs();
            this.writeEndOfLine();
        }
    }

    private void fillNumberOfCharactersOnLinePerFont(String string, int n) {
        if (string != null) {
            if (this.m_numberOfCharactersOnLinePerFont.containsKey(string)) {
                Integer n2 = this.m_numberOfCharactersOnLinePerFont.get(string);
                if (n2 < n) {
                    this.m_numberOfCharactersOnLinePerFont.put(string, new Integer(n));
                }
            } else {
                this.m_numberOfCharactersOnLinePerFont.put(string, new Integer(n));
            }
        }
    }

    @Override
    public void convert(String string, String string2) throws SAXException, IOException {
        File file = this.getLocalFile(string);
        this.m_largeReport = file.length() / 1024L > 500L;
        super.convert(string, string2);
    }

    public static void convertBML(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
        try {
            BML2HTML bML2HTML = new BML2HTML();
            bML2HTML.m_showCompanyLogo = bl;
            bML2HTML.m_showNavigation = bl2;
            bML2HTML.m_font = string3;
            bML2HTML.m_monospacedFont = string4;
            bML2HTML.m_monospacedFont = string4.replaceAll("Monospaced", "Courier New");
            bML2HTML.m_bidi = bl3;
            bML2HTML.convert(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void convertBML2HTML(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
        BML2HTML.convertBML(string, string2, bl, bl2, string3, string4, bl3);
    }

    public static String convertToHTML(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
        try {
            final int[] nArray = new int[]{0};
            XMLReader xMLReader = IOUtils.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                @Override
                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (string3.equals("pagebreak")) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            });
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            xMLReader.parse(string);
            int n = 100;
            if (nArray[0] > n) {
                return BML2PDF.convertToPDF(string, string2, bl, bl2, string3, string4, bl3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BML2HTML.convertBML(string, string2, bl, bl2, string3, string4, bl3);
        return "HTML";
    }

    public boolean isMonospaced() {
        return this.m_monospace;
    }

    public int getNumberOfPages() {
        if (this.m_pageNo != null) {
            return this.m_pageNo.getNumberOfPages();
        }
        return this.m_countPages;
    }

    public CellLayout getLastAddedCell() {
        return this.m_currentRow.getLastAddedCell();
    }

    public float getRowHeight() {
        return this.m_currentRow.getHeight();
    }

    public boolean isFirstTextOfCurrentLineRtl() {
        return this.m_currentRow.m_firstTextIsRtl;
    }

    public float getRowFixedOffset() {
        if (this.m_rowFixedOffset < 0.0f && this.m_currentRow != null) {
            return this.m_currentRow.getFixedOffset();
        }
        return this.m_rowFixedOffset;
    }

    public boolean useExactPosition() {
        return false;
    }

    public boolean isRtlText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            return c >= '\u05d0' && c <= '\u06ff';
        }
        return false;
    }

    public class RowLayout {
        private int m_index = 0;
        private Vector<CellLayout> m_cellLayouts = new Vector();
        private String m_rowFont;
        private Boolean m_rowJustify;
        private float m_height = -1.0f;
        private float m_fixedOffset = -1.0f;
        private boolean m_firstTextIsRtl = false;

        public void setFont(String string) {
            this.m_rowFont = string;
        }

        public void setJustify(boolean bl) {
            this.m_rowJustify = bl;
        }

        public void addCell(CellLayout cellLayout) {
            this.m_cellLayouts.addElement(cellLayout);
        }

        public void removeCell(CellLayout cellLayout) {
            this.m_cellLayouts.removeElement(cellLayout);
        }

        public boolean hasCell(CellLayout cellLayout) {
            return this.m_cellLayouts.contains(cellLayout);
        }

        public CellLayout getLastAddedCell() {
            return this.m_cellLayouts.lastElement();
        }

        public void setHeight(float f) {
            this.m_height = f;
        }

        public float getHeight() {
            return this.m_height;
        }

        public void setFixedOffset(float f) {
            this.m_fixedOffset = f;
        }

        public float getFixedOffset() {
            return this.m_fixedOffset;
        }

        public void sort() {
            Collections.sort(this.m_cellLayouts);
            CellLayout cellLayout = null;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cellLayout2 = this.m_cellLayouts.elementAt(i);
                if (cellLayout2.canOverlap()) continue;
                if (cellLayout != null) {
                    int n = cellLayout.getCol();
                    if (cellLayout.getWidth() != 1) {
                        int n2 = cellLayout2.getCol() - n;
                        if (cellLayout instanceof TextCellLayout && cellLayout2 instanceof TextCellLayout && cellLayout2.getWidth() > 2) {
                            --n2;
                        }
                        if (cellLayout.getWidth() < n2) {
                            boolean bl = true;
                            if (cellLayout instanceof TextCellLayout && ((TextCellLayout)cellLayout).getAlign() != 0) {
                                bl = false;
                            }
                            if (!cellLayout.isExpandable()) {
                                bl = false;
                            }
                            if (bl) {
                                cellLayout.setWidth(n2);
                            }
                        } else if (cellLayout.getWidth() > n2) {
                            cellLayout.setWidth(n2);
                        }
                    }
                }
                cellLayout = cellLayout2;
            }
            if (this.m_cellLayouts.size() > 0) {
                CellLayout cellLayout3 = this.m_cellLayouts.lastElement();
                int n = cellLayout3.getCol() + cellLayout3.getWidth() - 1;
                BML2HTML.this.fillNumberOfCharactersOnLinePerFont(BML2HTML.this.m_layoutFont, n);
            }
        }

        public int getNumberOfCharacters() {
            Integer n;
            if (this.m_rowFont != null && (n = (Integer)BML2HTML.this.m_numberOfCharactersOnLinePerFont.get(this.m_rowFont)) != null) {
                return n;
            }
            return BML2HTML.this.m_pwidth;
        }

        public String getRowFont() {
            if (this.m_rowFont == null) {
                return BML2HTML.this.m_reportFont;
            }
            return this.m_rowFont;
        }

        public boolean getRowJustify() {
            if (this.m_rowJustify != null) {
                return this.m_rowJustify;
            }
            if (BML2HTML.this.m_justify != null) {
                return BML2HTML.this.m_justify;
            }
            return true;
        }

        public void createTempStyles() {
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cellLayout = this.m_cellLayouts.get(i);
                if (cellLayout.hasE() || BML2HTML.this.m_currentStyles.size() <= 0) continue;
                this.createTempStyle(cellLayout, null);
            }
        }

        private void createTempStyle(CellLayout cellLayout, String string) {
            cellLayout.backup();
            Style style = cellLayout.getStyle();
            Style style2 = BML2HTML.this.createStyle(style, string);
            cellLayout.setStyle(style2);
        }

        public void addE(String string, String string2) {
            CellLayout cellLayout = this.get(true);
            if (cellLayout != null) {
                if (string2 != null || BML2HTML.this.m_currentStyles.size() > 0) {
                    this.createTempStyle(cellLayout, string2);
                }
                cellLayout.setText(string);
            }
        }

        public void clearEs() {
            this.m_index = 0;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cellLayout = this.m_cellLayouts.elementAt(i);
                cellLayout.setText("");
                cellLayout.setBarCode(null);
                cellLayout.restore();
            }
        }

        public int getIndex() {
            return this.m_index;
        }

        private CellLayout get(boolean bl) {
            while (this.m_index < this.m_cellLayouts.size()) {
                CellLayout cellLayout = this.m_cellLayouts.get(this.m_index);
                if (!cellLayout.hasE()) {
                    ++this.m_index;
                    continue;
                }
                if (bl) {
                    ++this.m_index;
                }
                return cellLayout;
            }
            if (bl) {
                ++this.m_index;
            }
            return null;
        }

        public void addBarCode(BarCode barCode) {
            CellLayout cellLayout = this.get(false);
            if (cellLayout != null) {
                cellLayout.setBarCode(barCode);
            }
        }

        public BarCode getCurrentBarCode() {
            CellLayout cellLayout = this.m_cellLayouts.get(this.m_index);
            return cellLayout.getBarCode();
        }

        public String getFont(CellLayout cellLayout) {
            if (cellLayout == null) {
                return BML2HTML.this.m_reportFont;
            }
            if (cellLayout instanceof TextCellLayout && ((TextCellLayout)cellLayout).getFont() != null) {
                return ((TextCellLayout)cellLayout).getFont();
            }
            if (this.m_rowFont != null) {
                return this.m_rowFont;
            }
            return BML2HTML.this.m_reportFont;
        }

        public String replaceTabs(String string, int n) {
            if (string == null) {
                return null;
            }
            if (BML2HTML.this.useExactPosition()) {
                return string;
            }
            string = string.replaceAll("\n", "");
            int n2 = string.indexOf("\t");
            while (n2 != -1) {
                int n3 = n - n2 % n;
                string = string.substring(0, n2) + this.spaces(n3) + string.substring(n2 + 1);
                n2 = string.indexOf("\t");
            }
            return string;
        }

        public String spaces(int n) {
            String string = "                                         ";
            return string.substring(0, n);
        }

        public void writeHTML() throws IOException {
            int n = this.getNumberOfCharacters();
            BML2HTML.this.setNumberOfCharactersForTheCurrentLine(n, this.getRowFont(), this.getRowJustify());
            boolean bl = false;
            this.m_firstTextIsRtl = false;
            int n2 = 1;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                Object object;
                CellLayout cellLayout = this.m_cellLayouts.elementAt(i);
                String string = cellLayout.getText();
                if (string == null) {
                    string = "";
                }
                if (string.length() > 0 && !bl) {
                    bl = true;
                    this.m_firstTextIsRtl = BML2HTML.this.isRtlText(string);
                }
                if (cellLayout instanceof LinesCellLayout && ((LinesCellLayout)(object = (LinesCellLayout)cellLayout)).getBorderType() == -1) {
                    BML2HTML.this.writeBorderCell(cellLayout.getCol(), cellLayout.getWidth(), -1, ((CellLayout)object).getStyle());
                    continue;
                }
                if (n2 < cellLayout.getCol() && !BML2HTML.this.useExactPosition()) {
                    BML2HTML.this.writeTextCell("", n2, cellLayout.getCol() - n2, 0, false, "", null);
                    n2 = n2 + cellLayout.getCol() - n2;
                } else if (n2 > cellLayout.getCol()) {
                    n2 = cellLayout.getCol();
                }
                if (cellLayout instanceof TextCellLayout) {
                    string = ((TextCellLayout)cellLayout).formatAccordingToDifo(string);
                    if ((string = this.replaceTabs(string, BML2HTML.this.m_numberOfSpacesForTab)).indexOf("%npages;") != -1) {
                        string = string.replaceAll("%npages;", "" + BML2HTML.this.getNumberOfPages());
                    }
                    if (string.indexOf("%pageno;") != -1) {
                        PageNoTextCellLayout pageNoTextCellLayout;
                        object = "" + BML2HTML.this.m_pageNoPageBreak;
                        PageNoTextCellLayout pageNoTextCellLayout2 = pageNoTextCellLayout = BML2HTML.this.m_pageNoTextCellLayouts.size() > 0 ? (PageNoTextCellLayout)BML2HTML.this.m_pageNoTextCellLayouts.get(0) : null;
                        if (pageNoTextCellLayout != null && pageNoTextCellLayout.getText() != null) {
                            object = pageNoTextCellLayout.getText();
                        }
                        string = string.replaceAll("%pageno;", (String)object);
                    }
                }
                if (cellLayout instanceof LinesCellLayout) {
                    object = (LinesCellLayout)cellLayout;
                    int n3 = ((LinesCellLayout)object).getBorderType();
                    if (BML2HTML.this.isBidi()) {
                        if (n3 == 3) {
                            n3 = 4;
                        } else if (n3 == 4) {
                            n3 = 3;
                        } else if (n3 == 5) {
                            n3 = 6;
                        } else if (n3 == 6) {
                            n3 = 5;
                        } else if (n3 == 7) {
                            n3 = 8;
                        } else if (n3 == 8) {
                            n3 = 7;
                        }
                    }
                    BML2HTML.this.writeBorderCell(n2, cellLayout.getWidth(), n3, ((CellLayout)object).getStyle());
                } else if (cellLayout instanceof TextCellLayout) {
                    object = (TextCellLayout)cellLayout;
                    BML2HTML.this.writeTextCell(string, n2, ((CellLayout)object).getWidth(), ((TextCellLayout)object).getAlign(), ((TextCellLayout)object).addAnotherCellForTheMinusSign(), this.getFont(cellLayout), ((CellLayout)object).getStyle());
                    if (((CellLayout)object).getBarCode() != null) {
                        this.writeBarcode(n2, ((CellLayout)object).getWidth(), ((CellLayout)object).getBarCode(), this.getFont(cellLayout), cellLayout.getStyle());
                    }
                } else if (cellLayout instanceof ImageCellLayout) {
                    object = string;
                    BML2HTML.this.writeImage(n2, cellLayout.getWidth(), ((ImageCellLayout)cellLayout).getHeight(), (String)object, ((ImageCellLayout)cellLayout).getHAlign(), ((ImageCellLayout)cellLayout).getVAlign(), cellLayout.getStyle(), ((ImageCellLayout)cellLayout).getSignatureId());
                } else if (cellLayout instanceof BarcodeCellLayout) {
                    object = new BarCode(-1, ((BarcodeCellLayout)cellLayout).getWidth(), ((BarcodeCellLayout)cellLayout).getHeight(), ((BarcodeCellLayout)cellLayout).getOptions(), 1, true);
                    ((BarCode)object).setValue(string);
                    ((BarCode)object).setJ4LType(((BarcodeCellLayout)cellLayout).getType());
                    BML2HTML.this.writeBarcode(n2, cellLayout.getWidth(), (BarCode)object, null, cellLayout.getStyle());
                }
                if (cellLayout instanceof TextCellLayout) {
                    object = (TextCellLayout)cellLayout;
                    if (((TextCellLayout)object).getCurrentWait() > 0) {
                        if (((TextCellLayout)object).getCurrentWait() == ((TextCellLayout)object).getWait()) {
                            TextCellLayout textCellLayout = (TextCellLayout)((CellLayout)object).copy();
                            textCellLayout.setCurrentWait(textCellLayout.getWait() - 1);
                            textCellLayout.setWait(-1);
                            BML2HTML.this.m_waitingFields.add(textCellLayout);
                        } else {
                            ((TextCellLayout)object).setCurrentWait(((TextCellLayout)object).getCurrentWait() - 1);
                        }
                    } else if (((TextCellLayout)object).getWait() == -1) {
                        BML2HTML.this.m_waitingFields.remove(object);
                    }
                }
                if (cellLayout.getWidth() <= 0) continue;
                n2 += cellLayout.getWidth();
            }
        }

        public void writeBarcode(int n, int n2, BarCode barCode, String string, Style style) throws IOException {
            BML2HTML.this.writeBarcode(n + barCode.m_position, n2 - barCode.m_position, barCode, string, style);
        }
    }

    public class BarCode {
        private int m_width;
        private int m_height;
        private int m_type;
        private String m_options;
        private int m_position;
        private String m_value;
        private boolean m_base64Encoded;
        private String m_j4lType;
        private boolean m_rotated = false;

        public BarCode(int n, int n2, int n3, String string, int n4, boolean bl) {
            this.m_type = n;
            this.m_width = n2;
            this.m_height = n3;
            this.m_options = string;
            this.m_position = n4;
            this.m_base64Encoded = bl;
        }

        public void setValue(String string) {
            if (this.m_base64Encoded) {
                try {
                    byte[] byArray = Base64.decode((String)string);
                    string = new String(byArray, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_value = string;
        }

        public String getJ4LType() {
            return this.m_j4lType;
        }

        public void setJ4LType(String string) {
            this.m_j4lType = string;
        }

        public String getOptions() {
            return this.m_options;
        }

        public int getPosition() {
            return this.m_position;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public String getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }

        public void setRotated(boolean bl) {
            this.m_rotated = bl;
        }

        public boolean isRotated() {
            return this.m_rotated;
        }
    }
}

