/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2BIRT;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.birt.BML2BIRTException;
import com.ssaglobal.bml.birt.ReportDesign;
import com.ssaglobal.bml.birt.ReportField;
import com.ssaglobal.bml.birt.ReportLayout;
import com.ssaglobal.bml.birt.ReportLine;
import com.ssaglobal.bml.birt.ReportModel;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.birt.core.framework.Platform;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2BIRTDesign
extends DefaultHandler {
    private ReportModel m_current_model;
    private ReportLayout m_current_layout;
    private ReportLine m_current_line;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.m_current_model = new ReportModel(attributes);
            } else if (string3.equals("layout")) {
                this.m_current_layout = new ReportLayout(attributes);
                this.m_current_model.add(this.m_current_layout);
            } else if (string3.equals("lline")) {
                String string4 = attributes.getValue("id");
                this.m_current_line = new ReportLine(string4, this.m_current_line);
                this.m_current_layout.add(this.m_current_line);
            } else if (string3.equals("special") || string3.equals("field") || string3.equals("text")) {
                ReportField reportField = new ReportField(string3, attributes);
                this.m_current_line.add(reportField);
            }
        }
        catch (Exception exception) {
            throw new SAXException(new BML2BIRTException(exception));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    public static void convertBML(String string, String string2, String string3, String string4) throws BML2BIRTException {
        try {
            BML2BIRTDesign bML2BIRTDesign = new BML2BIRTDesign();
            ReportModel reportModel = bML2BIRTDesign.convert("not_used", string, string2);
            bML2BIRTDesign = null;
            ReportDesign reportDesign = new ReportDesign();
            reportDesign.buildDesign(string4, string3, reportModel);
        }
        catch (Throwable throwable) {
            throw new BML2BIRTException(throwable);
        }
    }

    private ReportModel convert(String string, String string2, String string3) throws SAXException, IOException {
        XMLReader xMLReader = IOUtils.createXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        String string4 = BML2BIRT.BML2String(string3);
        StringReader stringReader = new StringReader(string4);
        InputSource inputSource = new InputSource(stringReader);
        xMLReader.parse(inputSource);
        stringReader.close();
        return this.m_current_model;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        System.out.println("Executing conversion with:");
        System.out.println("BML file:" + string2);
        System.out.println("Version:" + string);
        System.out.println("Output design file:" + string3);
        System.out.println("Birt template file:" + string4);
        System.out.println("Start");
        try {
            BML2BIRTDesign.convertBML(string, string2, string3, string4);
        }
        catch (Throwable throwable) {
            System.out.println("Error converting: " + string3);
            throwable.printStackTrace();
        }
        Platform.shutdown();
        System.out.println("Finished");
    }
}

