/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml.birt;

import org.xml.sax.Attributes;

public class ReportField {
    private String kind;
    private String id;
    private String fldtype;
    private String align;
    private int col;
    private int height;
    private int width;
    private String bold;
    private String underline;
    private String content;
    private String font;

    public ReportField(String string, Attributes attributes) {
        this.kind = string;
        this.id = null;
        this.fldtype = attributes.getValue("fldtype");
        this.align = attributes.getValue("align");
        String string2 = attributes.getValue("col");
        this.col = string2 == null ? 0 : Integer.parseInt(string2);
        String string3 = attributes.getValue("height");
        this.height = string3 == null ? 0 : Integer.parseInt(string3);
        String string4 = attributes.getValue("width");
        this.width = string4 == null ? 0 : Integer.parseInt(string4);
        this.bold = attributes.getValue("bold");
        this.underline = attributes.getValue("underline");
        this.content = attributes.getValue("content");
        this.font = attributes.getValue("font");
    }

    ReportField(ReportField reportField) {
        this.kind = reportField.kind;
        this.id = null;
        this.fldtype = reportField.fldtype;
        this.align = reportField.align;
        this.col = reportField.col;
        this.height = reportField.height - 1;
        this.width = reportField.width;
        this.bold = reportField.bold;
        this.underline = reportField.underline;
        this.content = reportField.content;
        this.font = reportField.font;
    }

    public int getStartPosition() {
        return this.col;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.kind.equals("text") ? this.content.length() : this.width;
    }

    public String getAlignment() {
        if ("left".equalsIgnoreCase(this.align)) {
            return "left";
        }
        if ("right".equalsIgnoreCase(this.align)) {
            return "right";
        }
        if ("centered".equalsIgnoreCase(this.align)) {
            return "center";
        }
        if ("double".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("float".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("integer".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("long".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        return "left";
    }

    public boolean hasDataItem() {
        return !this.hasText();
    }

    public String getName() {
        return this.id;
    }

    public void setName(String string) {
        this.id = string;
    }

    public boolean hasText() {
        return this.kind.equals("text");
    }

    public String getText() {
        return this.content == null ? "" : this.content;
    }

    public boolean isBold() {
        return "yes".equalsIgnoreCase(this.bold);
    }

    public boolean isUnderlined() {
        return "yes".equalsIgnoreCase(this.underline);
    }
}

