/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import com.ssaglobal.bml.NotoMapper;
import com.ssaglobal.bml.PDFTextWrap;
import java.util.ArrayList;
import java.util.List;

public class FallbackFontProvider
extends FontProvider {
    private PdfFont m_font;
    private FontProvider m_fallback;

    public FallbackFontProvider(PdfFont pdfFont, FontProvider fontProvider) {
        this.m_font = pdfFont;
        this.m_fallback = fontProvider;
    }

    public FontSelectorStrategy getStrategy(String string, List<String> list) {
        return new FallbackStrategy(string, this, null);
    }

    private class FallbackStrategy
    extends FontSelectorStrategy {
        private String m_remainingText;
        private PdfFont m_currentFont;

        public FallbackStrategy(String string, FontProvider fontProvider, FontSet fontSet) {
            super(string, fontProvider, fontSet);
            this.m_remainingText = string;
        }

        public PdfFont getCurrentFont() {
            return this.m_currentFont;
        }

        public List<Glyph> nextGlyphs() {
            FontSelectorStrategy fontSelectorStrategy;
            ArrayList<Object> arrayList = new ArrayList<Glyph>();
            if (this.m_remainingText.length() == 0) {
                return arrayList;
            }
            int n = 1;
            char c = this.m_remainingText.charAt(0);
            boolean bl = !FallbackFontProvider.this.m_font.containsGlyph((int)c);
            this.m_remainingText = this.m_remainingText.substring(1);
            PdfFont pdfFont = null;
            if (bl) {
                fontSelectorStrategy = FallbackFontProvider.this.m_fallback.getStrategy("" + c, PDFTextWrap.EMPTY);
                fontSelectorStrategy.nextGlyphs();
                pdfFont = fontSelectorStrategy.getCurrentFont();
            }
            while (this.m_remainingText.length() > 0) {
                c = this.m_remainingText.charAt(0);
                if (!bl && FallbackFontProvider.this.m_font.containsGlyph((int)c)) {
                    this.m_remainingText = this.m_remainingText.substring(1);
                    ++n;
                    continue;
                }
                if (bl && FallbackFontProvider.this.m_font.containsGlyph((int)c) || !bl) break;
                fontSelectorStrategy = FallbackFontProvider.this.m_fallback.getStrategy("" + c, PDFTextWrap.EMPTY);
                fontSelectorStrategy.nextGlyphs();
                PdfFont pdfFont2 = fontSelectorStrategy.getCurrentFont();
                if (pdfFont == null) {
                    this.m_remainingText = this.m_remainingText.substring(1);
                    ++n;
                    pdfFont = pdfFont2;
                    continue;
                }
                if (pdfFont != pdfFont2) break;
                this.m_remainingText = this.m_remainingText.substring(1);
                ++n;
                pdfFont = pdfFont2;
            }
            this.m_currentFont = bl ? pdfFont : FallbackFontProvider.this.m_font;
            arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList.add(NotoMapper.DUMMY);
            }
            return arrayList;
        }
    }
}

