/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.java4less.qrcode.QRCode;
import com.java4less.raztec.AztecCode;
import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.rdatamatrix.RDataMatrix;
import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.BarcodeParameter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.imageio.ImageIO;

public class BarcodeImageFactory {
    public static final int QRCODE = 500;
    public static final int AZTECCODE = 600;
    private static final String TRUE_VALUE = "true";
    private static final String BARCODE_1D_CLASS = "com.java4less.rbarcode.BarCode";
    private static final String BARCODE_PDF_CLASS = "com.java4less.rbarcode.BarCode2D";
    private static final String BARCODE_QRCODE_CLASS = "com.java4less.qrcode.QRCode";
    private static final String BARCODE_AZTECCODE_CLASS = "com.java4less.raztec.AztecCode";
    private static final String BARCODE_DATAMATRIX_CLASS = "com.java4less.rdatamatrix.RDataMatrix";
    private static final int PIXELS_PER_LINE = 50;
    private static final int PIXELS_PER_LINE_2D = 500;
    private static final int FONT_HEIGHT = 35;
    private static final int HORZ_MARGIN = 0;
    private static final int HORZ_MARGIN_EAN = 25;
    private static final int VERT_MARGIN = 0;
    private static final int NARROW_BAR_WIDTH = 5;
    private static final int PDF417_NARROW_BAR_WIDTH = 10;
    private static final int WIDE_BAR_NARROW_BAR_FACTOR = 2;
    private static final int MAX_WIDTH = 4000;
    private static final int MAX_HEIGHT = 3000;
    private final int barType;
    private final String value;
    private final Map<String, BarcodeParameter> parameters;
    private int heightInNumberOfLines;
    private int widthInChars;
    private BufferedImage barcodeImage;
    private boolean rotated = false;

    public BarcodeImageFactory(int n, String string, Map<String, BarcodeParameter> map, int n2, int n3) {
        this.barType = n;
        this.value = string;
        this.parameters = map;
        this.heightInNumberOfLines = n3;
        if (this.heightInNumberOfLines < 0) {
            this.heightInNumberOfLines = 3;
        }
        this.widthInChars = n2;
        if (this.widthInChars < 0) {
            this.widthInChars = 10;
        }
    }

    public void createBarcode() {
        try {
            switch (this.barType) {
                case 30: {
                    this.createBarcode2D();
                    break;
                }
                case 500: {
                    this.createQRCode();
                    break;
                }
                case 600: {
                    this.createAztecCode();
                    break;
                }
                case 31: {
                    this.createDataMatrix();
                    break;
                }
                default: {
                    this.createBarcode1D();
                    break;
                }
            }
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public BufferedImage getBarcodeImage() {
        return this.barcodeImage;
    }

    public boolean isRotated() {
        return this.rotated;
    }

    private void createBarcode1D() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(BARCODE_1D_CLASS);
        BarCode barCode = (BarCode)clazz.newInstance();
        this.createBarcode1D(barCode, clazz);
    }

    private static int getImageType() {
        return 13;
    }

    private void createBarcode1D(BarCode barCode, Class<?> clazz) {
        Object object;
        BarcodeParameter barcodeParameter;
        barCode.barType = this.barType;
        barCode.code = this.value;
        int n = 0;
        if (this.barType == 10 || this.barType == 11 || this.barType == 6 || this.barType == 12) {
            n = 25;
        }
        int n2 = (barcodeParameter = this.parameters.get("rotate")) == null ? 0 : Integer.parseInt(barcodeParameter.getValue());
        boolean bl = n2 > 45 && n2 < 135 || n2 > 225 && n2 < 315;
        int n3 = 50 * this.heightInNumberOfLines - 52;
        barCode.resolution = 1;
        barCode.barHeightCM = n3;
        barCode.leftMarginCM = n;
        barCode.topMarginCM = 0.0;
        barCode.X = 5.0;
        if (bl) {
            barCode.barHeightCM = 12.5 * (double)this.widthInChars;
            this.rotated = true;
        }
        if (this.barType == 30) {
            barCode.X = 10.0;
        }
        barCode.N = 2.0;
        barCode.textFont = new Font("SansSerif", 0, 35);
        barCode.postnetHeightShortBar = barCode.barHeightCM / 3.0;
        barCode.postnetHeightTallBar = barCode.barHeightCM;
        if (this.barType != 13) {
            barCode.checkCharacter = false;
        }
        barCode.setSize(4000, 3000);
        this.createBarcode(barCode, clazz);
        if (barCode.textFont == null) {
            barCode.barHeightCM = n3 + 46;
        }
        if (this.barType == 10 || this.barType == 11) {
            if (barCode.UPCEANSupplement2) {
                object = barCode.code;
                barCode.code = ((String)object).substring(0, ((String)object).length() - 2);
                barCode.supplement = ((String)object).substring(((String)object).length() - 2);
            }
            if (barCode.UPCEANSupplement5) {
                object = barCode.code;
                barCode.code = ((String)object).substring(0, ((String)object).length() - 5);
                barCode.supplement = ((String)object).substring(((String)object).length() - 5);
            }
        }
        if (((BufferedImage)(object = new BufferedImage(4000, 3000, BarcodeImageFactory.getImageType()))).getGraphics() instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            barCode.paint((Graphics)graphics2D);
        } else {
            barCode.paint(((BufferedImage)object).getGraphics());
        }
        n = (int)((double)barCode.resolution * barCode.leftMarginCM);
        int n4 = (int)((double)barCode.resolution * barCode.topMarginCM);
        int n5 = Math.min(4000, barCode.getPaintedArea().width + n);
        int n6 = Math.min(3000, barCode.getPaintedArea().height + n4 + 3);
        this.barcodeImage = ((BufferedImage)object).getSubimage(0, 0, n5, n6);
    }

    private void createBarcode2D() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(BARCODE_PDF_CLASS);
        BarCode2D barCode2D = (BarCode2D)clazz.newInstance();
        this.createBarcode1D((BarCode)barCode2D, clazz);
    }

    private void createQRCode() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(BARCODE_QRCODE_CLASS);
        QRCode qRCode = (QRCode)clazz.newInstance();
        int n = 500 * this.heightInNumberOfLines;
        int n2 = 4000;
        qRCode.setSize(n2, n);
        qRCode.setModuleSize(5);
        qRCode.setMargin(0);
        qRCode.setCode(this.value);
        this.createBarcode(qRCode, clazz);
        int n3 = 15;
        qRCode.setModuleSize(n3);
        BufferedImage bufferedImage = new BufferedImage(4000, 3000, BarcodeImageFactory.getImageType());
        qRCode.paint(bufferedImage.getGraphics());
        int n4 = Math.min(4000, qRCode.getCurrentX());
        int n5 = Math.min(3000, qRCode.getCurrentY());
        this.convertAlign(qRCode);
        this.addImage(bufferedImage, n4, n5);
        this.barcodeImage = bufferedImage.getSubimage(0, 0, n4, n5);
    }

    private void convertAlign(QRCode qRCode) {
        if (this.parameters.get("imageHAlign") != null && this.parameters.get("imageVAlign") != null) {
            int n = BML2HTML.getAlign(this.parameters.get("imageHAlign").getValue());
            int n2 = BML2HTML.getAlign(this.parameters.get("imageVAlign").getValue());
            double d = 15.0;
            if (this.parameters.get("imageWidth") != null) {
                d = Double.parseDouble(this.parameters.get("imageWidth").getValue());
            }
            double d2 = d;
            if (this.parameters.get("imageHeight") != null) {
                d2 = Double.parseDouble(this.parameters.get("imageHeight").getValue());
            }
            double d3 = 0.0;
            if (n == 1) {
                d3 = 50.0 - 0.5 * d;
            } else if (n == 2) {
                d3 = 100.0 - d;
            }
            double d4 = 0.0;
            if (n2 == 1) {
                d4 = 50.0 - 0.5 * d2;
            } else if (n2 == 2) {
                d4 = 100.0 - d2;
            }
            this.parameters.put("imageX", new BarcodeParameter("imageX", "" + d3, false));
            this.parameters.put("imageY", new BarcodeParameter("imageY", "" + d4, false));
            this.parameters.put("imageWidth", new BarcodeParameter("imageWidth", "" + d, false));
            this.parameters.put("imageHeight", new BarcodeParameter("imageHeight", "" + d, false));
        }
    }

    private void addImage(BufferedImage bufferedImage, int n, int n2) {
        BarcodeParameter barcodeParameter = this.parameters.get("image");
        if (barcodeParameter != null) {
            try {
                BufferedImage bufferedImage2 = ImageIO.read(new File(barcodeParameter.getValue()));
                Double d = Double.parseDouble(this.parameters.get("imageX").getValue());
                Double d2 = Double.parseDouble(this.parameters.get("imageY").getValue());
                Double d3 = Double.parseDouble(this.parameters.get("imageWidth").getValue());
                Double d4 = Double.parseDouble(this.parameters.get("imageHeight").getValue());
                int n3 = (int)(0.01 * d * (double)n);
                int n4 = (int)(0.01 * d2 * (double)n2);
                int n5 = (int)(0.01 * d3 * (double)n);
                int n6 = (int)(0.01 * d4 * (double)n2);
                bufferedImage.getGraphics().drawImage(bufferedImage2, n3, n4, n5, n6, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createAztecCode() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(BARCODE_AZTECCODE_CLASS);
        AztecCode aztecCode = (AztecCode)clazz.newInstance();
        int n = 500 * this.heightInNumberOfLines;
        int n2 = 4000;
        aztecCode.setSize(n2, n);
        aztecCode.setModuleSize(5);
        aztecCode.setMargin(0);
        aztecCode.setCode(this.value);
        this.createBarcode(aztecCode, clazz);
        BufferedImage bufferedImage = new BufferedImage(4000, 3000, BarcodeImageFactory.getImageType());
        aztecCode.paint(bufferedImage.getGraphics());
        int n3 = Math.min(4000, aztecCode.getCurrentX());
        int n4 = Math.min(3000, aztecCode.getCurrentY());
        this.barcodeImage = bufferedImage.getSubimage(0, 0, n3, n4);
    }

    private void createDataMatrix() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(BARCODE_DATAMATRIX_CLASS);
        RDataMatrix rDataMatrix = (RDataMatrix)clazz.newInstance();
        int n = 500 * this.heightInNumberOfLines;
        int n2 = 4000;
        rDataMatrix.setSize(n2, n);
        rDataMatrix.N = 5.0;
        rDataMatrix.margin = 0;
        rDataMatrix.code = this.value;
        this.createBarcode(rDataMatrix, clazz);
        BufferedImage bufferedImage = new BufferedImage(4000, 3000, BarcodeImageFactory.getImageType());
        rDataMatrix.paint(bufferedImage.getGraphics());
        int n3 = Math.min(4000, rDataMatrix.getPaintedWidth());
        int n4 = Math.min(3000, rDataMatrix.getPaintedHeight());
        this.barcodeImage = bufferedImage.getSubimage(0, 0, n3, n4);
    }

    private void createBarcode(Object object, Class<?> clazz) {
        for (Map.Entry<String, BarcodeParameter> entry : this.parameters.entrySet()) {
            BarcodeParameter barcodeParameter = entry.getValue();
            if (!barcodeParameter.useReflection() || this.setMethod(clazz, object, barcodeParameter)) continue;
            BarcodeImageFactory.setField(clazz, object, barcodeParameter);
        }
    }

    private boolean setMethod(Class<?> clazz, Object object, BarcodeParameter barcodeParameter) {
        boolean bl = false;
        try {
            String string = "set" + barcodeParameter.getName();
            String string2 = barcodeParameter.getValue();
            Method method = this.searchForMethod(clazz, string);
            if (null != method) {
                Class<?> clazz2 = method.getParameterTypes()[0];
                if (clazz2 == Integer.TYPE) {
                    method.invoke(object, Integer.parseInt(string2));
                    bl = true;
                } else if (clazz2 == String.class) {
                    method.invoke(object, string2);
                    bl = true;
                } else if (clazz2 == Byte.TYPE) {
                    method.invoke(object, (byte)Integer.parseInt(string2));
                    bl = true;
                } else if (clazz2 == Boolean.TYPE) {
                    method.invoke(object, string2.equalsIgnoreCase(TRUE_VALUE));
                    bl = true;
                } else if (clazz2 == Double.TYPE) {
                    method.invoke(object, Double.parseDouble(string2));
                    bl = true;
                } else if (clazz2 == Color.class) {
                    method.invoke(object, Color.decode(string2));
                    bl = true;
                } else if (clazz2 == Font.class) {
                    Font font = null;
                    if (!string2.trim().equals("") && !string2.equalsIgnoreCase("null")) {
                        font = Font.decode(string2);
                    }
                    method.invoke(object, font);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private Method searchForMethod(Class<?> clazz, String string) {
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            if (!methodArray[i].getName().equalsIgnoreCase(string) || (classArray = methodArray[i].getParameterTypes()).length != 1) continue;
            method = methodArray[i];
            break;
        }
        return method;
    }

    private static boolean setField(Class<?> clazz, Object object, BarcodeParameter barcodeParameter) {
        boolean bl = false;
        try {
            String string = barcodeParameter.getValue();
            Field field = BarcodeImageFactory.searchForField(clazz, barcodeParameter.getName());
            Class<?> clazz2 = field.getType();
            if (clazz2 == Integer.TYPE) {
                field.setInt(object, Integer.parseInt(string));
                bl = true;
            } else if (clazz2 == String.class) {
                field.set(object, string);
                bl = true;
            } else if (clazz2 == Byte.TYPE) {
                field.setByte(object, (byte)Integer.parseInt(string));
                bl = true;
            } else if (clazz2 == Boolean.TYPE) {
                field.setBoolean(object, string.equalsIgnoreCase(TRUE_VALUE));
                bl = true;
            } else if (clazz2 == Double.TYPE) {
                field.setDouble(object, Double.parseDouble(string));
                bl = true;
            } else if (clazz2 == Color.class) {
                field.set(object, Color.decode(string));
                bl = true;
            } else if (clazz2 == Font.class) {
                Font font = null;
                if (!string.trim().equals("") && !string.equalsIgnoreCase("null")) {
                    font = Font.decode(string);
                }
                field.set(object, font);
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static Field searchForField(Class<?> clazz, String string) {
        Field field = null;
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equalsIgnoreCase(string)) continue;
            field = fieldArray[i];
            break;
        }
        return field;
    }
}

