/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BMLConverter
extends DefaultHandler {
    private Writer m_writer;
    private StringBuffer m_chars;
    private String m_charsSetDirectly;
    private int m_pass = 1;
    protected Stack m_tags = new Stack();
    private boolean m_stopWriting = false;
    private boolean m_multipleDocuments = false;
    private boolean m_lastOne = false;
    private boolean m_firstOne = true;
    private static final Logger LOG = Logger.getLogger(BMLConverter.class.getName());

    public int getNumberOfPasses() {
        return 1;
    }

    public boolean getReencodeCharacters() {
        return true;
    }

    public boolean getReencodeCharacterApos() {
        return true;
    }

    public int getPass() {
        return this.m_pass;
    }

    protected void init() {
        this.m_stopWriting = false;
        this.m_tags.clear();
    }

    protected boolean isWritingStopped() {
        return this.m_stopWriting;
    }

    protected void stopWriting() {
        this.m_stopWriting = true;
    }

    protected void startWriting() {
        this.m_stopWriting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(String string, String string2) throws SAXException, IOException {
        this.init();
        XMLReader xMLReader = IOUtils.createXMLReader();
        xMLReader.setContentHandler(this);
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            this.m_writer = new BufferedWriter(outputStreamWriter);
            if (string2.endsWith("xml")) {
                this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            }
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            this.parse(xMLReader, string);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(this.m_writer);
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(this.m_writer);
        IOUtils.closeQuietly(outputStreamWriter);
        IOUtils.closeQuietly(fileOutputStream);
    }

    protected void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        try {
            this.m_multipleDocuments = false;
            for (int i = 0; i < this.getNumberOfPasses(); ++i) {
                this.m_pass = i + 1;
                try {
                    xMLReader.parse(string);
                    continue;
                }
                catch (StopParsingException stopParsingException) {
                    // empty catch block
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            this.m_multipleDocuments = true;
            this.m_lastOne = false;
            this.m_firstOne = true;
            StringBuffer stringBuffer = new StringBuffer();
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.trim().startsWith("<?xml")) {
                    this.parseSingleDocument(xMLReader, stringBuffer);
                    this.m_firstOne = false;
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
                string2 = bufferedReader.readLine();
            }
            this.m_lastOne = true;
            this.parseSingleDocument(xMLReader, stringBuffer);
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
    }

    private void parseSingleDocument(XMLReader xMLReader, StringBuffer stringBuffer) throws SAXException, IOException {
        if (stringBuffer.length() > 0) {
            this.init();
            for (int i = 0; i < this.getNumberOfPasses(); ++i) {
                this.m_pass = i + 1;
                try {
                    StringReader stringReader = new StringReader(stringBuffer.toString());
                    InputSource inputSource = new InputSource(stringReader);
                    xMLReader.parse(inputSource);
                    continue;
                }
                catch (StopParsingException stopParsingException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean hasMultipleDocuments() {
        return this.m_multipleDocuments;
    }

    public boolean isLastDocument() {
        return this.m_lastOne;
    }

    public boolean isFirstDocument() {
        return this.m_firstOne;
    }

    public void writeStartTag(String string) throws IOException {
        this.writeStartTag(string, true);
    }

    public void writeStartTag(String string, boolean bl) throws IOException {
        if (!this.m_stopWriting) {
            this.writeSpaces();
            this.m_tags.push(new Object[]{string, null});
            String string2 = "<" + string;
            if (bl) {
                string2 = string2 + ">";
            }
            this.write(string2);
        }
    }

    protected void writeSpaces() throws IOException {
        String string = System.getProperty("line.separator");
        for (int i = 0; i < this.m_tags.size(); ++i) {
            string = string + "   ";
        }
        this.write(string);
    }

    public String getCurrentTag() {
        if (this.m_tags.size() == 0) {
            return "none";
        }
        return (String)((Object[])this.m_tags.peek())[0];
    }

    public Object getCurrentExtra() {
        if (this.m_tags.size() == 0) {
            return null;
        }
        return ((Object[])this.m_tags.peek())[1];
    }

    public void setCurrentExtra(Object object) {
        ((Object[])this.m_tags.elementAt((int)(this.m_tags.size() - 1)))[1] = object;
    }

    public void writeEndTag() throws IOException {
        if (!this.m_stopWriting) {
            String string = this.getCurrentTag();
            this.m_tags.pop();
            this.write("</" + string + ">");
        }
    }

    public void write(String string) throws IOException {
        if (string != null && !this.m_stopWriting) {
            this.m_writer.write(string);
        }
    }

    public void writeData(String string) throws IOException {
        this.write("<![CDATA[" + string + "]]>");
    }

    public void writeTagAndData(String string, String string2) throws IOException {
        this.writeSpaces();
        this.write("<" + string + ">");
        this.writeData(string2);
        this.write("</" + string + ">");
    }

    public void writeTag(String string, String string2) throws IOException {
        this.writeSpaces();
        this.write("<" + string + ">");
        this.write(string2);
        this.write("</" + string + ">");
    }

    @Override
    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    @Override
    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.m_chars != null) {
            String string = new String(cArray, n, n2);
            if (this.getReencodeCharacters() && string.length() == 1) {
                char c = string.charAt(0);
                switch (c) {
                    case '<': {
                        string = "&lt;";
                        break;
                    }
                    case '>': {
                        string = "&gt;";
                        break;
                    }
                    case '&': {
                        string = "&amp;";
                        break;
                    }
                    case '\"': {
                        string = "&quot;";
                    }
                }
                if (c == '\'' && this.getReencodeCharacterApos()) {
                    string = "&apos;";
                }
            }
            this.m_chars.append(string);
        }
    }

    public void startCharacters() {
        this.m_chars = new StringBuffer();
    }

    public void addCharacters(String string) {
        this.m_chars.append(string);
    }

    public boolean isCharactersStarted() {
        return this.m_chars != null;
    }

    public void setCharactersDirectly(String string) {
        this.m_charsSetDirectly = string;
    }

    public String getCharacters() {
        if (this.m_charsSetDirectly != null) {
            return this.m_charsSetDirectly;
        }
        if (this.m_chars == null) {
            return "";
        }
        return this.m_chars.toString();
    }

    public void stopCharacters() {
        this.m_chars = null;
        this.m_charsSetDirectly = null;
    }

    protected void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    protected Writer getWriter() {
        return this.m_writer;
    }

    public static void main(String[] stringArray) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("arg[" + i + "]='" + stringArray[i].trim() + "';");
        }
        LOG.info("Method 'main' called, " + stringBuilder.toString());
        try {
            String string = "com.ssaglobal.bml.BML2" + stringArray[0].trim();
            Class<?> clazz = Class.forName(string);
            int n = stringArray.length - 1;
            Class[] classArray = new Class[n];
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = String.class;
                objectArray[i] = stringArray[i + 1].trim();
            }
            Method method = clazz.getMethod("convertBML", classArray);
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println();
            System.out.println("Example usage: java -classpath .;bml2xml.jar;xml-apis.jar;xercesImpl.jar com.ssaglobal.bml.BMLConverter Rosettanet <bml file in> <rosettanet file out>");
            System.out.println("");
            System.out.println("Possible conversions: HTML, BIRT, BIRTData, BIRTDesign, PDF, Rosettanet, TXT");
            LOG.log(Level.SEVERE, "BMLConverter failed", exception);
            throw exception;
        }
    }

    public class StopParsingException
    extends RuntimeException {
    }
}

