/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.licensekey.LicenseKey;
import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.BarcodeImage;
import com.ssaglobal.bml.CellWidths;
import com.ssaglobal.bml.ExactPosData;
import com.ssaglobal.bml.FallbackFontProvider;
import com.ssaglobal.bml.Grid;
import com.ssaglobal.bml.NotoMapper;
import com.ssaglobal.bml.PDFTextWrap;
import com.ssaglobal.bml.SimpleFontProvider;
import com.ssaglobal.bml.Style;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.xml.sax.SAXException;

public class BML2PDF
extends BML2HTML {
    private String m_pdfFileName;
    private long m_free;
    private long m_total;
    private long m_max;
    private Document m_document;
    private PdfWriter m_pdfWriter;
    private HashMap<String, Grid.SizedFont> m_fonts = new HashMap();
    private float m_currentYPos;
    private float m_charWidth;
    private float m_charHeight;
    private float m_leftMargin;
    private float m_rightMargin;
    private float m_topMargin;
    private float m_bottomMargin;
    private int m_linesPerPage;
    private int m_linesPerPageMax;
    private boolean m_doPageBreaksMySelf = false;
    private int m_lineNr = -1;
    private String m_arialuniFont;
    private String m_arialFont;
    private String m_couriernewFont;
    private com.itextpdf.kernel.colors.Color m_lineColor = ColorConstants.LIGHT_GRAY;
    private boolean m_debug = false;
    private boolean m_debugShowProps = false;
    private boolean m_negativeSignsArePresent = false;
    private String m_reportId;
    public static float DEFAULT_FONT_SIZE_FACTOR;
    private float m_fontSizeFactor = DEFAULT_FONT_SIZE_FACTOR;
    private static final float FONT_SIZE_FACTOR_MAX = 3.5f;
    private float m_dynamicFactor = 1.6f;
    private int m_landscape = 150;
    private Grid m_grid;
    private CellWidths m_cellWidths = new CellWidths();
    private int m_layoutStrategy = 1;
    private Properties m_properties;
    private String m_pdfPropertiesLocation;
    private float m_pageWidth = 21.0f;
    private float m_pageHeight = 29.7f;
    private PageSize m_pageSize;
    private boolean m_useExactPositioning = false;
    private String m_backgroundImage = "";
    private HashMap<String, BackgroundImage> m_backgroundImages = new HashMap();
    private HashMap<String, Count> m_numberOfLinesPerLayout = new HashMap();
    private Count m_currentCount;
    private PdfPage m_currentPage;
    private NotoMapper m_notoMapper;
    private static final Logger logger;

    protected static void loadLicense() {
        try {
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><license date=\"2019-10-03\" issuer=\"iText Group NV\" library=\"3\"><licensee expire=\"2069-10-03\"><name>Bram Vijfhuizen</name><email>bram.vijfhuizen@infor.com</email><company>Infor</company><version>7.1</version><key>18df2-f7baf-c7be3-75a5b</key><licensetype>oem</licensetype><signature>Vj0x+cr4MdUNySgeaXWVdl4EQS2yYQ7+cJM/pdKeM0hVp+BPXdYKR4+AyFl4EvN0Ip15jDf5bTekWh+ruX2GEqga5kxaDl45wVglHqC3rqfDtYmMb8GwfiFCf1yX5OzKtklr+vaQZE++34bnrQ0xjPYYepfi0SAygE//1o30Kq+p9dkvhZoetBjxwyjAVqp3WzKi1h1qRDio550jHYTHPW3cTOtgh+yuGis/2nZcaQbk4ENs0zL9RA3IpMXAph1t0TggFhFKqVpzHyFRSwST8Hdt9xjwdDkMYvlwCuJeej2WG1cjeGVNve15aKmoqLmE8zEOYT2XDvTvobN/MOy8Hgd31g4NsWXtJUHhXb52x8grmTTFcuYIhAVsln/jMgeZWJWPWewbwJJjHmFuUCJ6aL+44ozTzSBdLhGOR4aFtvu7nAxGfewScT+unttvkGlvFep+EEFPMYVV6zVr6gvrgaEPaRl3RwjKNqUfuX377JrD+iH+TkuSsshMmB/ofDjYFcueO/WZQ/5N0ENUirTUg+IjbIg1kzoqP3FV0/6COQu/X8gRPAPKatEOts1PSBlS35HT3fddB49gTs/0+yw1iShAWhDLrUtk/m0PfVCN9PrpdecnUcidJaEFfEZVsOtU0Q93dxYsSXUaVjCrpQPWFwzu3GyE3aiuCnKZWSkC+yU=</signature></licensee></license>";
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            LicenseKey.loadLicenseFile((InputStream)byteArrayInputStream);
            String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><license date=\"2019-10-09\" issuer=\"iText Group NV\" library=\"3\"><licensee expire=\"2069-10-09\"><name>Bram Vijfhuizen</name><email>bram.vijfhuizen@infor.com</email><company>Infor</company><version>7.1</version><key>90372-cae5c-a5786-9ce65</key><licensetype>oem</licensetype><signature>SWMd1n3lG0xYMfoDKJlmZGgG9qpZK6LNhGBRxBEb5QPYGbfwZ4aRpcZFubezpMbT85v5h0SllSoCCnthIBQ1ulJaZ7iBWLLfb4nVAPGCx4ILOdkr7vuDhrYjCFip/9MKkIDNG+yDHCWC1d3FUEAYq5W/iimGFpCdD55jJKzyuxLZUhW+epYu9kBzOBQbCGR2tk7zENkky13Vmi+Nfa7eLg8TWlJth47Nqpa8kBrrUvD7jQv8iU+agvP5JvqJQ8CDElE56S+fAEbWyH7pkOc478OYDva8asQmQ1gAcqCxRajmqSVU9Z2mWqLQuDRMjZ9H4gGzJsT4qQGq5Di4vhSYY/AmxFeTlgpH1qpwpIS4zWQ+FaRdf6Y0R8PL4RFRikyTnBXLxFxP4+5RzPqsHuzBjrYlqB3GN0PaNv6A9X50hcTqAPMbpeiC9lMtSGXh5Khj2aKOcqQAcKLaFgKQdyv1ryaJbLeqZQ15PVR4pB5pU80XnAOxq2FH5wuEdPHCn03gaZBUCuExj6ln/nK1l6liUSfFpQezN9wivSPOVSYmIMnySZTNr83rvKK56A+2hqV8huen9bHJcBWGhck6bLunPledKfQgkpZribdq+GDE0Og9Lwih2AtO6uHH7MckrrCX4dEVPlj/VUv3uR6sQokCMG1GIs5YfT0CZjtd2PG+0Ik=</signature></licensee><product deploymenttype=\"\" expire=\"2069-10-09\" licensetype=\"oem\" major=\"2\" name=\"pdfCalligraph\" platform=\"java\"><signature>GiAoHxrrE/zwlXHrH4+QrjsjRfe2vleWgCsxV9p4kOPCwTfhS4fivdy9OndG/+Qembv0LWApCE4mnWGSQ1E2/m3nidCWGQOFzIqSO0i7oJn+V7N7y/9Ntg1wt/7ugqN7N1ifhu0OecJIhmIFRLZihzWxWWROck6ra9WX/tBGBCECknGfMsO/Y8cWOEPfrQk2Jz3rtVPFmkSVHuEibkKd09rqo4kOQQ8lIbp0YKmeu5yWOBj8yc/xJLVoOnxMLs0lEyFCqAk+7xX/e4s613hRDlZ7NuG6Plfvwy1g45d0N7VnExzzNXkXAGvDAWhjxZ7sfseyIGnvUf2FsZ8ThQGIL4v92DLmsvo0YV7zMbLw+jEmYQOGO4ucLOLumwYptzfo8vkXz4CweWwUNDGiHMnEAFzDpd8Jr9om3+kY00UslAbkN5K1EdngEcz9pJCT52NhvcXdGwTdxRRBfuOT6nTNv55gVL19SnGai3xghQ5n2EyGvvWo6BBRvQ7Vn9ZXMpW2rJOrhde4fZ6tJcFfIIIqDyR3YBCca5LrnWl+/s2FOTrig6pOfxPAqof104k5DyUzn3LkkC0qUaz6orvdXbtdBRCOnkn+CnOFaePLnAxuDZ9ZjVMt2F2n9R386SIG3utti7RZYtZ5rDR0MKCHEwXymcBbqK2DPgXWExIUP+nlhwg=</signature></product></license>";
            byte[] byArray2 = string2.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            LicenseKey.loadLicenseFile((InputStream)byteArrayInputStream2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getDefaultFont(boolean bl) {
        String string = null;
        if (bl && string == null && this.m_couriernewFont != null) {
            string = this.m_couriernewFont;
        }
        if (string == null && this.m_arialuniFont != null) {
            string = this.m_arialuniFont;
        }
        if (string == null && this.m_arialFont != null) {
            string = this.m_arialFont;
        }
        return string;
    }

    private String getITextEncoding() {
        return "Identity-H";
    }

    @Override
    public String getLocale() {
        if (this.isBidi()) {
            return "ISO88596";
        }
        return super.getLocale();
    }

    @Override
    public void init() {
        super.init();
        this.m_arialuniFont = null;
        this.m_properties = null;
        this.m_negativeSignsArePresent = false;
        this.m_useExactPositioning = false;
    }

    private void tryToFindArialFonts() {
        File file;
        String string;
        String string2;
        if (this.m_arialuniFont != null) {
            return;
        }
        String string3 = this.getProperty(this.getProperties(), "default-proportional-font", null);
        String string4 = this.getProperty(this.getProperties(), "default-monospaced-font", null);
        if (string3 != null) {
            this.m_arialuniFont = string3;
            if (string4 == null) {
                string4 = string3;
            }
            this.m_couriernewFont = string4;
            return;
        }
        File file2 = new File("c:/notosans/");
        if (file2.exists()) {
            this.m_arialuniFont = file2.getAbsolutePath();
            this.m_couriernewFont = file2.getAbsolutePath();
            return;
        }
        String string5 = System.getProperty("os.name").toLowerCase();
        String string6 = string2 = "";
        if (string5.indexOf("windows") > -1) {
            string = System.getenv("windir");
            string6 = string2 = string + File.separator + "fonts" + File.separator;
        } else if (string5.indexOf("solaris") > -1) {
            string2 = File.separator + "usr";
            string2 = string2 + File.separator + "openwin";
            string2 = string2 + File.separator + "lib";
            string2 = string2 + File.separator + "X11";
            string6 = string2 = string2 + File.separator + "fonts";
            string2 = string2 + File.separator + "TrueType" + File.separator;
            string6 = string6 + File.separator + "truetype" + File.separator;
        } else if (string5.indexOf("linux") > -1) {
            string2 = File.separator + "usr";
            string2 = string2 + File.separator + "lib";
            string2 = string2 + File.separator + "X11";
            string6 = string2 = string2 + File.separator + "fonts";
            string2 = string2 + File.separator + "truetype" + File.separator;
            string6 = string6 + File.separator + "TrueType" + File.separator;
        } else {
            string2 = File.separator + "usr";
            string2 = string2 + File.separator + "share";
            string2 = string2 + File.separator + "fonts";
            string6 = string2 = string2 + File.separator + "default";
            string2 = string2 + File.separator + "TrueType" + File.separator;
            string6 = string6 + File.separator + "truetype" + File.separator;
        }
        string = this.getFontPath();
        if (string != null) {
            string2 = string;
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string6 = string2;
        }
        if (!(file = new File(string2)).exists()) {
            file = new File(string6);
            string2 = string6;
        }
        if (file.exists()) {
            String string7 = string2 + "arialuni.ttf";
            File file3 = new File(string7);
            if (file3.exists()) {
                this.m_arialuniFont = string7;
            } else {
                string7 = string2 + "ARIALUNI.TTF";
                file3 = new File(string7);
                if (file3.exists()) {
                    this.m_arialuniFont = string7;
                }
            }
            String string8 = string2 + "arial.ttf";
            File file4 = new File(string8);
            if (file4.exists()) {
                this.m_arialFont = string8;
            } else {
                string8 = string2 + "ARIAL.TTF";
                file4 = new File(string8);
                if (file4.exists()) {
                    this.m_arialFont = string8;
                }
            }
            String string9 = string2 + "cour.ttf";
            File file5 = new File(string9);
            if (file5.exists()) {
                this.m_couriernewFont = string9;
            } else {
                string9 = string2 + "COUR.TTF";
                file5 = new File(string9);
                if (file5.exists()) {
                    this.m_couriernewFont = string9;
                }
            }
        }
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }

    @Override
    public boolean getReencodeCharacters() {
        return false;
    }

    @Override
    public boolean getReencodeCharacterApos() {
        return false;
    }

    @Override
    protected void setNumberOfCharactersForTheCurrentLine(int n, String string, boolean bl) {
        super.setNumberOfCharactersForTheCurrentLine(n, string, bl);
        if ((double)n < 0.5 * (double)this.getPWidth()) {
            n = (int)(0.5 * (double)this.getPWidth());
        }
        if (n > this.getPWidth()) {
            n = this.getPWidth();
        }
        if (this.m_document != null) {
            this.m_charWidth = (this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin) / (float)n;
        }
        if (this.getPass() == 2 || this.useDynamicCols()) {
            this.createGrid(n, bl);
        }
    }

    private void createGrid(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.m_grid == null || n != this.m_grid.getWidth() || bl != this.m_grid.getJustify() && !this.m_useExactPositioning;
        if (bl2) {
            float f;
            this.writeGrid();
            float[] fArray = null;
            float f2 = -1.0f;
            if (this.m_layoutStrategy == 1) {
                if (this.getPass() == 1 || this.getPass() == 2) {
                    fArray = this.m_cellWidths.load("" + n + bl);
                    f2 = this.m_cellWidths.getFontSize(n);
                }
            } else if (this.m_layoutStrategy != 2 && this.m_layoutStrategy == 3 && this.getPass() == 2) {
                fArray = this.m_cellWidths.load("" + n + bl);
                f2 = this.m_cellWidths.getFontSize(n);
            }
            if ((f = this.getFontSize()) > 3.5f) {
                f = 3.5f;
            }
            float f3 = f * this.m_charWidth;
            this.m_grid = this.m_useExactPositioning ? new Grid(this.m_document, this.m_pageSize.getWidth(), this.m_pageSize.getHeight(), this.m_leftMargin, this.m_rightMargin, this.m_lineColor, this.isBidi(), this.isMonospaced(), this.m_debug, f2, this.m_currentYPos) : new Grid(this.m_document, n, this.m_charWidth, this.m_charHeight, this.m_pageSize.getWidth(), this.m_leftMargin, this.m_rightMargin, this.m_lineColor, this.isBidi(), this.useDynamicCols(), this.isMonospaced(), this.m_debug, fArray, f3, f2, this.m_fontSizeFactor, bl);
        }
    }

    public boolean useDynamicCols() {
        if (this.m_useExactPositioning) {
            return false;
        }
        return this.getFontSize() >= this.m_dynamicFactor;
    }

    @Override
    protected void writeBorderCell(int n, int n2, int n3, Style style) throws IOException {
        if (this.getPass() == 1) {
            return;
        }
        Grid grid = this.m_grid;
        grid.getClass();
        this.m_grid.addLine(new Grid.Line(grid, n, this.m_currentYPos, n2, n3, style));
    }

    public float getFontSize() {
        return this.m_fontSizeFactor;
    }

    private void showTextAligned(int n, String string, int n2, float f, float f2, BaseDirection baseDirection, int n3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Style style) {
        if (this.getPass() == 2 || this.useDynamicCols()) {
            Grid.SizedFont sizedFont = null;
            sizedFont = bl ? this.getFont(string2, true, bl2, style == null ? null : style.getForegroundColor(), string) : this.getFont(string2, false, bl2, style == null ? null : style.getForegroundColor(), string);
            sizedFont.setItalic(bl4);
            sizedFont.setUnderline(bl3);
            Grid grid = this.m_grid;
            grid.getClass();
            this.m_grid.addTextBlock(new Grid.TextBlock(grid, n, string, sizedFont, n2, f, f2, baseDirection, n3, string2, style));
        }
    }

    private Grid.SizedFont getFont(String string, boolean bl, boolean bl2, String string2, String string3) {
        Grid.SizedFont sizedFont = this.getFont(bl, string, string3);
        if (bl2) {
            sizedFont.setBold(true);
        }
        if (string2 != null) {
            sizedFont.setColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(Color.decode(string2)));
        }
        return sizedFont;
    }

    @Override
    protected void writeTextCell(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4, boolean bl5, Style style) throws IOException {
        boolean bl6;
        Object object;
        if (string == null) {
            return;
        }
        if (string.equals("&nbsp;")) {
            string = " ";
        }
        float f = this.m_currentYPos;
        boolean bl7 = false;
        if (bl2 && !bl3 && n3 == 2) {
            if (this.getPass() == 2 && !this.m_negativeSignsArePresent) {
                bl7 = false;
            } else {
                object = null;
                bl6 = true;
                if (string.length() == 0) {
                    object = string;
                } else {
                    char c = string.charAt(string.length() - 1);
                    bl6 = Character.isDigit(c);
                    if (bl6) {
                        object = string;
                    } else {
                        object = string.substring(0, string.length() - 1);
                        this.m_negativeSignOnNumbersOnTheRight = "" + c;
                    }
                }
                string = object;
                --n2;
                if (!bl6) {
                    bl7 = true;
                    this.m_negativeSignsArePresent = true;
                }
            }
        }
        object = BaseDirection.LEFT_TO_RIGHT;
        boolean bl8 = bl6 = this.isBidi() || this.isRtlText(string) && this.isFirstTextOfCurrentLineRtl();
        if (bl6) {
            if (n3 == 0) {
                n3 = 2;
            } else if (n3 == 2) {
                n3 = 0;
            }
            object = BaseDirection.RIGHT_TO_LEFT;
        }
        if (n3 == 0) {
            this.showTextAligned(0, string, n, f, 0.0f, (BaseDirection)object, n2, string2, bl3, bl, bl4, bl5, style);
            if (bl7) {
                this.showTextAligned(0, this.m_negativeSignOnNumbersOnTheRight, n + n2, f, 0.0f, (BaseDirection)object, 1, string2, bl3, bl, bl4, bl5, style);
            }
        } else if (n3 == 1) {
            this.showTextAligned(1, string, n, f, 0.0f, (BaseDirection)object, n2, string2, bl3, bl, bl4, bl5, style);
        } else if (n3 == 2) {
            this.showTextAligned(2, string, n, f, 0.0f, (BaseDirection)object, n2, string2, bl3, bl, bl4, bl5, style);
            if (bl7) {
                this.showTextAligned(0, this.m_negativeSignOnNumbersOnTheRight, n + n2, f, 0.0f, (BaseDirection)object, 1, string2, bl3, bl, bl4, bl5, style);
            }
        }
    }

    private File getFontFile(boolean bl, String string, String string2) {
        File file;
        String string3 = this.getProperty(this.getProperties(), string, null);
        if (string3 != null && (file = new File(string3)).exists()) {
            return file;
        }
        string3 = this.getDefaultFont(bl);
        if (string3 == null) {
            if (bl) {
                return new File("some_non_existing_monospace_font_file");
            }
            return new File("some_non_existing_font_file");
        }
        file = new File(string3);
        return file;
    }

    private Grid.SizedFont getBaseFont(boolean bl, String string, String string2) {
        String string3 = this.getFontName(string);
        File file = this.getFontFile(bl, string3, string2);
        Grid.SizedFont sizedFont = this.m_fonts.get(file.getAbsolutePath());
        if (sizedFont == null) {
            try {
                if (!file.exists()) {
                    PdfFont pdfFont = bl ? PdfFontFactory.createFont((String)"Courier") : PdfFontFactory.createFont((String)"Helvetica");
                    sizedFont = new Grid.SizedFont(pdfFont, 12.0f, false, bl);
                } else if (file.isDirectory()) {
                    FontProvider fontProvider = null;
                    File file2 = new File(file, "NotoSans-Regular.ttf");
                    if (file2.exists()) {
                        if (this.m_notoMapper == null) {
                            this.m_notoMapper = new NotoMapper(file, this.m_debug);
                        }
                        fontProvider = this.m_notoMapper;
                    } else {
                        fontProvider = new FontProvider();
                        fontProvider.addDirectory(file.getAbsolutePath());
                    }
                    sizedFont = new Grid.SizedFont(fontProvider, 12.0f, false, bl);
                } else {
                    PdfFont pdfFont = PdfFontFactory.createFont((String)file.getAbsolutePath(), (String)this.getITextEncoding(), (boolean)false);
                    File file3 = new File(this.getDefaultFont(false));
                    if (file.getAbsolutePath().equals(file3.getAbsolutePath())) {
                        sizedFont = new Grid.SizedFont(pdfFont, 12.0f, false, bl);
                    } else {
                        Grid.SizedFont sizedFont2 = this.getBaseFont(false, "default.please", null);
                        FontProvider fontProvider = sizedFont2.getProvider();
                        if (fontProvider == null) {
                            fontProvider = new SimpleFontProvider(sizedFont2.getFont());
                        }
                        FallbackFontProvider fallbackFontProvider = new FallbackFontProvider(pdfFont, fontProvider);
                        sizedFont = new Grid.SizedFont(fallbackFontProvider, 12.0f, false, bl);
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot create the font", exception);
            }
            this.m_fonts.put(file.getAbsolutePath(), sizedFont);
        }
        return sizedFont;
    }

    private Grid.SizedFont getFont(boolean bl, String string, String string2) {
        String string3 = this.getFontName(string);
        float f = this.getFontSizeInPt(string);
        string = string3.replaceAll(" ", "");
        Grid.SizedFont sizedFont = this.getBaseFont(bl, string, string2);
        if (f < 0.0f) {
            float f2 = this.getFontSize();
            if (f2 > 3.5f) {
                f2 = 3.5f;
            }
            f = f2 * this.m_charWidth;
            Grid.SizedFont sizedFont2 = new Grid.SizedFont(sizedFont, f, false, bl);
            return sizedFont2;
        }
        Grid.SizedFont sizedFont3 = new Grid.SizedFont(sizedFont, f, true, bl);
        return sizedFont3;
    }

    private String getFontName(String string) {
        if (this.getFontSizeInPt(string) < 0.0f) {
            return string;
        }
        int n = string.indexOf(40);
        return string.substring(0, n - 1).trim();
    }

    private float getFontSizeInPt(String string) {
        int n = string.indexOf(40);
        if (n == -1) {
            return -1.0f;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(41)) == -1) {
            return -1.0f;
        }
        String[] stringArray = (string = string.substring(0, n)).split(" ");
        if (stringArray.length != 2) {
            return -1.0f;
        }
        if (!stringArray[1].toLowerCase().equals("pt")) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(stringArray[0]);
        }
        catch (Exception exception) {
            return -1.0f;
        }
    }

    @Override
    protected void writeBarcode(int n, int n2, BML2HTML.BarCode barCode, boolean bl, String string, Style style) throws IOException {
        if (this.getPass() < 2) {
            return;
        }
        this.writeBarcodeJ4L(n, barCode, bl, string, style);
    }

    @Override
    protected void writeImage(int n, int n2, int n3, String string, int n4, int n5, Style style, String string2) {
        if (this.getPass() < 2) {
            return;
        }
        try {
            if (string2 != null) {
                Grid grid = this.m_grid;
                grid.getClass();
                this.m_grid.addImage(new Grid.ImageBlock(grid, n, this.m_currentYPos, n2, n3, null, false, false, n4, n5, style, string2));
            } else {
                if (string.trim().isEmpty()) {
                    return;
                }
                File file = new File(string);
                ImageData imageData = ImageDataFactory.create((String)file.getAbsolutePath());
                Image image = new Image(imageData);
                Grid grid = this.m_grid;
                grid.getClass();
                this.m_grid.addImage(new Grid.ImageBlock(grid, n, this.m_currentYPos, n2, n3, image, false, false, n4, n5, style, string2));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void writeBarcodeJ4L(int n, BML2HTML.BarCode barCode, boolean bl, String string, Style style) throws IOException {
        if (barCode == null || barCode.getValue() == null || barCode.getValue().isEmpty()) {
            return;
        }
        float f = this.m_currentYPos;
        String string2 = this.getBarcodeType(barCode);
        if (string2 != null) {
            Properties properties = this.getProperties();
            BufferedImage bufferedImage = this.getBufferedImage(barCode, string2);
            if (bufferedImage != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                ImageData imageData = ImageDataFactory.create((byte[])byteArrayOutputStream.toByteArray());
                Image image = new Image(imageData);
                boolean bl2 = !barCode.isRotated();
                Grid grid = this.m_grid;
                grid.getClass();
                Grid.ImageBlock imageBlock = new Grid.ImageBlock(grid, n, f, barCode.getWidth(), barCode.getHeight(), image, bl2, "yes".equals(this.getProperty(properties, "extend-barcodes", "no")), 0, 0, style, null);
                this.m_grid.addImage(imageBlock);
            }
        } else {
            this.writeTextCell("Unsupported bar code: " + barCode.getType(), n, 30, 0, false, false, false, "", false, false, null);
        }
    }

    private String getBarcodeType(BML2HTML.BarCode barCode) {
        String string = null;
        if (barCode.getJ4LType() != null) {
            string = barCode.getJ4LType();
        } else if (barCode.getType() == 1) {
            string = "EAN13";
        } else if (barCode.getType() == 2) {
            string = "EAN8";
        } else if (barCode.getType() == 5) {
            string = "UPCA";
        } else if (barCode.getType() == 6) {
            string = "UPCE";
        } else if (barCode.getType() == 7) {
            string = "INTERLEAVED25";
        } else if (barCode.getType() != 8) {
            if (barCode.getType() == 9) {
                string = "BAR39";
            } else if (barCode.getType() == 10) {
                string = "CODE128";
            } else if (barCode.getType() == 11) {
                string = "EAN128";
            } else if (barCode.getType() != 12 && barCode.getType() != 13) {
                if (barCode.getType() == 14) {
                    string = "BAR39";
                } else if (barCode.getType() != 15) {
                    if (barCode.getType() == 16) {
                        string = "CODE11";
                    } else if (barCode.getType() == 17) {
                        string = "CODABAR";
                    } else if (barCode.getType() != 18) {
                        if (barCode.getType() == 19) {
                            string = "BAR39EXT";
                        } else if (barCode.getType() != 20 && barCode.getType() != 21 && barCode.getType() != 22 && barCode.getType() != 23 && barCode.getType() != 24 && barCode.getType() != 25 && barCode.getType() != 26 && barCode.getType() != 27 && barCode.getType() != 28) {
                            if (barCode.getType() == 29) {
                                string = "POSTNET";
                            } else if (barCode.getType() == 30) {
                                string = "POSTNET";
                            } else if (barCode.getType() == 31) {
                                string = "POSTNET";
                            } else if (barCode.getType() != 32 && barCode.getType() != 33 && barCode.getType() != 34 && barCode.getType() != 35 && barCode.getType() != 36) {
                                if (barCode.getType() == 37) {
                                    string = "CODE93";
                                } else if (barCode.getType() == 38) {
                                    string = "CODE93EXT";
                                } else if (barCode.getType() != 39 && barCode.getType() != 40 && barCode.getType() != 41 && barCode.getType() != 42 && barCode.getType() != 43 && barCode.getType() != 44 && barCode.getType() != 45 && barCode.getType() != 46 && barCode.getType() != 47 && barCode.getType() != 48 && barCode.getType() != 49 && barCode.getType() != 50 && barCode.getType() != 51 && barCode.getType() != 52 && barCode.getType() != 53 && barCode.getType() != 54 && barCode.getType() != 55 && barCode.getType() != 56 && barCode.getType() != 57 && barCode.getType() != 58 && barCode.getType() != 59 && barCode.getType() != 60 && barCode.getType() != 61 && barCode.getType() != 62 && barCode.getType() != 63 && barCode.getType() != 64 && barCode.getType() != 65 && barCode.getType() != 66 && barCode.getType() != 67 && barCode.getType() != 68 && barCode.getType() != 69 && barCode.getType() != 70 && barCode.getType() != 71 && barCode.getType() != 72 && barCode.getType() != 73 && barCode.getType() != 74 && barCode.getType() != 1001 && barCode.getType() != 1002) {
                                    if (barCode.getType() == 1003) {
                                        string = "PDF417";
                                    } else if (barCode.getType() == 1004) {
                                        string = "AZTECCODE";
                                    } else if (barCode.getType() == 1005) {
                                        string = "DATAMATRIX";
                                    } else if (barCode.getType() != 1006 && barCode.getType() != 1007 && barCode.getType() != 1008 && barCode.getType() != 1009 && barCode.getType() == 1010) {
                                        string = "QRCODE";
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private void writeGrid() {
        if (this.getPass() == 2 || this.useDynamicCols()) {
            if (this.m_grid != null) {
                if (this.useDynamicCols()) {
                    if (this.getPass() == 1) {
                        if (this.m_layoutStrategy == 1) {
                            this.m_grid.calculateCellDimensions(null);
                            this.m_cellWidths.save("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getCellWidths());
                            this.m_cellWidths.setFontSize("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getFontSize());
                        } else if (this.m_layoutStrategy != 2 && this.m_layoutStrategy == 3) {
                            // empty if block
                        }
                    } else {
                        if (this.m_layoutStrategy != 1) {
                            if (this.m_layoutStrategy == 2) {
                                this.m_grid.calculateCellDimensions(null);
                            } else if (this.m_layoutStrategy == 3) {
                                this.m_grid.calculateCellDimensions(null);
                                this.m_cellWidths.save("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getCellWidths());
                                this.m_cellWidths.setFontSize("" + this.m_grid.getWidth() + this.m_grid.getJustify(), this.m_grid.getFontSize());
                            }
                        }
                        PdfCanvas pdfCanvas = new PdfCanvas(this.m_currentPage);
                        this.m_grid.write(pdfCanvas, false);
                    }
                } else {
                    PdfCanvas pdfCanvas = new PdfCanvas(this.m_currentPage);
                    this.m_grid.write(pdfCanvas, true);
                }
            }
            this.m_grid = null;
        }
    }

    protected void checkPageSize() {
        if (this.m_landscape > 0 && this.getPWidth() >= this.m_landscape && this.m_pageWidth < this.m_pageHeight) {
            float f;
            float f2 = this.m_pageWidth;
            this.m_pageWidth = f = this.m_pageHeight;
            this.m_pageHeight = f2;
        } else if (this.m_landscape > 0 && this.getPWidth() < this.m_landscape && this.m_pageWidth > this.m_pageHeight) {
            float f;
            float f3 = this.m_pageWidth;
            this.m_pageWidth = f = this.m_pageHeight;
            this.m_pageHeight = f3;
        }
    }

    protected void createPageSize() {
        PageSize pageSize;
        float f = BML2PDF.convertCmToDocPix(this.m_pageWidth);
        float f2 = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        Rectangle rectangle = new Rectangle(f, f2);
        this.m_pageSize = pageSize = new PageSize(rectangle);
    }

    @Override
    protected void writePageHeader() throws IOException {
        this.writeGrid();
        if (this.getPass() == 1) {
            this.m_linesPerPage = 0;
            this.m_doPageBreaksMySelf = false;
            return;
        }
        this.m_lineNr = 0;
        this.m_currentPage = this.m_document.getPdfDocument().addNewPage(this.m_pageSize);
        this.m_document.add((IBlockElement)new Paragraph(" "));
        this.startYPos();
        if (this.getPass() == 2 && !this.m_backgroundImage.isEmpty()) {
            this.createGrid(this.getPWidth(), true);
            this.m_grid.setCurrentYPos(this.m_currentYPos);
            Style style = new Style();
            ExactPosData exactPosData = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, BML2PDF.convertCmToDocPix(this.m_pageHeight) - this.m_topMargin - this.m_bottomMargin, -1.0f, 1, 0);
            style.setExactPosData(exactPosData);
            style.setPreserveRatio(this.parseBoolean(this.getProperty(this.getProperties(), "backgroundImagePreserveRatio", "true"), true));
            this.writeImage(-1, -1, -1, this.m_backgroundImage, 1, 1, style, null);
        }
    }

    protected Document createDocument(PdfWriter pdfWriter) {
        float f;
        float f2;
        if (this.m_useExactPositioning) {
            f2 = BML2PDF.convertCmToDocPix(this.m_pageWidth);
            f = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        } else {
            f2 = BML2PDF.convertCmToDocPix(this.m_pageWidth);
            f = BML2PDF.convertCmToDocPix(this.m_pageHeight);
        }
        Rectangle rectangle = new Rectangle(f2, f);
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        Document document = new Document(pdfDocument, new PageSize(rectangle));
        return document;
    }

    private float getProperty(Properties properties, String string, float f) {
        try {
            String string2 = this.getProperty(properties, string, "" + f);
            if (string2 != null && !string2.equals("")) {
                return Float.parseFloat(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private String getProperty(Properties properties, String string, String string2) {
        try {
            String string3 = properties.getProperty(this.m_reportId + "." + string);
            if (string3 == null) {
                string3 = properties.getProperty(string);
            }
            if (string3 != null) {
                string3 = string3.trim();
            }
            if (string3 != null && !string3.equals("")) {
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private String getFontPath() {
        try {
            Properties properties = this.getProperties();
            if (properties != null) {
                String string = this.getProperty(properties, "ttf-font-path", "");
                if (!"".equals(string)) {
                    return string;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Properties getProperties() {
        try {
            if (this.m_properties == null) {
                Properties properties;
                if (this.m_pdfPropertiesLocation != null && !this.m_pdfPropertiesLocation.isEmpty()) {
                    Properties properties2;
                    File file = new File(this.m_pdfPropertiesLocation);
                    if (!file.exists()) {
                        throw new RuntimeException("Cannot load PDF.properties: " + this.m_pdfPropertiesLocation);
                    }
                    this.m_properties = properties2 = BML2PDF.getPropertiesForFile(file);
                    return properties2;
                }
                this.m_properties = properties = BML2PDF.getPDFProperties();
                return properties;
            }
            return this.m_properties;
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot load PDF.properties: " + exception.getMessage());
        }
    }

    public static Properties getPDFProperties() throws IOException {
        CodeSource codeSource = BML2PDF.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL uRL = new URL(codeSource.getLocation(), "PDF.properties");
            File file = new File(uRL.getFile());
            return BML2PDF.getPropertiesForFile(file);
        }
        return null;
    }

    public BufferedImage getBarcodeImage(BML2HTML.BarCode barCode, String string) {
        this.m_pdfPropertiesLocation = string;
        BufferedImage bufferedImage = null;
        String string2 = this.getBarcodeType(barCode);
        if (string2 != null) {
            bufferedImage = this.getBufferedImage(barCode, string2);
        }
        return bufferedImage;
    }

    private BufferedImage getBufferedImage(BML2HTML.BarCode barCode, String string) {
        String string2;
        BufferedImage bufferedImage = null;
        Properties properties = this.getProperties();
        String string3 = this.getProperty(properties, "BARCODE", "");
        String string4 = this.m_reportId;
        this.m_reportId = null;
        String string5 = this.getProperty(properties, string, "");
        String string6 = null;
        if (string4 != null) {
            string2 = string4 + "." + string;
            if (properties != null && properties.containsKey(string2)) {
                string6 = this.getProperty(properties, string2, "");
            }
        }
        this.m_reportId = string4;
        string2 = barCode.getOptions();
        BarcodeImage barcodeImage = new BarcodeImage(string, barCode.getValue(), string3, string5, string6, string2);
        BufferedImage bufferedImage2 = bufferedImage = barcodeImage == null ? null : barcodeImage.getBarcodeImage(barCode.getWidth(), barCode.getHeight());
        if (barcodeImage != null) {
            barCode.setRotated(barcodeImage.isRotated());
        }
        return bufferedImage;
    }

    private static Properties getPropertiesForFile(File file) {
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                return properties;
            }
            Properties properties = new Properties();
            return properties;
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot load PDF.properties: " + exception.getMessage());
        }
    }

    private boolean parseBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if (string.equalsIgnoreCase("no")) {
            return false;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        return bl;
    }

    @Override
    protected void writeReportHeader(String string) throws IOException {
        try {
            if (this.m_document == null) {
                this.m_pdfWriter = new PdfWriter(this.m_pdfFileName);
                this.m_document = this.createDocument(this.m_pdfWriter);
            }
            this.m_pageSize = null;
            this.checkPageSize();
            this.createPageSize();
            if (this.getPass() == 1) {
                this.m_linesPerPage = 0;
                this.m_doPageBreaksMySelf = false;
            }
            float f = 2.0f;
            float f2 = 2.0f;
            float f3 = 1.5f;
            float f4 = 1.5f;
            int n = 192;
            int n2 = 192;
            int n3 = 192;
            Properties properties = this.getProperties();
            if (properties != null) {
                if (this.m_useExactPositioning) {
                    f = 10.0f * f;
                    f2 = 10.0f * f2;
                    f3 = 10.0f * f3;
                    f4 = 10.0f * f;
                }
                f = this.getProperty(properties, "left-margin", f);
                f2 = this.getProperty(properties, "right-margin", f2);
                f3 = this.getProperty(properties, "top-margin", f3);
                f4 = this.getProperty(properties, "bottom-margin", f4);
                if (this.m_useExactPositioning) {
                    f = 0.1f * f;
                    f2 = 0.1f * f2;
                    f3 = 0.1f * f3;
                    f4 = 0.1f * f4;
                }
                n = (int)this.getProperty(properties, "line-color-r", n);
                n2 = (int)this.getProperty(properties, "line-color-g", n2);
                n3 = (int)this.getProperty(properties, "line-color-b", n3);
                this.m_debug = "yes".equalsIgnoreCase(this.getProperty(properties, "debug", "no"));
                this.m_debugShowProps = "yes".equalsIgnoreCase(this.getProperty(properties, "debug.show.properties", "no"));
                this.m_fontSizeFactor = this.getProperty(properties, "font-size-factor", DEFAULT_FONT_SIZE_FACTOR);
                this.m_dynamicFactor = this.getProperty(properties, "dynamic-factor", 1.6f);
                this.m_layoutStrategy = (int)this.getProperty(properties, "layout-strategy", 1.0f);
                if (this.m_layoutStrategy < 1 && this.m_layoutStrategy > 3) {
                    this.m_layoutStrategy = 1;
                }
                this.m_backgroundImage = this.getProperty(properties, "backgroundImage", "");
            }
            this.m_lineColor = new DeviceRgb(n, n2, n3);
            this.m_leftMargin = this.m_pageSize.getWidth() * f / this.m_pageWidth;
            this.m_rightMargin = this.m_pageSize.getWidth() * f2 / this.m_pageWidth;
            this.m_topMargin = this.m_pageSize.getHeight() * f3 / this.m_pageHeight;
            this.m_bottomMargin = this.m_pageSize.getHeight() * f4 / this.m_pageHeight;
            this.m_charWidth = (this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin) / (float)this.getPWidth();
            float f5 = (this.m_pageSize.getHeight() - this.m_topMargin - this.m_bottomMargin) / (float)this.m_linesPerPageMax;
            this.m_charHeight = 3.0f * this.m_charWidth;
            if (this.m_charHeight > f5) {
                this.m_charHeight = f5;
            }
            if (this.m_charHeight < 1.5f * this.m_charWidth) {
                this.m_charHeight = 2.0f * this.m_charWidth;
                this.m_linesPerPageMax = (int)((this.m_pageSize.getHeight() - this.m_topMargin - this.m_bottomMargin) / this.m_charHeight) - 2;
                this.m_doPageBreaksMySelf = true;
            }
            this.startYPos();
            if (this.m_debug && this.getPass() == 2 && this.m_debugShowProps) {
                Object i;
                Object iOException;
                this.m_debug = false;
                this.m_currentPage = this.m_document.getPdfDocument().addNewPage(this.m_pageSize);
                this.setNumberOfCharactersForTheCurrentLine(150, "", true);
                float f6 = this.m_charHeight;
                this.m_charHeight = this.m_pageSize.getHeight() / 120.0f;
                this.writeDebugText("Contents of PDF.properties:", true);
                this.writeDebugText("");
                if (properties != null) {
                    for (String object32 : properties.stringPropertyNames()) {
                        iOException = properties.getProperty(object32);
                        iOException = ((String)iOException).replaceAll(" ", "_");
                        i = object32 + ": " + (String)iOException;
                        this.writeDebugText((String)i);
                    }
                } else {
                    this.writeDebugText("None");
                }
                this.writeDebugText("");
                this.writeDebugText("");
                this.writeDebugText("Other properties:", true);
                this.writeDebugText("");
                this.writeDebugText("Font size factor: " + this.getFontSize());
                this.writeDebugText("Font size factor max: 3.5");
                this.writeDebugText("");
                Object object4 = "<unknown>";
                Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (enumeration.hasMoreElements()) {
                    try {
                        iOException = new Manifest(enumeration.nextElement().openStream());
                        i = ((Manifest)iOException).getEntries();
                        for (String string2 : i.keySet()) {
                            Attributes attributes = ((Manifest)iOException).getAttributes(string2);
                            if (attributes.getValue("Specification-Build") == null) continue;
                            object4 = attributes.getValue("Specification-Build");
                        }
                    }
                    catch (IOException i2) {
                    }
                }
                this.writeDebugText("Converter version: " + (String)object4);
                this.writeDebugText("");
                this.writeDebugText("");
                this.writeDebugText("Location of PDF.properties:", true);
                this.writeDebugText("");
                if (this.m_pdfPropertiesLocation != null) {
                    this.writeDebugText(this.m_pdfPropertiesLocation);
                } else {
                    iOException = BML2PDF.class.getProtectionDomain().getCodeSource();
                    if (iOException != null) {
                        i = new URL(((CodeSource)iOException).getLocation(), "PDF.properties");
                        this.writeDebugText(((URL)i).getFile());
                    }
                }
                this.writeDebugText("");
                this.writeDebugText("");
                this.writeDebugText("Font paths:", true);
                this.writeDebugText("");
                this.writeDebugText("Default proportional font: " + this.m_arialuniFont);
                this.writeDebugText("Default fixed font: " + this.m_couriernewFont);
                this.writeDebugText("");
                this.writeDebugText("");
                this.writeDebugText("Chinese sample text:", true);
                this.writeDebugText("");
                this.writeDebugText("These are the protagonists in 'Hero', a movie by Zhang Yimou:");
                this.writeDebugText("      \u7121\u540d (Nameless), \u6b98\u528d (Broken Sword), ");
                this.writeDebugText("      \u98db\u96ea (Flying Snow), \u5982\u6708 (Moon), ");
                this.writeDebugText("      \u79e6\u738b (the King) and \u9577\u7a7a (Sky).");
                this.writeDebugText("");
                this.writeDebugText("Some Java properties:", true);
                this.writeDebugText("");
                this.writeDebugText("free memory (inital): " + this.m_free / 0x100000L + "m");
                this.writeDebugText("total memory (initial): " + this.m_total / 0x100000L + "m");
                this.writeDebugText("max memory (initial): " + this.m_max / 0x100000L + "m");
                this.writeDebugText("free memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
                this.writeDebugText("total memory: " + Runtime.getRuntime().totalMemory() / 0x100000L + "m");
                this.writeDebugText("max memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "m");
                if (this.m_notoMapper != null) {
                    for (int j = 0; j < this.m_notoMapper.getDebugLines().size(); ++j) {
                        this.writeDebugText(this.m_notoMapper.getDebugLines().get(j));
                    }
                }
                List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
                for (int j = 0; j < list.size(); ++j) {
                    this.writeDebugText("vm arg " + j + ": " + list.get(j));
                }
                this.m_debug = true;
                this.m_charHeight = f6;
                this.startYPos();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void writeDebugText(String string) throws IOException {
        this.writeDebugText(string, false);
    }

    private void writeDebugText(String string, boolean bl) throws IOException {
        int n = string.indexOf(": ");
        String string2 = n == -1 ? "" : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1, string.length());
        File file = new File(string3.trim());
        if (file.exists()) {
            string3 = " <some path>/" + file.getName();
        }
        string = n == -1 ? string3 : string2 + ":" + string3;
        Style style = null;
        if (this.m_useExactPositioning) {
            ExactPosData exactPosData = new ExactPosData(0.0f, 0.0f, BML2PDF.convertMmToDocPix(200.0f), 1.0f, 1.0f, 10, 0);
            style = new Style();
            style.setExactPosData(exactPosData);
        }
        this.writeTextCell(string, 1, string.length(), 0, bl, false, false, "Small (7 pt)", bl, false, style);
        this.m_currentYPos -= this.m_charHeight;
        if (this.m_grid != null) {
            this.m_grid.setCurrentYPos(this.m_currentYPos);
        }
    }

    @Override
    protected void writeStartOfNewLine() throws IOException {
        if (this.getPass() == 1) {
            ++this.m_linesPerPage;
            return;
        }
        ++this.m_lineNr;
        if (!this.m_useExactPositioning && this.m_doPageBreaksMySelf && this.m_lineNr >= this.m_linesPerPageMax) {
            this.writePageHeader();
        }
        if (this.getRowFixedOffset() >= 0.0f) {
            this.m_currentYPos = this.m_pageSize.getHeight() - BML2PDF.convertMmToDocPix(this.getRowFixedOffset());
            if (this.m_grid != null) {
                this.m_grid.setCurrentYPos(this.m_currentYPos);
            }
        }
    }

    @Override
    protected void writeEmptyLine() throws IOException {
        if (this.getPass() == 1) {
            ++this.m_linesPerPage;
            return;
        }
        ++this.m_lineNr;
        if (!this.m_useExactPositioning && this.m_doPageBreaksMySelf && this.m_lineNr >= this.m_linesPerPageMax) {
            this.writePageHeader();
        }
        this.calcYPos();
    }

    @Override
    protected void writePageBreakIfNeeded() throws IOException {
        if (this.getPass() == 1 && this.m_linesPerPage > this.m_linesPerPageMax) {
            this.m_linesPerPageMax = this.m_linesPerPage;
        }
    }

    @Override
    protected void writeReportEnd() throws IOException {
        if (this.getPass() == 1 && this.m_linesPerPage > this.m_linesPerPageMax) {
            this.m_linesPerPageMax = this.m_linesPerPage;
        }
        this.writeGrid();
    }

    @Override
    protected void writeEndOfLine() throws IOException {
        if (this.getPass() == 1) {
            return;
        }
        this.calcYPos();
    }

    private void calcYPos() {
        if (this.m_useExactPositioning) {
            float f = this.getRowHeight();
            float f2 = BML2PDF.convertMmToDocPix(f);
            this.m_currentYPos -= f2;
        } else {
            this.m_currentYPos -= this.m_charHeight;
        }
        if (this.m_grid != null) {
            this.m_grid.setCurrentYPos(this.m_currentYPos);
        }
    }

    private void startYPos() {
        this.m_currentYPos = this.m_pageSize.getHeight() - this.m_topMargin;
        if (this.m_grid != null) {
            this.m_grid.setCurrentYPos(this.m_currentYPos);
        }
    }

    public static float convertMmToDocPix(float f) {
        return 72.0f * f / 25.4f;
    }

    public static float convertDocPixToMm(float f) {
        return 25.4f * f / 72.0f;
    }

    public static float convertCmToDocPix(float f) {
        return 72.0f * f / 2.54f;
    }

    public static float convertPtToDocPix(float f) {
        float f2 = 0.035277f * f;
        return BML2PDF.convertCmToDocPix(f2);
    }

    @Override
    public synchronized void convert(String string, String string2) throws SAXException, IOException {
        this.m_pdfFileName = string2;
        this.m_free = Runtime.getRuntime().freeMemory();
        this.m_total = Runtime.getRuntime().totalMemory();
        this.m_max = Runtime.getRuntime().maxMemory();
        super.convert(string, string2);
        if (this.m_document != null) {
            this.m_document.close();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        Object object;
        String string4;
        Object object2;
        String string5;
        if (string3.equals("report")) {
            string5 = attributes.getValue("id");
            if (string5 == null) {
                string5 = "<unknown>";
            }
            if (string5.length() > 15) {
                this.m_reportId = string5.substring(1, 3) + string5.substring(string5.length() - 12, string5.length());
            }
            object2 = attributes.getValue("pagewidth");
            string4 = attributes.getValue("pageheight");
            this.m_pageWidth = 21.0f;
            this.m_pageHeight = 29.7f;
            object = this.getProperties();
            this.m_landscape = (int)this.getProperty((Properties)object, "landscape", 150.0f);
            boolean bl = this.m_useExactPositioning = attributes.getValue("pwidth") == null;
            if (object2 != null && !((String)object2).isEmpty()) {
                this.m_pageWidth = Float.parseFloat((String)object2);
                this.m_pageHeight = Float.parseFloat(string4);
                this.m_landscape = -1;
                if (this.m_useExactPositioning) {
                    this.m_pageWidth *= 0.1f;
                    this.m_pageHeight *= 0.1f;
                }
            }
        } else if (string3.equals("input_fields")) {
            this.tryToFindArialFonts();
        }
        super.startElement(string, string2, string3, attributes);
        if (string3.equals("property")) {
            string5 = attributes.getValue("name");
            object2 = attributes.getValue("value");
            string5 = string5.replaceAll(" ", "");
            this.getProperties().setProperty(string5, (String)object2);
        } else if (string3.equals("special") || string3.equals("field") || string3.equals("bgitem") || string3.equals("image") || string3.equals("barcode") || string3.equals("text") || string3.equals("signature")) {
            if (this.m_useExactPositioning) {
                float f = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("xpos"), -1.0));
                float f2 = -BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("ypos"), -1.0));
                float f3 = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("width"), -1.0));
                float f4 = BML2PDF.convertMmToDocPix((float)this.parseDouble(attributes.getValue("height"), -1.0));
                float f5 = (float)this.parseDouble(attributes.getValue("lineheight"), 1.0);
                int n = this.parseInt(attributes.getValue("multiline"), 1);
                int n2 = BML2HTML.getAlign(attributes.getValue("valign"));
                ExactPosData exactPosData = new ExactPosData(f, f2, f3, f4, f5, n, n2);
                this.getLastAddedCell().getStyle().setExactPosData(exactPosData);
            }
        } else if (string3.equals("layout")) {
            if (this.getPass() == 1) {
                this.m_currentCount = new Count();
                if (this.m_useExactPositioning) {
                    this.m_currentCount.m_count = 1;
                    this.m_numberOfLinesPerLayout.put(attributes.getValue("id"), this.m_currentCount);
                } else {
                    this.m_currentCount.m_count = 0;
                    this.m_numberOfLinesPerLayout.put(attributes.getValue("id"), this.m_currentCount);
                }
            } else if (this.getPass() == 2) {
                string5 = attributes.getValue("id");
                object2 = attributes.getValue("backgroundImage");
                string4 = attributes.getValue("backgroundImagePreserveRatio");
                if (!this.m_useExactPositioning) {
                    string5 = string5 + ".1";
                }
                if (object2 != null) {
                    object = new BackgroundImage();
                    ((BackgroundImage)object).m_backgroundImage = object2;
                    ((BackgroundImage)object).m_preserveRatio = this.parseBoolean(string4, true);
                    this.m_backgroundImages.put(string5, (BackgroundImage)object);
                }
            }
        } else if (string3.equals("lline")) {
            if (this.getPass() == 1) {
                ++this.m_currentCount.m_count;
            }
        } else if ((string3.equals("row") || string3.equals("emptyline")) && this.getPass() == 2 && (object2 = this.m_backgroundImages.get(string5 = attributes.getValue("layout"))) != null) {
            if (this.m_useExactPositioning) {
                float f = this.getRowHeight();
                object = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, BML2PDF.convertMmToDocPix(f), -1.0f, 1, 0);
                Style style = new Style();
                style.setExactPosData((ExactPosData)object);
                style.setPreserveRatio(((BackgroundImage)object2).m_preserveRatio);
                this.writeImage(-1, -1, -1, ((BackgroundImage)object2).m_backgroundImage, 1, 1, style, null);
            } else {
                int n = 1;
                try {
                    n = this.m_numberOfLinesPerLayout.get((Object)string5.substring((int)0, (int)(string5.length() - 2))).m_count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float f = (float)n * this.m_charHeight;
                ExactPosData exactPosData = new ExactPosData(0.0f, 0.0f, BML2PDF.convertCmToDocPix(this.m_pageWidth) - this.m_leftMargin - this.m_rightMargin, f, -1.0f, 1, 0);
                Style style = new Style();
                style.setExactPosData(exactPosData);
                style.setPreserveRatio(((BackgroundImage)object2).m_preserveRatio);
                this.writeImage(-1, -1, -1, ((BackgroundImage)object2).m_backgroundImage, 1, 1, style, null);
            }
        }
    }

    @Override
    protected double getFontSizeInPt(int n) {
        double d = this.m_pageSize.getWidth() - this.m_leftMargin - this.m_rightMargin;
        return (double)this.m_fontSizeFactor * d / (double)n;
    }

    public static void convertBML(String string, String string2) {
        try {
            BML2PDF bML2PDF = new BML2PDF();
            bML2PDF.convert(string, string2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create the PDF file", exception);
        }
    }

    public void setPdfPropsNameValue(String string) {
        if (string != null && string.startsWith("pdfprops=")) {
            int n = string.indexOf("=");
            this.m_pdfPropertiesLocation = string.substring(n + 1);
        } else {
            this.m_pdfPropertiesLocation = null;
        }
    }

    public static void convertBML(String string, String string2, String string3) {
        try {
            BML2PDF bML2PDF = new BML2PDF();
            bML2PDF.setPdfPropsNameValue(string3);
            bML2PDF.convert(string, string2);
            bML2PDF.setPdfPropsNameValue(null);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create the PDF file", exception);
        }
    }

    public static void convertBML2PDF(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
        try {
            BML2PDF bML2PDF = new BML2PDF();
            bML2PDF.setBidi(bl3);
            bML2PDF.convert(string, string2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create the PDF file", exception);
        }
    }

    public static String getVersion() {
        return "2051";
    }

    public static String convertToPDF(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
        BML2PDF.convertBML2PDF(string, string2, bl, bl2, string3, string4, bl3);
        return "PDF";
    }

    @Override
    public boolean useExactPosition() {
        return this.m_useExactPositioning;
    }

    public static int getNumberOfLines(String string, String string2, double d, double d2) {
        return BML2PDF.saveLines(string, null, string2, d, d2);
    }

    public static int saveLines(String string, String string2, String string3, double d, double d2) {
        try {
            Object object;
            if (string3 == null || string3.isEmpty()) {
                object = new BML2PDF();
                ((BML2PDF)object).tryToFindArialFonts();
                string3 = ((BML2PDF)object).m_arialuniFont;
            }
            object = File.createTempFile("pdf", ".pdf");
            PdfDocument pdfDocument = new PdfDocument(new PdfWriter((File)object));
            Document document = new Document(pdfDocument, PageSize.A4);
            StringBuffer stringBuffer = new StringBuffer();
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            char[] cArray = new char[16];
            boolean bl = true;
            while (bl) {
                int n = inputStreamReader.read(cArray);
                if (n == -1) {
                    bl = false;
                    continue;
                }
                stringBuffer.append(cArray, 0, n);
            }
            inputStreamReader.close();
            fileInputStream.close();
            String string4 = stringBuffer.toString();
            d2 = BML2PDF.convertMmToDocPix((float)d2);
            PdfFont pdfFont = PdfFontFactory.createFont((String)string3, (String)"Identity-H", (boolean)false);
            Grid.SizedFont sizedFont = new Grid.SizedFont(pdfFont, (float)d, false, false);
            PDFTextWrap.TabStopParagraph tabStopParagraph = new PDFTextWrap.TabStopParagraph(string4, sizedFont);
            Div div = new Div();
            div.setBorder((Border)new SolidBorder(1.0f));
            div.setFixedPosition(1, 0.0f, 600.0f, (float)d2);
            div.add((IBlockElement)tabStopParagraph);
            document.add((IBlockElement)div);
            String string5 = tabStopParagraph.toString();
            document.close();
            ((File)object).delete();
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            if (string2 != null) {
                fileOutputStream = new FileOutputStream(new File(string2));
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(string5);
                outputStreamWriter.flush();
                fileOutputStream.flush();
                outputStreamWriter.close();
                fileInputStream.close();
            }
            String[] stringArray = string5.split("\n");
            return stringArray.length;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.log(Level.SEVERE, "Cannot save the lines: " + exception.getMessage(), exception);
            return -1;
        }
    }

    static {
        BML2PDF.loadLicense();
        DEFAULT_FONT_SIZE_FACTOR = 1.84f;
        logger = Logger.getLogger(BML2PDF.class.getName());
    }

    private class Count {
        public int m_count = 0;

        private Count() {
        }
    }

    private class BackgroundImage {
        public String m_backgroundImage;
        public boolean m_preserveRatio = true;

        private BackgroundImage() {
        }
    }
}

