/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2BIRT;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.birt.BML2BIRTException;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2BIRTData
extends DefaultHandler {
    private static final char SEPARATOR = ',';
    private static final String PAGEBREAK = "pagebreak";
    private static final String EMPTYLINE = "emptyline";
    private Writer m_writer;
    private StringBuffer m_characters = null;
    private Model m_current_model;
    private Line m_current_line;
    private Layout m_current_layout;
    private Row m_current_row;
    private Value m_current_value;
    private Vector<String> m_fieldnames;
    private Hashtable<String, String> m_fieldvalues;
    String m_idOfFirstLineOfPage = null;

    Line transfer(String string, Line line) {
        Line line2 = new Line(string);
        if (line != null) {
            for (Field field : line.v) {
                if (field.height <= 1) continue;
                Field field2 = field.transfer();
                line2.add(field2);
            }
        }
        return line2;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string3.equals("report")) {
                this.m_current_model = new Model();
                this.m_current_model.desc = attributes.getValue("desc");
            } else if (string3.equals("layout")) {
                String string4 = attributes.getValue("id");
                this.m_current_layout = new Layout(string4);
                this.m_current_model.add(this.m_current_layout);
                this.m_current_line = null;
            } else if (string3.equals("lline")) {
                String string5 = attributes.getValue("id");
                this.m_current_line = this.transfer(string5, this.m_current_line);
                this.m_current_layout.add(this.m_current_line);
            } else if (string3.equals("special") || string3.equals("field")) {
                Field field = new Field();
                String string6 = attributes.getValue("col");
                field.col = string6 == null ? 0 : Integer.parseInt(string6);
                string6 = attributes.getValue("height");
                field.height = string6 == null ? 0 : Integer.parseInt(string6);
                field.fldtype = attributes.getValue("fldtype");
                field.difo = attributes.getValue("difo");
                this.m_current_line.add(field);
            } else if (string3.equals("row")) {
                String string7 = attributes.getValue("layout");
                this.m_current_row = new Row(string7);
                if (this.m_idOfFirstLineOfPage == null && this.getLine(string7) != null) {
                    this.m_idOfFirstLineOfPage = string7;
                }
            } else if (string3.equals("e")) {
                this.m_current_value = new Value();
                this.m_current_value.pv = attributes.getValue("pv");
                this.m_current_value.difo = attributes.getValue("difo");
                this.startCharacters();
                this.m_current_row.add(this.m_current_value);
            } else if (string3.equals(PAGEBREAK)) {
                this.pagebreak();
                this.m_idOfFirstLineOfPage = null;
            } else if (string3.equals(EMPTYLINE)) {
                this.emptyline();
            }
        }
        catch (Exception exception) {
            throw new SAXException(new BML2BIRTException(exception));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string3.equals("head")) {
                this.m_current_line = null;
                this.m_current_layout = null;
                this.m_fieldnames = this.getFieldNames();
                this.writeHeaderLine();
                this.m_fieldvalues = new Hashtable();
            } else if (string3.equals("e")) {
                this.m_current_value.characters = this.getCharacters();
                this.stopCharacters();
                this.m_current_value = null;
            } else if (string3.equals("row")) {
                this.row();
                this.m_current_row = null;
            } else if (string3.equals("body")) {
                this.finish();
            }
        }
        catch (Exception exception) {
            throw new SAXException(new BML2BIRTException(exception));
        }
    }

    private void startCharacters() {
        this.m_characters = new StringBuffer();
    }

    private void stopCharacters() {
        this.m_characters = null;
    }

    private String getCharacters() {
        String string = "";
        if (this.m_characters != null) {
            string = this.m_characters.toString();
        }
        return string;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.m_characters != null) {
            String string = new String(cArray, n, n2);
            this.m_characters.append(string);
        }
    }

    private Vector<String> getFieldNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(PAGEBREAK);
        vector.add(EMPTYLINE);
        for (Layout layout : this.m_current_model.v) {
            for (Line line : layout.v) {
                vector.add(line.id);
                for (Field field : line.v) {
                    vector.add(field.id);
                }
            }
        }
        return vector;
    }

    private void writeHeaderLine() throws IOException {
        String string = "";
        for (String string2 : this.m_fieldnames) {
            string = string + string2;
            string = string + ',';
        }
        this.m_writer.write(string);
        this.m_writer.write(System.getProperty("line.separator"));
    }

    private void pagebreak() throws IOException {
        this.flush();
        this.m_fieldvalues.put(PAGEBREAK, PAGEBREAK);
    }

    private void emptyline() throws IOException {
        int n;
        boolean bl = PAGEBREAK.equals(this.m_fieldvalues.get(PAGEBREAK));
        int n2 = n = bl ? 1 : 0;
        if (this.m_fieldvalues.size() > n) {
            this.flush();
        }
        this.m_fieldvalues.put(EMPTYLINE, EMPTYLINE);
    }

    private void finish() throws IOException {
        boolean bl = PAGEBREAK.equals(this.m_fieldvalues.get(PAGEBREAK));
        boolean bl2 = EMPTYLINE.equals(this.m_fieldvalues.get(EMPTYLINE));
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        if (this.m_fieldvalues.size() > n) {
            this.flush();
        }
    }

    private void row() throws IOException {
        Object object;
        String string = this.m_current_row.id;
        Line line = this.getLine(string);
        if (line == null) {
            return;
        }
        int n = this.m_fieldnames.indexOf(string);
        int n2 = this.m_fieldnames.size();
        for (int i = n; i < n2; ++i) {
            String string2 = this.m_fieldnames.get(i);
            object = this.m_fieldvalues.get(string2);
            if (object == null) continue;
            this.flush();
            break;
        }
        this.m_fieldvalues.put(string, string);
        Iterator<Value> iterator = this.m_current_row.v.iterator();
        int n3 = 0;
        while (iterator.hasNext() && n3 < line.v.size()) {
            object = iterator.next();
            Field field = line.v.get(n3++);
            String string3 = this.getFormatted((Value)object, field);
            this.m_fieldvalues.put(field.id, string3.trim());
        }
    }

    private String getFormatted(Value value, Field field) {
        if (value.pv == null) {
            return value.characters;
        }
        return value.pv;
    }

    private void flush() throws IOException {
        if (this.m_fieldvalues.isEmpty()) {
            return;
        }
        String string = "";
        for (String string2 : this.m_fieldnames) {
            String string3 = this.m_fieldvalues.get(string2);
            if (string3 != null) {
                boolean bl;
                boolean bl2 = bl = string2.startsWith(this.m_idOfFirstLineOfPage + ".") && string3.equalsIgnoreCase(this.m_current_model.desc);
                if (!bl) {
                    string = string + this.escape(string3);
                }
            }
            string = string + ',';
        }
        this.m_writer.write(string);
        this.m_writer.write(System.getProperty("line.separator"));
        this.m_fieldvalues.clear();
    }

    private Line getLine(String string) {
        for (Layout layout : this.m_current_model.v) {
            for (Line line : layout.v) {
                if (!line.id.equals(string)) continue;
                return line;
            }
        }
        return null;
    }

    private String escape(String string) {
        String string2;
        int n = string.indexOf(34);
        int n2 = string.indexOf(44);
        if (n < 0 && n2 < 0) {
            string2 = string;
        } else {
            string2 = "\"";
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    string2 = string2 + '\"';
                }
                string2 = string2 + c;
            }
            string2 = string2 + '\"';
        }
        return string2;
    }

    private void convertData(String string, String string2) throws SAXException, IOException {
        XMLReader xMLReader = IOUtils.createXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF8"));
        this.parse(xMLReader, string);
        this.m_writer.close();
    }

    private void parse(XMLReader xMLReader, String string) throws SAXException, IOException {
        String string2 = BML2BIRT.BML2String(string);
        StringReader stringReader = new StringReader(string2);
        InputSource inputSource = new InputSource(stringReader);
        xMLReader.parse(inputSource);
        stringReader.close();
    }

    public static void convertBML(String string, String string2, String string3, String string4) throws BML2BIRTException {
        try {
            BML2BIRTData bML2BIRTData = new BML2BIRTData();
            bML2BIRTData.convertData(string3, string4);
        }
        catch (Throwable throwable) {
            throw new BML2BIRTException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        System.out.println("Executing Data conversion with:");
        System.out.println("User:" + string);
        System.out.println("BML file:" + string3);
        System.out.println("Version:" + string2);
        System.out.println("Output data file:" + string4);
        System.out.println("Start");
        try {
            BML2BIRTData.convertBML(string, string2, string3, string4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("Finished");
    }

    private class Value {
        String difo;
        String pv;
        String characters;

        private Value() {
        }
    }

    private class Row {
        String id;
        Vector<Value> v = new Vector();

        Row(String string) {
            this.id = string;
        }

        void add(Value value) {
            this.v.add(value);
        }
    }

    private class Model {
        String desc;
        Vector<Layout> v = new Vector();

        private Model() {
        }

        void add(Layout layout) {
            this.v.add(layout);
        }
    }

    private class Layout {
        String id;
        Vector<Line> v = new Vector();

        Layout(String string) {
            this.id = string;
        }

        void add(Line line) {
            this.v.add(line);
        }
    }

    private class Line {
        String id;
        Vector<Field> v = new Vector();

        Line(String string) {
            this.id = string;
        }

        void add(Field field) {
            boolean bl = false;
            for (int i = 0; i < this.v.size(); ++i) {
                Field field2 = this.v.get(i);
                if (field.col >= field2.col) continue;
                this.v.insertElementAt(field, i);
                bl = true;
                break;
            }
            if (!bl) {
                this.v.add(field);
            }
            field.id = this.id + "." + this.v.size();
        }
    }

    private class Field {
        String id;
        String fldtype;
        String difo;
        int col;
        int height;

        private Field() {
        }

        Field transfer() {
            Field field = new Field();
            field.id = null;
            field.fldtype = this.fldtype;
            field.difo = this.difo;
            field.col = this.col;
            field.height = this.height - 1;
            return field;
        }
    }
}

